<?php

class ScheduleObjectActions
{
    function __construct()
    {

    }
    public function scheduleObjectActionsJson($date='',$scheduleID='',$salespersonIDs='',$customerIDs='')
    {
        if (empty($date)){
            $date = date('Y-m-d');
        }
        global $username, $password, $database;
        $dbClass = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $dbClass->set_charset("utf8");
        $scheduleArrayResponse = $this->getScheduleObjects($date,$scheduleID,$salespersonIDs,$dbClass);
        return $scheduleArrayResponse;
    }

    private function getScheduleObjects($date,$scheduleIDs,$salespersonIDs,$dbClass){
        $schedule_object_id = '';
        $schedule_id = '';
        $start_time = '';
        $end_time = '';
        $salesperson_id = '';
        $status = '';
        $start_km = '';
        $end_km = '';

        $where = "";
        if (strcmp($scheduleIDs,'')!=0){
            $where .=" AND schedule_id IN ($scheduleIDs)";
        }
        if (strcmp($salespersonIDs,'')!=0){
            $where .=" AND salesperson_id IN ($salespersonIDs) ";
        }
        $responseArray = array();
        $stm = $dbClass->prepare("SELECT schedule_object_id, schedule_id, date, start_time, end_time, salesperson_id, status, start_km,end_km
                                FROM Schedule_Objects
                                WHERE date='$date' $where ");
        $stm->execute();
        $stm->bind_result($schedule_object_id, $schedule_id, $date, $start_time, $end_time, $salesperson_id, $status, $start_km,$end_km);
        while ($stm->fetch()) {
            $scheduleObj = new stdClass();
            $scheduleObj->schedule_object_id    = $schedule_object_id;
            $scheduleObj->schedule_id           = $schedule_id;
            $scheduleObj->date                  = $date;
            $scheduleObj->start_time            = $start_time;
            $scheduleObj->end_time              = $end_time;
            $scheduleObj->salesperson_id        = $salesperson_id;
            $scheduleObj->status                = $status;
            $scheduleObj->start_km              = $start_km;
            $scheduleObj->end_km                = $end_km;
            $scheduleObj->htmlCode              = "";
            $scheduleObj->customers             = $this->getScheduleObjectCustomer($schedule_object_id);

            array_push($responseArray,$scheduleObj);

        }
        $stm->close();
        return $responseArray;
    }

    private function getScheduleObjectCustomer($schedule_object_id){

        global $username, $password, $database;
        $db2 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");


        $responseArraySchedules = array();

        $stm = $db2->prepare("SELECT customer_id,position,visit,appointment_time
                                FROM Schedule_Object_Customer
                                WHERE schedule_object_id='$schedule_object_id' ");
        $stm->execute();
        $stm->bind_result($customerID,$position,$visit,$appoimentTime);
        while ($stm->fetch()) {

            $scheduleObjCustomer = new stdClass();
            $scheduleObjCustomer->customerID           = $customerID;
            $scheduleObjCustomer->position             = $position;
            $scheduleObjCustomer->visit                = $visit;
            $customerInfo                              = $this->getCustomerInfo($customerID);
            $scheduleObjCustomer->customerInfo         = $customerInfo;
            $scheduleObjCustomer->appoimentTime        = $appoimentTime;
            $scheduleObjCustomer->htmlSchedules        = "<div class='info-card'>$customerInfo->code -> $customerInfo->name</div>";
            $scheduleObjCustomer->actions              = $this->getScheduleObjectActions($schedule_object_id,$customerID);

            array_push($responseArraySchedules,$scheduleObjCustomer);

        }
        $stm->close();
        return $responseArraySchedules;
    }

    private function getScheduleObjectActions($schedule_object_id,$customerID){

        global $username, $password, $database;
        $db3 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db3->set_charset("utf8");

        $responseArraySchedulesActions = array();

        $stm = $db3->prepare("SELECT customer_id,salesperson_id,action_type,action_id,lat,lng
                                FROM Schedule_Object_Actions
                                WHERE schedule_object_id='$schedule_object_id' AND customer_id='$customerID' ");
        $stm->execute();
        $stm->bind_result($customer_id,$salesperson_id,$action_type,$action_id,$lat,$lng);
        while ($stm->fetch()) {
            $scheduleObjCustomerActions = new stdClass();
            $scheduleObjCustomerActions->customerID        = $customerID;
            $scheduleObjCustomerActions->salesperson_id   = $salesperson_id;
            $scheduleObjCustomerActions->action_type      = $action_type;
            $scheduleObjCustomerActions->action_id        = $action_id;
            $scheduleObjCustomerActions->lat              = $lat;
            $scheduleObjCustomerActions->lng              = $lng;

            array_push($responseArraySchedulesActions,$scheduleObjCustomerActions);

        }
        $stm->close();
        return $responseArraySchedulesActions;
    }

    private function getCustomerInfo($customerID){
        global $username, $password, $database;
        $db4 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db4->set_charset("utf8");

        $objCust = new stdClass();
        $stm = $db4->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($customerCode,$customerName);
        while ($stm->fetch()) {
            $objCust->code = $customerCode;
            $objCust->name = $customerName;
        }
        $stm->close();

        $stm = $db4->prepare("SELECT lat,lng FROM CustomerAddress WHERE customer_id='$customerID' AND primary_address='yes' LIMIT 1");
        $stm->execute();
        $stm->bind_result($lat,$lng);
        while ($stm->fetch()) {
            $objCust->lat = $lat;
            $objCust->lng = $lng;
        }
        $stm->close();

        return $objCust;
    }
}