<?php
// List of events

include_once("../../../../param.php");
require(ROOT . "concc/dbhelpers/dbhelper.php");

$where="WHERE Service_Call.customer_id=Customers.customer_id AND Service_Call.type_id= SC_Types.type_id AND Service_Call.status_id= SC_Status.status_id AND schedule_start_date>'0000-00-00 00:00:00' AND schedule_end_date>'0000-00-00 00:00:00' AND schedule_start_date<=schedule_end_date";
$whereLeave = "";
$whereReferredTo = "";

if(isset($_GET['typeSelect']))
{
    $types=$_GET['typeSelect'];

    if(strcmp($types,"")!=0)
    {
        $where=$where." AND SC_Types.type_id IN($types)";
    }
}


if(isset($_GET['userSelect']))
{
    $users=$_GET['userSelect'];

    if(strcmp($users,"")!=0)
    {
        $where=$where." AND Service_Call.assign_to IN($users) ";
        $whereLeave .= " AND SalesPersons.salesperson_id IN ($users)";
        $whereReferredTo .= " AND SC_Referred_To.salesperson_id IN ($users)";
    }
}


if(isset($_GET['prioritySelect']))
{
    $priorities=$_GET['prioritySelect'];

    if(strcmp($priorities,"")!=0)
    {
        $where=$where." AND Service_Call.priority_id IN($priorities)";
    }
}


if(isset($_GET['statusSelect']))
{
    $statuses=$_GET['statusSelect'];

    if(strcmp($statuses,"")!=0)
    {
        $where=$where." AND Service_Call.status_id IN($statuses)";
    }
}

if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " Service_Call.assign_to IN (".$_SESSION['Allow_Salespersons'].")";
}

$objects = array();

// Query that retrieves events
$request = "SELECT service_call_id,service_call_code,topic,schedule_start_date,schedule_end_date,customer_company_name,type_name,priority_id,calendar_fixed,SC_Types.color,status_color,Service_Call.assign_to FROM Service_Call,Customers,SC_Types,SC_Status $where ORDER BY service_call_id";

$serviceCallArray = array();

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stmt = $db->prepare($request);
$stmt->execute();
$stmt->bind_result($serviceCallID,$serviceCallCode,$serviceCallTitle,$serviceCallDate,$serviceCallDateDue,$customerName,$type,$priorityID,$calendarFixed,$typeColor,$statusColor,$assignTo);
while ($stmt->fetch()) {
    $serviceCallTitle=str_replace("'","",$serviceCallTitle);
    $serviceCallTitle=str_replace("\"","",$serviceCallTitle);
    $customerName=str_replace("'","",$customerName);
    $customerName=str_replace("\"","",$customerName);

    $object =  new stdClass();
    $object->id = $serviceCallID;
    $object->title = $serviceCallCode." ".$customerName." ".$type." - ".$serviceCallTitle;
    $object->start = $serviceCallDate;
    $object->end = $serviceCallDateDue;

    if(strcmp($calendarFixed,'yes')==0){
        $object->editable = false;
    } else {
        $object->editable = true;
    }

    $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $serviceCallDate);
    $firstDate = $myDateTime->format('Y-m-d');
    $firstTime = $myDateTime->format('H:i:s');

    $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $serviceCallDateDue);
    $secondDate = $myDateTime->format('Y-m-d');
    $secondTime = $myDateTime->format('H:i:s');

    if(strcmp($firstDate,$secondDate)!=0 ) {
        $object->allDay=true;
        if(strcmp($secondTime,'00:00:00')!=0) {
            $object->end = date('Y-m-d H:i:s', strtotime($serviceCallDateDue . ' +1 day'));
        }
    }
    if(strcmp($firstDate,$secondDate)==0 && strcmp($firstTime,'00:00:00')==0 && strcmp($secondTime,'00:00:00')==0) {
        $object->end = date('Y-m-d H:i:s', strtotime($serviceCallDateDue . ' +1 day'));
        $object->allDay=true;
    }


    if($priorityID == 1)
    {
        $object->color = "#b22222";
    }
    else  if($priorityID == 2)
    {
        $object->color = "#CC8E53";
    }
    else  if($priorityID == 3)
    {
        $object->color = "#4682B4";
    }
    else  if($priorityID == 4)
    {
        $object->color = "#008080";
    } else {
        $object->color = getPriorityColor($priorityID);
    }

    if(strcmp($typeColor,'')!=0){
        $object->color = $typeColor;
    }

    if(strcmp($statusColor,'')!=0){
        $object->color = $statusColor;
    }

    $spColor = getSalesPersonColor($assignTo);

    if(strcmp($spColor,'')!=0){
        $object->color = $spColor;
    }

    array_push($serviceCallArray,$serviceCallID);
    array_push($objects,$object);

}

$stmt->close();


$db->set_charset("utf8");
$stmt = $db->prepare("SELECT Salesperson_Calendar_leave.salesperson_id,CONCAT(first_name,' ',last_name,'\n',SalesPersons.salesperson_code),date_from,date_to,Salesperson_Calendar_leave.details FROM Salesperson_Calendar_leave,SalesPersons WHERE Salesperson_Calendar_leave.salesperson_id=SalesPersons.salesperson_id $whereLeave");
$stmt->execute();
$stmt->bind_result($salespersonID,$salespersonCode,$leaveStartDate,$leaveEndDate,$details);
while ($stmt->fetch()) {
    $details=str_replace("'","",$details);
    $details=str_replace("\"","",$details);

    $object =  new stdClass();
    $object->id = $salespersonID;
    $object->title = $salespersonCode."\n\n".$details;
    $object->start = $leaveStartDate;
    $object->end = $leaveEndDate;
    $object->editable = false;
    $object->color = "gray";

    $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $leaveStartDate);
    $firstDate = $myDateTime->format('Y-m-d');
    $firstTime = $myDateTime->format('H:i:s');

    $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $leaveEndDate);
    $secondDate = $myDateTime->format('Y-m-d');
    $secondTime = $myDateTime->format('H:i:s');

    if(strcmp($firstDate,$secondDate)!=0 ) {
        $object->allDay=true;
        if(strcmp($secondTime,'00:00:00')!=0) {
            $object->end = date('Y-m-d H:i:s', strtotime($serviceCallDateDue . ' +1 day'));
        }
    }
    if(strcmp($firstDate,$secondDate)==0 && strcmp($firstTime,'00:00:00')==0 && strcmp($secondTime,'00:00:00')==0) {
        $object->end = date('Y-m-d H:i:s', strtotime($serviceCallDateDue . ' +1 day'));
        $object->allDay=true;
    }
    array_push($objects,$object);

}

$stmt->close();

if(strcmp($whereReferredTo,'')!=0) {
    $db->set_charset("utf8");
    $stmt = $db->prepare("SELECT Service_Call.service_call_code,Service_Call.service_call_id,SalesPersons.salesperson_id,CONCAT(first_name,' ',last_name,' - ',SalesPersons.salesperson_code),schedule_start_date,schedule_end_date,topic,customer_company_name FROM Service_Call,SC_Referred_To,SalesPersons,Customers WHERE Service_Call.service_call_id=SC_Referred_To.service_call_id AND SalesPersons.salesperson_id=Service_Call.assign_to AND Service_Call.customer_id=Customers.customer_id AND schedule_start_date>'0000-00-00 00:00:00' AND schedule_end_date>'0000-00-00 00:00:00' AND schedule_start_date<schedule_end_date $whereReferredTo");
    $stmt->execute();
    $stmt->bind_result($serviceCallCode,$serviceCallID,$salespersonID, $salespersonCode, $leaveStartDate, $leaveEndDate, $details,$customerName);
    while ($stmt->fetch()) {
        $details = str_replace("'", "", $details);
        $details = str_replace("\"", "", $details);

        $object = new stdClass();
        $object->id = $serviceCallID;
        $object->title = "Assigned to: " . $salespersonCode . "  " . $serviceCallCode . ": $customerName - " . $details;
        $object->start = $leaveStartDate;
        $object->end = $leaveEndDate;
        $object->editable = false;
        $object->color = "gray";

        $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $leaveStartDate);
        $firstDate = $myDateTime->format('Y-m-d');
        $firstTime = $myDateTime->format('H:i:s');

        $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $leaveEndDate);
        $secondDate = $myDateTime->format('Y-m-d');
        $secondTime = $myDateTime->format('H:i:s');

        if (strcmp($firstDate, $secondDate) != 0) {
            $object->allDay = true;
            if (strcmp($secondTime, '00:00:00') != 0) {
                $object->end = date('Y-m-d H:i:s', strtotime($serviceCallDateDue . ' +1 day'));
            }
        }
        if(strcmp($firstDate,$secondDate)==0 && strcmp($firstTime,'00:00:00')==0 && strcmp($secondTime,'00:00:00')==0) {
            $object->end = date('Y-m-d H:i:s', strtotime($serviceCallDateDue . ' +1 day'));
            $object->allDay=true;
        }

        if(!in_array($serviceCallID,$serviceCallArray)){
            array_push($objects, $object);
        }

    }

    $stmt->close();
}


// sending the encoded result to success page
echo json_encode($objects);



function getPriorityColor($priorityID){
    $z='';
    global $username,$password,$database;
    $db22 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db22->set_charset("utf8");
    $stmt9 = $db22->prepare("SELECT priority_color FROM SC_Priorities WHERE priority_id = '$priorityID' LIMIT 1");
    $stmt9->execute();
    $stmt9->bind_result($color);
    while ($stmt9->fetch()) {if(strcmp($color,'')!=0){$z = $color;}}
    $stmt9->close();

    return $z;

}

function getSalesPersonColor($spID){
    $z='';
    global $username,$password,$database;
    $db9 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db9->set_charset("utf8");
    $stmt9 = $db9->prepare("SELECT email FROM SalesPersons WHERE salesperson_id='$spID'");
    $stmt9->execute();
    $stmt9->bind_result($email);
    while ($stmt9->fetch()) {
        if (strpos($email, '#') !== false) {
            $z = $email;
        }
    }
    $stmt9->close();

    return $z;
}

?>
