<?php
include_once("../../../../param.php");

$scheduleID = trim($_GET['scheduleID']);

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}




?>

<div class="container" id="main" role="main" style="width: 88%">

    <div class="row" style="margin-left:10px;margin-top:10px;">
        <div class="col-xs-12 col-sm-8 col-md-9 col-lg-2">
            <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;" id="currentDateText">
                <i class="fa-fw fa fa-map-marker"></i>
                <b>Asset Location</b>
            </h4>
        </div>
        <div class="col-xs-12 col-sm-8 col-md-9 col-lg-3">
            <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;text-align: left;" id="currentSchedule">
                <i class="fa-fw fa fa-user"></i>
                <input type='hidden' placeholder="Customers" id='customerSearch' name='customerSearch[]' style='width:300px'/>
            </h4>
        </div>
        <div class="col-xs-12 col-sm-8 col-md-9 col-lg-3">
            <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;text-align: left;" id="currentSchedule">
                <i class="fa-fw fa fa-users"></i>
                <input type='hidden' placeholder="Customer Groups" id='customerGroupSearch' name='customerGroupSearch[]' style='width:300px'/>
            </h4>
        </div>
        <div class="col-xs-12 col-sm-8 col-md-9 col-lg-3">
            <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;text-align: left;" id="currentSchedule">
                <i class="fa-fw fa fa-barcode"></i>
                <input type='hidden' placeholder="Serial Numbers" id='serialNumberSearch' name='serialNumberSearch[]' style='width:300px'/>
            </h4>
        </div>

    </div>

    <!-- MAIN CONTENT -->

    <div  id="noCordinatesContainer" class="pull-right" style="float: right;background: whitesmoke;width: 19%; height: 100%;">
        <span style=" text-align: center;font-size: 16px;"><b>Not Registered Locations</b></span>
        <div  id="noCordinates" style="float: right;background: whitesmoke;width: 100%; height: 100%; margin-top: 10px;"></div>
    </div>
    <div class="map" id="map_coprime" ></div>

</div>



<!-- Modal -->
<div class="modal fade" id="contractDetailsModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document" style="width: 60%">
        <div class="modal-content" >
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" style="margin-left:10px;"><i class="fa fa-lg fa-fw fa-file-text"></i><strong style="padding-left:5px;">Contract</strong></h4>
            </div>
            <div class="modal-body" id="contractDetailsModalBody">


            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs">
</script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<style>

    html { height: 100% }
    body { height: 100%; margin: 0px; padding: 0px }
    .container { width: 85%; height: 86% }
    #nav { z-index: 100; position: absolute;
        margin: 10px 0px 0px 200px; background-color: #fff;
        border: 1px #000 Solid; padding: 5px; }
    .map { width: 81%; height: 100% }
</style>


<script type="text/javascript">

    var copMap;
    var markers=[];

    var customerMarkers = [];

    var showCustomers = false;
    var showLines = false;

    var currentMarkerPosition = 0;
    var flightPath;
    var latlngs = [];

    function initMap()
    {
        copMap = new google.maps.Map(document.getElementById('map_coprime'), {
            center: {lat: 34.92, lng: 33.63},
            zoom: 8
        });
        updateMarkers();
    }

    function updateMarkers()
    {
        currentMarkerPosition = 0;

        var customer = $('#customerSearch').val();
        var customerGroup = $('#customerGroupSearch').val();
        var serialNumber = $('#serialNumberSearch').val();

        if(flightPath != null) {
            flightPath.setMap(null);
        }
        if(latlngs != null)
        {
            latlngs = [];
        }


        $.ajax({
            type:"POST",
            dataType: "json",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/service/controllers/getContractMarkersForMap.php',
            data: {'customer': customer,'customerGroup': customerGroup,'serialNumber': serialNumber},
            success: function(data) {

                var bounds = new google.maps.LatLngBounds();

                var counter = 0;

                for (var i = 0; i < markers.length; i++) {
                    // alert(markers.length);
                    if(markers[i] !== undefined) {
                        markers[i].setMap(null);
                    }
                }
                var nomarkers = '';
                $.each(data, function(index,value)
                {

                    if(value.mark === undefined){
                        counter = counter +1;
                    }
                    else{
                        nomarkers = nomarkers.concat(value.mark,'<br />');
                    }


                    if(value.lat > 0 && value.lng > 0){
                        var marker = new google.maps.Marker({
                            position: new google.maps.LatLng(value.lat, value.lng),
                            map: copMap,
                            title: value.name,
                            label: value.label,
                            contract: value.contract,
                            item: value.item,
                            customer: value.customer
                        });
                        google.maps.event.addListener(marker, "click", function() {
                            showDetails(marker.customer,marker.contract,marker.item);
                        });

                        markers[index] = marker;
                        latlngs[index] = marker.position;

                        bounds.extend(markers[index].position);
                    }
                    $('#noCordinates').html(nomarkers);
                });

                copMap.fitBounds(bounds);

                if(showLines) {
                    flightPath = new google.maps.Polyline({
                        path: latlngs,
                        geodesic: true,
                        strokeColor: '#FF0000',
                        strokeOpacity: 1.0,
                        strokeWeight: 2
                    });
                    flightPath.setMap(copMap);
                }
            }
        });
    }

    function showDetails(customer,contract,asset){
        $('#contractDetailsModalBody').html('');

        $.ajax({
            type: "POST",
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/service/controllers/getContractDetailsForModal.php',
            data: {
                'customer':customer,
                'contract':contract,
                'asset':asset

            },

            success: function (result) {
                $('#contractDetailsModalBody').html(result);
                $('#contractDetailsModal').modal('toggle');
            }
        });


    }

    function initCustomerAutocomplete()
    {
        $("#customerSearch").select2({
            tags: true,
            multiple: true,
            tokenSeparators: [',', ' '],
            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/customerSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
        $("#customerGroupSearch").select2({
            tags: true,
            multiple: true,
            tokenSeparators: [',', ' '],
            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/customerGroupSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
        $("#serialNumberSearch").select2({
            tags: true,
            multiple: true,
            tokenSeparators: [',', ' '],
            minimumInputLength: 2,
            minimumResultsForSearch: 1,
            ajax: {
                url: "//<?php echo HTML_PATH ?>/cop/backend/core/controllers/search/serialNumberSearch.php",
                dataType: "json",
                type: "GET",
                data: function (term, page) {
                    return {
                        query: term
                        //page: page,
                        // pageLimit: 25
                    };
                },
                results: function (data) {
                    return {
                        results: $.map(data, function (item) {
                            return {
                                text: item.name,
                                id: item.id
                            }
                        })
                    };
                }
            }
        });
    }

    function toggleLines()
    {
        if(showLines)
        {
            showLines = false;
            if(flightPath != null) {
                flightPath.setMap(null);
            }
        }
        else
        {
            showLines = true;

            flightPath = new google.maps.Polyline({
                path: latlngs,
                geodesic: true,
                strokeColor: '#FF0000',
                strokeOpacity: 1.0,
                strokeWeight: 2
            });
            flightPath.setMap(copMap);
        }
    }



    function previousMarker()
    {
        try {

            if(currentMarkerPosition > 0) {
                currentMarkerPosition = currentMarkerPosition - 1;
                var currentMarker = markers[currentMarkerPosition];
                if (currentMarker != null) {
                    currentMarker.setIcon('http://mt.googleapis.com/vt/icon/name=icons/spotlight/spotlight-poi.png');
                }
            }
            //currentMarker.setLabel((currentMarkerPosition+1).toString());
        }
        catch (err){}

    }

    function nextMarker()
    {
        try {
            if(currentMarkerPosition < markers.length)
            {
                var currentMarker = markers[currentMarkerPosition];
                if (currentMarker != null) {

                    currentMarker.setIcon('http://maps.google.com/mapfiles/ms/icons/green.png');
                    currentMarker.setLabel((currentMarkerPosition + 1).toString());
                    currentMarkerPosition = currentMarkerPosition + 1;
                }
            }
        }
        catch (err){}
    }

    $(document).ready(function() {

        pageSetUp();
        initCustomerAutocomplete();
        initMap();

        $('#customerGroupSearch').change(function(){
            updateMarkers();
        });
        $('#customerSearch').change(function(){
            updateMarkers();
        })
        $('#serialNumberSearch').change(function(){
            updateMarkers();
        })

    })

</script>

