<?php
include_once("../../../../param.php");
require_once(ROOT . "backend/core/model/RouteManager.php");
global $username,$password,$database;
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

if (isset($_POST['salesPersonID']) && strcmp($_POST['salesPersonID'],'')!=0){
    $salesPersonID = $_POST['salesPersonID'];
}
if (isset($_POST['date']) && strcmp($_POST['date'],'')!=0){
    $dateToOptimaze = $_POST['date'];
}
if (isset($_GET['salesPersonID']) && strcmp($_GET['salesPersonID'],'')!=0){
    $salesPersonID = $_GET['salesPersonID'];
}
if (isset($_GET['date']) && strcmp($_GET['date'],'')!=0){
    $dateToOptimaze = $_GET['date'];
}
if (isset($_GET['warehouse']) && strcmp($_GET['warehouse'],'')!=0){
    $warehouseID = $_GET['warehouse'];
}
if (isset($_GET['startTime']) && strcmp($_GET['startTime'],'')!=0){
    $time = $_GET['startTime'].':00';
}else{
    $time = "08:00";
}

if (isset($_GET['warehouseEnd']) && strcmp($_GET['warehouseEnd'],'')!=0){
    $warehouseIDend = $_GET['warehouseEnd'];
}
if (isset($_GET['endTime']) && strcmp($_GET['endTime'],'')!=0){
    $timeEnding = $_GET['endTime'].':00';
}

$departureTime = "$dateToOptimaze $time";
$destinationTime = "$dateToOptimaze $timeEnding";
$scDateToOptimazeStart = "$dateToOptimaze 00:00:00";
$scDateToOptimazeEnd = "$dateToOptimaze 23:59:59";
$dateToOptimazeFormat = date_format(date_create_from_format('Y-m-d', $dateToOptimaze), 'd/m/Y');

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT CONCAT(salesperson_code, ' - ',first_name, ' ', last_name) FROM SalesPersons WHERE salesperson_id = $salesPersonID LIMIT 1 ");
$stm->execute();
$stm->bind_result($salespersonName);
while ($stm->fetch()) {}
$stm->close();

$arrayOfCustomersWithoutScAddress = array();
$arrayOfCustomerAddresses = array();
$customerServiceCalls = array();
$stm = $db->prepare("SELECT service_call_id,Service_Call.customer_id,Customers.customer_code,Customers.customer_company_name,customer_address_id,service_call_code,topic,schedule_start_date,schedule_end_date,SC_Status.status_color FROM Service_Call LEFT JOIN SC_Status ON(SC_Status.status_id=Service_Call.status_id) LEFT JOIN Customers ON (Service_Call.customer_id = Customers.customer_id) WHERE assign_to='$salesPersonID' AND schedule_start_date >= '$scDateToOptimazeStart' AND schedule_end_date <= '$scDateToOptimazeEnd' AND DATE(schedule_start_date)=DATE(schedule_end_date) ORDER BY schedule_start_date ASC ");
$stm-> execute();
$stm-> bind_result($serviceCallID,$customerID,$customerCode,$customerName,$serviceCallAddressID,$serviceCallCode,$title,$scheduleStartDate,$scheduleEndDate,$statusColor);
while ($stm->fetch()) {
    $object = new stdClass();
    $object->customerID = $customerID;
    $object->addressID = $serviceCallAddressID;
    $object->code = $serviceCallCode;
    $object->name = $customerName;
    $object->id   = $serviceCallID;
    $object->title = $title;
    $object->color = $statusColor;
    $scheduleStartDate = strtotime($scheduleStartDate);
    $scheduleEndDate = strtotime($scheduleEndDate);
    $object->visitTimeMinutes  = round(abs($scheduleStartDate - $scheduleEndDate) / 60,2);
    array_push($arrayOfCustomerAddresses,$object);
}
$stm->close();

if($salesPersonID > 0) {
    $stm = $db->prepare("SELECT lat,lng,time FROM GPS_Log WHERE salesperson_id='$salesPersonID' ORDER BY time DESC LIMIT 1 ");
    $stm->execute();
    $stm->bind_result($salespersonLat, $salespersonLng,$deviceTime);
    while ($stm->fetch()) {
        $deviceTime = 'Last Recorded Location: '.date_format( date_create_from_format('Y-m-d H:i:s', $deviceTime), 'd/m/Y H:i');
    }
    $stm->close();

    $stm = $db->prepare("SELECT salesperson_code ,first_name,last_name FROM SalesPersons WHERE salesperson_id='$salesPersonID' LIMIT 1 ");
    $stm->execute();
    $stm->bind_result($salespersonCode, $salespersonFirstName,$salespersonLastName);
    while ($stm->fetch()) {}
    $stm->close();
}

foreach ($arrayOfCustomerAddresses as $object){
    $lat = 0;
    $lng = 0;
    $customerAddressID = 0;
    if($object->addressID > 0){
        $stm = $db->prepare("SELECT customer_address_id,lat,lng FROM CustomerAddress WHERE primary_address = 'yes' AND customer_address_id = $object->addressID LIMIT 1 ");
        $stm->execute();
        $stm->bind_result($customerAddressID,$lat,$lng);
        while ($stm->fetch()) {}
        $stm->close();
    } else {
        $stm = $db->prepare("SELECT customer_address_id,lat,lng FROM CustomerAddress WHERE primary_address = 'yes' AND customer_id = $object->customerID ORDER BY CustomerAddress.timestamp DESC LIMIT 1 ");
        $stm->execute();
        $stm->bind_result($customerAddressID,$lat,$lng);
        while ($stm->fetch()) {}
        $stm->close();
    }
    $object->addressID = $customerAddressID;
    $object->lat = $lat;
    $object->lng = $lng;
}

$optimazeRoute = new RouteManager();

if($warehouseID > 0) {
    $stm = $db->prepare("SELECT warehouse_id,warehouse_code,name,lat,lng FROM Warehouses WHERE warehouse_id = '$warehouseID' LIMIT 1 ");
    $stm->execute();
    $stm->bind_result($warehouseID, $warehouseCode, $warehouseName, $warehouseLat, $warehouseLng);
    while ($stm->fetch()) {
        $origin = new StdClass();
        $origin->code = "$warehouseCode";
        $origin->name = "$warehouseName";
        $origin->lat = $warehouseLat;
        $origin->lng = $warehouseLng;
        $origin->addressID = $warehouseID;
        $origin->locationIDfield = 'warehouse_id';
        $origin->locationIDtable = 'Warehouses';
    }
    $stm->close();
} else {
    $origin = array_shift($arrayOfCustomerAddresses);
    $origin->visitTimeMinutes = $optimazeRoute->getVisitTime();
    $dateTimeAT = new DateTime($departureTime);
    $dateTimeAT->add(new DateInterval('PT' . $origin->visitTimeMinutes . 'M'));
    $origin->nextDepartureTimeTitle = $dateTimeAT->format('H:i');
}

if($warehouseIDend > 0) {
    $stm = $db->prepare("SELECT warehouse_id,warehouse_code,name,lat,lng FROM Warehouses WHERE warehouse_id = '$warehouseIDend' LIMIT 1 ");
    $stm->execute();
    $stm->bind_result($warehouseID, $warehouseCode, $warehouseName, $warehouseLat, $warehouseLng);
    while ($stm->fetch()) {
        $destination = new StdClass();
        $destination->code = "$warehouseCode";
        $destination->name = "$warehouseName";
        $destination->lat = $warehouseLat;
        $destination->lng = $warehouseLng;
        $destination->addressID = $warehouseID;
        $destination->locationIDfield = 'warehouse_id';
        $destination->locationIDtable = 'Warehouses';
    }
    $stm->close();
}else{
    $destination = '';
}

$newArray = $optimazeRoute->calculateCustomRoute($departureTime,$arrayOfCustomerAddresses,$origin,$destination,$destinationTime);
$htmlCode = $optimazeRoute->createHtmlList($newArray,false);
$optimazeRoute->createModalForMarker($newArray);
$modal = $optimazeRoute->createModalForOptimization($newArray,"updateCalendar();");
?>


<div id="main" role="main" >

    <div id="content" style="padding-top:5px;">

        <div class="row" >
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-6">
                <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;" id="currentDateText">
                    <i class="fa-fw fa fa-map-marker"></i>
                    <?php  echo "$salespersonName - $dateToOptimazeFormat";?>
                </h4>
            </div>
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-4">
                <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;text-align: right;" id="currentSchedule">
                    <input type='hidden' id="elementToCheckMarker" value="multiple">
                    <input type="radio" id="singleMarker" name="markerOptions"  value="single"  />
                    <label for="huey" style="margin-right:10px;">Single</label>
                    <input type="radio" id="multipleMarker" name="markerOptions" value="multiple" checked />
                    <label for="huey">Multiple</label>
                </h4>
            </div>
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-2">
                <h4 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;text-align: right;" id="currentSchedule">
                    <i class="fa-fw fa fa-calendar"></i>

                </h4>
            </div>

        </div>

        <div class="row" >
            <div  id="noCordinatesContainer" style="float: right;background: whitesmoke;width: 20%;height:770px;overflow-y: scroll;margin-top:-1px;">
                <?php echo $htmlCode; ?>
            </div>
            <div style="width: 80%;height:770px;">
                <div class="map" id="map_coprime" ></div>
            </div>
        </div>
    </div>
</div>

</div>
</div>

<div id="modalInfoLocation" class="modal fade" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <center><b><h2 class="modal-title" id="titleModal" style="font-weight: bold"></h2></b></center>
            </div>
            <div class="modal-body">
                <div id="container"></div>

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-link pull-right" onclick="$('#modalInfoLocation').modal('hide');" >Close</button>
            </div>
        </div>
    </div>
</div>

<?php echo $modal; ?>
<script
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCXxVn57dN6LmM9EJuuVCHtGIvwK0fBNs4">
</script>

<style>

    html { height: 100% }
    body { height: 100%; margin: 0px; padding: 0px }
    #nav { z-index: 100; position: absolute;
        margin: 10px 0px 0px 200px; background-color: #fff;
        border: 1px #000 Solid; padding: 5px; }
    .map { width: 100%; height: 100% }




    .triangle {
        width: 0;
        height: 0;
        position: relative;
        border: 15px solid transparent;
        border-top: 0;
        border-bottom: 20px solid #008080;
        transform: rotate(0.5turn);
    }

    .page-footer{
        display: none;
    }


    .triangle-salesperson {
        width: 0;
        height: 0;
        position: relative;
        border: 15px solid transparent;
        border-top: 0;
        border-bottom: 20px solid #008080;
        transform: rotate(0.5turn);
    }

    .triangle-salesperson:before {
        content: "";
        width: 0;
        height: 0;
        transform: rotate(0.5turn);
        position: absolute;
        border-bottom: solid 15px transparent;
        border-top: solid 15px firebrick;
        border-left: solid 15px transparent;
        border-right: solid 15px transparent;
        top: -7px;
        left: -14px;
    }

</style>


<script type="text/javascript">
    $('input[type=radio][name=markerOptions]').change(function() {
        if (this.value == 'single') {
            $('#elementToCheckMarker').val(this.value);
        }
        else if (this.value == 'multiple') {
            $('#elementToCheckMarker').val(this.value);
        }
        initMap();
    });

    function updateCalendar(){
        $.ajax({
            type: 'POST',
            url: '//<?php echo HTML_PATH ?>/cop/backend/modules/service/controllers/updateServiceCallCallendarEvents.php',
            data: {json: <?php echo "'$optimizedServiceCallsJson'";?>},
            success: function (result) {
                if (result != 'error'){
                    $.smallBox({
                        title: "Success!",
                        content: "Success Update Calendar",
                        color: "#739E73",
                        timeout: 1000,
                        icon: "fa fa-user swing animated"
                    });
                }
            }
        });

    }

    var copMap;
    var markers=[];

    var customerMarkers = [];

    var showCustomers = false;
    var showLines = true;

    var currentMarkerPosition = 0;
    var flightPath;
    var latlngs = [];


    function CustomMarker(latlng, map, args) {
        this.latlng = latlng;
        this.args = args;
        this.setMap(map);
    }

    CustomMarker.prototype = new google.maps.OverlayView();

    CustomMarker.prototype.draw = function() {
        var self = this;
        var div = this.div;

        if (!div) {
            div = this.div = document.createElement('div');
            div.className = 'marker';
            div.style.position = 'absolute';
            div.style.cursor = 'pointer';
            div.style.transform = 'translate(-50%, -100%)';
            div.innerHTML = self.args.html;

            google.maps.event.addDomListener(div, "click", function(event) {
                google.maps.event.trigger(self, "click");
            });

            var panes = this.getPanes();
            panes.overlayImage.appendChild(div);
        }

        var point = this.getProjection().fromLatLngToDivPixel(this.latlng);

        if (point) {
            div.style.left = point.x + 'px';
            div.style.top = point.y + 'px';
        }
    };

    CustomMarker.prototype.remove = function() {
        if (this.div) {
            this.div.parentNode.removeChild(this.div);
            this.div = null;
        }
    };

    CustomMarker.prototype.getPosition = function() {
        return this.latlng;
    };

    function initMap()
    {
        copMap = new google.maps.Map(document.getElementById('map_coprime'), {
            center: {lat: 35.039380, lng: 33.388666},
            zoom: 8
        });
        updateMarkers(<?php echo json_encode($newArray); ?>);
    }

    function updateMarkers(data)
    {
        currentMarkerPosition = 0;



        if(flightPath != null) {
            flightPath.setMap(null);
        }
        if(latlngs != null)
        {
            latlngs = [];
        }





        var bounds = new google.maps.LatLngBounds();

        var counter = 0;
        var latLngCounter = 0;

        for (var i = 0; i < markers.length; i++) {
            markers[i].setMap(null);
        }
        var nomarkers = '';
        var firstDepartureTime = '';
        var isFirstMarker = true;
        var prevLat = 0;
        var prevLng = 0;
        $.each(data, function(index,value)
        {

            if(value.mark === undefined){
                counter = counter +1;
            }
            else{
                nomarkers = nomarkers.concat(value.mark,'<br />');
            }


            if(value.lat > 0 && value.lng > 0){

                if(value.lat == prevLat && value.lng == prevLng){
                    value.lat = value.lat - 0.000007;
                    value.lng = value.lng - 0.000007;
                } else {
                    prevLat = value.lat;
                    prevLng = value.lng;
                }

                if(isFirstMarker){
                    isFirstMarker = false;
                    firstDepartureTime = value.departureTime;
                }
                var marker = new google.maps.Marker({
                    position: new google.maps.LatLng(value.lat, value.lng),
                    map: copMap,
                    title: value.name,
                    label: value.counterString
                });

                var divColor = "black";
                var markerColor = value.color;
                var textColor = 'white';

                 if(value.color == null || markerColor.localeCompare('')==0){
                     markerColor = '#f3f3f3';
                     var textColor = 'black';
                }

                var nameLabel = '' + value.name;
                if(nameLabel.localeCompare('')==0 || nameLabel.localeCompare('undefined')==0){nameLabel = value.code;}
                var checkMarkerType = $('#elementToCheckMarker').val();
                if (checkMarkerType==='multiple'){
                    var htmlForMarker = '<div style="background-color:' + markerColor + ';padding:0px;color:' + textColor + ';font-weight:bold;border-radius:20px;border: 3px solid ' + divColor + ';">'
                        + ' <div style="border-bottom: 1px solid grey;padding-bottom:3px;padding:2px;border-top-left-radius: 80px 80px;border-top-right-radius: 80px 80px;width:100%;box-shadow: rgba(0, 0, 0, 0.17) 0px -23px 25px 0px inset, rgba(0, 0, 0, 0.15) 0px -36px 30px 0px inset, rgba(0, 0, 0, 0.1) 0px -79px 40px 0px inset;">'
                        +'<center>' + counter + '</center>'
                        +'</div>'
                        +'<div style="padding:7px;margin-bottom:3px;">'
                        +'<i class="fa fa-user"></i>&nbsp; ' + nameLabel + '<br>'
                        +'<i class="fa fa-clock-o"></i>&nbsp; ' + value.arrivalTimeTitle
                        +'</div>'
                        +'</div>'
                        +'<center><div class="triangle custom-maps-marker-overlay" style="border-bottom: 20px solid ' + divColor + ';"></div></center>';
                }else{
                    var htmlForMarker = '';
                }


                var overlay = new CustomMarker(
                    new google.maps.LatLng(value.lat, value.lng),
                    copMap,
                    {
                        marker_id: index,
                        html : htmlForMarker
                    }
                );

                overlay.addListener('click',function(){
                    $("#titleModal").text(value.counter);
                    $('#container').html(value.htmlElementToModal);
                    $('#modalInfoLocation').modal('show');
                });



                markers[index] = marker;
                latlngs[latLngCounter++] = marker.position;

                bounds.extend(markers[index].position);
            }





            $('#noCordinates').html(nomarkers);
        });

        var salesPersonPositionmarker = new CustomMarker(
            new google.maps.LatLng(<?php echo "'$salespersonLat','$salespersonLng'"?>),
            copMap,
            {
                marker_id: markers.length + 1,
                html: '<div style="background-color:firebrick;color:white;font-size:18px;padding:0px;border-radius:20px;margin-bottom:-5px;border: 3px solid black;">'
                    + '<img style="display:inline;width:40px;height:40px;" class="custom-rounded-image" src="//<?php echo HTML_PATH; ?>/cop/backend/themes/<?php echo THEME_NAME; ?>/img/waybillicon.png" width="30" height="30">'
                    + '</div>'
                    + '<center><div class="triangle-salesperson custom-maps-marker-overlay" style="border-bottom: 20px solid black;"></div></center>'
            }
        );

        salesPersonPositionmarker.addListener('click',function(){
            $("#titleModal").text('<?php echo "$salespersonCode - $salespersonFirstName $salespersonLastName"?>');
            $('#container').html('<center><?php echo $deviceTime;?></center>');
            $('#modalInfoLocation').modal('show');
        });

        copMap.fitBounds(bounds);


        var arrayWaypoints = latlngs;
        var countLatLng = latlngs.length;
        console.log(countLatLng);
        var check = 0;
        var min = 0;
        var max = 0;
        var dif = 0 ;
        var defaultCheck = 0;
        var variableName = [];
        if(countLatLng<20){
            max = countLatLng-1;
        }else{
            max = 19;
        }
        // console.log('ALL :'+arrayWaypoints);
        while(check<(countLatLng-1)){
            defaultCheck++;
            if ((max-1)==min){
                arrayToCallGoogleAPI=[];
            }else{
                if ((min+1) == (max-1)){
                    console.log('here');
                    arrayToCallGoogleAPI = [arrayWaypoints[max-1]];
                }else{
                    arrayToCallGoogleAPI = arrayWaypoints.slice(min+1,max);
                }
            }
            // console.log('Min: '+min+' Max: '+max);
            originToCallGoogleAPI = arrayWaypoints[min];
            destinationToCallGoogleAPI = arrayWaypoints[max];
            // console.log('Anaxorish: '+originToCallGoogleAPI);
            // console.log('Staseis: ' +arrayToCallGoogleAPI);
            // console.log('Afixh: ' +destinationToCallGoogleAPI);
            variableName[defaultCheck] = 'request_'+defaultCheck;
            // console.log (variableName[defaultCheck]);
            variableName[defaultCheck] = {
                origin: originToCallGoogleAPI,
                destination: destinationToCallGoogleAPI,
                waypoints: arrayToCallGoogleAPI.map(waypoint => ({ location: waypoint, stopover: true })),
                travelMode: google.maps.TravelMode.DRIVING,
                drivingOptions: {
                    departureTime: new Date(firstDepartureTime),
                }
            };
            var directionService = 'directionsService_'+defaultCheck;
            var directionRender = 'directionsService_'+defaultCheck;
            var arrayToRoute = variableName[defaultCheck];
            toShowRouteOnMap(directionService,directionRender,arrayToRoute);
            check += (max+1);
            if ((countLatLng-check)>20){
                min = check-1;
                max=check+19;
            }else{
                dif =countLatLng-check;
                min = check-1;
                max = check+dif-1;
            }
            // console.log('Check: '+check);
            if (defaultCheck>5){
                break;
            }
        }

    }


    function toShowRouteOnMap(directionService,directionRender,arrayToRoute){
        directionService = new google.maps.DirectionsService();
        directionRender = new google.maps.DirectionsRenderer({map: copMap,suppressMarkers: true});

        directionService.route(arrayToRoute, function (response, status) {
            if (status === google.maps.DirectionsStatus.OK) {
                directionRender.setDirections(response);
            }else if (status === google.maps.DirectionsStatus.OVER_QUERY_LIMIT){
                console.log('error error');
            }else {
                console.log("Directions request failed due to " + status);
            }
        });
    }





    $(document).ready(function() {

        pageSetUp();

        initMap();

    })

</script>



<!--<div id="main" role="main" class="background-color-whitish">-->
<!---->
<!---->
<!--    <div id="ribbon" class="bg-color-blue">-->
<!---->
<!--				<span class="ribbon-button-alignment">-->
<!--					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">-->
<!--						<i class="fa fa-refresh"></i>-->
<!--					</span>-->
<!--				</span>-->
<!---->
<!---->
<!--        <ol class="breadcrumb">-->
<!--            <li class="txt-color-white">Home / Practice Code </li>-->
<!--        </ol>-->
<!---->
<!---->
<!--    </div>-->
<!---->
<!--    <div id="content">-->
<!---->
<!--        <div class="row">-->
<!--            <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6">-->
<!--                <h3 style="display:inline;margin-left:10px;" class="page-title txt-color-blueDark header-margin">-->
<!--                    <i class="fa-fw fa fa-signal"></i>-->
<!---->
<!--                </h3>-->
<!--            </div>-->
<!--        </div>-->
<!---->
<!---->
<!--        <section id="widget-grid" class="" style="margin-top:10px;">-->
<!---->
<!--            <div class="row">-->
<!---->
<!---->
<!--                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">-->
<!---->
<!--                    <div class="jarviswidget jarviswidget-color-blueDark" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">-->
<!--                        <header>-->
<!--                            <span class="widget-icon"> <i class="fa fa fa-table"></i> </span>-->
<!--                            <h2>Practice Code</h2>-->
<!--                        </header>-->
<!---->
<!--                        <div>-->
<!---->
<!--                            <br>-->
<!--                            <pre>-->
<!--                                --><?php
//                                var_dump($newArray);
//                                ?>
<!--                            </pre>-->
<!--                            callendar-->
<!--                            <pre>-->
<!--                                --><?php
//                                echo $optimizedServiceCallsJson;
//                                ?>
<!--                            </pre>-->
<!---->
<!---->
<!--                        </div>-->
<!---->
<!---->
<!--                    </div>-->
<!---->
<!--                </article>-->
<!---->
<!--            </div>-->
<!---->
<!---->
<!--    </div>-->
<!---->
<!--    </section>-->
<!---->
<!--</div>-->


<script type="text/javascript">


    $(document).ready(function() {
        pageSetUp();
    })

</script>













































