<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");

$settlementID  = trim($_POST['settlementID']);
$status        = trim($_POST['status']);
$createZReport = trim($_POST['createZReport']);
ob_start();
if(strcmp($status, "") != 0 && $settlementID > 0) {
    global $username, $password, $database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    try {
        $db->begin_transaction();

        echo "status -> $status\n";
        switch ($status){
            case "Rejected":
                echo "CASE -> $status\n";
                $receiptsArray=array();
                $stmt = $db->prepare("SELECT receipt_id FROM Settlement_Receipt WHERE settlement_id=?");
                $stmt->bind_param('i',$settlementID);
                $stmt->execute();
                if(strcmp($stmt->error,"")!=0) {throw new Exception($stmt->error);}
                $stmt->bind_result($receiptID);
                while ($stmt->fetch()) {array_push($receiptsArray,$receiptID);}
                $stmt->close();

                foreach ($receiptsArray as $receiptID){
                    $stmt = $db->prepare("UPDATE Receipts SET status='to be checked' WHERE receipt_id=?");
                    $stmt->bind_param('i', $receiptID);
                    $stmt->execute();
                    if(strcmp($stmt->error,"")!=0) {throw new Exception($stmt->error);}
                    $stmt->close();
                }
                $stmt = $db->prepare("DELETE FROM Settlement_Receipt WHERE settlement_id=?");
                $stmt->bind_param('i',$settlementID);
                $stmt->execute();
                if(strcmp($stmt->error,"")!=0) {throw new Exception($stmt->error);}
                $stmt->close();

                break;
            case "Approved / Waiting Cashier":
                echo "CASE -> $status\n";

                $stmt = $db->prepare("SELECT settlement_code FROM Settlements WHERE settlement_id=?");
                $stmt->bind_param('i',$settlementID);
                $stmt->execute();
                if(strcmp($stmt->error,"")!=0) {throw new Exception($stmt->error);}
                $stmt->bind_result($zCode);
                while ($stmt->fetch()) {}
                $stmt->close();

                $receiptsArray=array();
                $stmt = $db->prepare("SELECT Receipts.receipt_id,receipt_code,receipt_date,amount,cash_discount,salesperson_id FROM Settlement_Receipt,Receipts WHERE Settlement_Receipt.receipt_id=Receipts.receipt_id AND settlement_id=?");
                $stmt->bind_param('i',$settlementID);
                $stmt->execute();
                if(strcmp($stmt->error,"")!=0) {throw new Exception($stmt->error);}
                $stmt->bind_result($receiptID,$receiptCode,$receiptDate,$amount,$cashDiscount,$salespersonID);
                while ($stmt->fetch()) {

                    $total = $amount+$cashDiscount;

                    $receipt = new stdClass();
                    $receipt->id = $receiptID ;
                    $receipt->code = $receiptCode ;
                    $receipt->date = $receiptDate ;
                    $receipt->amount = $amount ;
                    $receipt->cashDicount = $cashDiscount ;
                    $receipt->total = $total ;
                    $receipt->salesperson = $salespersonID ;

                    array_push($receiptsArray,$receipt);
                }
                $stmt->close();

                if(strcmp($createZReport,'yes')==0) {

                    foreach ($receiptsArray as $receipt) {

                        $lockID = getNextIDSingleTransaction('ZE_Z_Report', 'lock_id', $db);
                        $receiptID = $receipt->id;
                        $salespersonID = $receipt->salesperson;
                        $documentType = 'Receipts';
                        $zDate = date('Y-m-d');
                        $zStartTime = date('Y-m-d');
                        $subtotal = $receipt->total;
                        $discount = 0;
                        $vatAmount = 0;
                        $grandTotal = $receipt->total;

                        echo "INSERT INTO Z_Report $lockID, $receiptID, $documentType, $zCode, $zDate, $zStartTime, $salespersonID, $subtotal, $discount, $vatAmount, $grandTotal\n";

                        $stmt = $db->prepare("INSERT INTO ZE_Z_Report (lock_id, document_id, document_type, lock_number, z_date, start_z_time, salesperson_id, subtotal, discount_amount, vat_amount, grand_total, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
                        $stmt->bind_param('sssssssssss', $lockID, $receiptID, $documentType, $zCode, $zDate, $zStartTime, $salespersonID, $subtotal, $discount, $vatAmount, $grandTotal);
                        $stmt->execute();
                        if (strcmp($stmt->error, "") != 0) {throw new Exception($stmt->error);}
                        $stmt->close();
                    }
                }

                break;
        }


        $stmt = $db->prepare("UPDATE Settlements SET status=? WHERE settlement_id=?");
        $stmt->bind_param('si', $status,$settlementID);
        $stmt->execute();
        if(strcmp($stmt->error,"")!=0) {throw new Exception($stmt->error);}
        $stmt->close();

        $db->commit(true);
        ob_end_clean();
        echo '0';

    } catch (Exception  $e) {
        echo $e."\n ---ROLLBACK--- \n";
        $db->rollback();
    }
}

function getNextSettlementCodeSingleTransaction($table,$field,$tablePrefix,$activationCode,$db)
{
    $result   = 0;
    $prefix   = '';
    $nextCode = '';

    $stm1 = $db->prepare("SELECT display_prefix FROM Devices WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($prefix);
    while ($stm1->fetch()) {}
    $stm1->close();

    if(strcmp($prefix,'')!=0) {
        $prefix = $tablePrefix.$prefix;
        $stm = $db->prepare("SELECT REPLACE($field, '$prefix', '')+1 AS counter FROM $table WHERE $field LIKE'$prefix%' AND REPLACE($field, '$prefix', '') REGEXP '^-?[0-9]+$' ORDER BY counter DESC LIMIT 1");
        $stm->execute();
        $stm->bind_result($nextCode);
        while ($stm->fetch()) {
            if(is_numeric($nextCode) && $nextCode > 0){
                $result=$nextCode;
            }
        }
        $stm->close();
    } else {
        $prefix = $tablePrefix.$prefix;
    }

    if($result > 0){
        return $prefix.$result;
    } else {
        return $prefix.'100001';
    }


}

function getNextIDSingleTransaction($tableName,$idName,$db)
{
    $z=0;
    if(isset($_SESSION['prefix']) && $_SESSION['prefix'] > 0)
    {
        $prefix=$_SESSION['prefix'];
    }

    $likeVar = $prefix."%";
    $stm1 = $db->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($nextID);
    while ($stm1->fetch()) {

        $z = substr($nextID,4,strlen($nextID));
        $z+=1;


    }
    $stm1->close();


    return $prefix.$z;




}
?>