<?php
include_once("../../../../param.php");
// DB table to use
$table = 'Receipts';
 
// Table's primary key
$primaryKey = "receipt_code";
$customerID = trim($_GET['customerID']);
$settlementID = trim($_GET['settlementID']);

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`r`.`receipt_id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $check = false;
        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT attachment_url FROM Action_Attachments WHERE  action_id='$d' AND action_type='Receipts' ORDER BY timestamp DESC LIMIT 1 ");
        $stm1-> execute();
        $stm1-> bind_result($imgName);
        while ($stm1->fetch()) {
            if(strcmp($imgName,'')!=0) {
                $d = '//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/imageicon.png';
                if (file_exists(ROOT . "media/actionAttachments/$imgName")) {
                    $check = true;
                }
            }

        }
        $stm1->close();
        if(!$check) {
            $d = '//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/receipticon.png';
        }

        return '<img class="custom-rounded-image receipt center-canvas" src="'.$d.'" width="30" height="30" onclick="getImage(\''.$imgName.'\')" title="'.$imgName.'" ></td>';},
        'field' => 'receipt_id' ),
     array( 'db' => '`r`.`receipt_code`', 'dt' =>  'code', 'field' =>'receipt_code' ),
       array( 'db' => '`c`.`customer_code`', 'dt' => 'cCode', 'field' => 'customer_code' ),
    array( 'db' => '`r`.`status`', 'dt' => 'status', 'field' => 'status' ),

    array( 'db' => '`r`.`bank`', 'dt' => 'bank', 'field' => 'bank' ),
    array( 'db' => '`r`.`payment_method`', 'dt' => 'method', 'field' => 'payment_method' ),
    array( 'db' => '`r`.`cheque_number`', 'dt' => 'cheque_number', 'field' => 'cheque_number' ),
    array( 'db' => '`r`.`cheque_date`', 'dt' => 'cheque_date', 'field' => 'cheque_date' ),

       array( 'db' => '`c`.`customer_company_name`', 'dt' => 'cName', 'field' => 'customer_company_name' ),
     array( 'db' => '`r`.`receipt_date`', 'dt' => 'date' ,'formatter' => function( $d, $row ) {
         return date('d-m-Y',strtotime($d));}, 'field' => 'receipt_date' ),
    
            array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),
    array( 'db' => '`r`.`amount`', 'dt' => 'amount', 'formatter' => function( $d, $row ) {
        return currencySymbol . number_format($d,'2','.',',');},
        'field' => 'amount' ),
    array( 'db' => '`r`.`cash_discount`', 'dt' => 'cash_discount', 'formatter' => function( $d, $row ) {
        return currencySymbol . number_format($d,'2','.',',');},
        'field' => 'cash_discount' ),
    array( 'db' => '`r`.`receipt_id`', 'dt' => 'buttons', 'formatter' => function( $d, $row ) {
        $buttons = '';

        $buttons .= '<form id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/modules/settlements/views/view_fast_receipt.php" method="post" style="display: inline-block; margin-bottom: 3px;">
                    <input type="hidden" name="receipt_id" value="'.$d.'">	           			                   
                    <input style="font-size:13px;width:65px" type="submit" class="btn btn-orange" value="View" >
                </form>';

        $buttons .= '<button type="button" class="btn btn-danger " onclick="cancelReceipt('.$d.')">Cancel</button>';

        return "$buttons";},
        'field' => 'receipt_id' ),

    array( 'db' => '`r`.`receipt_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        if(isset($_POST['autoReceiptsString']) && strcmp($_POST['autoReceiptsString'],'')!=0){
            $disabled = 'disabled';
        } else {
            $disabled = 'disabled';
        }
        return "<input type='checkbox' class='form-control' name='receipt' id='$d' style='width: 100%;' checked $disabled>";
        },
        'field' => 'receipt_id' )
);

 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */


$joinQuery = "FROM `Receipts` AS `r` LEFT JOIN `Customers` AS `c` ON (`r`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`r`.`salesperson_id` = `s`.`salesperson_id`)";

if(isset($_POST['autoReceiptsString']) && strcmp($_POST['autoReceiptsString'],'')!=0){
    $where = " 1=1 AND NOT `r`.`status` = 'Canceled' AND `r`.`receipt_id` IN (".$_POST['autoReceiptsString'].") ";
} else {
    $where = " 1=1 AND NOT `r`.`status` = 'Canceled' AND `r`.`receipt_id` IN (SELECT receipt_id FROM Settlement_Receipt WHERE settlement_id = '$settlementID' ) ";

}

if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `i`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}


require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>