<?php
require "../model/smsSender.php";
require "../../../../concc/dbinfo.php";

$tomorrow = date('Y-m-d',strtotime(date('Y-m-d') . "+1 days"));
$messageDate = date_format( date_create_from_format('Y-m-d', $tomorrow), 'd/m/Y');

$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$send = false;
$message = "Meetings for $messageDate:<br>";
$db->set_charset("UTF8");
$stm = $db->prepare("SELECT service_call_id,topic,customer_company_name,schedule_start_date,schedule_end_date FROM Service_Call,Customers WHERE Service_Call.customer_id=Customers.customer_id AND type_id = 20 AND assign_to = 1 AND DATE(schedule_start_date) = DATE('$tomorrow') ");
$stm-> execute();
$stm->store_result();
$stm-> bind_result($id,$title,$customer,$date,$end);
while ($stm->fetch()) {
    $location = getLastValueOfCustomForm(1,2,"Service_Call",$id);
    if(strcmp($customer,'')!=0){
        $date = date_format( date_create_from_format('Y-m-d H:i:s', $date), 'd/m/Y | H:i');
        $date = explode('|',$date);
        $end = date_format( date_create_from_format('Y-m-d H:i:s', $end), 'd/m/Y | H:i');
        $end = explode('|',$end);
        $send = true;
        $message .= "<br>Time: $date[1] -$end[1]<br>Location: $location<br>$customer<br>$title<br>";
    }
}
$stm-> close();

if($send){

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT sms_supplier,sms_username,sms_password FROM Cloud_Configuration LIMIT 1");
    $stm->execute();
    $stm->bind_result($smsSupplier,$smsUserName,$smsPassword);
    while ($stm->fetch()) {}
    $stm->close();

    $sms = new sms();
// Connection to SMS provider
    $sms->setSupplier($smsSupplier);
    $sms->setUsername($smsUserName);
    $sms->setPassword($smsPassword);

    // SMS Context
    $sms->setTitle('COPRIME');
    $sms->setContent($message);

    // Send SMS
    $sms->setMobile('99961125');
    $sms->sendSms();
    echo $sms->getError();

} else {
    echo "Meetings: ".$message." NONE";
}

function getLastValueOfCustomForm($customFormID,$customFieldID,$tableName,$tableID)
{
    global $db;
    $value="";
    $stm = $db->prepare("SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Object.custom_form_id='$customFormID' AND ZA_Custom_Form_Object.custom_form_id =ZA_Custom_Form_Usage.custom_form_id AND ZA_Custom_Form_Usage.linked_table='$tableName' AND  ZA_Custom_Form_Object.linked_table_id='$tableID' AND ZA_Custom_Form_Object.custom_form_object_id=ZA_Custom_Field_Object.custom_form_object_id AND ZA_Custom_Field_Object.custom_field_id='$customFieldID' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($value);
    while ($stm->fetch()) {


    }
    $stm-> close();

    return $value;
}