<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Firebase_Notifications';

// Table's primary key
$primaryKey = "id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`f`.`id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {return '<span class="return" style="padding: 5px;border-radius: 15px;" title="'.$d.'"><img class="" src="//'.HTML_PATH.'/cop/backend/themes/'.THEME_NAME.'/img/tendericon.png" width="18" height="15"></span>';}, 'field' => 'id' ),
    array( 'db' => '`f`.`schedule_batch`', 'dt' =>  'batchSchedule', 'field' =>'schedule_batch' ),

    array( 'db' => '`f`.`schedule_batch`', 'dt' =>  'forGlobal','formatter' => function( $d, $row ) {
        $GLOBALS["globalNum"] = $d;
    }, 'field' =>'schedule_batch' ),

    array( 'db' => '`f`.`device_id`', 'dt' =>  'device_id', 'field' =>'device_id' ),
    array( 'db' => '`f`.`sender_id`', 'dt' =>  'sender_id', 'field' =>'sender_id' ),
    array( 'db' => '`f`.`sender_name`', 'dt' =>  'sender_name', 'field' =>'sender_name' ),
    array( 'db' => '`f`.`recipient_id`', 'dt' =>  'recipient_id', 'field' =>'recipient_id' ),
//    array( 'db' => 'GROUP_CONCAT(`f`.`recipient_name` SEPARATOR ", ") as recipient_name', 'dt' =>  'recipient_name', 'field' =>'recipient_name'),

    array( 'db' => 'GROUP_CONCAT(`f`.`recipient_name`,"||",`f`.`schedule_date`,"||",`f`.`status` SEPARATOR "|-|") AS `recipient_name`',  'dt' => 'recipient_name', 'field' => 'recipient_name', 'formatter' => function( $d, $row ) {

        $dArray = explode('|-|',$d);
        $batchNum = $GLOBALS["globalNum"];
        $result = '<button class="btn btn-return btn-block" onclick="$(\'#batchNum'.$batchNum.'\').toggle();" >Recepient Info</button>';
        $result .= '<div id="batchNum'.$batchNum.'" style="display:none;"><br>';
        foreach($dArray as $salesPDateStatus){
            $salesPDateStatusArray = explode('||',$salesPDateStatus);
            $salesP = $salesPDateStatusArray[0];
            $sentDate = $salesPDateStatusArray[1];
            $sentStatus = $salesPDateStatusArray[2];
            if(strcmp($salesP.$sentDate,'')!=0) {
                if(strcmp($sentStatus,'')==0){$sentStatus = '<b style="color: goldenrod">Pending</b>';}
                if(strcmp($sentStatus,'Sent')==0){$sentStatus = '<b style="color: green">Sent!</b>';}
                $sentDate = date_format( date_create_from_format('Y-m-d H:i:s', $sentDate), 'd/m/y H:i');
                $result .= "<ul><li>$salesP</li><li>$sentDate</li><li>Status: $sentStatus</li></ul><br>";
            }
        }
        $result .= '</div>';

        return $result;
    }),

    array( 'db' => '`f`.`notification_type`', 'dt' =>  'notification_type','formatter' => function( $d, $row ) { return ucwords(preg_replace('/(?<!\ )[A-Z]/', ' $0', $d)); }, 'field' =>'notification_type' ),
    array( 'db' => '`f`.`title`','formatter' => function( $d, $row ) {if(strcmp('',$d)==0){$d='-';}return $d;}, 'dt' =>  'title', 'field' =>'title' ),
    array( 'db' => '`f`.`body`', 'dt' =>  'body','formatter' => function( $d, $row ) {if(strcmp('',$d)==0){$d='-';}return $d;}, 'field' =>'body' ),
    array( 'db' => '`f`.`silent`', 'dt' =>  'silent', 'field' =>'silent' ),
    array( 'db' => '`f`.`coprime_app`', 'dt' =>  'coprime_app','formatter' => function( $d, $row ) {

        switch ($d){
            case 'sal':
                $type = 'Sales';
                break;
            case 'pur':
                $type = 'Purchase';
                break;
            default:
                $type = $d;
        }

        return $type;

    }, 'field' =>'coprime_app' ),
    array( 'db' => '`f`.`date_sent`', 'dt' => 'date_sent' ,'formatter' => function( $d, $row ) {if(strcmp($d,'0000-00-00 00:00:00')==0){return '-';}else{date_default_timezone_set('Europe/Athens'); return date('d-m-Y H:i:s',strtotime($d)+ date('Z'));}}, 'field' => 'date_sent' ),
    array( 'db' => '`f`.`date_received`', 'dt' => 'date_received' ,'formatter' => function( $d, $row ) {if(strcmp($d,'0000-00-00 00:00:00')==0){return '-';}else{return date('d-m-Y H:i:s',strtotime($d));}}, 'field' => 'date_received' ),
    array( 'db' => '`f`.`date_seen`', 'dt' => 'date_seen' ,'formatter' => function( $d, $row ) {if(strcmp($d,'0000-00-00 00:00:00')==0){return '-';}else{return date('d-m-Y H:i:s',strtotime($d));}}, 'field' => 'date_seen' ),
    array( 'db' => '`f`.`firebase_message_id`', 'dt' =>  'firebase_message_id', 'field' =>'firebase_message_id' ),
    array( 'db' => '`f`.`schedule_date`', 'dt' =>  'dateTime', 'field' =>'schedule_date' ),
    array( 'db' => '`f`.`status`', 'dt' =>  'status', 'field' =>'status' ),
    array( 'db' => '`f`.`schedule_batch`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        return '
			<button  type="button" class="btn btn-danger contractDeleteButton" onclick="changeStatusScheduleNotification('.$d.')" style="width:70px">Cancel</button>
			'
            ;},
        'field' => 'schedule_batch' )



);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

$where = '';

if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `f`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Firebase_Notifications` AS `f` ";

//edw tha exw na m fernei mono auta pou exoun schedule
if(strcmp($where,'')!=0){$where.= " AND ";}
$where .= " `f`.`notification_type`='Schedule' AND NOT `f`.`status`='Canceled' GROUP BY schedule_batch";

require(ROOT . 'backend/core/controllers/ssp2.class.php');

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>