<?php
foreach (glob("./cop_*.zip") as $filename) {
    if(strpos($filename, 'archive') == false ){
        if (preg_match('#[0-9]#',$filename)){
            $updateFile = $filename;
            $newVersion = str_replace('./cop_','',$filename);
            $newVersion = str_replace('.zip','',$newVersion);
        }
    }
}

$redirectURL = "./cop/";

?>

<!DOCTYPE html>
<html lang="en-us" id="extr-page">
<head>
    <meta charset="utf-8">
    <title> Coprime Mobile Commerce</title>
    <meta name="description" content="">
    <meta name="author" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <style>

        .btn {
            color: #fff !important;
            background-color: #396BBD;
            border-color: #315DA3;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 20px;

        }

        .btn-warning {
            color: #fff !important;
            background-color: #d59634;
            border-color: #d99227;
            padding: 15px 32px;
            text-align: center;
            text-decoration: none;
            display: inline-block;
            font-size: 20px;

        }

        .dot {
            height: 45px;
            width: 45px;
            background-color: #bbb;
            border-radius: 50%;
            border-color: #0a0a0a;
            display: inline-block;
        }

        .dot-complete {
            background-color: darkgreen;
        }
        .dot-not-complete {
            background-color: firebrick;
        }

        .in_progress {
            background-color: #315DA3;
        }

        .blink {
            background-color: darkgoldenrod;
            animation: blinker 1s linear infinite;
        }

        .form-control {
            width: 100%;
            padding: 12px 20px;
            margin: 8px 0;
            display: block;
            border: 1px solid #ccc;
            border-radius: 4px;
            box-sizing: border-box;
        }

        .form-label {
            text-align: center;
            color: dimgrey;
            width: 100%;
            font-size: large;
            margin: 8px 0;
            display: block;

        }

        @keyframes blinker {
            50% {
                opacity: 0;
            }
        }

    </style>
</head>

<body>
<center>

    <div style='margin-top: 40px;font-size: 25px;color: steelblue;font-family: "Helvetica Neue", Helvetica, Arial, sans-serif'>
        Coprime Mobile Commerce
    </div>

    <button type="button" class="btn" id="initiate" onclick="StepOne()" style="margin-top: 50px;display: block;"> Start Update</button>

    <div style="margin-top: 0px;display: none" id="progressBar">
        <span class="dot in_progress" id="stepOneDot"></span>
        <svg height="75" width="50">
            <line x1="0" y1="50" x2="50" y2="50" style="stroke:grey;stroke-width:2"/>
        </svg>
        <span class="dot" id="stepTwoDot"></span>
        <svg height="75" width="50">
            <line x1="0" y1="50" x2="50" y2="50" style="stroke:grey;stroke-width:2"/>
        </svg>
        <span class="dot" id="stepThreeDot"></span>
        <svg height="75" width="50">
            <line x1="0" y1="50" x2="50" y2="50" style="stroke:grey;stroke-width:2;"/>
        </svg>
        <span class="dot" id="stepFourDot"></span>
        <svg height="75" width="50">
            <line x1="0" y1="50" x2="50" y2="50" style="stroke:grey;stroke-width:2;"/>
        </svg>
        <span class="dot" id="stepFiveDot"></span>
    </div>

    <label style="display: block;margin-bottom: 20px;margin-top: 20px;color: grey; font-size: 40px;" id="progressLabel"> </label>
    <button type="button" class="btn" id="button" onclick="window.open('<?php echo $redirectURL?>', '_blank');" style="display: none;margin-bottom: 10px;">Open Back-Office</button>
    <button type="button" class="btn" id="buttonRedirect" onclick="location.href ='<?php echo $redirectURL?>'" style="display: none;margin-bottom: 10px;">Go to Back-Office</button>
    <button type="button" class="btn btn-warning" id="buttonRetry" onclick="StepOne()" style="display: none;margin-bottom: 10px;">Restart Process</button>
    <span style="margin-bottom: 90px;">&nbsp;</span>
</center>

<pre style="display: block;margin: 20px;width: 100%;font-size: 22px;" id="errorLog"> </pre>


<script src="https://code.jquery.com/jquery-1.9.1.min.js"></script>
<script>

    function displayError() {

        $.ajax({
            type: "POST",
            url: './updateHelper.php',
            data: {'errorLog':1},
            success: function (result) {
                $("#errorLog").html(result);
            }
        });


    }

    function StepOne() {
        $("#errorLog").html('');
        $("#initiate").css("display", "none");
        $("#progressBar").css("display", "block");
        $("#stepOneDot").removeClass("dot-not-complete").removeClass("dot-complete").addClass("blink");
        $("#stepTwoDot").removeClass("blink").removeClass("dot-complete");
        $("#button").css("display", "none");

        $("#progressLabel").html("Archiving Previous Version").css('color','');

        $.ajax({
            type: "POST",
            url: './updateHelper.php',
            data: {'stepOne':1},
            success: function (result) {
                StepTwo(result);
            },
            error: function(XMLHttpRequest, textStatus, errorThrown) {
                StepTwo(0);
            }
        });


    }

    function StepTwo(val) {
        if(val > 0) {
            $("#errorLog").html('');
            $("#stepOneDot").removeClass("dot-not-complete").removeClass("blink").removeClass("in_progress").addClass("dot-complete");
            $("#stepTwoDot").addClass("blink");
            $("#stepThreeDot").removeClass("blink").removeClass("dot-complete");
            $('#button').css("display", "none");

            $("#progressLabel").html("Extracting Version <?php echo $newVersion?>").css('color','');

            $.ajax({
                type: "POST",
                url: './updateHelper.php',
                data: {'StepTwo':1},
                success: function (result) {
                    StepThree(result);
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    StepThree(0);
                }
            });

        } else {
            $("#stepOneDot").removeClass("blink").removeClass("in_progress").addClass("dot-not-complete");
            $("#progressLabel").html("Archiving Failed").css('color','firebrick');
            $("#button").css("display", "block");
            $("#buttonRetry").css("display", "block").attr("onclick","StepOne()").html("Retry Archiving");

        }



    }

    function StepThree(val) {
        if(val > 0) {
            $("#errorLog").html('');
            $("#stepTwoDot").removeClass("dot-not-complete").removeClass("blink").addClass("dot-complete");
            $("#stepThreeDot").addClass("blink");
            $("#stepFourDot").removeClass("blink").removeClass("dot-complete");
            $("#button").css("display", "none");

            $("#progressLabel").html("Transferring Data to New Version").css('color','');

            $.ajax({
                type: "POST",
                url: './updateHelper.php',
                data: {'StepThree':1},
                success: function (result) {
                    displayError();
                    StepFour(result);
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    StepFour(0);
                }
            });

        } else {
            $("#stepTwoDot").removeClass("blink").removeClass("in_progress").addClass("dot-not-complete");
            $("#progressLabel").html("Extracting Version <?php echo $newVersion?> Failed").css('color','firebrick');
            $("#button").css("display", "block");
            $("#buttonRetry").css("display", "block").attr("onclick","StepTwo(1)").html("Retry Extracting");

        }


    }

    function StepFour(val) {
        if(isNumber(val) && val > 0) {
            $("#errorLog").html('');
            $("#stepThreeDot").removeClass("dot-not-complete").removeClass("blink").addClass("dot-complete");
            $("#stepFourDot").addClass("blink");
            $("#stepFiveDot").removeClass("blink").removeClass("dot-complete");
            $("#button").css("display", "none");

            $("#progressLabel").html("Updating DB").css('color','');

            $.ajax({
                type: "POST",
                url: './updateHelper.php',
                data: {'StepFour':1},
                success: function (result) {
                    displayError();
                    StepFive(result);
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    StepFive(0);
                }
            });

        } else {
            $("#stepThreeDot").removeClass("blink").removeClass("in_progress").addClass("dot-not-complete");
            $("#progressLabel").html("Transferring Data Failed").css('color','firebrick');
            $("#button").css("display", "block");
            $("#buttonRetry").css("display", "block").attr("onclick","StepThree(1)").html("Retry Transferring");

        }

    }

    function StepFive(val) {
        if(isNumber(val) && val > 0) {
            $("#errorLog").html('');
            $("#stepFourDot").removeClass("dot-not-complete").removeClass("blink").addClass("dot-complete");
            $("#stepFiveDot").addClass("blink");
            $("#button").css("display", "none");

            $("#progressLabel").html("Removing Old Version").css('color','');

            $.ajax({
                type: "POST",
                url: './updateHelper.php',
                data: {'StepFive':1},
                success: function (result) {
                    StepFinal(result);
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    StepFinal(0);
                }
            });
        } else {
            $("#stepFourDot").removeClass("blink").removeClass("in_progress").addClass("dot-not-complete");
            $("#progressLabel").html("DB Update Failed<br>").css('color','firebrick');
            $("#button").css("display", "block");
            $("#buttonRetry").css("display", "block").attr("onclick","StepFour(1)").html("Retry DB Update");
        }

    }

    function StepFinal(val) {
        if (val > 0) {
            $("#errorLog").html('');
            $("#stepFiveDot").removeClass("dot-not-complete").addClass("dot-complete").removeClass("blink");
            $("#progressLabel").html("<?php echo $newVersion?> Update Complete.").css('color','');
            $("#buttonRedirect").css("display", "block");
            $("#buttonRetry").css("display", "none");
        } else {
            $("#stepFiveDot").removeClass("dot-not-complete").addClass("dot-complete").removeClass("blink");
            $("#progressLabel").html("Removing Old Version Failed<br>"+val).css('color','');
            $("#button").css("display", "block");
        }
    }

    function isNumber(n) { return /^-?[\d.]+(?:e-?\d+)?$/.test(n); }

    $(document).ready(function() {
        $("#buttonRetry").css("display", "none");
        $("#buttonRedirect").css("display", "none");
        StepOne();
    });


</script>

</body>
</html>



