<?php
include_once('../../../../param.php');
include_once(ROOT . "concc/dbhelpers/dbhelper.php");

$createdBy= $_SESSION['adminID'];
$truckTypeID = trim($_POST['truckTypeID']);
$truckTypeName = trim($_POST['truckTypeName']);
$numberOfColumns = trim($_POST['numberOfColumns']);
$numberOfRows = trim($_POST['numberOfRows']);
$numberOfLevels = trim($_POST['numberOfLevels']);
$status = trim($_POST['status']);
$details = trim($_POST['details']);
$notes = trim($_POST['notes']);
$position = trim($_POST['position']);

$truckTypePositions = array();
$truckTypePositions = $_POST['truckTypePositions'];



global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}


try {
    $db->begin_transaction();


    $stmt = $db->prepare("UPDATE Truck_Types SET truck_type_name=?, number_of_columns=?, number_of_rows=?, number_of_levels=?, status=?, details=?, notes=?, position=?, timestamp=NOW() WHERE truck_type_id=?");
    $stmt->bind_param('siiisssii',$truckTypeName,$numberOfColumns,$numberOfRows,$numberOfLevels,$status,$details,$notes,$position,$truckTypeID);
    $stmt->execute();
    if(strcmp($stmt->error,"")!=0) {throw new Exception();}
    $stmt->close();

    $updatedTypePositionIDs = array();
    foreach($truckTypePositions as $truckTypePosition){
        $truckTypePositionID = $truckTypePosition['ID'];
        $positionName = $truckTypePosition['Name'];
        $columnNumber = $truckTypePosition['Column'];
        $rowNumber = $truckTypePosition['Row'];
        $levelNumber = $truckTypePosition['Level'];
        $volume = $truckTypePosition['Volume'];
        $salespersonID = 0;
        $groupID = 0;
        $categoryID = 0;
        $details = 0;
        $status = 'yes';

        if($truckTypePositionID > 0){
            $stmt = $db->prepare("UPDATE Truck_Type_Positions SET position_name=?, column_number=?, row_number=?, level_number=?, volume=?, timestamp=NOW() WHERE truck_type_position_id=?");
            $stmt->bind_param('siiidi',$positionName,$columnNumber,$rowNumber,$levelNumber,$volume,$truckTypePositionID);
            $stmt->execute();
            if(strcmp($stmt->error,"")!=0) {throw new Exception();}
            $stmt->close();
            array_push($updatedTypePositionIDs,$truckTypePositionID);
        } else {
            $truckTypePositionID = getNextKeySingleTransaction("Truck_Type_Positions","truck_type_position_id",$db);
            $stmt = $db->prepare("INSERT INTO Truck_Type_Positions (truck_type_position_id, truck_type_id, position_name, column_number, row_number, level_number, volume, salesperson_id, group_id, category_id, details, status, creation_date, timestamp) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,NOW(),NOW())");
            $stmt->bind_param('iisiiidiiiss',$truckTypePositionID,$truckTypeID,$positionName,$columnNumber,$rowNumber,$levelNumber,$volume,$salespersonID,$groupID,$categoryID,$details,$status);
            $stmt->execute();
            if(strcmp($stmt->error,"")!=0) {throw new Exception();}
            $stmt->close();
            array_push($updatedTypePositionIDs,$truckTypePositionID);
        }


    }

    $updatedTypePositionIDsString = implode(",",$updatedTypePositionIDs);
    if(strcmp($updatedTypePositionIDsString,"")!=0){
        $statement = "DELETE FROM Truck_Type_Positions WHERE truck_type_id='$truckTypeID' AND truck_type_position_id NOT IN ($updatedTypePositionIDsString)";
    } else {
        $statement = "DELETE FROM Truck_Type_Positions WHERE truck_type_id='$truckTypeID'";
    }

    $stmt = $db->prepare($statement);
    $stmt->execute();
    if(strcmp($stmt->error,"")!=0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id",$db);
    $stmt2 = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt2->bind_param('is', $deleteID, $statement);
    $stmt2->execute();
    if(strcmp($stmt->error,"")!=0) {throw new Exception();}
    $stmt2->close();



    $db->commit(true);
    echo "$truckTypeID";
} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

?>

