<?php
// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");


// DB table to use
$table = 'Truck_Types';

// Table's primary key
$primaryKey = "truck_type_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`t`.`truck_type_id`', 'dt' => 'truck_type_id', 'formatter' => function( $d, $row ) {$GLOBALS['truck_type_id']=$d;return $d;}, 'field' => 'truck_type_id' ),
    array( 'db' => '`t`.`position`', 'dt' => 'position', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['truck_type_id'];

        return "<input type='number' class='form-control text-center' id='position_$id' name='position_$id' value='$d' onchange='changeTruckTypePosition(this,$id);'>";

    }, 'field' => 'position' ),
    array( 'db' => '`t`.`truck_type_name`', 'dt' => 'name', 'field' => 'truck_type_name' ),
    array( 'db' => '`t`.`number_of_columns`', 'dt' => 'columns', 'field' => 'number_of_columns' ),
    array( 'db' => '`t`.`number_of_rows`', 'dt' => 'rows', 'field' => 'number_of_rows' ),
    array( 'db' => '`t`.`number_of_levels`', 'dt' => 'levels', 'field' => 'number_of_levels' ),
    array( 'db' => '`t`.`status`', 'dt' => 'active', 'formatter' => function( $d, $row ) {
        $GLOBALS['status']=$d;
        if(strcmp($d,"yes")==0){
            return '<center><div class="label-success" style="text-align: center;width: 33px;height: 33px;padding-top: 7.5px;border-radius: 50%;color: white"><b>Yes</b></div></center>';
        }else{
            return '<center><div class="label-danger" style="text-align: center;width: 33px;height: 33px;padding-top: 7.5px;border-radius: 50%;color: white"><b>No</b></div></center>';
        }
    }, 'field' => 'status' ),
    array( 'db' => '`t`.`truck_type_id`',       'dt' => 'actions' , 'formatter' => function( $d, $row ) {
        $status = $GLOBALS['status'];
        $buttons = "";

        if(strcmp($status,"yes")==0) {
            $buttons .= "<button type=\"button\" class=\"btn btn-danger\" onclick=\"changeTruckTypeStatus('$d','no');\" style=\"display: inline-block;margin: 1px;\" >Deactivate</button>";
        } else if (strcmp($status,"no")==0) {
            $buttons .= "<button type=\"button\" class=\"btn btn-success\" onclick=\"changeTruckTypeStatus('$d','yes');\" style=\"display: inline-block;margin: 1px;\" >Activate</button>";
        }

        global $username,$password,$database;
        $db = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT COUNT(truck_id) FROM Truck_Type_Trucks WHERE truck_type_id=?");
        $stm->bind_param('i', $d);
        $stm->execute();
        $stm->bind_result($truck_count);
        while ($stm->fetch()) {}
        $stm->close();

        if($truck_count == 1){
            $truckLabel = $truck_count.' Truck&nbsp;';
        } else {
            $truckLabel = $truck_count.' Trucks';
        }

        return 	'<a href="//'.HTML_PATH.'/cop/backend/modules/truckLoading/views/manage_trucks.php?type='.$d.'" class="btn btn-waybill"  style="display: inline-block;margin: 1px;" > '.$truckLabel.'</a>
			<form  action="//'.HTML_PATH.'/cop/backend/modules/truckLoading/views/create_truck_type.php" target="_blank" method="POST" style="display: inline;">
           		<input type="hidden" id="truck_type_id" name="truck_type_id" value="'.$d.'">
			    <button type="submit" class="btn btn-invoice" style="margin: 1px;display: inline-block;" >Edit</button>
			</form>  
			'.$buttons;
    }, 'field' => 'truck_type_id' )

);
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Truck_Types` AS `t`";
$where="";



//$where ="`a`.`primary_address`='yes'";
require(ROOT . 'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>