<?php
include_once("../../../../param.php");
global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT from_table FROM Truck_Type_Trucks LIMIT 1");
$stm->execute();
$stm->bind_result($selectedFromTable);
while ($stm->fetch()) {}
$stm->close();


if(isset($_GET['type']) && $_GET['type'] > 0){
    $typeID = $_GET['type'];
    $typeWhere = ' truck_type_id = '.$typeID;
    $getFilter = '?type='.$typeID;
    $fromType = true;
} else {
    $typeWhere = " status = 'yes'";
    $getFilter = '';
    $fromType = false;
}
$typeOptions = '';
$pageTitle = ' All ';
$stm = $db->prepare("SELECT truck_type_id,truck_type_name FROM Truck_Types WHERE $typeWhere ORDER BY truck_type_name ASC");
$stm->execute();
$stm->bind_result($truck_type_id,$truck_type_name);
while ($stm->fetch()) {
    if($fromType){$pageTitle = " '$truck_type_name' ";}

    $typeOptions .=  "<option value='$truck_type_id'>$truck_type_name</option>";
}
$stm->close();

?>
<div id="main" role="main" class="background-color-whitish">
    <!-- Start CUSTOM CODE-->

    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Manage <?php echo $pageTitle ?>Trucks</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-6 col-lg-8">
                <h3 class="page-title txt-color-blueDark" style="margin-top: 5px;margin-bottom: 15px;">
                    <span class="widget-icon"> <i class="fa fa-truck"></i> </span>
                    <?php echo $pageTitle ?>Trucks
                </h3>
            </div>

            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">


            </div>
            <div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                <table class='table' style="width: 100%;margin: 0px;border: 2px solid #353d4b" id="addTruck">
                    <tr>
                        <td >
                            <h6>Add Truck </h6>
                        </td>
                        <td >
                            <h6 class="pull-right">From:</h6>
                        </td>
                        <td>
                            <select style='display:inline;' class='text-center form-control' id='fromTable' name='fromTable' type='text' >

                                <?php
                                    switch ($selectedFromTable){
                                        case 'SalesPersons':
                                            echo "<option value='SalesPersons|salesperson_id' selected>Users</option>";
                                            break;
                                        case 'Warehouses':
                                            echo "<option value='Warehouses|warehouse_id' selected>Warehouses</option>";
                                            break;
                                        default:
                                            echo "<option value='SalesPersons' selected>Users</option>";
                                            echo "<option value='Warehouses'>Warehouses</option>";
                                    }

                                ?>
                            </select>
                        </td>
                        <td >
                            <h6 class="pull-right">Truck:</h6>
                        </td>
                        <td>
                            <input style='display:inline;' class='text-center form-control' id='truckSearch' name='truckSearch' type='text' value='' placeholder="Select Truck">
                            <input type="hidden" id="truckID" value=""/>
                            <input type="hidden" id="truckCode" value=""/>
                            <input type="hidden" id="truckName" value=""/>
                        </td>
                        <td >
                            <h6 class="pull-right">Type:</h6>
                        </td>
                        <td>
                            <select style='display:inline;' class='text-center form-control' id='truckTypeID' name='truckTypeID' type='text' >
                                <?php echo $typeOptions ?>
                            </select>
                        </td>

                        <td>
                            <button type="button" class="btn btn-primary" onclick="addTruck()">Add Truck</button>
                        </td>
                    </tr>
                </table>

            </div>
        </div>



        <!-- row -->
        <section id="widget-grid" class="">
            <!-- row -->
            <div class="row">
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
                    <div class="jarviswidget jarviswidget-color-blueDark" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-table"></i> </span>
                            <h2>Trucks Table </h2>
                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%">

                                    <thead>
                                    <tr>
                                        <th class="hasinput" style="width:10%"><input type="text" class="form-control text-center" id="codeFilter"  placeholder="Filter Code" /></th>
                                        <th class="hasinput" style="width:30%"><input type="text" class="form-control text-center" id="nameFilter"  placeholder="Filter Name" /></th>
                                        <th class="hasinput" style="width:10%"><input type="text" class="form-control text-center" id="typeFilter"  placeholder="Type" /></th>
                                        <th class="hasinput" style="width:10%"><input type="text" class="form-control text-center" id="activeFilter"  placeholder="Active" /></th>
                                        <th class="hasinput" style="width:20%"></th>
                                    </tr>
                                    <tr>
                                        <th class='text-center'>Code</th>
                                        <th class='text-center'>Name</th>
                                        <th class='text-center'>Type</th>
                                        <th class='text-center'>Active</th>
                                        <th class='text-center'>Actions</th>
                                    </tr>
                                    </thead>

                                </table>

                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>
                <!-- WIDGET END -->
            </div>
            <!-- end row -->
        </section>
    </div>
</div>

</div>


</div>
</div>

<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/DataTables/datatables.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.colVis.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.tableTools.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatables/dataTables.bootstrap.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/plugin/datatable-responsive/datatables.responsive.min.js"></script>

<script type="text/javascript">

    function deleteTruck(truckID){
        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH ?>/cop/backend/modules/truckLoading/controllers/delete_truck.php",
            data: {truckID:truckID},
            success: function(data){
                $('#datatable_fixed_column').DataTable().ajax.reload(null, false);
            }
        });
    }

    function changeTruckStatus(truckID,status){
        $.ajax({
            type: "POST",
            url: "//<?php echo HTML_PATH ?>/cop/backend/modules/truckLoading/controllers/change_truck_status.php",
            data: {truckID:truckID,status:status},
            success: function(data){
                $('#datatable_fixed_column').DataTable().ajax.reload(null, false);
            }
        });
    }

    function addTruck(){
        var truckID = $('#truckID').val();
        var truckCode = $('#truckCode').val();
        var truckName = $('#truckName').val();
        var truckTypeID = $('#truckTypeID').val();
        var fromTable = $('#fromTable').val();
        var run = true;

        if (truckID == '') {
            highlightData($('#truckSearch'),'#ffd0bd');
            run = false;
        }
        if (truckTypeID == '') {
            highlightData($('#truckTypeID'),'#ffd0bd');
            run = false;
        }

        if(run) {
            $.ajax({
                type: "POST",
                url: "//<?php echo HTML_PATH ?>/cop/backend/modules/truckLoading/controllers/add_truck.php",
                data: {
                    truckID: truckID,
                    truckCode: truckCode,
                    truckName: truckName,
                    truckTypeID: truckTypeID,
                    fromTable: fromTable
                },
                success: function (data) {
                    if(data==2){
                        $.smallBox({
                            title : "Warning!",
                            content : 'Truck Already Exists.',
                            color : "goldenrod",
                            timeout: 5000,
                            icon : "fa fa-warning swing animated"
                        });
                        $('#codeFilter').val($('#truckCode').val());
                        $('#nameFilter').val($('#truckName').val()).trigger('change');
                        highlightData($('#addTruck'),'goldenrod');
                    } else if(data==1){
                        highlightData($('#addTruck'),'#739E73');
                        $('#datatable_fixed_column').DataTable().ajax.reload(null, false);
                        $('#truckSearch').val('');
                        $('#truckID').val('');
                        $('#truckCode').val('');
                        $('#truckName').val('');

                    } else {
                        $.smallBox({
                            title : "Fail!",
                            content : 'Something Went Wrong.',
                            color : "firebrick",
                            timeout: 5000,
                            icon : "fa fa-warning swing animated"
                        });
                        highlightData($('#addTruck'),'#ffd0bd');
                        console.log(data);
                    }
                }
            });
        } else {
            $.smallBox({
                title : "Warning!",
                content : 'Please Complete Truck Data.',
                color : "goldenrod",
                timeout: 5000,
                icon : "fa fa-warning swing animated"
            });
        }
    }

    function initTruckAutocomplete(from)
    {
        $("#truckSearch").autocomplete({
            source: "//<?php echo HTML_PATH ?>/cop/backend/modules/truckLoading/controllers/truck_autocomplete.php?from="+from,
            autoFocus: true,
            open: function(){
                $('.ui-autocomplete').css('width', '400px');
            },
            select: function (event, ui) {
                $('#truckID').val(ui.item.truck_id);
                $('#truckCode').val(ui.item.truck_code);
                $('#truckName').val(ui.item.truck_name);
            }
        });

    }



    function highlightData(element,color){
        element.css('border-color',color).css('background-color',color);
        window.setTimeout(function(){element.css('border-color','').css('background-color','');
        },1000);
    }



    $(document).ready(function() {

        pageSetUp();


        initTruckAutocomplete($('#fromTable').val());
        $('#fromTable').change(function() {
            initTruckAutocomplete($(this).val());
        });

        var responsiveHelper_datatable_fixed_column = undefined;

        var breakpointDefinition = {
            tablet : 1024,
            phone : 480
        };

        /* COLUMN FILTER  */
        var otable = $('#datatable_fixed_column').DataTable({
            "sDom": "<'dt-toolbar'<'col-xs-6 col-sm-6'f><'col-sm-6 col-xs-6 hidden-xs' B C l>r>"+
                "t"+
                "<'dt-toolbar-footer'<'col-sm-6 col-xs-12 hidden-xs'i><'col-sm-6 col-xs-12'p>>",
            "autoWidth" : true,
            "processing": false,
            "serverSide": true,
            "ajax": "//<?php echo HTML_PATH ?>/cop/backend/modules/truckLoading/controllers/getTrucks.php<?php echo $getFilter; ?>",
            "columns": [
                { "data": "code" },
                { "data": "name" },
                { "data": "type" },
                { "data": "active" },
                { "data": "actions" },
            ],
            "deferRender": true,
            "order": [[ 0, "asc" ]],
            "buttons": ['copyHtml5',
                'excelHtml5',
                'csvHtml5',
                'pdfHtml5'
            ],
            "preDrawCallback" : function() {
                // Initialize the responsive datatables helper once.
                if (!responsiveHelper_datatable_fixed_column) {
                    responsiveHelper_datatable_fixed_column = new ResponsiveDatatablesHelper($('#datatable_fixed_column'), breakpointDefinition);
                }
            },
        });
        // Apply the filter
        $("#datatable_fixed_column thead th input[type=text]").on( 'keyup change', function () {
            otable
                .column( $(this).parent().index()+':visible' )
                .search( this.value )
                .draw();
        } );
        /* END COLUMN FILTER */

        $('#typeFilterSelect').change(function() {
            var current = $(this).val();
            $('#typeFilterImput').val(current).trigger('keyup');
            if (current != '') {
                $(this).css('color','');
            } else {
                $(this).css('color','rgba(131,131,131,0.8)');
            }
        }).trigger('change');
    })


</script>