<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");
// DB table to use
$table = 'Waybills';
 
// Table's primary key
$primaryKey = "waybill_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`w`.`waybill_id`', 'dt' => 'id', 'formatter' => function( $d, $row ) {
        $GLOBALS['tender_id']=$d;



        return '';}, 'field' => 'waybill_id' ),
    array( 'db' => '`w`.`waybill_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        $id = $GLOBALS['tender_id'];
        return '<img class="custom-rounded-image waybill center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/waybillicon.png" width="30" height="30" onclick="actionHistory('.$id.',\'Waybills\')" title="Track POD" ></td>';},
        'field' => 'waybill_code' ),
    array( 'db' => '`w`.`waybill_code`', 'dt' =>  'code', 'formatter' => function( $d, $row ) {$GLOBALS['waybill_code']=$d;return $d;}, 'field' =>'waybill_code' ),
    array( 'db' => '`w`.`status`', 'dt' =>  'status', 'field' =>'status' ),
    array( 'db' => '`c`.`customer_id`', 'dt' => 'customerid', 'formatter' => function( $d, $row ) {
        $GLOBALS['customer_id'] = $d;
        if($d==1) {
            $id = $GLOBALS['tender_id'];
            global $username;
            global $password;
            global $database;
            $db1 = new mysqli('localhost', $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $db1->set_charset("utf8");
            $stm1 = $db1->prepare("SELECT source_name FROM Service_Call,Service_Call_Reply WHERE Service_Call.service_call_id=Service_Call_Reply.service_call_id AND reply_type_id=3 AND document_type='Waybills' AND document_id='$id' LIMIT 1");
            $stm1->execute();
            $stm1->bind_result($sourceName);
            while ($stm1->fetch()) {}
            $stm1->close();

            $source = explode(';',$sourceName);

            $GLOBALS['customer_code'] = $source[0];
            $GLOBALS['customer_name'] = $source[1];

        }

        return "";
    }, 'field' => 'customer_id' ),
    array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer','formatter' => function( $d, $row ) {
        if( $GLOBALS['customer_id'] == 1){
            return $GLOBALS['customer_name'];
        } else {
            return $d;
        }
    }, 'field' => 'customer_company_name' ),
    array( 'db' => '`c`.`customer_code`', 'dt' => 'customercode', 'formatter' => function( $d, $row ) {
           if($GLOBALS['customer_id'] == 1){
               return $GLOBALS['customer_code'];
           } else {
               return $d;
           }
    }, 'field' => 'customer_code' ),
    array( 'db' => '`w`.`waybill_date`', 'dt' => 'date', 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'waybill_date' ),

    array( 'db' => '`w`.`timestamp`', 'dt' => 'synctime', 'formatter' => function( $d, $row ) {
        if(strcmp($d,'0000-00-00 00:00:00')!=0 && strcmp($d,'')!=0){

            $timezone = 'Asia/Dubai';
            date_default_timezone_set($timezone);
            $timestamp = strtotime($d);
            $local_time = $timestamp + date('Z');
            $local_date = date('d-m-Y H:i', $local_time);

            return $local_date;
        } else {
            return '-';
        }
        },'field' => 'timestamp' ),
    array( 'db' => '`soa`.`date`', 'dt' => 'timeofdelivery', 'formatter' => function( $d, $row ) {
        if(strcmp($d,'0000-00-00 00:00:00')!=0 && strcmp($d,'')!=0){
            $local_date = date_format( date_create_from_format('Y-m-d H:i:s', $d), 'd-m-Y H:i');

            return $local_date;
        } else {
            return '-';
        }
        },'field' => 'date' ),
    array( 'db' => '`o`.`order_code`', 'dt' => 'order', 'field' => 'order_code' ),



    array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson',

    'formatter' => function( $d, $row ) {


        global $username;
        global $password;
        global $database;
        $db1 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db1->set_charset("utf8");
        $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
        $stm1-> execute();
        $stm1-> bind_result($fname,$lname);
        while ($stm1->fetch()) {

        }
        $stm1->close();

        return "$d - $fname $lname";



    },


    'field' => 'salesperson_code' ),
        
             array( 'db' => '`w`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) {
                return currencySymbol . strval(number_format($d,2));},
          'field' => 'grand_total' ),
         
     array( 'db' => '`w`.`waybill_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {

         $waybillCode = $GLOBALS['waybill_code'];
         if(file_exists(ROOT."media/pdfs/waybills/Waybill$waybillCode.pdf")){
             $pdfButton = "<form method='POST' action='//" . HTML_PATH . "/cop/readPDF.php' target='_blank' style='display: inline-block;'>
                    <input type='hidden' name='code' value='$waybillCode'/>
                    <input type='hidden' name='type' value='waybills'/>
                    <span  style='display: inline-block;width: 70px;margin: 3px;'><button type='submit' class='btn btn-danger btn-block' style='text-transform: capitalize;' ><i class='fa fa-file-pdf-o'></i>&nbsp; PDF</button></span>
                  </form>";
         }
             $mapView   = "<span  style='display: inline-block;width: 70px;margin: 3px;'> <span onclick='viewOnMap($d)' class='btn btn-waybill btn-block'><i class='fa fa-map-marker  '></i>&nbsp; Map</span></span>";

            $formActions = '<form id="'.$d.'"  action="//'.HTML_PATH .'/cop/backend/core/views/view/view_waybill.php" method="post" style="display:inline;">
           		<input type="hidden" name="waybill_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-waybill" value="View" style="width:60px">
			</form>
			<form style="display:inline;" class="tableRowForm" id="'.$d.'"  action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_waybill.php" method="post">
           		<input type="hidden" class="waybillID" name="waybill_id" value="'.$d.'">
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="Edit">
			</form>
			
			';

            return $mapView.$pdfButton;

         },
            'field' => 'waybill_id' )
);
 
// SQL server connection information
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Waybills` AS `w` ";
$joinQuery .= " LEFT JOIN `Customers` AS `c` ON (`w`.`customer_id` = `c`.`customer_id`)";
$joinQuery .= " LEFT JOIN `SalesPersons` AS `s` ON (`w`.`salesperson_id` = `s`.`salesperson_id`)";
$joinQuery .= " LEFT JOIN `Order_Waybill` AS `ow` ON (`w`.`waybill_id` = `ow`.`waybill_id`)";
$joinQuery .= " LEFT JOIN `Orders` AS `o` ON (`ow`.`order_id` = `o`.`order_id`)";
$joinQuery .= " LEFT JOIN `Schedule_Object_Actions` AS `soa` ON (`w`.`waybill_code` = `soa`.`action_id` AND `soa`.`action_type` = 'Waybill')";
$where='';
//if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
//    if(strcmp($where,'')!=0){$where.= " AND ";}
//    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
//}
//if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
//    if(strcmp($where,'')!=0){$where.= " AND ";}
//    $where .= " `w`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
//}
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>