<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
include_once('../../../../concc/dbinfo.php');

$androidID = trim($_POST['androidID']);
$deviceID = trim($_POST['deviceID']);
$companyCode = trim($_POST['companyCode']);
$displayPrefix = trim($_POST['displayPrefix']);
$databasePrefix = trim($_POST['databasePrefix']);
$activationCode = trim($_POST['activationCode']);


$method=$_POST['method'];
$json=$_POST['json'];
$checker = $_POST['checker'];

// send yes to release all the picks from an order.
$admin=$_POST['admin'];

$responce = new stdClass();
$responce->error = '';
$responce->result = '';

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");


$responce = validUser($androidID,$deviceID,$companyCode,$displayPrefix,$databasePrefix,$activationCode,$responce,$db);


if(strcmp($responce->error,'OK')==0){

    switch($method){

        case 'pickOrders':
            $responce = insertPickFromJson($json,$responce,$db);
            break;
        case 'releaseOrders':
            $responce = releaseOrdersFromJson($json,$admin,$responce,$db);
            break;
        case 'checkPicks':
            $responce = checkPickFromJson($json,$responce,$db);
            break;
        case 'getPick':
            $responce = getPickFromJson($json,$checker,$responce,$db);
            break;
        case 'releasePick':
            $responce = releasePickFromJson($json,$responce,$db);
            break;
        default:
            $responce->error = "Method error: Method $method Does Not Exist.";
            break;
    }

}

echo json_encode($responce);

$logFile = fopen('RequestLog.txt','w');
fwrite($logFile,json_encode($responce));
fclose($logFile);

function getPickFromJson($json,$checker,$responce,$db){
    try {
        $db->begin_transaction();
        $picksArray = json_decode($json);
        $activationCode = $responce->result->userCode;
        $salespersonID = (int)$responce->result->userID;

        $responce->result = array();

        if(strcmp($json,'')==0){$responce->error = "json error: Empty json."; return $responce;}
        if(count($picksArray)==0 || !is_array($picksArray)){$responce->error = "json error: Empty Array."; return $responce;}

        foreach($picksArray as $pickID){

            $pickResponce = new stdClass();
            $pickResponce->pick = $pickID;

            $stm = $db->prepare("SELECT pick_code, salesperson_id,status FROM Pick WHERE pick_id = '$pickID' LIMIT 1");
            $stm->execute();
            $stm->bind_result($pickCode, $pickSalesperson, $pickStatus);
            while ($stm->fetch()) {}
            $stm->close();

            if(strcmp($pickCode,'')==0){
                $pickResponce->responce = false;
                $pickResponce->reason = "Pick Missing.";
                $responce->error = $pickResponce->reason;
                array_push($responce->result, $pickResponce);
                continue;
            }

            $isFromPickerToChecker = false;
            if(strcmp("$checker",'yes')==0){
                $stm = $db->prepare("SELECT type FROM SalesPersons WHERE salesperson_id = '$pickSalesperson' LIMIT 1");
                $stm->execute();
                $stm->bind_result($salespersonType);
                while ($stm->fetch()) {}
                $stm->close();

                if(strcmp(trim(strtolower("$salespersonType")),'picker')==0) {
                    $isFromPickerToChecker = true;
                }

            }


            if($pickSalesperson==0 || $isFromPickerToChecker){
                $pickResponce->responce = true;
                $pickResponce->reason = "Pick Status: $pickStatus.";

                $stmt = $db->prepare("UPDATE Pick SET salesperson_id=? WHERE pick_id=?");
                $stmt->bind_param('si',$salespersonID,$pickID);
                $stmt->execute();
                if(strcmp($stmt->error,'')!=0){$responce->error = "Pick Update DB error: $stmt->error";}
                $stmt->close();

                array_push($responce->result, $pickResponce);

                continue;
            }

            if($salespersonID != $pickSalesperson){
                $pickResponce->responce = false;
                $pickResponce->reason = "Pick not in your list.";
                $responce->error = $pickResponce->reason;
                array_push($responce->result, $pickResponce);
                continue;
            }


            $pickResponce->responce = true;
            $pickResponce->reason = "Pick Status: $pickStatus.";
            array_push($responce->result, $pickResponce);


        }

        if(strcmp($responce->error,"")!=0 && strcmp($responce->error,"OK")!=0) {throw new Exception();}

        $db->commit(true);

    } catch (Exception  $e) {
        $db->rollback();
    }

    return $responce;
}
function releasePickFromJson($json,$responce,$db){
    try {
        $db->begin_transaction();
        $picksArray = json_decode($json);
        $activationCode = $responce->result->userCode;
        $salespersonID = (int)$responce->result->userID;

        $responce->result = array();

        if(strcmp($json,'')==0){$responce->error = "json error: Empty json."; return $responce;}
        if(count($picksArray)==0 || !is_array($picksArray)){$responce->error = "json error: Empty Array."; return $responce;}

        foreach($picksArray as $pickID){

            $pickResponce = new stdClass();
            $pickResponce->pick = $pickID;

            $stm = $db->prepare("SELECT pick_code, salesperson_id,status FROM Pick WHERE pick_id = '$pickID' LIMIT 1");
            $stm->execute();
            $stm->bind_result($pickCode, $pickSalesperson, $pickStatus);
            while ($stm->fetch()) {}
            $stm->close();





            if(strcmp($pickCode,'')==0){
                $pickResponce->responce = false;
                $pickResponce->reason = "Pick Missing.";
                $responce->error = $pickResponce->reason;
                array_push($responce->result, $pickResponce);
                continue;
            }

            if($salespersonID == $pickSalesperson){
                $pickResponce->responce = true;
                $pickResponce->reason = "Pick Status: $pickStatus.";
                $pickSalesperson=0;

                $stmt = $db->prepare("UPDATE Pick SET salesperson_id=? WHERE pick_id=?");
                $stmt->bind_param('si',$pickSalesperson,$pickID);
                $stmt->execute();
                if(strcmp($stmt->error,'')!=0){$responce->error = "Pick Update DB error: $stmt->error";}
                $stmt->close();

                array_push($responce->result, $pickResponce);

                continue;
            }

            if($salespersonID != $pickSalesperson){
                $pickResponce->responce = false;
                $pickResponce->reason = "Pick not in your list.";
                $responce->error = $pickResponce->reason;
                array_push($responce->result, $pickResponce);
                continue;
            }


            $pickResponce->responce = true;
            $pickResponce->reason = "Pick Status: $pickStatus.";
            array_push($responce->result, $pickResponce);


        }

        if(strcmp($responce->error,"")!=0 && strcmp($responce->error,"OK")!=0) {throw new Exception();}

        $db->commit(true);

    } catch (Exception  $e) {
        $db->rollback();
    }

    return $responce;
}
function checkPickFromJson($json,$responce,$db){
    try {
        $db->begin_transaction();
        $picksArray = json_decode($json);
        $activationCode = $responce->result->userCode;
        $salespersonID = (int)$responce->result->userID;

        $responce->result = array();

        if(strcmp($json,'')==0){$responce->error = "json error: Empty json."; return $responce;}
        if(count($picksArray)==0 || !is_array($picksArray)){$responce->error = "json error: Empty Array."; return $responce;}

        foreach($picksArray as $pickID){

            $pickResponce = new stdClass();
            $pickResponce->pick = $pickID;

            $stm = $db->prepare("SELECT pick_code, salesperson_id,status FROM Pick WHERE pick_id = '$pickID' LIMIT 1");
            $stm->execute();
            $stm->bind_result($pickCode, $pickSalesperson, $pickStatus);
            while ($stm->fetch()) {}
            $stm->close();

            if(strcmp($pickCode,'')==0){
                $pickResponce->responce = false;
                $pickResponce->reason = "Pick Missing.";
                $responce->error = $pickResponce->reason;
                array_push($responce->result, $pickResponce);
                continue;
            }

            if($salespersonID != $pickSalesperson){
                $pickResponce->responce = false;
                $pickResponce->reason = "Pick not in your list.";
                $responce->error = $pickResponce->reason;
                array_push($responce->result, $pickResponce);
                continue;
            }


            $pickResponce->responce = true;
            $pickResponce->reason = "Pick Status: $pickStatus.";
            array_push($responce->result, $pickResponce);


        }

        if(strcmp($responce->error,"")!=0 && strcmp($responce->error,"OK")!=0) {throw new Exception();}

    } catch (Exception  $e) {
        $db->rollback();
    }

    return $responce;
}

function releaseOrdersFromJson($json,$admin,$responce,$db){
    try {
        $db->begin_transaction();
        $ordersArray = json_decode($json);
        $activationCode = $responce->result->userCode;
        $salespersonID = (int)$responce->result->userID;

        $responce->result = array();

        if(strcmp($json,'')==0){$responce->error = "json error: Empty json."; return $responce;}
        if(count($ordersArray)==0 || !is_array($ordersArray)){$responce->error = "json error: Empty Array."; return $responce;}

        foreach($ordersArray as $orderID){

            $orderResponce = new stdClass();
            $orderResponce->order = $orderID;

            $stm = $db->prepare("SELECT order_code, company_id, details, delivery_method FROM Orders WHERE order_id = '$orderID'");
            $stm->execute();
            $stm->bind_result($orderCode, $companyID, $orderDetails, $whareHouseID);
            while ($stm->fetch()) {}
            $stm->close();

            if(strcmp($orderCode,'')==0){
                $orderResponce->responce = false;
                $orderResponce->reason = "Order Missing.";
                $responce->error = $orderResponce->reason;
                array_push($responce->result, $orderResponce);
                continue;
            }

            $picksForRelease = array();
            $stm = $db->prepare("SELECT Pick.pick_id,Pick.pick_code,Pick.salesperson_id FROM Pick_Order,Pick WHERE Pick_Order.pick_id=Pick.pick_id AND Pick_Order.order_id = '$orderID'");
            $stm->execute();
            $stm->bind_result($existingPickID,$existingPickCode,$existingPickSalesperson);
            while ($stm->fetch()) {
                $pick = new stdClass();
                $pick->id = $existingPickID;
                $pick->code = $existingPickCode;
                $pick->salesperson = $existingPickSalesperson;

                array_push($picksForRelease,$pick);

            }
            $stm->close();


            foreach($picksForRelease as $pick){



                if($pick->salesperson == $salespersonID || strcmp($admin,'yes')==0){

                    $orderResponce->responce = true;
                    $orderResponce->reason = "Pick $pick->code for Order $orderCode Released.";
                    array_push($responce->result, $orderResponce);

                    $noneSalesperson = 0;
                    $stmt = $db->prepare("UPDATE Pick SET salesperson_id=? WHERE pick_id=?");
                    $stmt->bind_param('si',$noneSalesperson,$pick->id);
                    $stmt->execute();
                    if(strcmp($stmt->error,'')!=0){$responce->error = "Pick Update DB error: $stmt->error";}
                    $stmt->close();

                }



            }


            $newStatus = 'Placed';
            $stmt = $db->prepare("UPDATE Orders SET status=? WHERE order_id=?");
            $stmt->bind_param('si',$newStatus,$orderID);
            $stmt->execute();
            if(strcmp($stmt->error,'')!=0){$responce->error = "Order Update DB error: $stmt->error";}
            $stmt->close();


        }

        if(strcmp($responce->error,"")!=0 && strcmp($responce->error,"OK")!=0) {throw new Exception();}

        $db->commit(true);



    } catch (Exception  $e) {
        $db->rollback();
    }

    return $responce;
}

function insertPickFromJson($json,$responce,$db){
    try {
        $db->begin_transaction();
        $ordersArray = json_decode($json);
        $activationCode = $responce->result->userCode;
        $salespersonID = (int)$responce->result->userID;

        $responce->result = array();

        if(strcmp($json,'')==0){$responce->error = "json error: Empty json."; return $responce;}
        if(count($ordersArray)==0 || !is_array($ordersArray)){$responce->error = "json error: Empty Array."; return $responce;}

        foreach($ordersArray as $orderID){

            $orderResponce = new stdClass();
            $orderResponce->order = $orderID;

            $existingPicks = array();
            $stm = $db->prepare("SELECT Pick.pick_id,Pick.pick_code,Pick.salesperson_id FROM Pick_Order,Pick WHERE Pick_Order.pick_id=Pick.pick_id AND Pick_Order.order_id = '$orderID'");
            $stm->execute();
            $stm->bind_result($existingPickID,$existingPickCode,$existingPickSalesperson);
            while ($stm->fetch()) {
                $pick = new stdClass();
                $pick->id = $existingPickID;
                $pick->code = $existingPickCode;
                $pick->salesperson = $existingPickSalesperson;

                array_push($existingPicks,$pick);

            }
            $stm->close();


            $stm = $db->prepare("SELECT order_code, company_id, details, delivery_method FROM Orders WHERE order_id = '$orderID'");
            $stm->execute();
            $stm->bind_result($orderCode, $companyID, $orderDetails, $whareHouseID);
            while ($stm->fetch()) {}
            $stm->close();

            if(count($existingPicks) > 0){

                foreach($existingPicks as $pick){

                    if($pick->salesperson == 0){

                        $stmt = $db->prepare("UPDATE Pick SET salesperson_id=? WHERE pick_id=?");
                        $stmt->bind_param('si',$salespersonID,$pick->id);
                        $stmt->execute();
                        if(strcmp($stmt->error,'')!=0){$responce->error = "Pick Assign DB error: $stmt->error";}
                        $stmt->close();

                        $orderResponce->responce = true;
                        $orderResponce->reason = "Pick $pick->code for Order $orderCode Assigned.";
                        array_push($responce->result, $orderResponce);
                        continue;

                    } else if($pick->salesperson == $salespersonID){

                        $orderResponce->responce = true;
                        $orderResponce->reason = "Pick $pick->code for Order $orderCode In Progress.";
                        array_push($responce->result, $orderResponce);
                        continue;

                    } else {

                        $orderResponce->responce = false;
                        $orderResponce->reason = "Pick Already Exists for Order $orderCode.";
                        $responce->error = $orderResponce->reason;
                        array_push($responce->result, $orderResponce);
                        continue;

                    }
                }

            } else {

                if(strcmp($orderCode,'')==0){
                    $orderResponce->responce = false;
                    $orderResponce->reason = "Order Missing.";
                    $responce->error = $orderResponce->reason;
                    array_push($responce->result, $orderResponce);
                    continue;
                }

                $items = array();
                $stm = $db->prepare("SELECT order_item_id,item_id,qty,promotion_number FROM Order_Item WHERE order_id LIKE '$orderID'");
                $stm->execute();
                $stm->bind_result($orderItemID, $itemID, $itemQty, $promotionNumber);
                while ($stm->fetch()) {
                    $item = new stdClass();
                    $item->order_item_id =$orderItemID;
                    $item->id =$itemID;
                    $item->qty=$itemQty;
                    $item->promotion_number=$promotionNumber;
                    array_push($items,$item);
                }
                $stm->close();

                if(count($items)==0){
                    $orderResponce->responce = false;
                    $orderResponce->reason = "Order Items Missing.";
                    $responce->error = $orderResponce->reason;
                    array_push($responce->result, $orderResponce);
                    continue;
                }

                $pickID     = getNextKeySingleTransaction("Pick","pick_id",$db);
                $pickCode   = getNextCodeSingleTransaction("Pick","pick_code","P","$activationCode",$db,$devicesTable = 'Devices_Pop');
                $pickStatus = 'Created';

                $stmt = $db->prepare("INSERT INTO Pick (pick_id,pick_code,company_id,salesperson_id,date,notes,status,timestamp) VALUES(?,?,?,?,NOW(),?,?,NOW())");
                $stmt->bind_param('isiiss',$pickID,$pickCode,$companyID,$salespersonID,$orderDetails,$pickStatus);
                $stmt->execute();
                if(strcmp($stmt->error,'')!=0){$responce->error = "Order Update DB error: $stmt->error";}
                $stmt->close();

                $stmt = $db->prepare("INSERT INTO Pick_Order (pick_id,order_id,timestamp) VALUES(?,?,NOW())");
                $stmt->bind_param('ii',$pickID,$orderID);
                $stmt->execute();
                if(strcmp($stmt->error,'')!=0){$responce->error = "Order Update DB error: $stmt->error";}
                $stmt->close();

                foreach ($items as $item){

                    $pickItemID    = getNextKeySingleTransaction("Pick_Item","pick_item_id",$db);
                    $batchNumber   = 0;
                    $qty           = 0;
                    $stmt = $db->prepare("INSERT INTO Pick_Item (pick_item_id,pick_id,item_id,batch_number,warehouse_id,qty,qty_to_pick,notes,from_document_line_id,timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
                    $stmt->bind_param('iiiiiddsi',$pickItemID,$pickID,$item->id,$batchNumber,$whareHouseID,$qty,$item->qty,$item->promotion_number,$item->order_item_id);
                    $stmt->execute();
                    if(strcmp($stmt->error,'')!=0){$responce->error = "Order Update DB error: $stmt->error";}
                    $stmt->close();


                }

                $newStatus = 'In Progress';
                $stmt = $db->prepare("UPDATE Orders SET status=? WHERE order_id=?");
                $stmt->bind_param('si',$newStatus,$orderID);
                $stmt->execute();
                if(strcmp($stmt->error,'')!=0){$responce->error = "Order Update DB error: $stmt->error";}
                $stmt->close();


                $orderResponce->responce = true;
                $orderResponce->reason = "Pick $pickCode Created for Order $orderCode.";
                array_push($responce->result, $orderResponce);
            }

        }

        if(strcmp($responce->error,"")!=0 && strcmp($responce->error,"OK")!=0) {throw new Exception();}

        $db->commit(true);



    } catch (Exception  $e) {
        $db->rollback();
    }

    return $responce;
}

function insertOrderFromJson($json,$responce,$db){
    try {
        $db->begin_transaction();

        $responce->result = '';
        if(strcmp($json,'')==0){$responce->error = "json error: Empty json."; return $responce;}

        $object = json_decode($json);

        $totalDiscount  = 0;
        $orderItems = array();
        foreach($object->products as $product){
            $orderItem = new stdClass();

            $priceAftDisc = $product->price_after_discount;
            $priceBefDisc = $product->price;
            $lineDiscount = $priceBefDisc - $priceAftDisc;
            $itemID = getItemID($product->sku,$db);

            $vatResponce = getOrInsertVatFromPercent($product->vat_percentage,$responce,$db);
            $responce = $vatResponce->responce;
            $vatID = $vatResponce->id;

            if($itemID == 0){
                $insertItemObject = insertItem($product->sku,$product->name,$vatID,$product->weight,$responce,$db);
                $responce = $insertItemObject->responce;
                $itemID   = $insertItemObject->id;
            }

            $orderItem->itemID       = $itemID;
            $orderItem->itemCode     = $product->sku;
            $orderItem->itemName     = $product->name;
            $orderItem->vatID        = $vatID;
            $orderItem->qty          = $product->qty;
            $orderItem->price        = $priceAftDisc;
            $orderItem->lineDiscount = $lineDiscount;
            $orderItem->vatAmount    = $product->vat_value;
            $orderItem->totalLine    = $product->row_total;
            $orderItem->weightSteps  = $product->weight_step;
            $orderItem->weight       = $product->weight;
            $orderItem->lineItemID   = $product->item_id;

            $totalDiscount += $lineDiscount;

            array_push($orderItems,$orderItem);

        }


        $customer = new stdClass();
        $customer->id = 0;
        $customer->code = '';
        $customer->name = trim(trim($object->shipping_address->firstname).' '.trim($object->shipping_address->lastname));
        $customer->email = trim($object->shipping_address->email);
        $customer->street = trim($object->shipping_address->street);
        $customer->postcode = trim($object->shipping_address->postcode);
        $customer->city = trim($object->shipping_address->city);
        $customer->region = trim($object->shipping_address->region);
        $customer->country = trim($object->shipping_address->country_id);
        $customer->telephone = trim($object->shipping_address->telephone);

        $customer = getCustomerFromDetails($customer,$db);

        if($customer->id == 0){
            $customerResponce = insertCustomer($customer,$responce,$db);
            $responce = $customerResponce->responce;
            $customer->id = $customerResponce->id;
            $customer->code = $customerResponce->code;
        }




        $comments = $object->comments;
        $timeslot = "Timeslot: ".$object->timeslot->from." - ".$object->timeslot->to;
        $subtotal = $object->grand_total - $object->vat_value - $totalDiscount;

        $paymentTypeResponce = getOrInsertPaymentMethodID($object->payment_method,$responce,$db);
        $responce = $paymentTypeResponce->responce;
        $paymentTypeID = $paymentTypeResponce->id;

        $order = new stdClass();
        $order->orderCode       = $object->increment_id;
        $order->orderDate       = $object->created_at;
        $order->paymentMethod   = $object->payment_method;
        $order->paymentMethodID = $paymentTypeID;
        $order->deliveryMethod  = $object->shipping_method;
        $order->isPaid          = $object->is_paid;
        $order->status          = $object->status;
        $order->warehouseCode   = $object->hub->warehouse_id;
        $order->warehouseID     = getWarehouseID($object->hub->warehouse_id,$db);
        $order->details         = $timeslot." | Comments:".$comments;
        $order->subtotal        = $subtotal;
        $order->discountTotal   = $totalDiscount;
        $order->vatTotal        = $object->vat_value;
        $order->grandTotal      = $object->grand_total;
        $order->addressID       = getCustomerAddress($customer->id,$db);
        $order->items           = $orderItems;
        $order->customer        = $customer;

        // echo "<pre>";
        // var_dump($object);
        // echo "</pre>";
        // echo "<pre>";
        // var_dump($order);
        // echo "</pre>";


        if(count($order->items)==0){$responce->error = 'json error: Empty Order Items.';return $responce;}
        if(strcmp(trim($customer->email),'')==0){$responce->error = 'Customer error: Incomplete Email.';return $responce;}
        if(strcmp(trim($customer->telephone),'')==0){$responce->error = 'Customer error: Incomplete Telephone.';return $responce;}
        if(strcmp(trim($customer->street),'')==0){$responce->error = 'Customer error: Incomplete Address.';return $responce;}
        if(strcmp(trim($order->warehouseID),'0')==0){$responce->error = 'Warehouse error: Missing Warehouse '.$object->hub->warehouse_id;return $responce;}
        if(strcmp(trim($order->paymentMethodID),'0')==0){$responce->error = 'Payment Type error: Missing Payment Type '.$order->paymentMethod;return $responce;}


        if(strcmp($responce->error,"")!=0 && strcmp($responce->error,"OK")!=0) {throw new Exception();}


        $orderResponce = insertOrder($order,$responce,$db);
        $responce = $orderResponce->responce;


        if(strcmp($responce->error,"")!=0 && strcmp($responce->error,"OK")!=0) {throw new Exception();}



        $db->commit(true);

        $responce->result = $order;

    } catch (Exception  $e) {
        $db->rollback();
    }

    return $responce;

}


function insertOrder($order,$responce,$db){

    $orderCode  = $order->orderCode;
    $companyID  = 1;
    $customerID = $order->customer->id;
    $salespersonSearch = 0;
    $paymentMethod = $order->paymentMethodID;
    $subtotal = $order->subtotal;
    $grandTotal = $order->grandTotal;
    $vatTotal = $order->vatTotal;
    $discount = $order->discountTotal;
    $billingAddress = $order->addressID;
    $deliveryAddress = $order->addressID;
    $orderDate = $order->orderDate;
    $dueDate = $order->orderDate;
    $details = $order->details;
    $globalDiscountPercentage = 0;
    $status2 = $order->status;
    $warehouseSearch = $order->warehouseID;
    $project = 0;
    $currencyID = 0;
    $actionHash = hashObject($order);
    $status = 'Placed';

    $orderID = 0;
    $stmt = $db->prepare("SELECT order_id FROM Orders WHERE order_code = '$orderCode' ORDER BY timestamp DESC LIMIT 1");
    $stmt->execute();
    $stmt->bind_result($orderID);
    while ($stmt->fetch()) {}
    $stmt->close();

    if($orderID > 0){


        if(true){

            $stmt = $db->prepare("UPDATE Orders SET order_code=? ,company_id=? ,customer_id=? ,salesperson_id=? ,paymenttype_id=? ,subtotal=? ,grand_total=? ,vat_amount=? ,discount_amount=? ,order_address_id=? ,delivery_address_id=? ,order_date=? ,delivery_date=? ,details=? ,global_discount_percentage=? ,status=? , delivery_method=? ,tender_id=? ,currency_id=? ,action_hash=?,status2=? WHERE order_id=?");
            $stmt->bind_param('siiiiddddiisssdssiissi',$orderCode,$companyID,$customerID,$salespersonSearch,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseSearch,$project,$currencyID,$actionHash,$status2,$orderID);
            $stmt->execute();
            if(strcmp($stmt->error,'')!=0){$responce->error = "Order Update DB error: $stmt->error";$orderID=0;}
            $stmt->close();


            $stmt = $db->prepare("DELETE FROM Order_Item WHERE order_id=?");
            $stmt->bind_param('i', $orderID);
            $stmt->execute();
            if(strcmp($stmt->error,'')!=0){$responce->error = "Order Update Items DB error: $stmt->error";$orderID=0;}
            $stmt->close();


            foreach($order->items as $orderItem){

                $orderItemID = getNextKeySingleTransaction("Order_Item","order_item_id",$db);
                $itemID = $orderItem->itemID;
                $qty = $orderItem->qty;
                $unitPrice = $orderItem->price;
                $lineDiscount = $orderItem->lineDiscount;
                $globalDiscount = 0;
                $vatTotal = $orderItem->vatAmount;
                $priceType = 98;
                $vatID = $orderItem->vatID;
                $lineDiscountSelectedPercentage = 0;
                $itemNotes = '';
                $promotionNumber = $orderItem->lineItemID;

                $stmt = $db->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,promotion_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
                $stmt->bind_param('iiidddddiidsi', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemNotes,$promotionNumber);
                $stmt->execute();
                if(strcmp($stmt->error,'')!=0){$responce->error = "Order Item DB error: $stmt->error";break;}
                $stmt->close();
            }


        } else {
            $responce->error = "Locked Document error: Order $order->orderCode is ". ucwords(strtolower(str_replace('_',' ',$orderStatusCheck)))." and cannot be changed.";
        }


    } else {

        $orderID    = getNextKeySingleTransaction("Orders","order_id",$db);

        $stmt = $db->prepare("INSERT INTO Orders (order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,order_address_id,delivery_address_id,order_date,delivery_date,details,global_discount_percentage,status, delivery_method,tender_id,currency_id,action_hash) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isiiiiddddiisssdssiis',$orderID,$orderCode,$companyID,$customerID,$salespersonSearch,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseSearch,$project,$currencyID,$actionHash);
        $stmt->execute();
        if(strcmp($stmt->error,'')!=0){$responce->error = "Order DB error: $stmt->error";$orderID=0;}
        $stmt->close();

        lockDocumentSingleTransaction($orderID,"Orders",$db);

        $lineTotals         = 0;
        $lineDiscountTotals = 0;
        $itemsCounter       = 0;

        foreach($order->items as $orderItem){

            $orderItemID = getNextKeySingleTransaction("Order_Item","order_item_id",$db);
            $itemID = $orderItem->itemID;
            $qty = $orderItem->qty;
            $unitPrice = $orderItem->price;
            $lineDiscount = $orderItem->lineDiscount;
            $globalDiscount = 0;
            $vatTotal = $orderItem->vatAmount;
            $priceType = 98;
            $vatID = $orderItem->vatID;
            $lineDiscountSelectedPercentage = 0;
            $itemNotes = '';
            $promotionNumber = $orderItem->lineItemID;
            $stmt = $db->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,promotion_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiidddddiidsi', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemNotes,$promotionNumber);
            $stmt->execute();
            if(strcmp($stmt->error,'')!=0){$responce->error = "Order Item DB error: $stmt->error";break;}
            $stmt->close();
        }



    }

    $result = new stdClass();
    $result->responce = $responce;

    return $result;

}

function getCustomerAddress($customerID,$db){
    $z=0;

    $stm1 = $db->prepare("SELECT customer_address_id FROM CustomerAddress WHERE customer_id='$customerID' ORDER BY timestamp DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($value);
    while ($stm1->fetch()) {if($value > 0){$z = $value;}}
    $stm1->close();

    return $z;
}

function getOrInsertPaymentMethodID($paymentType,$responce,$db){
    $paymentTypeID=0;
    $stm1 = $db->prepare("SELECT paymenttype_id FROM PaymentTypes WHERE name = '$paymentType' ORDER BY timestamp DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($value);
    while ($stm1->fetch()) {if($value > 0){$paymentTypeID = $value;}}
    $stm1->close();

    if($paymentTypeID == 0){
        $paymentTypeID = getNextKeySingleTransaction("PaymentTypes","paymenttype_id",$db);
        $stmt = $db->prepare("INSERT INTO PaymentTypes(paymenttype_id,paymenttype_code,name,timestamp) VALUES(?,?,?,NOW())");
        $stmt->bind_param('iss',$paymentTypeID,$paymentType,$paymentType);
        $stmt->execute();
        if(strcmp($stmt->error,'')!=0){$responce->error = "Payment Types DB error: $stmt->error";$paymentTypeID=0;}
        $stmt->close();
    }

    $result = new stdClass();
    $result->responce = $responce;
    $result->id = $paymentTypeID;

    return $result;
}

function insertCustomer($customer,$responce,$db){


    $customerID     = getNextKeySingleTransaction('Customers','customer_id',$db);
    $customerCode   = getNextCustomerCode($db);
    $companyName    = $customer->name;
    $reportName     = '';
    $registration   = '';
    $mobile         = $customer->telephone;
    $website        = '';
    $email          = $customer->email;
    $description    = "$customer->street $customer->postcode $customer->city";
    $ticCode        = '';
    $vatCode        = '';
    $creditLimit    = 0;
    $customerType   = 'Credit';
    $balance        = 0;
    $typeOfBusiness = '';

    $stmt = $db->prepare("INSERT INTO Customers (customer_id,customer_code,customer_company_name,customer_report_name,registration_code,mobile,website,email,description,tic_code,vat_code,credit_limit,customer_type,balance,type_of_business,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('issssssssssssds',$customerID,$customerCode,$companyName,$reportName,$registration,$mobile,$website,$email,$description,$ticCode,$vatCode,$creditLimit,$customerType,$balance,$typeOfBusiness);
    $stmt->execute();
    if(strcmp($stmt->error,'')!=0){$responce->error = "Customers DB error: $stmt->error";$itemID=0;}
    $stmt->close();


    $stmt = $db->prepare("INSERT INTO ChartOfAccounts (account_id,account_code,account_name,timestamp) VALUES(?,?,?,NOW())");
    $stmt->bind_param('iss',$customerID,$customerCode,$companyName);
    $stmt->execute();
    if(strcmp($stmt->error,'')!=0){$responce->error = "ChartOfAccounts DB error: $stmt->error";$itemID=0;}
    $stmt->close();


    $customerAddressID = getNextKeySingleTransaction('CustomerAddress','customer_address_id',$db);
    $country      = $customer->country;
    $city         = $customer->city;
    $addressLine1 = $customer->street;
    $addressLine2 = '';
    $postcode     = $customer->postcode;
    $region       = $customer->region;
    $landline     = $customer->telephone;
    $primary      = 'yes';
    $lat          = 0;
    $lng          = 0;

    $stmt = $db->prepare("INSERT INTO CustomerAddress (customer_address_id,address_code,customer_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,landline,primary_address,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('isissssssssss', $customerAddressID, $customerCode,$customerID, $country, $city, $addressLine1, $addressLine2, $postcode, $region,$lat,$lng, $landline,$primary);
    $stmt->execute();
    if(strcmp($stmt->error,'')!=0){$responce->error = "CustomerAddress DB error: $stmt->error";$itemID=0;}
    $stmt->close();


    $result = new stdClass();
    $result->responce = $responce;
    $result->id = $customerID;
    $result->code = $customerCode;

    return $result;

}

function getCustomerFromDetails($customer,$db){


    $stm1 = $db->prepare("SELECT customer_id,customer_code FROM Customers WHERE customer_company_name = '$customer->name' AND email = '$customer->email' AND mobile = '$customer->telephone' AND description = '$customer->street $customer->postcode $customer->city' ORDER BY timestamp DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($id,$code);
    while ($stm1->fetch()) {
        if($id > 0){
            $customer->id = $id;
            $customer->code = $code;
        }
    }
    $stm1->close();


    return $customer;
}

function getOrInsertVatFromPercent($vatPercent,$responce,$db){
    $z=0;

    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE percentage = '$vatPercent' ORDER BY timestamp DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($value);
    while ($stm1->fetch()) {if($value > 0){$z = $value;}}
    $stm1->close();

    if($z == 0){
        $z = getNextKeySingleTransaction("Vats","vat_id",$db);
        $stmt = $db->prepare("INSERT INTO Vats(vat_id,vat_code,vat_display_name,percentage,timestamp) VALUES(?,?,?,?,NOW())");
        $stmt->bind_param('issi',$z,$vatPercent,$vatPercent,$vatPercent);
        $stmt->execute();
        if(strcmp($stmt->error,'')!=0){$responce->error = "VAT DB error: $stmt->error";$paymentTypeID=0;}
        $stmt->close();
    }


    $result = new stdClass();
    $result->responce = $responce;
    $result->id = $z;

    return $result;
}

function getWarehouseID($warehouseCode,$db){
    $z=0;

    $stm1 = $db->prepare("SELECT warehouse_id FROM Warehouses WHERE warehouse_code = '$warehouseCode' ORDER BY timestamp DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($value);
    while ($stm1->fetch()) {if($value > 0){$z = $value;}}
    $stm1->close();

    return $z;
}

function getItemID($itemCode,$db){
    $z=0;

    $stm1 = $db->prepare("SELECT item_id FROM Items WHERE item_code = '$itemCode' ORDER BY timestamp DESC LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($value);
    while ($stm1->fetch()) {if($value > 0){$z = $value;}}
    $stm1->close();

    return $z;
}

function validUser($androidID,$deviceID,$companyCode,$displayPrefix,$databasePrefix,$activationCode,$responce,$db){

    if(strcmp($androidID,'')==0){$responce->error ="No android ID provided.";return $responce;}
    if(strcmp($deviceID,'')==0){$responce->error ="No device ID provided.";return $responce;}
    if(strcmp($companyCode,'')==0){$responce->error ="No Company Code provided.";return $responce;}
    if(strcmp($displayPrefix,'')==0){$responce->error ="No Display Prefix provided.";return $responce;}
    if(strcmp($databasePrefix,'')==0){$responce->error ="No Prefix provided.";return $responce;}

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT count(company_id) FROM Companies WHERE company_code = '$companyCode' LIMIT 1");
    $stm->execute();
    $stm->bind_result($companiesCount);
    while ($stm->fetch()) {}
    $stm->close();

    if($companiesCount > 0) {
        $stm1 = $db->prepare("SELECT device_pop_id,sales_person_id,activation_code FROM Devices_Pop WHERE device_pop_id='$deviceID' AND android_id='$androidID' AND display_prefix='$displayPrefix' AND prefix='$databasePrefix' LIMIT 1");
        $stm1->execute();
        $stm1->bind_result($value, $spID, $activationCode);
        while ($stm1->fetch()) {if ($value > 0) {$z = $value;}}
        $stm1->close();
    } else {
        $z = 0;
    }


    if($z > 0){$responce->error = 'OK';} else {$responce->error ="Login Failed: Invalid Credentials";}

    $user = new stdClass();
    $user->userCode = $activationCode;
    $user->userID   = $spID;
    $responce->result = $user;

    return $responce;
}

function insertItem($productCode,$productName,$vatID,$weight,$responce,$db){

    $itemID = getNextKeySingleTransaction('Items','item_id',$db);
    $productSKU = '';
    $subunits = 1;
    $salesunits = 'UNIT';
    $shortDescription = $productName;
    $longDescription = '';
    $reorderLevel = 0;
    $targetQty = 0;
    $maxStock = 0;
    $minStock = 0;
    $packing = 0;
    $stockControl = 'yes';
    $sellable = 'yes';
    $cbm = 0;
    $status = 'yes';

    $stmt = $db->prepare("INSERT INTO Items (item_id,item_code,item_sku,vat_id,subunits,sales_units,name,short_description,long_description,reorder_level,target_qty,max_stock,min_stock,packing,stock_control,sellable,weight,cbm,status,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('issidssssdidddssdds',$itemID,$productCode,$productSKU,$vatID,$subunits,$salesunits,$productName,$shortDescription,$longDescription,$reorderLevel,$targetQty,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status);
    $stmt->execute();
    if(strcmp($stmt->error,'')!=0){$responce->error = "insertItem DB error: $stmt->error";$itemID=0;}
    $stmt->close();


    $result = new stdClass();
    $result->responce = $responce;
    $result->id = $itemID;

    return $result;


}

function getNextKeySingleTransaction($tableName,$idName,$db){
    $z=0;
    $prefix=1000;


    $likeVar = $prefix."%";
    $stm1 = $db->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($nextID);
    while ($stm1->fetch()) {

        $z = substr($nextID,4,strlen($nextID));
        $z+=1;


    }
    $stm1->close();


    return $prefix.$z;

}

function getNextCustomerCode($db1){
    $customerCode="";


    $stm1 = $db1->prepare("SELECT customer_code_suffix,customer_code_format FROM Cloud_Configuration");
    $stm1-> execute();
    $stm1-> bind_result($customerCodeSuffix,$customerCodeFormat);
    while ($stm1->fetch()) {
        $customerCodeSuffix .= "$customerCodeFormat" ;
    }
    $stm1->close();

    $customerCode = $customerCodeSuffix.'1';
    $stm1 = $db1->prepare("SELECT MAX(REPLACE(customer_code, '$customerCodeSuffix', '')+1),REPLACE(customer_code, '$customerCodeSuffix', '')+1 FROM Customers WHERE customer_code LIKE '$customerCodeSuffix%' AND REPLACE(customer_code, '$customerCodeSuffix', '') REGEXP '^-?[0-9]+$' ORDER BY REPLACE(customer_code, '$customerCodeSuffix', '') REGEXP '^-?[0-9]+$' DESC LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($customerCode,$nextCustomerCode);
    while ($stm1->fetch()) {
        $customerCode = $customerCodeSuffix.$customerCode;
    }
    $stm1->close();

    return $customerCode;

}

function getNextCodeSingleTransaction($table,$field,$tablePrefix,$activationCode,$db,$devicesTable = 'Devices'){
    $result   = 0;
    $prefix   = '';
    $nextCode = '';

    $stm1 = $db->prepare("SELECT display_prefix FROM $devicesTable WHERE activation_code='$activationCode' LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($prefix);
    while ($stm1->fetch()) {}
    $stm1->close();

    if(strcmp($prefix,'')!=0) {
        $prefix = $tablePrefix.$prefix;
        $stm = $db->prepare("SELECT REPLACE($field, '$prefix', '')+1 AS counter FROM $table WHERE $field LIKE'$prefix%' AND REPLACE($field, '$prefix', '') REGEXP '^-?[0-9]+$' ORDER BY counter DESC LIMIT 1");
        $stm->execute();
        $stm->bind_result($nextCode);
        while ($stm->fetch()) {
            if(is_numeric($nextCode) && $nextCode > 0){
                $result=$nextCode;
            }
        }
        $stm->close();
    }

    if($result > 0){
        while (canceledActionExists($table,$prefix,$result,$db)){
            $result++;
        }
        return $prefix.$result;
    } else {
        return $prefix.'10000';
    }


}

function canceledActionExists($table,$prefix,$code,$db9){
    $z=false;

    $actionType = rtrim($table,'s');
    $actionCode = $prefix.$code;


    $stm1 = $db9->prepare("SELECT cancelled_id FROM Cancelled_Actions WHERE type = '$actionType' AND code = '$actionCode' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($key);
    while ($stm1->fetch()) {
        if(strcmp($key,'')!=0 && $key > 0){
            $z = true;
        }
    }
    $stm1->close();

    return $z;
}

function lockDocumentSingleTransaction($documentID,$documentType,$db){

    if(!containsLockSingleTransaction($documentID,$documentType,$db)) {

        $stmt = $db->prepare("INSERT INTO ZD_Lock_Document (document_id,document_type,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('is', $documentID, $documentType);
        $stmt->execute();
        $stmt->close();
    }
}

function containsLockSingleTransaction($documentID,$documentType,$db){
    $contains=false;

    $stm1 = $db->prepare("SELECT COUNT(*) FROM ZD_Lock_Document WHERE document_id='$documentID' AND document_type='$documentType'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $contains=true;
        }

    }
    $stm1->close();
    return $contains;
}

function hashObject($object){
    return hash('sha256',json_encode($object));
}


?>