<?php
require_once('../../../backend/core/model/ErpImport.php');
class ConnectionAuth{

    private $authUsername;
    private $authPassword;
    private $authType;
    private $authIP;
    private $authConnection;
    private $authConnectionString;
    private $authToken;
    private $connectionLog;
    private $erpImportLog;
    private $daysBack;
    private $db;

    private $functionsToCall = array();

    public function __construct($GET,$POST)
    {
        foreach ($GET as $param => $value) {
            if(strcmp($param,'username')==0) {$authUsername = $value;}
            else if(strcmp($param,'password')==0){$authPassword = $value;}
            else if(strcmp($param,'type')==0)    {$authType     = $value;}
            else if(strcmp($param,'daysBack')==0){$daysBack     = $value;}
            else if(strpos($param, '_php') === false) {array_push($this->functionsToCall,$param);}
        }
        foreach ($POST as $param => $value) {
            if(strcmp($param,'username')==0) {$authUsername = $value;}
            else if(strcmp($param,'password')==0){$authPassword = $value;}
            else if(strcmp($param,'type')==0)    {$authType     = $value;}
            else if(strcmp($param,'daysBack')==0){$daysBack     = $value;}
            else if(strpos($param, '_php') === false) {array_push($this->functionsToCall,$param);}
        }
        if(strcmp((int)$daysBack,'')==0){$daysBack = 0;}

        $this->authUsername = "$authUsername";
        $this->authPassword = "$authPassword";
        $this->authType     = "$authType";
        $this->daysBack     = "$daysBack";
        $this->authIP       = $this->getClientIP();

        $this->erpImportLog = new ErpImport(
            $name             = 'Connection',
            $type             = "$authType",
            $resultLog        = '',
            $affectedRows     = '0',
            $deletedRows      = '0',
            $deleteStatements = '0',
            $sourceName       = "$authUsername",
            $sourceMethod     = "",
            $sourceIP         = "$this->authIP",
            $status           = "Running"
        );

    }

    public function connect($directoryPath){

        $db = new Database(localhost,username,password,database,prefix,'utf8');
        $this->erpImportLog = $this->erpImportLog->start($db);

        if( strcmp($this->authPassword,'')==0){
            $this->connectionLog = 'Connection Refused (No Password Specified in Parameters)';
            return false;
        }
        if(strcmp($this->authUsername,'')==0){
            $this->connectionLog = 'Connection Refused (No Username Specified in Parameters)';
            return false;
        }
        if(strcmp($this->authType,'')==0){
            $this->connectionLog = 'Connection Refused (No Type Specified in Parameters)';
            return false;
        }

        $connectionCheck = false;
        $connectionLog = "Connection Request For $this->authType : $this->authUsername - ";

        $connectionData = array(
            'auth_username'=>$this->authUsername,
            'auth_password'=>$this->authPassword,
            'auth_type'=>$this->authType

        );

        if($db->checkExist('Connection_Auth',$connectionData)){

            $connection = $db->getData();

            if(strcmp($connection->auth_type, $directoryPath)==0){
                $connectionCheck = true;
            } else if(strcmp($connection->auth_type, 'all')==0){
                $connectionCheck = true;
            } else {
                $connectionLog .= "Connection Refused (User Access Forbidden For $this->authType).";
                $connectionCheck = false;
            }

            if($connectionCheck){
                if(strcmp($connection->auth_ip, $_SERVER['REMOTE_ADDR'])==0){
                    $connectionCheck = true;
                } else if(strcmp($connection->auth_ip, '')==0){
                    $connectionCheck = true;
                } else {
                    $connectionLog .= "Connection Refused (Access Forbidden For IP: ".$_SERVER['REMOTE_ADDR'].").";
                    $connectionCheck = false;
                }
            }


        } else {
            $connectionLog .= "Connection Refused (User/Password Mismatch For $this->authUsername).";
            $connectionCheck = false;
        }

        if($connectionCheck){
            $connectionLog .= "Successful";
            $this->erpImportLog = $this->erpImportLog->end($db,$connectionLog);
        } else {
            $this->erpImportLog = $this->erpImportLog->end($db,$connectionLog);
            $db = false;
        }



        $this->connectionLog = $connectionLog;
        $this->db = $db;
        return $db;
    }

    public function getErpConnectionData($erpName){
        $this->erpImportLog->setSourceMethod($erpName);
        $privateDB = new Database(localhost,username,password,database,prefix,'utf8');
        if(strcmp($this->authUsername,'')==0 || strcmp($this->authPassword,'')==0 || $this->db == false){
            $this->erpImportLog = $this->erpImportLog->end($privateDB,$this->connectionLog,'Refused');
            return false;
        }

        $erpData = $this->db->checkExist('ERP_Connection',array('erp_name'=>$erpName));

        if($erpData == false){
            $this->connectionLog = "No $erpName Connection Found in Database.";
            $this->erpImportLog = $this->erpImportLog->end($privateDB,$this->connectionLog,'Refused');
            return false;
        } else {
            $erpData = $this->db->getData();
            if(strcmp($erpData->erp_active,'yes')!=0){
                $this->connectionLog = "$erpName Connection Not Active in Database.";
                $this->erpImportLog = $this->erpImportLog->end($privateDB,$this->connectionLog,'Refused');
                return false;
            } else {
                $this->connectionLog = "$erpName Connection Established.";
                $this->erpImportLog = $this->erpImportLog->end($privateDB,$this->connectionLog);
                $erpData->erp_import_id = $this->erpImportLog->erpImportID;
                $erpData->db = $this->db;
                $erpData->daysBack = $this->daysBack;
                return $erpData;
            }
        }


    }

    public function getConnectionLog()
    {
        return $this->connectionLog;
    }

    public function getAuthUsername()
    {
        return $this->authUsername;
    }

    public function getAuthPassword()
    {
        return $this->authPassword;
    }

    public function getAuthType()
    {
        return $this->authType;
    }

    public function getAuthIP()
    {
        return $this->authIP;
    }

    public function getAuthConnection()
    {
        return $this->authConnection;
    }

    public function getAuthConnectionString()
    {
        return $this->authConnectionString;
    }

    public function getAuthToken()
    {
        return $this->authToken;
    }

    public function getSpecificFunctionsToCall()
    {
        $array = array();
        foreach ($this->functionsToCall as $function){
            $function = str_replace("$this->authType",'',$function);
            array_push($array,$this->authType.$function);
        }
        return $array;
    }

    public function hasSpecificFunctionsToCall(){
        if(!empty($this->functionsToCall)){return true;}
        else {return false;}
    }

    public function callSpecificFunctions($db, $client){
        if($this->hasSpecificFunctionsToCall()){
            foreach ($this->functionsToCall as $function) {
                $function = str_replace("$this->authType",'',$function);
                $call = "$this->authType"."$function";
                $call($db, $client);
            }
            return false;
        } else {
            return true;
        }
    }

    private function getClientIP() {
        $ipaddress = '';
        if (getenv('HTTP_CLIENT_IP'))
            $ipaddress = getenv('HTTP_CLIENT_IP');
        else if(getenv('HTTP_X_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');
        else if(getenv('HTTP_X_FORWARDED'))
            $ipaddress = getenv('HTTP_X_FORWARDED');
        else if(getenv('HTTP_FORWARDED_FOR'))
            $ipaddress = getenv('HTTP_FORWARDED_FOR');
        else if(getenv('HTTP_FORWARDED'))
            $ipaddress = getenv('HTTP_FORWARDED');
        else if(getenv('REMOTE_ADDR'))
            $ipaddress = getenv('REMOTE_ADDR');
        else
            $ipaddress = '-';
        return $ipaddress;
    }


}


?>