<?php
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/PriceType.php');
require_once('../../../backend/core/model/ContractPrice.php');


function inboundContractPrices(Database $db, AuthTokenClient $client)
{
    $filters = array('Company' => $client->getCompanyCode(), 'LastSyncDate' =>$client->getDateFilter().'T00:00:00');
    $filters = json_encode($filters);

    $response = $client->requestData('Contracts',$filters);


    foreach ($response->Contracts as $data){

        $itemObject      = $db->getItemObjectByCode("$data->ItemCode");
        $customerObject  = $db->getCustomerObjectByCode("$data->SupplierCode");

        $fromDate = substr("$data->DateFrom",0,10);
        $toDate   = substr("$data->DateTo",0,10);

        if(strcmp($toDate,'')==0){$toDate = '2050-01-01';}


        $contractPrice = new ContractPrice(
            $customerID   = "$customerObject->customerID",
            $itemID       = "$itemObject->itemID",
            $priceTypeID  = "",
            $price        = "",
            $percentage   = "",
            $minQty       = "",
            $validFrom    = "$fromDate",
            $validUntil   = "$toDate"
        );

        $excludeUpdateColumns = array('ContractPrices' => array());
        $deleteRecordsNotSent = array();

        switch($data->Type){
            case '1':
                //PackContract
                $contractPrice->setPrice($data->PackContract->PackPrice);
                $contractPrice->setPercentage(0);
                $contractPrice->setMinQty(0);
                $contractPrice->setPriceTypeID(0);


                if($contractPrice->price > 0) {
                    $client->log($db->insertUpdateContractPriceByObject($contractPrice, $excludeUpdateColumns, $deleteRecordsNotSent));
                }
                break;
            case '2':
                //PriceContract
                $percentage = $data->PriceContract->PriceDiscount / $data->PriceContract->PriceAmount * 100;
                $price = $data->PriceContract->PriceAmount - $data->PriceContract->PriceDiscount;
                $priceTypeID = $db->getPriceTypeObjectByCode($data->PriceContract->PriceCode)->priceTypeID;

                $contractPrice->setPriceTypeID($priceTypeID);
                $contractPrice->setPrice($price);
                $contractPrice->setPercentage($percentage);
                $contractPrice->setMinQty(0);

                if($contractPrice->price > 0) {
                    $client->log($db->insertUpdateContractPriceByObject($contractPrice, $excludeUpdateColumns, $deleteRecordsNotSent));
                }

                break;
            case '3':
                //QuantityContract
                $contractPrice->setPriceTypeID(0);
                $contractPrice->setPercentage(0);

                if($data->QuantityContract->QuantityPrice1 > 0){
                    $contractPrice->setPrice($data->QuantityContract->QuantityPrice1);
                    $contractPrice->setMinQty($data->QuantityContract->Quantity1);

                    $client->log($db->insertUpdateContractPriceByObject($contractPrice, $excludeUpdateColumns, $deleteRecordsNotSent));
                }
                if($data->QuantityContract->QuantityPrice2 > 0){
                    $contractPrice->setPrice($data->QuantityContract->QuantityPrice2);
                    $contractPrice->setMinQty($data->QuantityContract->Quantity2);

                    $client->log($db->insertUpdateContractPriceByObject($contractPrice, $excludeUpdateColumns, $deleteRecordsNotSent));
                }
                if($data->QuantityContract->QuantityPrice3 > 0){
                    $contractPrice->setPrice($data->QuantityContract->QuantityPrice3);
                    $contractPrice->setMinQty($data->QuantityContract->Quantity3);

                    $client->log($db->insertUpdateContractPriceByObject($contractPrice, $excludeUpdateColumns, $deleteRecordsNotSent));
                }
                if($data->QuantityContract->QuantityPrice4 > 0){
                    $contractPrice->setPrice($data->QuantityContract->QuantityPrice4);
                    $contractPrice->setMinQty($data->QuantityContract->Quantity4);

                    $client->log($db->insertUpdateContractPriceByObject($contractPrice, $excludeUpdateColumns, $deleteRecordsNotSent));
                }
                if($data->QuantityContract->QuantityPrice5 > 0){
                    $contractPrice->setPrice($data->QuantityContract->QuantityPrice5);
                    $contractPrice->setMinQty($data->QuantityContract->Quantity5);

                    $client->log($db->insertUpdateContractPriceByObject($contractPrice, $excludeUpdateColumns, $deleteRecordsNotSent));
                }

                break;
            default:
                break;
        }

    }


    $client->complete();
}

?>