<?php
require_once('../../../backend/core/model/CustomerGroup.php');
require_once('../../../backend/core/model/Category.php');
require_once('../../../backend/core/model/PriceGroup.php');
require_once('../../../backend/core/model/PriceGroupRule.php');
require_once('../../../backend/core/model/PriceType.php');

function inboundPriceGroups(Database $db,AuthTokenClient $client){

    $filters = array('Company' => $client->getCompanyCode());
    $filters = json_encode($filters);

    $response = $client->requestData('GroupDiscount',$filters);


    foreach ($response->GroupDiscountList as $data){

        if(strcmp($data->AmountOrPerc,'%')==0) {

            $category = $db->getCategoryObjectByCode("$data->ItemGroup");
            $priceType = $db->getPriceTypeObjectByCode("$data->PriceCode");
            $customerGroup = $db->getCustomerGroupObjectByCode("$data->AccountGroup");

            $priceGroup = new PriceGroup(
                $priceGroupDefinitionID = "",
                $priceGroupCode = "$category->categoryName" . "$data->Value",
                $name = "$data->Value" . "$data->AmountOrPerc",
                $type = ""
            );

            $priceGroupRule = new PriceGroupRule(
                $priceGroupRuleID = "",
                $priceGroupDefinitionID = "",
                $categoryID = "$category->categoryID",
                $discountPercent = "$data->Value",
                $priceTypeID = "$priceType->priceTypeID"
            );

            $priceGroup->addPriceGroupRule($priceGroupRule);
            $priceGroup->addCustomerGroup($customerGroup);

            $excludeUpdateColumns = array();

            $deleteRecordsNotSent = array(
                'Price_Group_Customer_Group' => true,
                'Price_Group_Rules' => true,
            );

            $client->log($db->insertUpdatePriceGroupByObject($priceGroup, $excludeUpdateColumns, $deleteRecordsNotSent), 'PRICE GROUP');

        }

    }

    $client->complete();
}

/**
 * custom Functions
 */


?>