<?php
class FileClient
{
    private $filesDirectory;
    private $fileObject;
    private $fileName;
    private $lineNumber;
    private $delimiter;

    private $log;
    private $erpImportID;
    private $erpImportLog;
    private $db;

    public function __construct($cData,$cLog,$delimiter='|')
    {

        InterfaceLogger::start();
        if($cData !== false) {
            $this->filesDirectory = $cData->erp_database;
            $this->delimiter = $delimiter;
            $this->erpImportID = $cData->erp_import_id;
            $this->db = $cData->db;
        } else {
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] NOTICE : $cLog\n","connection","ERP Connection");
            InterfaceLogger::log("[".date('Y-m-d H:i:s')."] NOTICE : $cLog\n","analytic","ERP Connection");
        }

    }

    public function requestData($fileName)
    {
        $this->erpImportLog = new ErpImport( "$fileName", "", '','0','0','0',"","", "", "");
        $this->db->resetAffectedRecords();
        $this->erpImportLog->start($this->db,"$this->log","$this->erpImportID");

        $this->lineNumber = 0;
        if(file_exists($this->filesDirectory.$fileName)){
            $this->fileObject = fopen($this->filesDirectory.$fileName, "r");

            if(!$this->fileObject){
                $this->log = "[".date('Y-m-d H:i:s')."] File open failed: ".$this->filesDirectory.$fileName." - ERROR \n";
                InterfaceLogger::log($this->log,"summary","$fileName");
                InterfaceLogger::log($this->log,"analytic","$fileName");
                $this->erpImportLog->end($this->db,"$this->log",'Exception');
                return false;
            } else {
                $this->log = "[".date('Y-m-d H:i:s')."] File Request: ".$this->filesDirectory.$fileName." - Success\n";
                InterfaceLogger::log($this->log,"summary","$fileName");
                InterfaceLogger::log($this->log,"analytic","$fileName");
                $this->erpImportLog->end($this->db,"$this->log",'Complete');
                $this->fileName = $fileName;
                return $this->fileObject;
            }
        } else {
            $this->log = "[".date('Y-m-d H:i:s')."] Exception: File Missing (".$this->filesDirectory.$fileName.") - ERROR \n";
            InterfaceLogger::log($this->log,"summary","$fileName");
            InterfaceLogger::log($this->log,"analytic","$fileName");
            $this->erpImportLog->end($this->db,"$this->log",'Exception');
            return false;
        }

    }

    public function getLineAsObject($line){

        $simpleArray       = explode("$this->delimiter","$line");
        $counter           = 1;
        $this->lineNumber += 1;

        $assocArray  = array();
        $assocArray["number_of_values"] = count($simpleArray);

        foreach ($simpleArray as $simpleValue){

            $assocArray["value_".$counter++] = str_replace("\r\n",'',$simpleValue);
        }

        InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Read Line $this->lineNumber : ".json_encode($simpleArray)." \n","analytic","$this->fileName");
        InterfaceLogger::log("[".date('Y-m-d H:i:s')."] Read Line $this->lineNumber \n","summary","$this->fileName");

        return (object)$assocArray;

    }

    public function stopReading(){

        fclose($this->fileObject);
    }


    public function getDelimiter()
    {
        return $this->delimiter;
    }


    public function setDelimiter($delimiter)
    {
        $this->delimiter = $delimiter;
        return $this;
    }

    function log($response,$alterURL=''){
        foreach($response as $url => $text) {
            if(strcmp(trim($alterURL),'')!=0){$url = $alterURL;}
            $url = strtoupper($url);
            InterfaceLogger::log($text, "summary", "$url");
            InterfaceLogger::log($text, "analytic", "$url");
            $this->erpImportLog->update($this->db,"$text");

        }
        $this->erpImportLog->updateRecordsAffected($this->db,$this->db->affectedRecords,$this->db->deletedRecords,$this->db->deleteStatementRecords);
    }

    function textLog($text){
        InterfaceLogger::log("[".date('Y-m-d H:i:s')."] ".$text, "summary", "TEXT LOG");
        InterfaceLogger::log("[".date('Y-m-d H:i:s')."] ".$text, "analytic", "TEXT LOG");
    }

    function complete(){
        $this->erpImportLog->end($this->db);
        $this->db->resetAffectedRecords();
    }



}



?>
