<?php
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/PriceType.php');
require_once('../../../backend/core/model/ContractPrice.php');


function inboundContractPrices($db, $client)
{
    $filter = '?$filter=UDATE ge '.$client->getDateFilter().'T00:00:00%2B02:00';
    $filter = str_replace(' ','%20', $filter);

    $response = $client->requestData('CUSTPARTPRICEONE'.$filter);

    $priceTypeObject = $db->getDefaultPriceTypeObject();

    foreach ($response->value as $data){
        $itemObject      = $db->getItemObjectByCode("$data->PARTNAME");
        $customerObject  = $db->getCustomerObjectByCode("$data->CUSTNAME");

        $fromDate = substr("$data->FROMDATE",0,10);
        $toDate   = substr("$data->EXPIRYDATE",0,10);

        $contractPrice = new ContractPrice(
            $customerID   = "$customerObject->customerID",
            $itemID       = "$itemObject->itemID",
            $priceTypeID  = "$priceTypeObject->priceTypeID",
            $price        = (float)$data->PRICE * (float)$itemObject->subunits,
            $percentage   = "0",
            $minQty       = "0",
            $validFrom    = "$fromDate",
            $validUntil   = "$toDate"
        );

        $excludeUpdateColumns = array(
            'ContractPrices' => array()
        );


        $deleteRecordsNotSent = array(

        );
        if($contractPrice->price > 0) {
            $client->log($db->insertUpdateContractPriceByObject($contractPrice, $excludeUpdateColumns, $deleteRecordsNotSent));
        }
    }

    $response = $client->requestData('CUSTPARTDISCONE'.$filter, false);

    $priceTypeObject = $db->getDefaultPriceTypeObject();

    foreach ($response->value as $data){
        $itemObject      = $db->getItemObjectByCode("$data->PARTNAME");
        $customerObject  = $db->getCustomerObjectByCode("$data->CUSTNAME");
        $itemPrice       = $db->getItemPriceFromPriceType($itemObject->itemID,$priceTypeObject->priceTypeID);


        $fromDate = substr("$data->FROMDATE",0,10);
        $toDate   = substr("$data->EXPIRYDATE",0,10);

        $discPrice = round($itemPrice-$itemPrice*($data->PERCENT/100),4);


        $contractPrice = new ContractPrice(
            $customerID   = "$customerObject->customerID",
            $itemID       = "$itemObject->itemID",
            $priceTypeID  = "$priceTypeObject->priceTypeID",
            $price        = "$discPrice",
            $percentage   = "$data->PERCENT",
            $minQty       = "0",
            $validFrom    = "$fromDate",
            $validUntil   = "$toDate"
        );

        $excludeUpdateColumns = array(
            'ContractPrices' => array()
        );


        $deleteRecordsNotSent = array(

        );
        if($contractPrice->price > 0) {
            $client->log($db->insertUpdateContractPriceByObject($contractPrice, $excludeUpdateColumns, $deleteRecordsNotSent));
        }

    }


    $client->complete();
}

?>