<?php
require_once('../BasicAuthClient.php');
require_once('../../../backend/core/model/Database.php');

require_once('../../../backend/core/model/Order.php');
require_once('../../../backend/core/model/OrderItem.php');
require_once('../../../backend/core/model/PaymentType.php');
require_once('../../../backend/core/model/DocumentStatus.php');

function inboundOrders($db, $client)
{
    $filter = '?$filter=ORDSTATUSDES ne \'Draft\'';
    $filter.= '&$expand=ORDERITEMS_SUBFORM';
    $filter.= '&$since='.$client->getDateFilter().'T00:00:00%2B02:00';
    $filter = str_replace(' ','%20', $filter);

    $response = $client->requestData("ORDERS".$filter);

    foreach ($response->value as $data) {

        if($db->checkExist('Documents_Status',array('type'=>$db->getDocumentStatusTypeByTable('Orders'),'export_code'=>$data->ORDNAME)))  {

            $existingID   = $db->getData()->id;
            $existingCode = $db->getOrderObjectByID($existingID,false)->orderCode;
            $client->log(array('Documents_Status'=>"[".date('Y-m-d H:i:s')."] Order Exists (Coprime Order Code: $existingCode ).\n"));
            continue;

        }

        $customerID    = $db->getCustomerObjectByCode("$data->CUSTNAME")->customerID;
        $paymentTypeID = $db->getPaymentTypeObjectByCode("$data->PAYCODE")->paymentTypeID;
        $salespersonID = $db->getSalesPersonIDByCode("$data->AGENTCODE");

        $discountPrice = (float)$data->QPRICE - (float)$data->DISPRICE;

        $order = new Order(
            $orderID            = "",
            $orderCode          = "$data->ORDNAME",
            $companyID          = "1",
            $customerID         = "$customerID",
            $salespersonID      = "$salespersonID",
            $paymentTypeID      = "$paymentTypeID",
            $orderDate          = "$data->CURDATE",
            $subTotal           = "$data->QPRICE",
            $grandTotal         = "$data->TOTPRICE",
            $vatAmount          = "$data->VAT",
            $discountAmount     = "$discountPrice",
            $printCount         = "0",
            $orderAddressID     = "0",
            $deliveryAddressID  = "0",
            $tenderID           = "0",
            $vatIorE            = "",
            $deliveryDate       = "$data->DUEDATE",
            $depositAmount      = "0",
            $details            = "$data->SHIPREMARK",
            $status             = "$data->ORDSTATUSDES",
            $currencyID         = "0",
            $globalDiscountPercentage = "$data->PERCENT",
            $deliveryMethod     = "",
            $onlineOrderID      = "",
            $actionHash         = "",
            $actionTime         = "",
            $orderItems         = array()
        );


        foreach ($data->ORDERITEMS_SUBFORM as $dataItem) {

            $item = $db->getItemObjectByCode("$dataItem->PARTNAME");

            $vatID             = $item->vatID;
            $itemID            = $item->itemID;
            $itemSubunits      = $item->subunits;
            $vatPrice          = (float)$dataItem->VATPRICE - (float)$dataItem->QPRICE;
            $lineDiscountPrice = (float)$dataItem->TQUANT * ((float)$dataItem->PRICE - (float)$dataItem->DISPRICE);
            $unitPrice         = (float)$dataItem->PRICE * (float)$itemSubunits;

            $order->addOrderItem(
                new OrderItem(
                    $orderItemID            = "",
                    $orderID                = "",
                    $itemID                 = "$itemID",
                    $qty                    = "$dataItem->TQUANT",
                    $qtyPicked              = "",
                    $qtyDelivered           = "",
                    $qtyInvoiced            = "",
                    $unitPrice              = "$unitPrice",
                    $lineDiscount           = "$lineDiscountPrice",
                    $globalDiscount         = "",
                    $lineDiscountPercentage = "$dataItem->PERCENT",
                    $vatAmount              = "$vatPrice",
                    $priceTypeID            = "0",
                    $vatID                  = "$vatID",
                    $description            = "$dataItem->PDES",
                    $promotionID            = "",
                    $promotionNumber        = "",
                    $masterItem             = ""
                )
            );
        }

        $order->setActionHash($db->hashObject($order));
        $order->setActionTime(date('Y-m-d H:i:s'));


        $excludeUpdateColumns=array(
            'Orders' => array('order_date','delivery_date','order_address_id','delivery_address_id','print_count','tender_id','action_time')
        );

        $deleteRecordsNotSent=array(

        );

        $order = inboundOrdersAfterObjectCreationBeforeDbInsert($data,$order);
        $db->displayObject($order);
//        $client->log($db->insertUpdateOrderByObject($order,$excludeUpdateColumns,$deleteRecordsNotSent));

        $documentStatus = new DocumentStatus(
            $id         = $db->getOrderObjectByCode($data->ORDNAME,false)->orderID,
            $table      = $db->getDocumentStatusTypeByTable("Orders"),
            $status     = 100,
            $reason     = 'Imported From ERP',
            $exportID   = 100,
            $exportCode = $data->ORDNAME
        );

//        $client->log($db->insertUpdateDocumentStatusByObject($documentStatus));
    }
    $client->complete();
}

/**
 * custom Functions
 */

function inboundOrdersAfterObjectCreationBeforeDbInsert($data,$order){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $order;
}

?>