<?php
require_once('../../../backend/core/model/PriceType.php');
require_once('../../../backend/core/model/Customer.php');
require_once('../../../backend/core/model/CustomerPriceList.php');
require_once('../../../backend/core/model/ItemPrice.php');


function inboundPrices($db,$client){

    $response = $client->requestData('PRICELIST');

    foreach ($response->value as $data){

        $priceType = new PriceType(
            $priceTypeID   = "",
            $priceCode     = "$data->PLNAME",
            $name          = "$data->PLDES",
            $allowDiscount = "",
            $defaultType   = ""
        );


        $excludeUpdateColumns = array(
            'PriceTypes'      => array('default_type'),
        );


        $deleteRecordsNotSent = array(

        );

        $client->log($db->insertUpdatePriceTypeByObject($priceType,$excludeUpdateColumns,$deleteRecordsNotSent));

        $priceTypeObject = $db->getPriceTypeObjectByCode("$data->PLNAME");
        $responseCustomers = $client->requestData("PRICELIST('$data->PLNAME')/PLISTCUSTOMERS_SUBFORM",false);

        foreach ($responseCustomers->value as $customersData) {

            $customerObject = $db->getCustomerObjectByCode("$customersData->CUSTNAME");

            $priceList = new CustomerPriceList(
                $customer           = $customerObject,
                $priceType          = $priceTypeObject,
                $discountPercentage = "",
                $fixAmount          = "",
                $allowDiscount      = "",
                $startDate          = "2021-01-01",
                $endDate            = "2050-01-01",
                $periodic           = ""

            );

            $excludeUpdateColumns = array(
                'Customer_Pricelist' => array()
            );

            $deleteRecordsNotSent = array(

            );

            $client->log($db->insertUpdateCustomerPriceListByObject($priceList,$excludeUpdateColumns,$deleteRecordsNotSent));

        }

        $responseItems = $client->requestData("PRICELIST('$data->PLNAME')/PARTPRICE2_SUBFORM",false);

        foreach ($responseItems->value as $itemsData) {

            $itemObject = $db->getItemObjectByCode("$itemsData->PARTNAME");


            $itemPrice = new ItemPrice(
                $item          = $itemObject,
                $priceType     = $priceTypeObject,
                $price         = "$itemsData->PRICE", //PRICE * SUBUNITS
                $allowDiscount = "",
                $incVat        = "no"
            );

            $excludeUpdateColumns = array(
                'Prices' => array()
            );


            $deleteRecordsNotSent = array(

            );

            $itemPrice = inboundPriceTypesAfterItemPriceObjectCreationBeforeDbInsert($itemsData,$itemPrice);

            $client->log($db->insertUpdateItemPriceByObject($itemPrice,$excludeUpdateColumns,$deleteRecordsNotSent));
        }

    }
    $client->complete();
}

function inboundPriceTypesAfterItemPriceObjectCreationBeforeDbInsert($itemsData,$itemPrice){
    global $db;
    global $client;

    $file = includeCustomFunctionFile(__FUNCTION__,'inboundCustomCodeTemplates');
    if($file !== false){include "$file";}

    return $itemPrice;
}
?>