<?php
require_once('../../../backend/core/model/Stock.php');
require_once('../../../backend/core/model/Item.php');
require_once('../../../backend/core/model/Warehouse.php');


function inboundStock($db, $client)
{
    $filter = '?$filter=LASTDATE ge '.$client->getDateFilter().'T00:00:00%2B02:00';
    $filter = str_replace(' ','%20', $filter);

    $response = $client->requestData('PARTBAL'.$filter);

    foreach ($response->value as $data){

        if(strcmp($data->CUSTNAME,'Goods')==0){

            $db->displayObject($data);
            $stockItem      = $db->getItemObjectByCode("$data->PARTNAME");
            $stockWarehouse = $db->getWarehouseObjectByCode("$data->WARHSNAME");


            $stock = new Stock(
                $item        = $stockItem,
                $warehouse   = $stockWarehouse,
                $batchNumber = "$data->SERIALNAME",
                $available   = "$data->TBALANCE",
                $reserved    = "",
                $delivered   = "",
                $onOrder     = "",
                $requested   = "",
                $sold        = "",
                $expiryDate  = "$data->EXPIRYDATE"
            );

            $excludeUpdateColumns = array(
                'Stock' => array('reserved','delivered','on_order','requested','sold')
            );


            $deleteRecordsNotSent = array(

            );


            $client->log($db->insertUpdateStockByObject($stock,$excludeUpdateColumns,$deleteRecordsNotSent));

        }
    }
    $client->complete();
}

?>