<?php

function sendFailErrorEmail($type,$code,$id,$status,$reason,$to=''){
    global $username;
    global $password;
    global $database;
    global $errorMail;
    
    if($status != 1){
        
        if(strcmp($to,'')==0){$to=$errorMail;}
        
        $headers = 'From: Coprime Cloud <info@coprime.co>' . "\r\n";
        $headers  .= 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html;charset=UTF-8' . "\r\n";
    
        mb_internal_encoding("UTF-8");
    
        $subject ="$type $code Failed to Sync";
    
        $message ="- - - This is an automatic notice. There is no need to reply to this email. - - -<br/>
                <br/>
                <br/>           
                $type $code Failed to Sync. <br/>
                Reason: $reason<br/>
                <br/>
                Regards,<br/>
                Coprime Team<br/>
                ";
    
    
        if(strcmp($to,'')!=0 && strpos($to, '@') !== false){
            echo "<br>mail $to, $subject </br>";
            mail($to, $subject, $message, $headers);
    
        }
    }
    
}

function insertDocumentStatuses($id,$type,$status,$reason){
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
 	$stmt = $db->prepare("INSERT IGNORE INTO Documents_Status (id,type,status,reason,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('iiis',$id,$type,$status,$reason);
 	$stmt->execute(); 	
 	$stmt->close();
}

function exportTender($tenderID,$myfile='') {
    global $username;
    global $password;
    global $database;


    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");



    $stm = $db->prepare("SELECT tender_id,tender_code,company_id,customer_id,salesperson_id,tender_date,valid_until,subtotal,grand_total,vat_amount,discount_amount,print_count,details,status,timestamp FROM Tenders WHERE tender_id='$tenderID'");
    $stm-> execute();
    $stm-> bind_result($tenderID,$orderCode,$companyID,$customerID,$salespersonID,$orderDate,$deliveryDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$details,$status,$timestamp);
    while ($stm->fetch()) {
        $docCounter++;

        $customerCode = getCustomerCode($customerID);
        $typeOfBusiness=getTypeOfBusiness($customerID);
        $typeOfCustomer=getTypeOfCustomer($customerID);
        $registrationCode =getRegistrationCode($customerID);
        $salesPersonCode = getSalespersonCode($salespersonID);


        $grandTotal=round($grandTotal,2);
        $discountAmount=round($discountAmount,2);
        $depositAmount=round($depositAmount,2);



        if(true)
        {






            $resultLines=array();

            //EXPORT LINES
            $lineCounter=0;
            $db2 = new mysqli(localhost,$username,$password,$database);
            if (mysqli_connect_errno())
            {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db2->set_charset("utf8");

            $stm2 = $db2->prepare("SELECT tender_item_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM Tender_Item WHERE tender_id='$tenderID' ");
            $stm2-> execute();
            $stm2-> bind_result($orderItemID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
            while ($stm2->fetch()) {
                $line="";
                if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
                $lineCounter=$lineCounter+1;
                $discount = $lineDiscount+$globalDiscount;

                $lineTotal=0;
                $subunits = getSubUnits($itemID);
                if($subunits==1)
                {
                    $lineTotal= $unitPrice*$qty;
                    $lineTotal=round($lineTotal,2);
                    $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;



                }
                else
                {

                    $units = getUntis($qty,$subunits);
                    $sub = getSub($qty,$subunits);
                    $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
                    $lineTotal=round($lineTotal,2);
                    $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;



                }

                $itemCode = getItemCode($itemID);
                $priceCode = $pricetypeID ;
                if($pricetypeID>6)
                {
                    $priceCode ="M";
                }
                if($pricetypeID==0)
                {
                    $priceCode ="M";
                }

                if($pricetypeID == 97)
                {
                    $priceCode ="C";
                }



                if($discount>0)
                {
                    $priceCode ="%";
                }




                $lineTotal = $lineTotal - $discount;
                $lineTotal=round($lineTotal,2);

                $vatTotal =round($vatTotal,2);
                $discount=round($discount,2);

                $lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
                $lineText= str_replace("null","",$lineText);
                if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
                $line->ItemCode=$itemCode;
                $line->Quantity=$qty;
                $line->UnitPrice=$unitPrice;
                if($pricetypeID==99||$pricetypeID==98||$discount>0)
                {
                    $line->UnitPrice=$lineTotal/$qty;
                }
                $line->FreeText = $description;

                array_push($resultLines,$line);



            }
            $stm2-> close();
        }

        $result = "";
        $result->NumAtCard = $orderCode;
        $result->DocDate = $orderDate;
        $result->DocDueDate = $deliveryDate;
        $result->CardCode = $customerCode;
        $result->Comments = $details;
        $result->SalesPersonCode = $salesPersonCode;
        $result->DocumentLines = $resultLines;
        $result->DocTotal=$grandTotal;
        // $result->BPL_IDAssignedToInvoice = $companyCode;
        // $result->U_CoPrime = "Y";
        // $result->U_City = "$city";




    }
    $stm-> close();

    return $result;
}

function exportOrder($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,order_date,subtotal,grand_total,vat_amount,discount_amount,print_count,order_address_id,delivery_address_id,tender_id,vat_i_or_e,delivery_date,deposit_amount,details,status,delivery_method,timestamp FROM Orders WHERE order_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$depositAmount,$details,$status,$deliveryMethod,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
	$region = getWarehouseRegion($salepersonWarehouseCode);

//	$companyCode = getCompanyCode($companyID);
// 	$numberOFLines = getNumberOFLinesOrder($orderID);

    // $linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getCustomerCode($customerID);
    $typeOfBusiness=getTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfCustomer($customerID);
    $registrationCode =getRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
// 	if($paymentTypeID>1)
//         {
//               $paymentType="CH";
//         }
//         else
//         {
//               $paymentType="CR";       
//         }

//         if(strcmp($typeOfCustomer,"Cash")==0)
//         { 
//             $paymentType="CH";     
//         }

//          if(strcmp($registrationCode,"0")==0)
//         { 
//             $paymentType="CH";     
//         }

     
//         if(strcmp($typeOfBusiness,"Cash")==0)
//         { 
//             if($paymentTypeID>1)
//             {
//                  $customerCode=getPaymentTypeCode($paymentTypeID);
//             }
//             else
//             {
//                 $customerCode="321999";
//             }
//             $paymentType="CH";
//             $addressCode=$delivertyAddressCode="";
//             $customerName= getCustomerName($customerID);
//             $details=$details." ".$customerName; 
//         }
	
    // 	$date = DateTime::createFromFormat('Y-m-d', $orderDate);
    // 	$orderDate= $date->format('d/m/Y');
    	
    	
    // 	$date = DateTime::createFromFormat('Y-m-d', $deliveryDate);
    // 	$deliveryDate= $date->format('d/m/Y');
    	
    
        if(true)
        {
        
        
        //     if(strcmp($myfile,'')!=0){fwrite($myfile, "OH\n");}
        // 	$headerText = "$companyCode|$orderCode|$numberOFLines|$printCount|$orderDate|$deliveryDate|$depositAmount|$paymentType|$customerCode|$addressCode|$delivertyAddressCode|$salepersonWarehouseCode|$salesPersonCode||$details|O|Y|EUR|1|Coprime|E|\n";
        // 	$headerText= str_replace("null","",$headerText);
        //     if(strcmp($myfile,'')!=0){fwrite($myfile, $headerText);}
        	
        	
        	
        	
        	
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT order_item_id,order_id,item_id,qty,qty_delivered,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM Order_Item WHERE order_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$qtyDelivered,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				// $line->WarehouseCode='GDLT-YPS';
        				$line->WarehouseCode=$salepersonWarehouseCode;
        				$line->CostingCode = $region;
        				$line->FreeText = $description;

        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $orderCode;
            $result->DocDate = $orderDate;
            $result->DocDueDate = $deliveryDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->DocumentLines = $resultLines;
            $result->BPL_IDAssignedToInvoice= $companyCode;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportPurchaseOrder($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,order_date,subtotal,grand_total,vat_amount,discount_amount,print_count,order_address_id,delivery_address_id,tender_id,vat_i_or_e,delivery_date,deposit_amount,details,status,delivery_method,timestamp FROM Purchase_Orders WHERE order_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$depositAmount,$details,$status,$deliveryMethod,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
	$region = getWarehouseRegion($salepersonWarehouseCode);

//	$companyCode = getCompanyCode($companyID);
// 	$numberOFLines = getNumberOFLinesOrder($orderID);

    // $linesSubTotal = getOrderLinesSubTotal($orderID);
    
    $customerCode = getSupplierCode($customerID);
    $typeOfBusiness=getSupplierTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfSupplier($customerID);
    $registrationCode =getSupplierRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);


	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
// 	if($paymentTypeID>1)
//         {
//               $paymentType="CH";
//         }
//         else
//         {
//               $paymentType="CR";       
//         }

//         if(strcmp($typeOfCustomer,"Cash")==0)
//         { 
//             $paymentType="CH";     
//         }

//          if(strcmp($registrationCode,"0")==0)
//         { 
//             $paymentType="CH";     
//         }

     
//         if(strcmp($typeOfBusiness,"Cash")==0)
//         { 
//             if($paymentTypeID>1)
//             {
//                  $customerCode=getPaymentTypeCode($paymentTypeID);
//             }
//             else
//             {
//                 $customerCode="321999";
//             }
//             $paymentType="CH";
//             $addressCode=$delivertyAddressCode="";
//             $customerName= getCustomerName($customerID);
//             $details=$details." ".$customerName; 
//         }
	
    // 	$date = DateTime::createFromFormat('Y-m-d', $orderDate);
    // 	$orderDate= $date->format('d/m/Y');
    	
    	
    // 	$date = DateTime::createFromFormat('Y-m-d', $deliveryDate);
    // 	$deliveryDate= $date->format('d/m/Y');
    	
    
        if(true)
        {
        
        
        //     if(strcmp($myfile,'')!=0){fwrite($myfile, "OH\n");}
        // 	$headerText = "$companyCode|$orderCode|$numberOFLines|$printCount|$orderDate|$deliveryDate|$depositAmount|$paymentType|$customerCode|$addressCode|$delivertyAddressCode|$salepersonWarehouseCode|$salesPersonCode||$details|O|Y|EUR|1|Coprime|E|\n";
        // 	$headerText= str_replace("null","",$headerText);
        //     if(strcmp($myfile,'')!=0){fwrite($myfile, $headerText);}
        	
        	
        	
        	
        	
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT order_item_id,order_id,item_id,qty,qty_delivered,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM Purchase_Order_Item WHERE order_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$qtyDelivered,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				// $line->WarehouseCode='GDLT-YPS';
        				$line->WarehouseCode=$salepersonWarehouseCode;
        				$line->CostingCode = $region;
        				$line->FreeText = $description;

        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $orderCode;
            $result->DocDate = $orderDate;
            $result->DocDueDate = $deliveryDate;
            $result->RequriedDate = $deliveryDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->DocumentLines = $resultLines;
            $result->BPL_IDAssignedToInvoice= $companyCode;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportPurchaseInvoice($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,invoice_date,subtotal,grand_total,vat_amount,discount_amount,print_count,invoice_address_id,delivery_address_id,tender_id,vat_i_e,due_date,details,status,timestamp FROM Purchase_Invoices WHERE invoice_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$details,$status,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);

//	$companyCode = getCompanyCode($companyID);
// 	$numberOFLines = getNumberOFLinesOrder($orderID);

    // $linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getSupplierCode($customerID);
    $typeOfBusiness=getSupplierTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfSupplier($customerID);
    $registrationCode =getSupplierRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
        if(true)
        {
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT invoice_item_id,invoice_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM Purchase_Invoice_Item WHERE invoice_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				// $line->WarehouseCode='GDLT-YPS';
        				$line->WarehouseCode=$salepersonWarehouseCode;
        				$line->UnitPrice = $unitPrice;

        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $orderCode;
            $result->DocDate = $orderDate;
            $result->DocDueDate = $deliveryDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->DocumentLines = $resultLines;
            $result->BPL_IDAssignedToInvoice= $companyCode;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportPurchaseReturn($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT return_id,return_code,company_id,customer_id,salesperson_id,paymenttype_id,return_date,subtotal,grand_total,vat_amount,discount_amount,print_count,return_address_id,return_address_id,details,status,timestamp FROM Purchase_Returns WHERE return_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$details,$status,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);

//	$companyCode = getCompanyCode($companyID);
// 	$numberOFLines = getNumberOFLinesOrder($orderID);

    // $linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getSupplierCode($customerID);
    $typeOfBusiness=getSupplierTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfSupplier($customerID);
    $registrationCode =getSupplierRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
        if(true)
        {
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT return_item_id,return_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,status,timestamp FROM Purchase_Return_Item WHERE return_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				// $line->WarehouseCode='GDLT-YPS';
        				$line->WarehouseCode=$salepersonWarehouseCode;
        				$line->UnitPrice = $unitPrice;

        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $orderCode;
            $result->DocDate = $orderDate;
            $result->DocDueDate = $deliveryDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->DocumentLines = $resultLines;
            $result->BPL_IDAssignedToInvoice= $companyCode;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportGRN($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT waybill_id,waybill_code,company_id,customer_id,salesperson_id,paymenttype_id,waybill_date,subtotal,grand_total,vat_amount,discount_amount,print_count,waybill_address_id,delivery_address_id,tender_id,vat_i_e,waybill_date,details,status,document_number,timestamp FROM GRNs WHERE waybill_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$details,$status,$documentNumber,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);

//	$companyCode = getCompanyCode($companyID);
// 	$numberOFLines = getNumberOFLinesOrder($orderID);

    // $linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getSupplierCode($customerID);
    $typeOfBusiness=getSupplierTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfSupplier($customerID);
    $registrationCode =getSupplierRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	$region = getWarehouseRegion($salepersonWarehouseCode);
	
        if(true)
        {
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT waybill_item_id,waybill_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM GRN_Item WHERE waybill_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				$line->WarehouseCode=$salepersonWarehouseCode;
                        $line->UnitPrice = $unitPrice;
                        $line->VendorNum = "$documentNumber";
                        $line->CostingCode = $region;
        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $documentNumber;
            $result->DocDate = $orderDate;
            $result->DocDueDate = $deliveryDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->DocumentLines = $resultLines;
            $result->BPL_IDAssignedToInvoice= $companyCode;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportReturn($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");


    $stm = $db->prepare("SELECT return_id,return_code,company_id,customer_id,salesperson_id,paymenttype_id,return_date,subtotal,grand_total,vat_amount,discount_amount,print_count,return_address_id,return_address_id,order_id,vat_i_e,details,status,return_type,timestamp FROM Returns WHERE return_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$details,$status,$returnType,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	
	$salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
    $region = getWarehouseRegion($salepersonWarehouseCode);	
// 	$numberOFLines = getNumberOFLinesOrder($orderID);
    // $linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getCustomerCode($customerID);
    $typeOfBusiness=getTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfCustomer($customerID);
    $registrationCode =getRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
// 	if($paymentTypeID>1)
//         {
//               $paymentType="CH";
//         }
//         else
//         {
//               $paymentType="CR";       
//         }

//         if(strcmp($typeOfCustomer,"Cash")==0)
//         { 
//             $paymentType="CH";     
//         }

//          if(strcmp($registrationCode,"0")==0)
//         { 
//             $paymentType="CH";     
//         }

     
//         if(strcmp($typeOfBusiness,"Cash")==0)
//         { 
//             if($paymentTypeID>1)
//             {
//                  $customerCode=getPaymentTypeCode($paymentTypeID);
//             }
//             else
//             {
//                 $customerCode="321999";
//             }
//             $paymentType="CH";
//             $addressCode=$delivertyAddressCode="";
//             $customerName= getCustomerName($customerID);
//             $details=$details." ".$customerName; 
//         }
	
    // 	$date = DateTime::createFromFormat('Y-m-d', $orderDate);
    // 	$orderDate= $date->format('d/m/Y');
    	
    	
    // 	$date = DateTime::createFromFormat('Y-m-d', $deliveryDate);
    // 	$deliveryDate= $date->format('d/m/Y');
    	
    
        if(true)
        {
        
        
        //     if(strcmp($myfile,'')!=0){fwrite($myfile, "OH\n");}
        // 	$headerText = "$companyCode|$orderCode|$numberOFLines|$printCount|$orderDate|$deliveryDate|$depositAmount|$paymentType|$customerCode|$addressCode|$delivertyAddressCode|$salepersonWarehouseCode|$salesPersonCode||$details|O|Y|EUR|1|Coprime|E|\n";
        // 	$headerText= str_replace("null","",$headerText);
        //     if(strcmp($myfile,'')!=0){fwrite($myfile, $headerText);}
        	
        	
        	
        	
        	
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");

        	$stm2 = $db2->prepare("SELECT return_item_id,return_id,item_id,qty,batch_number,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,warehouse_id,timestamp FROM Return_Item WHERE return_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$qtyDelivered,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$itemWarehouseID,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "RL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        			    $itemWarehouseCode = getWarehouseCode($itemWarehouseID);
        			    

        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				// $line->WarehouseCode='GDLT-YPS';
        				$line->WarehouseCode=$itemWarehouseCode;
        				$line->CostingCode = $region;

        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $orderCode;
            $result->DocDate = $orderDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->BPL_IDAssignedToInvoice = $companyCode;
            $result->DocumentLines = $resultLines;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportReceipt($receiptID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");



    $stm = $db->prepare("SELECT receipt_id,receipt_code,customer_id,company_id,salesperson_id,order_id,invoice_id,address_id,amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,receipt_date,notes,status,timestamp FROM Receipts WHERE receipt_id='$receiptID'");
	$stm-> execute();
	$stm-> bind_result($receiptID,$receiptCode,$customerID,$companyID,$salespersonID,$orderID,$invoiceID,$addressID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$receiptDate,$notes,$status,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	

	
// 	$companyCode = getCompanyCode($companyID);
//  $registrationCode =getRegistrationCode($customerID);
// 	$addressCode= getAddressCode($orderAddressID);
// 	$salesPersonCode = getSalespersonCode($salespersonID);
    
    $customerCode = getCustomerCode($customerID);
	$salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
	
	
	$amount=round($amount,2);
	$cashDiscount=round($cashDiscount,2);
	
	

    	
    
        if(true)
        {
        
        
            //  if(strcmp($myfile,'')!=0){fwrite($myfile, "OH\n");}
            // 	$headerText = "$companyCode|$orderCode|$numberOFLines|$printCount|$orderDate|$deliveryDate|$depositAmount|$paymentType|$customerCode|$addressCode|$delivertyAddressCode|$salepersonWarehouseCode|$salesPersonCode||$details|O|Y|EUR|1|Coprime|E|\n";
            // 	$headerText= str_replace("null","",$headerText);
            //  if(strcmp($myfile,'')!=0){fwrite($myfile, $headerText);}
        	
        	$result = "";
            $result->DocDate = $receiptDate;
            $result->CardCode = $customerCode;
            $result->Reference1=$receiptCode;
            $result->Reference2=$receiptCode;
            $result->CounterReference=$receiptCode;
            $result->BPLID= $companyCode;
            
           // $result->TotalDiscount = $cashDiscount;
        	

            if(strcmp($paymentMethod,'Cheque')==0)
            {
                $result->CashSum = 0;
                $result->PaymentChecks = array();
                
                $checks = '';
                $checks->DueDate = $chequeDate;
                $checks->CheckNumber = $chequeNumber;
                $checks->BankCode = $bank;
                $checks->Branch = $branch;
                $checks->CheckSum = $amount;
    
                array_push($result->PaymentChecks,$checks);
            }
            else 
            {
                
                $result->CashSum = $amount;
                $result->PaymentChecks = array();

            }
            

    
        }
	}
    $stm-> close();	

    return $result;
}

function exportTransferRequest($requestID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");

    $resultLines=array();
    $stm = $db->prepare("SELECT warehouse_transaction_id,warehouse_transaction_code,warehouse_id_from,warehouse_id_to,company_id,salesperson_id,type,transaction_date,details,timestamp FROM Warehouse_Transactions WHERE warehouse_transaction_id='$requestID'");
	$stm-> execute();
	$stm-> bind_result($requestID,$requestCode,$warehouseFromID,$warehouseToID,$companyID,$salespersonID,$type,$requestDate,$details,$timestamp);
	while ($stm->fetch()) {
	    
    	$docCounter++;
    	
    // 	$companyCode = getCompanyCode($companyID);
    //  $registrationCode =getRegistrationCode($customerID);
    // 	$addressCode= getAddressCode($orderAddressID);
    // 	$salesPersonCode = getSalespersonCode($salespersonID);
        
    	$salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
    	
    	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
    	$db2 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) 
        {
     	   printf("Connect failed: %s\n", mysqli_connect_error());
     	   exit();
     	}
    	$db2->set_charset("utf8");
    	
        $stm2 = $db2->prepare("SELECT warehouse_transaction_item_id, Warehouse_Transaction_Item.item_id,Items.item_code, batch_number, warehouse_id, qty, serialnumber,Warehouse_Transaction_Item.timestamp FROM Warehouse_Transaction_Item,Items WHERE Warehouse_Transaction_Item.item_id=Items.item_id AND warehouse_transaction_id='$requestID' ORDER BY Items.item_code");
        $stm2-> execute();
        $stm2-> bind_result($wtItemID,$itemID,$itemCode,$batchNumber,$warehouseID,$qty,$serialNumber,$timestamp);
        while ($stm2->fetch()) {
            //$itemCode =getItemCode($itemID);
            $itemWarehouseCode=getWarehouseCode($warehouseToID);
            $region = getWarehouseRegion($itemWarehouseCode);
            $itemFromWarehouseCode=getWarehouseCode($warehouseFromID);
            if(strcmp($itemWarehouseCode,'GDL')==0){$itemWarehouseCode=1;}
            $line = '';
    	    $line->ItemCode=$itemCode;
        	$line->Quantity=$qty;
        	$line->WarehouseCode=$itemWarehouseCode;
        	$line->FromWarehouseCode=$itemFromWarehouseCode;
        	$line->DistributionRule = $region;
        	
        	array_push($resultLines,$line);
        
        }
        $stm2-> close();
            $result->Reference1 = $requestCode;
            $result->DocDate = $requestDate;
            $result->Comments = $details;
            $result->ToWarehouse=$itemWarehouseCode;
        	$result->FromWarehouse=$itemFromWarehouseCode;
        	$result->SalesPersonCode = $salesPersonCode;
            $result->StockTransferLines = $resultLines;
    }
    $stm-> close();	

    return $result;
}

function getCompanyCode($cumpanyID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT company_code FROM Companies WHERE company_id='$cumpanyID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($companyCode);
	while ($stm1->fetch()) {
		return $companyCode;
	 }
	 $stm1->close();
    $stm1->close();
      return $companyCode;
   
    
}

function getCustomerCode($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_code FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getSupplierCode($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_code FROM Suppliers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getAddressCode($addressID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT address_code FROM CustomerAddress WHERE customer_address_id ='$addressID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($addressCode);
	while ($stm1->fetch()) {
		return $addressCode;
	 }
	 $stm1->close();
      return $addressCode;
   
    
}

function getWarehouseCodeOFSalesPerson($salesPersonID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");



$stm1 = $db1->prepare("SELECT default_warehouse_id FROM SalesPersons WHERE salesperson_id='$salesPersonID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($defaultWarehouseID);
	while ($stm1->fetch()) {
		
	 }
	 $stm1->close();
      



	$stm1 = $db1->prepare("SELECT warehouse_code FROM Warehouses WHERE warehouse_id ='$defaultWarehouseID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($warehouseCode);
	while ($stm1->fetch()) {
		return $warehouseCode;
	 }
	 $stm1->close();
      return $warehouseCode;
   
    
}

function getWarehouseCode($whID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");


      

	$stm1 = $db1->prepare("SELECT warehouse_code FROM Warehouses WHERE warehouse_id ='$whID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($warehouseCode);
	while ($stm1->fetch()) {
		return $warehouseCode;
	 }
	 $stm1->close();
      return $warehouseCode;
   
    
}

function getWarehouseCompany($warehouseCode) {
    global $username;
    global $password;
    global $database;
	
    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");


      
    $companyID=1;
	$stm1 = $db1->prepare("SELECT company_id FROM Warehouses WHERE warehouse_code ='$warehouseCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($id);
	while ($stm1->fetch()) {
		if($id > 0){
		  $companyID = $id;
		}
	}
	$stm1->close();
    
    $stm1 = $db1->prepare("SELECT company_code FROM Companies WHERE company_id ='$companyID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($companyCode);
	while ($stm1->fetch()) {}
	$stm1->close();
	
	if(strcmp($companyCode,'GDL')==0){$companyCode=1;}
     
    return $companyCode;
   
    
}

function getSalespersonCode($salesPersonID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id='$salesPersonID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($salespersonCode);
	while ($stm1->fetch()) {
		return $salespersonCode;
	 }
	 $stm1->close();
      return $salespersonCode;
   
    
}

function getSubUnits($itemID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT subunits FROM Items WHERE item_id='$itemID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($sub);
	while ($stm1->fetch()) {
		return $sub;
	 }
	 $stm1->close();
      return $sub;
   
    
}

function getVatPercentage($vatID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT percentage FROM Vats WHERE vat_id='$vatID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($percentage);
	while ($stm1->fetch()) {
		return $percentage;
	 }
	 $stm1->close();
      return $percentage;
   
    
}

function getUntis($qty,$subunits){

	return ((int) ($qty/$subunits));

}

function getSub($qty,$subunits){

	return  $qty % $subunits;

}

function getItemCode($itemID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT item_code FROM Items WHERE item_id='$itemID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($code);
	while ($stm1->fetch()) {
		return $code;
	 }
	 $stm1->close();
      return $code;
   
    
}

function getTypeOfBusiness($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT type_of_business FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getSupplierTypeOfBusiness($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT type_of_business FROM Suppliers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getTypeOfSupplier($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_type FROM Suppliers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getTypeOfCustomer($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_type FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getCustomerName($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_company_name FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getPaymentTypeCode($paymentTypeID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT paymenttype_code FROM PaymentTypes WHERE paymenttype_id ='$paymentTypeID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getRegistrationCode($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT registration_code FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getSupplierRegistrationCode($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT registration_code FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getSalesPersonOfLeadCustomer($customerID) {

    $devicePrefix = substr($customerID, 0, 4);

    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT sales_person_id FROM Devices WHERE prefix='$devicePrefix' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($salespersonID);
    while ($stm1->fetch()) {}
    $stm1->close();

    $salespersonID = intval($salespersonID);

    $stm1 = $db1->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id ='$salespersonID' AND NOT salesperson_id=0 LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($salespersonCode);
    while ($stm1->fetch()) { }
    $stm1->close();


    return "$salespersonCode";


}
?>