<?php
class SAPClient
{
    private $ip;
    private $port;
    private $userame;
    private $password;
    private $company;
    private $action;
    private $filterQuery;
    private $sessionID;
    private $errors;
    private $response;
    private $responseCode;

    function setIP($ip){$this->ip = $ip;}
    function setPort($port){$this->port = $port;}
    function setUsername($username){$this->username = $username;}
    function setPassword($password){$this->password = $password;}
    function setCompany($company){$this->company = $company;}
    function setAction($action){$this->action = $action;}
    function setFilterQuery($filterQuery){$this->filterQuery = $filterQuery;}
    function setSessionID($sessionID){$this->sessionID = $sessionID;}
    function setErrors($errors){$this->errors = $errors;}
    function setResponse($response){$this->responce = $response;}
    function setResponseCode($responseCode){$this->responseCode = $responseCode;}

    function getIP(){ return $this->ip;}
    function getUsername(){ return $this->username;}
    function getPassword(){ return $this->password;}
    function getCompany(){ return $this->company;}
    function getAction(){ return $this->action;}
    function getFilterQuery(){ return $this->filterQuery;}
    function getSessionID(){ return $this->sessionID;}
    function getErrors(){ return $this->errors;}
    function getResponse(){ return $this->response;}
    function getResponseCode(){ return $this->responseCode;}


    function __construct($ip,$port,$username,$password,$company)
    {
        $this->setIP($ip);
        $this->setPort($port);
        $this->setUsername($username);
        $this->setPassword($password);
        $this->setCompany($company);

    }

    function startConnection()
    {
        $params = ["UserName" => "$this->username", "Password" => "$this->password", "CompanyDB" => "$this->company",];

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, "https://" . $this->ip . ":" . $this->port . "/b1s/v1/Login");
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_VERBOSE, 1);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($params));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);

        $result  = json_decode(curl_exec($curl),true);
        $errors  = $this->getErrors();
        $errors .= curl_error($curl);

        curl_close($curl);
        
        // echo json_encode($result).'<br>';

        $this->setSessionID($result['SessionId']);
        $this->setResponse(curl_getinfo($curl, CURLINFO_HTTP_CODE));
        $this->setErrors($errors);
        echo $this->getErrors();

    }

    function closeConnection()
    {

    }

    function requestDataForTest($action='',$filterQuery='')
    {

        if(strcmp($action,'')==0){$action = $this->action;}
        if(strcmp($filterQuery,'')==0){$filterQuery = $this->filterQuery;}
        if(strcmp($filterQuery,'')!=0){$action .= '?'.$filterQuery;}
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => "https://$this->ip:$this->port/b1s/v1/$action",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 100,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_SSL_VERIFYPEER =>false,
            CURLOPT_SSL_VERIFYHOST =>false,
            CURLOPT_HTTPHEADER => array("Cookie: B1SESSION=$this->sessionID; ROUTEID=.node7"),
        ));

            $response = curl_exec($curl);
            curl_close($curl);


            return $response;
    }

    function requestData($action='',$filterQuery='',$echo=true)
    {

        if(strcmp($action,'')==0){$action = $this->action;}
        if(strcmp($filterQuery,'')==0){$filterQuery = $this->filterQuery;}
        if(strcmp($filterQuery,'')!=0){$action .= '?'.$filterQuery;}
        if (strpos($filterQuery, '$skip') !== false) {
            $filter = explode('=',$filterQuery)[1];
            if (strpos($action, '$skip') !== false && strpos($filter, '$skip') !== false) {$action = explode('?',$action)[0];}
            $NextResult = $this->requestData($action."?".$filter,'');
            return $NextResult;
        } else {

            $curl = curl_init();
            if($echo){
                echo "<br><br><b>REQUEST: https://$this->ip:$this->port/b1s/v1/$action</b><br>";
            }
    
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://$this->ip:$this->port/b1s/v1/$action",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 100,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_SSL_VERIFYPEER =>false,
                CURLOPT_SSL_VERIFYHOST =>false,
                CURLOPT_HTTPHEADER => array("Cookie: B1SESSION=$this->sessionID; ROUTEID=.node7"),
            ));
    
            $response = json_decode(curl_exec($curl),true);
        // echo"<pre>";var_dump($response);
            curl_close($curl);
            $dataResult = $response['value'];
            $skipValue = $response['odata.nextLink'];
            $result = array($dataResult,$skipValue,$response);
            
            // $result = $response['value'];
    
            // if(strcmp($response['odata.nextLink'],'')!=0){
                
            //     $filter = explode('?',$response['odata.nextLink'])[1];
            //     if (strpos($action, '$skip') !== false && strpos($filter, '$skip') !== false) {$action = explode('?',$action)[0];}
            //     $NextResult = $this->requestData($action."?".$filter,'');
            //     $result = array_merge($result, $NextResult);
            //     // echo $action."?".$filter."<br>";
    
            // }
    
            return $result;
        }
    }
    
    function requestDataWithPaging($action='',$filterQuery='',$echo=true)
    {

        if(strcmp($action,'')==0){$action = $this->action;}
        if(strcmp($filterQuery,'')==0){$filterQuery = $this->filterQuery;}
        if(strcmp($filterQuery,'')!=0){$action .= '?'.$filterQuery;}
        if (strpos($filterQuery, '$skip') !== false) {
            $filter = explode('=',$filterQuery)[1];
            if (strpos($action, '$skip') !== false && strpos($filter, '$skip') !== false) {$action = explode('?',$action)[0];}
            $NextResult = $this->requestDataWithPaging($action."?".$filter,'');
            return $NextResult;
        } else {

            $curl = curl_init();
            if($echo){
                echo "<br><br><b>REQUEST: https://$this->ip:$this->port/b1s/v1/$action</b><br>";
            }
    
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://$this->ip:$this->port/b1s/v1/$action",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 100,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_SSL_VERIFYPEER =>false,
                CURLOPT_SSL_VERIFYHOST =>false,
                CURLOPT_HTTPHEADER => array("Cookie: B1SESSION=$this->sessionID; ROUTEID=.node7","Prefer: odata.maxpagesize=500"),
            ));
    
            $response = json_decode(curl_exec($curl),true);
        // echo"<pre>";var_dump($response);
            curl_close($curl);
            $dataResult = $response['value'];
            $skipValue = $response['odata.nextLink'];
            $result = array($dataResult,$skipValue);
            
            // $result = $response['value'];
    
            // if(strcmp($response['odata.nextLink'],'')!=0){
                
            //     $filter = explode('?',$response['odata.nextLink'])[1];
            //     if (strpos($action, '$skip') !== false && strpos($filter, '$skip') !== false) {$action = explode('?',$action)[0];}
            //     $NextResult = $this->requestData($action."?".$filter,'');
            //     $result = array_merge($result, $NextResult);
            //     // echo $action."?".$filter."<br>";
    
            // }
    
            return $result;
        }
    }
    
    function requestBalances($action='',$filterQuery='')
    {

        if(strcmp($action,'')==0){$action = $this->action;}
        if(strcmp($filterQuery,'')==0){$filterQuery = $this->filterQuery;}
        if(strcmp($filterQuery,'')!=0){$action .= '?'.$filterQuery;}
        if (strpos($filterQuery, '$skip') !== false) {
            $filter = explode('=',$filterQuery)[1];
            if (strpos($action, '$skip') !== false && strpos($filter, '$skip') !== false) {$action = explode('?',$action)[0];}
            $NextResult = $this->requestData($action."?".$filter,'');
            return $NextResult;
        } else {

            $curl = curl_init();
            echo "<br><br><b>REQUEST: https://$this->ip:$this->port/b1s/v1/$action</b><br>";
    
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://$this->ip:$this->port/b1s/v1/$action",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 100,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_SSL_VERIFYPEER =>false,
                CURLOPT_SSL_VERIFYHOST =>false,
                CURLOPT_HTTPHEADER => array("Cookie: B1SESSION=$this->sessionID; ROUTEID=.node7"),
            ));
    
            $response = json_decode(curl_exec($curl),true);
        // echo"<pre>";var_dump($response);
            curl_close($curl);
            $dataResult = $response['value'];
            $skipValue = $response['@odata.nextLink'];
            $result = array($dataResult,$skipValue);
            
            // $result = $response['value'];
    
            // if(strcmp($response['odata.nextLink'],'')!=0){
                
            //     $filter = explode('?',$response['odata.nextLink'])[1];
            //     if (strpos($action, '$skip') !== false && strpos($filter, '$skip') !== false) {$action = explode('?',$action)[0];}
            //     $NextResult = $this->requestData($action."?".$filter,'');
            //     $result = array_merge($result, $NextResult);
            //     // echo $action."?".$filter."<br>";
    
            // }
    
            return $result;
        }
    }
    
      function requestDataImage($action='',$filterQuery='')
    {

        if(strcmp($action,'')==0){$action = $this->action;}
        if(strcmp($filterQuery,'')==0){$filterQuery = $this->filterQuery;}
        if(strcmp($filterQuery,'')!=0){$action .= '?'.$filterQuery;}
        if (strpos($filterQuery, '$skip') !== false) {
            $filter = explode('=',$filterQuery)[1];
            if (strpos($action, '$skip') !== false && strpos($filter, '$skip') !== false) {$action = explode('?',$action)[0];}
            $NextResult = $this->requestData($action."?".$filter,'');
            return $NextResult;
        } else {

            $curl = curl_init();
            echo "<br><br><b>REQUEST: https://$this->ip:$this->port/b1s/v1/$action</b><br>";
    
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://$this->ip:$this->port/b1s/v1/$action",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 100,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_SSL_VERIFYPEER =>false,
                CURLOPT_SSL_VERIFYHOST =>false,
                CURLOPT_HTTPHEADER => array("Cookie: B1SESSION=$this->sessionID; ROUTEID=.node7"),
            ));
    
            $response = curl_exec($curl);
        // echo"<pre>";var_dump($response);
            curl_close($curl);
            $dataResult = $response['value'];
            $skipValue = $response['odata.nextLink'];
            $result = array($dataResult,$skipValue);
            
            // $result = $response['value'];
    
            // if(strcmp($response['odata.nextLink'],'')!=0){
                
            //     $filter = explode('?',$response['odata.nextLink'])[1];
            //     if (strpos($action, '$skip') !== false && strpos($filter, '$skip') !== false) {$action = explode('?',$action)[0];}
            //     $NextResult = $this->requestData($action."?".$filter,'');
            //     $result = array_merge($result, $NextResult);
            //     // echo $action."?".$filter."<br>";
    
            // }
    
            return $response;
        }
    }
    
    function postData($action='',$postData=array())
    {

        if(!empty($postData)){
            $postValue = json_encode($postData);
            $curl = curl_init();
            echo "<br><br><b>POST: https://$this->ip:$this->port/b1s/v1/$action</b><br>";
        
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://$this->ip:$this->port/b1s/v1/$action",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 100,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "POST",
                CURLOPT_SSL_VERIFYPEER =>false,
                CURLOPT_SSL_VERIFYHOST =>false,
                CURLOPT_POSTFIELDS => $postValue,
                CURLOPT_HTTPHEADER => array("Cookie: B1SESSION=$this->sessionID; ROUTEID=.node7","Expect:"),
            ));
    
            $result = json_decode(curl_exec($curl),true);
            // echo"<pre>";var_dump($response);
            curl_close($curl);
        } else {
            $result = "Empty Array";
        }
        

        return $result;
    }
    
    function patchData($action='',$postData=array())
    {

        if(!empty($postData)){
            $postValue = json_encode($postData);
            $curl = curl_init();
            echo "<br><br><b>PATCH: https://$this->ip:$this->port/b1s/v1/$action</b><br>";
        
            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://$this->ip:$this->port/b1s/v1/$action",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 100,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "PATCH",
                CURLOPT_SSL_VERIFYPEER =>false,
                CURLOPT_SSL_VERIFYHOST =>false,
                CURLOPT_POSTFIELDS => $postValue,
                CURLOPT_HTTPHEADER => array("Cookie: B1SESSION=$this->sessionID; ROUTEID=.node7"),
            ));
    
            $result = json_decode(curl_exec($curl),true);
            // echo"<pre>";var_dump($response);
            curl_close($curl);
        } else {
            $result = "Empty Array";
        }
        

        return $result;
    }


    function patchDataWithDelete($action='',$postData=array())
    {

        if(!empty($postData)){
            $postValue = json_encode($postData);
            $curl = curl_init();
            echo "<br><br><b>PATCH: https://$this->ip:$this->port/b1s/v1/$action</b><br>";

            curl_setopt_array($curl, array(
                CURLOPT_URL => "https://$this->ip:$this->port/b1s/v1/$action",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 100,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "PATCH",
                CURLOPT_SSL_VERIFYPEER =>false,
                CURLOPT_SSL_VERIFYHOST =>false,
                CURLOPT_POSTFIELDS => $postValue,
                CURLOPT_HTTPHEADER => array("Cookie: B1SESSION=$this->sessionID; ROUTEID=.node7","Expect: ","B1S-ReplaceCollectionsOnPatch: true"),
            ));

            $result = json_decode(curl_exec($curl),true);
            // echo"<pre>";var_dump($response);
            curl_close($curl);
        } else {
            $result = "Empty Array";
        }


        return $result;
    }

    function sendFileAttachment($action,$fileRelativePath){

        echo "<br><br><b>POST: https://$this->ip:$this->port/b1s/v1/$action</b><br>";

        $curl = curl_init();

        curl_setopt_array($curl, array(
            //   CURLOPT_URL => 'https://213.207.148.14:50000/b1s/v1/Attachments2',
            CURLOPT_URL => "https://$this->ip:$this->port/b1s/v1/$action",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_SSL_VERIFYPEER =>false,
            CURLOPT_SSL_VERIFYHOST =>false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array ('File' => new CURLFILE($fileRelativePath)),
            CURLOPT_HTTPHEADER => array('Cookie: B1SESSION='.$this->sessionID.'; ROUTEID=.node2'),
        ));



        $result = json_decode(curl_exec($curl),true);
        // echo"RESPONCE:<pre>";var_dump($result);echo "</pre>";


        return $result;


    }

    function sendItemImage($action,$fileRelativePath){

        echo "<br><br><b>POST: https://$this->ip:$this->port/b1s/v1/$action</b><br>";

        $curl = curl_init();

        curl_setopt_array($curl, array(
            //   CURLOPT_URL => 'https://213.207.148.14:50000/b1s/v1/ItemImages('i001')',
            CURLOPT_URL => "https://$this->ip:$this->port/b1s/v1/$action",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_SSL_VERIFYPEER =>false,
            CURLOPT_SSL_VERIFYHOST =>false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'PATCH',
            CURLOPT_POSTFIELDS => array ('files' => new CURLFILE($fileRelativePath,'image/jpeg',basename($fileRelativePath))),
            CURLOPT_HTTPHEADER => array("Content-Type: multipart/form-data",'Cookie: B1SESSION='.$this->sessionID.'; ROUTEID=.node2', "Expect:"),
        ));



        $result = json_decode(curl_exec($curl),true);
        // echo"RESPONCE:<pre>";var_dump($result);echo "</pre>";


        return $result;


    }


}
?>