<?php

function sendFailErrorEmail($type,$code,$id,$status,$reason,$to=''){
    global $username;
    global $password;
    global $database;
    global $errorMail;
    
    if($status != 1){
        
        if(strcmp($to,'')==0){$to=$errorMail;}
        
        $headers = 'From: Coprime Cloud <info@coprime.co>' . "\r\n";
        $headers  .= 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html;charset=UTF-8' . "\r\n";
    
        mb_internal_encoding("UTF-8");
    
        $subject ="$type $code Failed to Sync";
    
        $message ="- - - This is an automatic notice. There is no need to reply to this email. - - -<br/>
                <br/>
                <br/>           
                $type $code Failed to Sync. <br/>
                Reason: $reason<br/>
                <br/>
                Regards,<br/>
                Coprime Team<br/>
                ";
    
    
        if(strcmp($to,'')!=0 && strpos($to, '@') !== false){
            echo "<br>mail $to, $subject </br>";
            mail($to, $subject, $message, $headers);
    
        }
    }
    
}

function insertDocumentStatuses($id,$type,$status,$reason){
    global $username;
    global $password;
    global $database;
	$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
 	$stmt = $db->prepare("INSERT IGNORE INTO Documents_Status (id,type,status,reason,timestamp) VALUES(?,?,?,?,NOW())");
	$stmt->bind_param('iiis',$id,$type,$status,$reason);
 	$stmt->execute(); 	
 	$stmt->close();
}

function exportTender($tenderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT tender_id,tender_code,company_id,customer_id,salesperson_id,tender_date,subtotal,grand_total,vat_amount,discount_amount,print_count,vat_i_e,valid_until,details,status,delivery_method,timestamp FROM Tenders WHERE tender_id='$tenderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$vatIE,$deliveryDate,$details,$status,$deliveryMethod,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
	$region = getWarehouseRegion($salepersonWarehouseCode);

//	$companyCode = getCompanyCode($companyID);
// 	$numberOFLines = getNumberOFLinesOrder($orderID);

    // $linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getCustomerCode($customerID);
    $typeOfBusiness=getTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfCustomer($customerID);
    $registrationCode =getRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
    
        if(true)
        {
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT tender_item_id,tender_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM Tender_Item WHERE tender_id='$tenderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				
        				$line = "";
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				$line->Price=$unitPrice;
        				$line->WarehouseCode=$salepersonWarehouseCode;
        				$line->CostingCode = $region;
        				$line->FreeText = $description;

        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $orderCode;
            $result->DocDate = $orderDate;
            $result->DocDueDate = $deliveryDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->DocumentLines = $resultLines;
            $result->BPL_IDAssignedToInvoice= $companyCode;


    
        }
        $stm-> close();	

    return $result;
}

function exportOrder($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,order_date,subtotal,grand_total,vat_amount,discount_amount,print_count,order_address_id,delivery_address_id,tender_id,vat_i_or_e,delivery_date,deposit_amount,details,status,delivery_method,timestamp FROM Orders WHERE order_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$depositAmount,$details,$status,$warehouseID,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$docCounter++;
	$documents=array();
	$document="";
	
	$companyCode = getCompanyCode($companyID);
	$numberOFLines = getNumberOFLinesOrder($orderID);

$linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getCustomerCode($customerID);
$typeOfBusiness=getTypeOfBusiness($customerID);
$typeOfCustomer=getTypeOfCustomer($customerID);
$registrationCode =getRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	
	$salepersonWarehouseCode=getWarehouseCode($warehouseID);
	if(strcmp($salepersonWarehouseCode,"")==0)
	{
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
	if($paymentTypeID>1)
        {
              $paymentType="CH";
        }
        else
        {
              $paymentType="CR";       
        }

        if(strcmp($typeOfCustomer,"Cash")==0)
        { 
            $paymentType="CH";     
        }

         if(strcmp($registrationCode,"0")==0)
        { 
            $paymentType="CH";     
        }

     
        if(strcmp($typeOfBusiness,"Cash")==0)
        { 
            if($paymentTypeID>1)
            {
                 $customerCode=getPaymentTypeCode($paymentTypeID);
            }
            else
            {
                $customerCode="321999";
            }
            $paymentType="CH";
            $addressCode=$delivertyAddressCode="";
            $customerName= getCustomerName($customerID);
            $details=$details." ".$customerName; 
        }
	$city=getShipment($orderID);
	
	

		$subtotal=round($subtotal,2);
		$vatAmount=round($vatAmount,2);	
		$grandTotal=round($grandTotal,2);
		
	$document->DocType=17;
	$document->NumAtCard=$orderCode;
	$document->DocDate=$orderDate;
	$document->DocDueDate=$deliveryDate;
// 	$document->PaymentMethod=$paymentType;
    $document->CardCode=$customerCode;
   
    $document->SalesPersonCode=$salesPersonCode;
    $document->Comments=$details;
    // $document->subtotal="$subtotal";
    $document->DocTotal="$grandTotal";
    $document->DocTotalSys="$grandTotal";
    $document->VatSum="$vatAmount";
    $document->VatSumSys="$vatAmount";
    $document->TotalDiscount="$discountAmount";
    $document->U_City="$city";
    



    $lines=array();
	
	//EXPORT LINES
	$lineCounter=0;
	$db2 = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db2->set_charset("utf8");
	
			$stm2 = $db2->prepare("SELECT order_item_id,order_id,item_id,qty,qty_delivered,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM Order_Item WHERE order_id='$orderID' ");
	$stm2-> execute();
	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$qtyDelivered,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
			while ($stm2->fetch()) {
            	$line="";
			
				$lineCounter=$lineCounter+1;
				$discount = $lineDiscount+$globalDiscount;
				
				$lineTotal=0;
				$subunits = getSubUnits($itemID);
				if($subunits==1)
				{
				 $lineTotal= $unitPrice*$qty;
				 $lineTotal=round($lineTotal,2);
				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
				 
				
				
				}
				else
				{
					
				 $units = getUntis($qty,$subunits);
				 $sub = getSub($qty,$subunits);
				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
				 $lineTotal=round($lineTotal,2);
				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
				 
				 
				 
				}
				
				$itemCode = getItemCode($itemID);
				$priceCode = $pricetypeID ;
				if($pricetypeID>6)
				{
					$priceCode ="M";
				}
				if($pricetypeID==0)
                                {
                                        $priceCode ="M";
                                }

                                if($pricetypeID == 97)
                                {
                                	$priceCode ="C";
                                }


                                
                                if($discount>0)
                                {
                                	$priceCode ="%";
                                }
                                
                                
				
				$lineTotal = $lineTotal - $discount;
				$lineTotal=round($lineTotal,2);
				$unitPrice=round($unitPrice,2);
				$vatTotal =round($vatTotal,2);
				$discount=round($discount,2);
				$description=urlencode($description);
				$itemCode=urlencode($itemCode);
				$line->ItemCode=$itemCode;
				$line->Quantity=$qty;
				$line->Price="$unitPrice";
				$line->UnitPrice="$unitPrice";
				$line->WarehouseCode=$salepersonWarehouseCode;
				$line->SalesPersonCode=$salesPersonCode;
				// $line->lineDiscount="$lineDiscount";
				// $line->globalDiscount="$globalDiscount";
				$line->FreeText=$description;
				$line->U_LFrText=$description;
				$line->U_FrText=$description;
				
			    array_push($lines,$line);
	
			}
			$stm2-> close();
			
			$document->DocumentLines=$lines;
			
            

    
        }
        $stm-> close();	

    return $document;
}

function exportPurchaseOrder($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,order_date,subtotal,grand_total,vat_amount,discount_amount,print_count,order_address_id,delivery_address_id,tender_id,vat_i_or_e,delivery_date,deposit_amount,details,status,delivery_method,timestamp FROM Purchase_Orders WHERE order_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$depositAmount,$details,$status,$deliveryMethod,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
	$region = getWarehouseRegion($salepersonWarehouseCode);

//	$companyCode = getCompanyCode($companyID);
// 	$numberOFLines = getNumberOFLinesOrder($orderID);

    // $linesSubTotal = getOrderLinesSubTotal($orderID);
    
    $customerCode = getSupplierCode($customerID);
    $typeOfBusiness=getSupplierTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfSupplier($customerID);
    $registrationCode =getSupplierRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);


	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
// 	if($paymentTypeID>1)
//         {
//               $paymentType="CH";
//         }
//         else
//         {
//               $paymentType="CR";       
//         }

//         if(strcmp($typeOfCustomer,"Cash")==0)
//         { 
//             $paymentType="CH";     
//         }

//          if(strcmp($registrationCode,"0")==0)
//         { 
//             $paymentType="CH";     
//         }

     
//         if(strcmp($typeOfBusiness,"Cash")==0)
//         { 
//             if($paymentTypeID>1)
//             {
//                  $customerCode=getPaymentTypeCode($paymentTypeID);
//             }
//             else
//             {
//                 $customerCode="321999";
//             }
//             $paymentType="CH";
//             $addressCode=$delivertyAddressCode="";
//             $customerName= getCustomerName($customerID);
//             $details=$details." ".$customerName; 
//         }
	
    // 	$date = DateTime::createFromFormat('Y-m-d', $orderDate);
    // 	$orderDate= $date->format('d/m/Y');
    	
    	
    // 	$date = DateTime::createFromFormat('Y-m-d', $deliveryDate);
    // 	$deliveryDate= $date->format('d/m/Y');
    	
    
        if(true)
        {
        
        
        //     if(strcmp($myfile,'')!=0){fwrite($myfile, "OH\n");}
        // 	$headerText = "$companyCode|$orderCode|$numberOFLines|$printCount|$orderDate|$deliveryDate|$depositAmount|$paymentType|$customerCode|$addressCode|$delivertyAddressCode|$salepersonWarehouseCode|$salesPersonCode||$details|O|Y|EUR|1|Coprime|E|\n";
        // 	$headerText= str_replace("null","",$headerText);
        //     if(strcmp($myfile,'')!=0){fwrite($myfile, $headerText);}
        	
        	
        	
        	
        	
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT order_item_id,order_id,item_id,qty,qty_delivered,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM Purchase_Order_Item WHERE order_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$qtyDelivered,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				// $line->WarehouseCode='GDLT-YPS';
        				$line->WarehouseCode=$salepersonWarehouseCode;
        				$line->CostingCode = $region;
        				$line->FreeText = $description;

        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $orderCode;
            $result->DocDate = $orderDate;
            $result->DocDueDate = $deliveryDate;
            $result->RequriedDate = $deliveryDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->DocumentLines = $resultLines;
            $result->BPL_IDAssignedToInvoice= $companyCode;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportPurchaseInvoice($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,invoice_date,subtotal,grand_total,vat_amount,discount_amount,print_count,invoice_address_id,delivery_address_id,tender_id,vat_i_e,due_date,details,status,timestamp FROM Purchase_Invoices WHERE invoice_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$details,$status,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);

//	$companyCode = getCompanyCode($companyID);
// 	$numberOFLines = getNumberOFLinesOrder($orderID);

    // $linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getSupplierCode($customerID);
    $typeOfBusiness=getSupplierTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfSupplier($customerID);
    $registrationCode =getSupplierRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
        if(true)
        {
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT invoice_item_id,invoice_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM Purchase_Invoice_Item WHERE invoice_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				// $line->WarehouseCode='GDLT-YPS';
        				$line->WarehouseCode=$salepersonWarehouseCode;
        				$line->UnitPrice = $unitPrice;

        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $orderCode;
            $result->DocDate = $orderDate;
            $result->DocDueDate = $deliveryDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->DocumentLines = $resultLines;
            $result->BPL_IDAssignedToInvoice= $companyCode;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportPurchaseReturn($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT return_id,return_code,company_id,customer_id,salesperson_id,paymenttype_id,return_date,subtotal,grand_total,vat_amount,discount_amount,print_count,return_address_id,return_address_id,details,status,timestamp FROM Purchase_Returns WHERE return_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$details,$status,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);

//	$companyCode = getCompanyCode($companyID);
// 	$numberOFLines = getNumberOFLinesOrder($orderID);

    // $linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getSupplierCode($customerID);
    $typeOfBusiness=getSupplierTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfSupplier($customerID);
    $registrationCode =getSupplierRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
        if(true)
        {
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT return_item_id,return_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,status,timestamp FROM Purchase_Return_Item WHERE return_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				// $line->WarehouseCode='GDLT-YPS';
        				$line->WarehouseCode=$salepersonWarehouseCode;
        				$line->UnitPrice = $unitPrice;

        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $orderCode;
            $result->DocDate = $orderDate;
            $result->DocDueDate = $deliveryDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->DocumentLines = $resultLines;
            $result->BPL_IDAssignedToInvoice= $companyCode;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportGRN($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT waybill_id,waybill_code,company_id,customer_id,salesperson_id,paymenttype_id,waybill_date,subtotal,grand_total,vat_amount,discount_amount,print_count,waybill_address_id,delivery_address_id,tender_id,vat_i_e,waybill_date,details,status,document_number,timestamp FROM GRNs WHERE waybill_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$details,$status,$documentNumber,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);

//	$companyCode = getCompanyCode($companyID);
// 	$numberOFLines = getNumberOFLinesOrder($orderID);

    // $linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getSupplierCode($customerID);
    $typeOfBusiness=getSupplierTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfSupplier($customerID);
    $registrationCode =getSupplierRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	$region = getWarehouseRegion($salepersonWarehouseCode);
	
        if(true)
        {
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT waybill_item_id,waybill_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM GRN_Item WHERE waybill_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				$line->WarehouseCode=$salepersonWarehouseCode;
        				echo"isSupplierPrice($customerID,$itemID,$unitPrice)<br>";
        				$res=isSupplierPrice($customerID,$itemID,$unitPrice);
        				var_dump($res);
        				if(!isSupplierPrice($customerID,$itemID,$unitPrice)){
                            $line->UnitPrice = $unitPrice;
        				}
                        $line->VendorNum = "$documentNumber";
                        $line->CostingCode = $region;
        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $documentNumber;
            $result->DocDate = $orderDate;
            $result->DocDueDate = $deliveryDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->DocumentLines = $resultLines;
            $result->BPL_IDAssignedToInvoice= $companyCode;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportPickAsWaybill($pickID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");



    $stm = $db->prepare("SELECT Orders.order_id,order_code,customer_id,Orders.salesperson_id,date,delivery_method,Pick.pick_id,pick_code,Pick.notes FROM Orders,Pick,Pick_Order WHERE Orders.order_id=Pick_Order.order_id AND Pick.pick_id=Pick_Order.pick_id AND Pick.status='Completed'  AND Pick.pick_id='$pickID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$customerID,$salespersonID,$pickDate,$warehouseID,$pickID,$pickCode,$details);
	while ($stm->fetch()) {
	$docCounter++;
	$documents=array();
	$document="";
	

	$customerCode = getCustomerCode($customerID);
$typeOfBusiness=getTypeOfBusiness($customerID);
$typeOfCustomer=getTypeOfCustomer($customerID);
$registrationCode =getRegistrationCode($customerID);

	$salepersonWarehouseCode=getWarehouseCode($warehouseID);
	if(strcmp($salepersonWarehouseCode,"")==0)
	{
	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	}
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
// 	$date = DateTime::createFromFormat('Y-m-d H:i:s', $pickDate);
// 	$orderDate= $date->format('d/m/Y');

	

// 	$document->DocType=15;
// 	$document->orderCode=$pickCode;
// 	$document->orderDate=$pickDate;
// 	$document->dueDate=$pickDate;
// 	$document->paymentType="CR";
//     $document->customerCode=$customerCode;
//     $document->warehouseCode=253;
//     $document->salespersonCode=-1;
//     $document->details="";
//     $document->subtotal="0";
//     $document->vatAmount="0";
//     $document->grandTotal="0";
//     $document->discountAmount="0";
    
    $document->DocType=15;
	$document->NumAtCard=$pickCode;
	$document->DocDate=$pickDate;
	$document->DocDueDate=$pickDate;
// 	$document->PaymentMethod="CR";
    $document->CardCode=$customerCode;
    $document->warehouseCode=253;
    $document->salespersonCode=-1;
    $document->Comments="$details";
    // $document->subtotal="$subtotal";
    // $document->DocTotal="0";
    // $document->DocTotalSys="0";
    // $document->VatSum="0";
    // $document->VatSumSys="0";
    // $document->TotalDiscount="0";

    



    $lines=array(); 
	
	//EXPORT LINES
	$lineCounter=0;
	$db2 = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db2->set_charset("utf8");
	
			$stm2 = $db2->prepare("SELECT Pick_Item.pick_item_id,item_id,qty,baseentry,baseline,Pick_Item.notes FROM Pick_Item,Pick_Item_SAP WHERE  pick_id='$pickID' AND Pick_Item.pick_item_id=Pick_Item_SAP.pick_item_id AND qty_to_pick>0");
	$stm2-> execute();
	$stm2-> bind_result($pickItemID,$itemID,$qty,$baseentry,$baseline,$freeText);
			while ($stm2->fetch()) {
            	$line="";
			
				$lineCounter=$lineCounter+1;
				$itemCode = getItemCode($itemID);
				$itemCode=urlencode($itemCode);
				$line->itemCode=$itemCode;
				$line->Quantity=$qty;
				$line->Price="0";
                $line->BaseType=17;
                $line->BaseEntry=$baseentry;
				$line->BaseLine=$baseline;
				$line->FreeText=$freeText;
			    array_push($lines,$line);
			    
			    
	
			}
			$stm2-> close();
			
			$document->DocumentLines=$lines;
	}
	$stm-> close();

    return $document;
}

function exportReturn($orderID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");


    $stm = $db->prepare("SELECT return_id,return_code,company_id,customer_id,salesperson_id,paymenttype_id,return_date,subtotal,grand_total,vat_amount,discount_amount,print_count,return_address_id,return_address_id,order_id,vat_i_e,details,status,return_type,timestamp FROM Returns WHERE return_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$details,$status,$returnType,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	
	
	$salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	
	
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
    $region = getWarehouseRegion($salepersonWarehouseCode);	
// 	$numberOFLines = getNumberOFLinesOrder($orderID);
    // $linesSubTotal = getOrderLinesSubTotal($orderID);

	$customerCode = getCustomerCode($customerID);
    $typeOfBusiness=getTypeOfBusiness($customerID);
    $typeOfCustomer=getTypeOfCustomer($customerID);
    $registrationCode =getRegistrationCode($customerID);
	$addressCode= getAddressCode($orderAddressID);
	$delivertyAddressCode=getAddressCode($deliveryAddressID);
	$salesPersonCode = getSalespersonCode($salespersonID);
	
	
	$grandTotal=round($grandTotal,2);
	$discountAmount=round($discountAmount,2);
	$depositAmount=round($depositAmount,2);
	
	
// 	if($paymentTypeID>1)
//         {
//               $paymentType="CH";
//         }
//         else
//         {
//               $paymentType="CR";       
//         }

//         if(strcmp($typeOfCustomer,"Cash")==0)
//         { 
//             $paymentType="CH";     
//         }

//          if(strcmp($registrationCode,"0")==0)
//         { 
//             $paymentType="CH";     
//         }

     
//         if(strcmp($typeOfBusiness,"Cash")==0)
//         { 
//             if($paymentTypeID>1)
//             {
//                  $customerCode=getPaymentTypeCode($paymentTypeID);
//             }
//             else
//             {
//                 $customerCode="321999";
//             }
//             $paymentType="CH";
//             $addressCode=$delivertyAddressCode="";
//             $customerName= getCustomerName($customerID);
//             $details=$details." ".$customerName; 
//         }
	
    // 	$date = DateTime::createFromFormat('Y-m-d', $orderDate);
    // 	$orderDate= $date->format('d/m/Y');
    	
    	
    // 	$date = DateTime::createFromFormat('Y-m-d', $deliveryDate);
    // 	$deliveryDate= $date->format('d/m/Y');
    	
    
        if(true)
        {
        
        
        //     if(strcmp($myfile,'')!=0){fwrite($myfile, "OH\n");}
        // 	$headerText = "$companyCode|$orderCode|$numberOFLines|$printCount|$orderDate|$deliveryDate|$depositAmount|$paymentType|$customerCode|$addressCode|$delivertyAddressCode|$salepersonWarehouseCode|$salesPersonCode||$details|O|Y|EUR|1|Coprime|E|\n";
        // 	$headerText= str_replace("null","",$headerText);
        //     if(strcmp($myfile,'')!=0){fwrite($myfile, $headerText);}
        	
        	
        	
        	
        	
        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");

        	$stm2 = $db2->prepare("SELECT return_item_id,return_id,item_id,qty,batch_number,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,warehouse_id,timestamp FROM Return_Item WHERE return_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$qtyDelivered,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$itemWarehouseID,$timestamp);
        		while ($stm2->fetch()) {
        			    $line="";
        	            if(strcmp($myfile,'')!=0){fwrite($myfile, "RL\n");}
        				$lineCounter=$lineCounter+1;
        				$discount = $lineDiscount+$globalDiscount;
        				
        				$lineTotal=0;
        				$subunits = getSubUnits($itemID);
        				if($subunits==1)
        				{
        				 $lineTotal= $unitPrice*$qty;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				
        				
        				}
        				else
        				{
        					
        				 $units = getUntis($qty,$subunits);
        				 $sub = getSub($qty,$subunits);
        				 $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
        				 $lineTotal=round($lineTotal,2);
        				 $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
        				 
        				 
        				 
        				}
        				
        				$itemCode = getItemCode($itemID);
        				$priceCode = $pricetypeID ;
        				if($pricetypeID>6)
        				{
        					$priceCode ="M";
        				}
        				if($pricetypeID==0)
                                        {
                                                $priceCode ="M";
                                        }
        
                                        if($pricetypeID == 97)
                                        {
                                        	$priceCode ="C";
                                        }
        
        
                                        
                                        if($discount>0)
                                        {
                                        	$priceCode ="%";
                                        }
                                        
                                        
                                        
        				
        				$lineTotal = $lineTotal - $discount;
        				$lineTotal=round($lineTotal,2);
        				
        				$vatTotal =round($vatTotal,2);
        				$discount=round($discount,2);
        				
        			    $itemWarehouseCode = getWarehouseCode($itemWarehouseID);
        			    

        				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
        				$lineText= str_replace("null","",$lineText);
        				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
        				$line->ItemCode=$itemCode;
        				$line->Quantity=$qty;
        				// $line->WarehouseCode='GDLT-YPS';
        				$line->WarehouseCode=$itemWarehouseCode;
        				$line->CostingCode = $region;

        				array_push($resultLines,$line);
        
        				
        	
        			}
        			$stm2-> close();	
                }
            
            $result = "";
            $result->NumAtCard = $orderCode;
            $result->DocDate = $orderDate;
            $result->CardCode = $customerCode;
            $result->Comments = $details;
            $result->SalesPersonCode = $salesPersonCode;
            $result->BPL_IDAssignedToInvoice = $companyCode;
            $result->DocumentLines = $resultLines;
            

    
        }
        $stm-> close();	

    return $result;
}

function exportReceipt($receiptID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");



    $stm = $db->prepare("SELECT receipt_id,receipt_code,customer_id,company_id,salesperson_id,order_id,invoice_id,address_id,amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,receipt_date,notes,status,timestamp FROM Receipts WHERE receipt_id='$receiptID'");
	$stm-> execute();
	$stm-> bind_result($receiptID,$receiptCode,$customerID,$companyID,$salespersonID,$orderID,$invoiceID,$addressID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$receiptDate,$notes,$status,$timestamp);
	while ($stm->fetch()) {
	$docCounter++;
	

	
// 	$companyCode = getCompanyCode($companyID);
//  $registrationCode =getRegistrationCode($customerID);
// 	$addressCode= getAddressCode($orderAddressID);
// 	$salesPersonCode = getSalespersonCode($salespersonID);
    
    $customerCode = getCustomerCode($customerID);
	$salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
	
	
	$amount=round($amount,2);
	$cashDiscount=round($cashDiscount,2);
	
	

    	
    
        if(true)
        {
        
        
            //  if(strcmp($myfile,'')!=0){fwrite($myfile, "OH\n");}
            // 	$headerText = "$companyCode|$orderCode|$numberOFLines|$printCount|$orderDate|$deliveryDate|$depositAmount|$paymentType|$customerCode|$addressCode|$delivertyAddressCode|$salepersonWarehouseCode|$salesPersonCode||$details|O|Y|EUR|1|Coprime|E|\n";
            // 	$headerText= str_replace("null","",$headerText);
            //  if(strcmp($myfile,'')!=0){fwrite($myfile, $headerText);}
        	
        	$result = "";
            $result->DocDate = $receiptDate;
            $result->CardCode = $customerCode;
            $result->Reference1=$receiptCode;
            $result->Reference2=$receiptCode;
            $result->CounterReference=$receiptCode;
            $result->BPLID= $companyCode;
            
           // $result->TotalDiscount = $cashDiscount;
        	

            if(strcmp($paymentMethod,'Cheque')==0)
            {
                $result->CashSum = 0;
                $result->PaymentChecks = array();
                
                $checks = '';
                $checks->DueDate = $chequeDate;
                $checks->CheckNumber = $chequeNumber;
                $checks->BankCode = $bank;
                $checks->Branch = $branch;
                $checks->CheckSum = $amount;
    
                array_push($result->PaymentChecks,$checks);
            }
            else 
            {
                
                $result->CashSum = $amount;
                $result->PaymentChecks = array();

            }
            

    
        }
	}
    $stm-> close();	

    return $result;
}

function exportTransferRequest($requestID,$myfile='') {
global $username;
global $password;
global $database;


$db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");

    $resultLines=array();
    $stm = $db->prepare("SELECT warehouse_transaction_id,warehouse_transaction_code,warehouse_id_from,warehouse_id_to,company_id,salesperson_id,type,transaction_date,details,timestamp FROM Warehouse_Transactions WHERE warehouse_transaction_id='$requestID'");
	$stm-> execute();
	$stm-> bind_result($requestID,$requestCode,$warehouseFromID,$warehouseToID,$companyID,$salespersonID,$type,$requestDate,$details,$timestamp);
	while ($stm->fetch()) {
	    
    	$docCounter++;
    	
    // 	$companyCode = getCompanyCode($companyID);
    //  $registrationCode =getRegistrationCode($customerID);
    // 	$addressCode= getAddressCode($orderAddressID);
    // 	$salesPersonCode = getSalespersonCode($salespersonID);
        
    	$salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
    	
    	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
    	$db2 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno()) 
        {
     	   printf("Connect failed: %s\n", mysqli_connect_error());
     	   exit();
     	}
    	$db2->set_charset("utf8");
    	
        $stm2 = $db2->prepare("SELECT warehouse_transaction_item_id, Warehouse_Transaction_Item.item_id,Items.item_code, batch_number, warehouse_id, qty, serialnumber,Warehouse_Transaction_Item.timestamp FROM Warehouse_Transaction_Item,Items WHERE Warehouse_Transaction_Item.item_id=Items.item_id AND warehouse_transaction_id='$requestID' ORDER BY Items.item_code");
        $stm2-> execute();
        $stm2-> bind_result($wtItemID,$itemID,$itemCode,$batchNumber,$warehouseID,$qty,$serialNumber,$timestamp);
        while ($stm2->fetch()) {
            //$itemCode =getItemCode($itemID);
            $itemWarehouseCode=getWarehouseCode($warehouseToID);
            $region = getWarehouseRegion($itemWarehouseCode);
            $itemFromWarehouseCode=getWarehouseCode($warehouseFromID);
            if(strcmp($itemWarehouseCode,'GDL')==0){$itemWarehouseCode=1;}
            $line = '';
    	    $line->ItemCode=$itemCode;
        	$line->Quantity=$qty;
        	$line->WarehouseCode=$itemWarehouseCode;
        	$line->FromWarehouseCode=$itemFromWarehouseCode;
        	$line->DistributionRule = $region;
        	
        	array_push($resultLines,$line);
        
        }
        $stm2-> close();
            $result->Reference1 = $requestCode;
            $result->DocDate = $requestDate;
            $result->Comments = $details;
            $result->ToWarehouse=$itemWarehouseCode;
        	$result->FromWarehouse=$itemFromWarehouseCode;
        	$result->SalesPersonCode = $salesPersonCode;
            $result->StockTransferLines = $resultLines;
    }
    $stm-> close();	

    return $result;
}

function getCompanyCode($cumpanyID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT company_code FROM Companies WHERE company_id='$cumpanyID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($companyCode);
	while ($stm1->fetch()) {
		return $companyCode;
	 }
	 $stm1->close();
    $stm1->close();
      return $companyCode;
   
    
}

function getCustomerCode($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_code FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getSupplierCode($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_code FROM Suppliers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getAddressCode($addressID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT address_code FROM CustomerAddress WHERE customer_address_id ='$addressID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($addressCode);
	while ($stm1->fetch()) {
		return $addressCode;
	 }
	 $stm1->close();
      return $addressCode;
   
    
}

function getWarehouseCodeOFSalesPerson($salesPersonID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");



$stm1 = $db1->prepare("SELECT default_warehouse_id FROM SalesPersons WHERE salesperson_id='$salesPersonID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($defaultWarehouseID);
	while ($stm1->fetch()) {
		
	 }
	 $stm1->close();
      



	$stm1 = $db1->prepare("SELECT warehouse_code FROM Warehouses WHERE warehouse_id ='$defaultWarehouseID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($warehouseCode);
	while ($stm1->fetch()) {
		return $warehouseCode;
	 }
	 $stm1->close();
      return $warehouseCode;
   
    
}

function getWarehouseCode($whID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");


      

	$stm1 = $db1->prepare("SELECT warehouse_code FROM Warehouses WHERE warehouse_id ='$whID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($warehouseCode);
	while ($stm1->fetch()) {
		return $warehouseCode;
	 }
	 $stm1->close();
      return $warehouseCode;
   
    
}

function getWarehouseCompany($warehouseCode) {
    global $username;
    global $password;
    global $database;
	
    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");


      
    $companyID=1;
	$stm1 = $db1->prepare("SELECT company_id FROM Warehouses WHERE warehouse_code ='$warehouseCode' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($id);
	while ($stm1->fetch()) {
		if($id > 0){
		  $companyID = $id;
		}
	}
	$stm1->close();
    
    $stm1 = $db1->prepare("SELECT company_code FROM Companies WHERE company_id ='$companyID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($companyCode);
	while ($stm1->fetch()) {}
	$stm1->close();
	
	if(strcmp($companyCode,'GDL')==0){$companyCode=1;}
     
    return $companyCode;
   
    
}

function getSalespersonCode($salesPersonID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT salesperson_code FROM SalesPersons WHERE salesperson_id='$salesPersonID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($salespersonCode);
	while ($stm1->fetch()) {
		return $salespersonCode;
	 }
	 $stm1->close();
      return $salespersonCode;
   
    
}

function getSubUnits($itemID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT subunits FROM Items WHERE item_id='$itemID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($sub);
	while ($stm1->fetch()) {
		return $sub;
	 }
	 $stm1->close();
      return $sub;
   
    
}

function getVatPercentage($vatID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT percentage FROM Vats WHERE vat_id='$vatID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($percentage);
	while ($stm1->fetch()) {
		return $percentage;
	 }
	 $stm1->close();
      return $percentage;
   
    
}

function getUntis($qty,$subunits){

	return ((int) ($qty/$subunits));

}

function getSub($qty,$subunits){

	return  $qty % $subunits;

}

function getItemCode($itemID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT item_code FROM Items WHERE item_id='$itemID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($code);
	while ($stm1->fetch()) {
		return $code;
	 }
	 $stm1->close();
      return $code;
   
    
}

function getTypeOfBusiness($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT type_of_business FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getSupplierTypeOfBusiness($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT type_of_business FROM Suppliers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getTypeOfSupplier($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_type FROM Suppliers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getTypeOfCustomer($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_type FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getCustomerName($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT customer_company_name FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getPaymentTypeCode($paymentTypeID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT paymenttype_code FROM PaymentTypes WHERE paymenttype_id ='$paymentTypeID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getRegistrationCode($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT registration_code FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}

function getSupplierRegistrationCode($customerID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT registration_code FROM Customers WHERE customer_id ='$customerID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($customerCode);
	while ($stm1->fetch()) {
		return $customerCode;
	 }
	 $stm1->close();
      return $customerCode;
   
    
}


function isSupplierPrice($customerID,$itemID,$price) {
global $username;
global $password;
global $database;
	$result=false;
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(*) FROM Item_Supplier WHERE (supplier_id ='$customerID') AND item_id='$itemID' AND price='$price'");
	$stm1-> execute();
	$stm1-> bind_result($resultCount);
	while ($stm1->fetch()) {
	    if($resultCount>=1)
	    {
	        $result=true;
	    }
	    
	 }
	 $stm1->close();

 return $result;
   
    
}

function getOrderLinesSubTotal($orderID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT SUM(ROUND(unit_price*qty/subunits,2)) FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND order_id='$orderID'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		return $counter;
	 }
	 $stm1->close();
      return $counter;
   
    
}

function getShipment($orderID)
{
 
  require("dbinfo.php");
 $competitorPriceResult="No_City";
    $db = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	 $db->set_charset("utf8");
$stm = $db->prepare("SELECT value FROM ZA_Custom_Field_Object,ZA_Custom_Form_Object  WHERE ZA_Custom_Form_Object.linked_table_id='$orderID' AND  ZA_Custom_Field_Object.custom_form_object_id = ZA_Custom_Form_Object.custom_form_object_id AND custom_field_id=1");
	$stm-> execute();
	$stm-> bind_result($competitorPrice);
	while ($stm->fetch()) {
	    if(strcmp($competitorPrice,'')!=0){
	        $competitorPriceResult = $competitorPrice;
	    }
	}
		$stm-> close();	

   return $competitorPriceResult;
    
}

function setOrderStatus($status,$orderID)
{
    global $username;
global $password;
global $database;

    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("UPDATE Orders SET status =? WHERE order_id=?");
	$stm1-> execute();
	  $stm1->bind_param('si',$status,$orderID);
    $stm1->execute();
    $stm1->close();
    
}

function getNumberOFLinesOrder($orderID) {
global $username;
global $password;
global $database;
	
    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT COUNT(order_item_id) FROM Order_Item WHERE order_id='$orderID'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {
		return $counter;
	 }
	 $stm1->close();
      return $counter;
   
    
}


function setTenderID($orderID)
{
global $username;
global $password;
global $database;
	$tenderID=1;

    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("UPDATE Orders SET tender_id =? WHERE order_id=?");
	$stm1-> execute();
	  $stm1->bind_param('ii',$tenderID,$orderID);
    $stm1->execute();
    $stm1->close();
      

}

function setCompanyID($pickID)
{
global $username;
global $password;
global $database;
	$tenderID=1;

    	$db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("UPDATE Pick SET company_id =? WHERE pick_id=?");
	$stm1-> execute();
	  $stm1->bind_param('ii',$tenderID,$pickID);
    $stm1->execute();
    $stm1->close();
      

}

function isZeroQtyPick($pickID){
    global $username;
    global $password;
    global $database;
	
    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT SUM(qty) FROM Pick_Item WHERE pick_id='$pickID'");
	$stm1-> execute();
	$stm1-> bind_result($counter);
	while ($stm1->fetch()) {}
	$stm1->close();
	
	if($counter > 0){
	   return false;
	} else {
	   return true;
	}
}

function getMaxLineNumberOfDocument($orderID){
    global $username;
    global $password;
    global $database;
	
    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");
    $lineNumbers=array();
	$stm1 = $db1->prepare("SELECT description FROM Purchase_Order_Item WHERE order_id='$orderID'");
	$stm1-> execute();
	$stm1-> bind_result($description);
	while ($stm1->fetch()) {
		$lineNumber = explode('|LineNum|',$description)[1];
		$lineNumber = intval(trim($lineNumber));
		array_push($lineNumbers,$lineNumber);
		
	 }
	$stm1->close();
	

    return max($lineNumbers);
}

function getBaseLineNumberFromPO($orderItemID){
    global $username;
    global $password;
    global $database;
	
    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT description FROM Purchase_Order_Item WHERE order_item_id='$orderItemID' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($description);
	while ($stm1->fetch()) {
		$lineNumber = explode('|LineNum|',$description)[1];
		$lineNumber = intval(trim($lineNumber));
	 }
	$stm1->close();

    return intval($lineNumber);
}

function exportGRNDraft($orderID,$myfile='') {
    global $username;
    global $password;
    global $database;
    
    
    $db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");

    $stm = $db->prepare("SELECT tender_id,details,shipping_company FROM Purchase_Order_GRN,Purchase_Orders WHERE Purchase_Order_GRN.order_id=Purchase_Orders.order_id AND waybill_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($sapDocEntry,$order_notes,$shippingCompany);
	while ($stm->fetch()) {}
	$stm-> close();
	
	$sapDocEntry = intval($sapDocEntry);

    $stm = $db->prepare("SELECT waybill_id,waybill_code,company_id,customer_id,salesperson_id,paymenttype_id,waybill_date,subtotal,grand_total,vat_amount,discount_amount,print_count,waybill_address_id,delivery_address_id,tender_id,vat_i_e,waybill_date,details,status,document_number,document_date,timestamp FROM GRNs WHERE waybill_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$details,$status,$documentNumber,$documentDate,$timestamp);
	while ($stm->fetch()) {
	    $docCounter++;
	
        if(true){
            
            $maxLineNumber=getMaxLineNumberOfDocument(intval($linkedPO));

        	
        	$resultLines=array();
        	
        	//EXPORT LINES
        	$lineCounter=0;
        	$db2 = new mysqli(localhost,$username,$password,$database);
        	 if (mysqli_connect_errno()) 
         	{
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	 $db2->set_charset("utf8");
        	$baseline = 0;
        	$stm2 = $db2->prepare("SELECT waybill_item_id,waybill_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,batch_number,timestamp,cost FROM GRN_Item WHERE waybill_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$batchNumberBinLocation,$timestamp,$cost);
            while ($stm2->fetch()) {
            
            
                $batchNumberBinLocationExplode = explode(';BIN;',$batchNumberBinLocation);
                $batchNumber = $batchNumberBinLocationExplode[0];
                $binLocation = $batchNumberBinLocationExplode[1];
                
                $line="";
                if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
                $lineCounter=$lineCounter+1;
                $discount = $lineDiscount+$globalDiscount;
                
                $lineTotal=0;
                $subunits = getSubUnits($itemID);
                if($subunits==1){
                    $lineTotal= $unitPrice*$qty;
                    $lineTotal=round($lineTotal,2);
                    $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
                }
                else{
                
                    $units = getUntis($qty,$subunits);
                    $sub = getSub($qty,$subunits);
                    $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
                    $lineTotal=round($lineTotal,2);
                    $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
       
                }
                
                $itemCode = getItemCode($itemID);
                
                $priceCode = $pricetypeID ;
                if($pricetypeID>6){
                    $priceCode ="M";
                }
                
                if($pricetypeID==0){
                    $priceCode ="M";
                }
                
                if($pricetypeID == 97){
                    $priceCode ="C";
                }
                
                if($discount>0){
                    $priceCode ="%";
                }
                
                
                $lineTotal = $lineTotal - $discount;
                $lineTotal=round($lineTotal,2);
                
                $vatTotal =round($vatTotal,2);
                $discount=round($discount,2);
                
                $lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
                $lineText= str_replace("null","",$lineText);
                if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}
                
                $line->ItemCode=$itemCode;
                $line->Quantity=$qty;
                
                $line->VendorNum = "$documentNumber";
                $line->BatchNumbers=array();
                $line->DocumentLinesBinAllocations = array();
                
                if($cost==0){
                    $maxLineNumber++;
                    $baseline=$maxLineNumber;
                }
                else{
                    $baseline = getBaseLineNumberFromPO($cost);
                }
                
                if(strcmp("$sapDocEntry","")!=0 && $sapDocEntry > 0){
                
                    $line->BaseEntry = $sapDocEntry;
                    $line->BaseLine = $baseline;
                    $line->BaseType = 22;
                
                }
                
                if(strcmp($batchNumber,'0')!=0 && strcmp(trim($batchNumber),'')!=0){
                    $InventoryCountingBatchNumber = new stdClass();
                    $InventoryCountingBatchNumber->BatchNumber=$batchNumber;
                    $InventoryCountingBatchNumber->Quantity=$qty;
                    array_push($line->BatchNumbers,$InventoryCountingBatchNumber);
                }
                
                
                if(strcmp($binLocation,'0')!=0 && strcmp(trim($binLocation),'')!=0){
                    $binAllocation = new stdClass();
                    $binAllocation->BinAbsEntry = getBinLocationAbsEntry("$binLocation");
                    $binAllocation->Quantity = $qty;
                    array_push($line->DocumentLinesBinAllocations,$binAllocation);
                }
                
                
                array_push($resultLines,$line);
                
                
                
            }
            $stm2-> close();	
        }
                
        $customerCode = getSupplierCode($customerID);
        
        
        $result = "";
        $result->NumAtCard = $documentNumber;
        $result->CardCode = $customerCode;
        
        $result->DocDate = $orderDate;
        
        $result->DocDueDate = $deliveryDate;
        
        $result->DocumentLines = $resultLines;
        
        
        $result->DocObjectCode= "oPurchaseDeliveryNotes";
        
        $result->DocumentAdditionalExpenses=$shippingCompany;
        
        
        
    }
    $stm-> close();	

    return $result;
}

function exportGRNwithBatch($orderID,$myfile='') {
    global $username,$password,$database;

    $db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db->set_charset("utf8");
	
	$stm = $db->prepare("SELECT Purchase_Orders.order_id,Purchase_Orders.tender_id,Purchase_Orders.delivery_method FROM Purchase_Order_GRN,Purchase_Orders WHERE Purchase_Order_GRN.order_id = Purchase_Orders.order_id AND Purchase_Order_GRN.waybill_id='$orderID' LIMIT 1");
	$stm-> execute();
	$stm-> bind_result($linkedPO,$linkedPO_id,$deliveryMethod);
	while ($stm->fetch()) {}
	$stm-> close();

    $stm = $db->prepare("SELECT waybill_id,waybill_code,company_id,customer_id,salesperson_id,paymenttype_id,waybill_date,subtotal,grand_total,vat_amount,discount_amount,print_count,waybill_address_id,delivery_address_id,tender_id,vat_i_e,waybill_date,details,status,document_number,timestamp FROM GRNs WHERE waybill_id='$orderID'");
	$stm-> execute();
	$stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$details,$status,$documentNumber,$timestamp);
	while ($stm->fetch()) {
    	$docCounter++;
    	
    	$salepersonWarehouseCode = getWarehouseCode($deliveryMethod);
    	if(strcmp($salepersonWarehouseCode,'')==0 || strcmp($deliveryMethod,'Not Set')==0){
    	    $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);
    	}
    	
    	$companyCode = getWarehouseCompany($salepersonWarehouseCode);
    	$customerCode = getSupplierCode($customerID);
        $typeOfBusiness=getSupplierTypeOfBusiness($customerID);
        $typeOfCustomer=getTypeOfSupplier($customerID);
        $registrationCode =getSupplierRegistrationCode($customerID);
    	$addressCode= getAddressCode($orderAddressID);
    	$delivertyAddressCode=getAddressCode($deliveryAddressID);
    	$salesPersonCode = getSalespersonCode($salespersonID);
    	
    	$grandTotal=round($grandTotal,2);
    	$discountAmount=round($discountAmount,2);
    	$depositAmount=round($depositAmount,2);
    // 	$region = getWarehouseRegion($salepersonWarehouseCode);
    	
        if(true){
    	
        	$resultLines=array();
        	$lineCounter=0;
        	
        	$db2 = new mysqli('localhost',$username,$password,$database);
        	if (mysqli_connect_errno()) {
           	   printf("Connect failed: %s\n", mysqli_connect_error());
           	   exit();
         	}
        	$db2->set_charset("utf8");
        	
        	$stm2 = $db2->prepare("SELECT waybill_item_id,waybill_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,batch_number,timestamp FROM GRN_Item WHERE waybill_id='$orderID' ");
        	$stm2-> execute();
        	$stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$batchNumberBinLocation,$timestamp);
        	while ($stm2->fetch()) {
    	    
	            if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
	            
				$lineCounter++;
				$discount = $lineDiscount+$globalDiscount;
				
				$lineTotal=0;
				$subunits = getSubUnits($itemID);
				
				if($subunits==1){
				    $lineTotal= $unitPrice*$qty;
				    $lineTotal=round($lineTotal,2);
				    $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
				} else {
				    $units = getUntis($qty,$subunits);
				    $sub = getSub($qty,$subunits);
				    $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
				    $lineTotal=round($lineTotal,2);
				    $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
				}
				
				$itemCode = getItemCode($itemID);
				$priceCode = $pricetypeID ;
				
				if($pricetypeID>6){$priceCode ="M";}
				if($pricetypeID==0){$priceCode ="M";}
                if($pricetypeID == 97){$priceCode ="C";}
                if($discount>0){$priceCode ="%";}

				$lineTotal = $lineTotal - $discount;
				$lineTotal=round($lineTotal,2);
				
				$vatTotal =round($vatTotal,2);
				$discount=round($discount,2);
				
				$lineText= "$companyCode|$orderCode|$lineCounter|$qty|$qtyDelivered|||$lineTotal|$lineDiscount|$globalDiscount|$vatTotal|0|$itemCode|$description|$priceCode|| \n";
				$lineText= str_replace("null","",$lineText);
				if(strcmp($myfile,'')!=0){fwrite($myfile, $lineText);}

                if(!is_array($resultLines["$itemID"])){$resultLines["$itemID"] = array();}
                
                if(!isset($resultLines["$itemID"]['baseLineCounter'])){$resultLines["$itemID"]['baseLineCounter'] = 0;}
                $resultLines["$itemID"]['baseLineCounter']++;

                $line=new stdClass();
				$line->ItemCode=$itemCode;
				$line->Quantity = $qty;
				$line->WarehouseCode=$salepersonWarehouseCode;
				$res=isSupplierPrice($customerID,$itemID,$unitPrice);
                $line->VendorNum = "$documentNumber";
                // if(!isSupplierPrice($customerID,$itemID,$unitPrice)){$line->UnitPrice = $unitPrice;}
                
                $resultLines["$itemID"]["Item"]=$line;
                $resultLines["$itemID"]["Quantity"] += $qty;
                $resultLines["$itemID"]["coprimeItemID"] = $itemID;

                
                $batchNumberBinLocationExplode = explode(';BIN;',$batchNumberBinLocation);
                $batchNumber = $batchNumberBinLocationExplode[0];
                $binLocation = $batchNumberBinLocationExplode[1];
                
                if(strcmp(trim("$batchNumber"),"0")==0){$batchNumber="";}
                
                $serialNumber = new stdClass();
                $serialNumber->InternalSerialNumber = $batchNumber;
                $serialNumber->Quantity = $qty;
                
                if(!is_array($resultLines["$itemID"]["SerialNumbers"])){$resultLines["$itemID"]["SerialNumbers"] = array();}
                
                if(strcmp(trim("$serialNumber->InternalSerialNumber"),"")!=0){
				    array_push($resultLines["$itemID"]["SerialNumbers"],$serialNumber);
				}
                
                $binAllocation = new stdClass();
                $binAllocation->BinAbsEntry = getBinLocationAbsEntry("$binLocation");
                $binAllocation->Quantity = $qty;
                
                if(strcmp(trim("$serialNumber->InternalSerialNumber"),"")!=0){
                    $binAllocation->SerialAndBatchNumbersBaseLine = $resultLines["$itemID"]['baseLineCounter']-1;
                }
				
				if(!is_array($resultLines["$itemID"]["DocumentLinesBinAllocations"])){$resultLines["$itemID"]["DocumentLinesBinAllocations"] = array();}
				
				if(intval($binAllocation->BinAbsEntry) > 0){
				    array_push($resultLines["$itemID"]["DocumentLinesBinAllocations"],$binAllocation);
				}
			
	
    		}
    		$stm2-> close();	
        }
        
        $grnItems = array();
        $baseLineCounter = 0;
        foreach($resultLines as $line){
            $grnItem = new stdClass();
            $grnItem = $line["Item"];
            $grnItem->BaseType = 22;
            $grnItem->BaseEntry = intval($linkedPO_id);
            $grnItem->BaseLine = getBaseLineNumberFromPO(intval($linkedPO),intval($line["coprimeItemID"]));
            $grnItem->CostingCode = "1030";
            $grnItem->Quantity = $line["Quantity"];
            $grnItem->SerialNumbers = $line["SerialNumbers"];
            $grnItem->DocumentLinesBinAllocations = $line["DocumentLinesBinAllocations"];
            array_push($grnItems,$grnItem);
            $baseLineCounter++;
        }
        
        $result = new stdClass();
        $result->NumAtCard = $orderCode." - ".$documentNumber;
        $result->DocDate = $orderDate;
        $result->DocDueDate = $deliveryDate;
        $result->CardCode = $customerCode;
        $result->Comments = $details;
        $result->Reference2 = "$orderCode";
        $result->SalesPersonCode = '-1';
        $result->DocumentLines = $grnItems;
        $result->BPL_IDAssignedToInvoice= $companyCode;
        


    }
    $stm-> close();	

    return $result;
}


function getBinLocationAbsEntry($binLocation) {
    
    if(strcmp(trim("$binLocation"),"")==0){return 0;}
    
    global $username;
    global $password;
    global $database;
	
    $db1 = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) {
    		printf("Connect failed: %s\n", mysqli_connect_error());
    		exit();
	}
 	$db1->set_charset("utf8");

	$stm1 = $db1->prepare("SELECT attribute5 FROM Warehouse_BinLocations WHERE bin_location_code='$binLocation' LIMIT 1");
	$stm1-> execute();
	$stm1-> bind_result($code);
	while ($stm1->fetch()) {
	    if(strcmp(trim("$binLocation"),"")!=0){
		    return $code;
	    }
	 }
	 $stm1->close();
	 
     return 0;
   
    
}

function exportInvoice($orderID,$myfile='') {
    global $username;
    global $password;
    global $database;


    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");


    $stm = $db->prepare("SELECT invoice_id,invoice_code,company_id,customer_id,salesperson_id,invoice_date,subtotal,grand_total,vat_amount,discount_amount,print_count,due_date,details,status,timestamp FROM Invoices WHERE invoice_id='$orderID'");
    $stm-> execute();
    $stm-> bind_result($orderID,$orderCode,$companyID,$customerID,$salespersonID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$deliveryDate,$details,$status,$timestamp);
    while ($stm->fetch()) {
        $salepersonWarehouseCode = getWarehouseCodeOFSalesPerson($salespersonID);

//        $companyCode = getCompanyCode($companyID);
//        $numberOFLines = getNumberOFLinesOrder($orderID);
//        $linesSubTotal = getOrderLinesSubTotal($orderID);
//        $typeOfBusiness=getTypeOfBusiness($customerID);
//        $typeOfCustomer=getTypeOfCustomer($customerID);
//        $registrationCode =getRegistrationCode($customerID);
        $customerCode = getCustomerCode($customerID);
        $salesPersonCode = getSalespersonCode($salespersonID);

        $grandTotal=round($grandTotal,2);
        $discountAmount=round($discountAmount,2);
        $depositAmount=round($depositAmount,2);


//         if($paymentTypeID>1) {$paymentType="CH";}
//         else {$paymentType="CR";}
//
//         if(strcmp($typeOfCustomer,"Cash")==0) {$paymentType="CH";}
//         if(strcmp($registrationCode,"0")==0) {$paymentType="CH";}
//
//         if(strcmp($typeOfBusiness,"Cash")==0) {
//             if($paymentTypeID>1) {
//                  $customerCode=getPaymentTypeCode($paymentTypeID);
//             } else {
//                 $customerCode="321999";
//             }
//             $paymentType="CH";
//             $addressCode=$delivertyAddressCode="";
//             $customerName= getCustomerName($customerID);
//             $details=$details." ".$customerName;
//        }
//
//        $date = DateTime::createFromFormat('Y-m-d', $orderDate);
//        $orderDate= $date->format('d/m/Y');
//
//        $date = DateTime::createFromFormat('Y-m-d', $deliveryDate);
//        $deliveryDate= $date->format('d/m/Y');


        if(true) {

            $resultLines=array();
            $lineCounter=0;

            $stm2 = $db2->prepare("SELECT invoice_item_id,invoice_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,description,timestamp FROM Invoice_Item WHERE invoice_id='$orderID' ");
            $stm2-> execute();
            $stm2-> bind_result($orderItemID,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$vatAmount,$pricetypeID,$vatID,$description,$timestamp);
            while ($stm2->fetch()) {
                $line="";
                if(strcmp($myfile,'')!=0){fwrite($myfile, "OL\n");}
                $lineCounter=$lineCounter+1;
                $discount = $lineDiscount+$globalDiscount;

                $lineTotal=0;
                $subunits = getSubUnits($itemID);
                if($subunits==1) {
                    $lineTotal= $unitPrice*$qty;
                    $lineTotal=round($lineTotal,2);
                    $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
                } else {
                    $units = getUntis($qty,$subunits);
                    $sub = getSub($qty,$subunits);
                    $lineTotal = $unitPrice*$units+ $unitPrice*$sub/$subunits;
                    $lineTotal=round($lineTotal,2);
                    $vatTotal = ($lineTotal-$discount)*getVatPercentage($vatID)/100;
                }

                $itemCode = getItemCode($itemID);
                $priceCode = $pricetypeID ;

                if($pricetypeID>6) {$priceCode ="M";}
                if($pricetypeID==0) {$priceCode ="M";}
                if($pricetypeID == 97) {$priceCode ="C";}
                if($discount>0) {$priceCode ="%";}

                $lineTotal = $lineTotal - $discount;
//                $lineTotal=round($lineTotal,2);

                $vatTotal =round($vatTotal,2);
                $discount=round($discount,2);

                $line->ItemCode=$itemCode;
                $line->Quantity=$qty;
                $line->WarehouseCode=$salepersonWarehouseCode;

                if($pricetypeID==99||$pricetypeID==98||$discount>0) {
                    $line->UnitPrice=$lineTotal/$qty;
                }


                $line->FreeText = $description;

                array_push($resultLines,$line);



            }
            $stm2-> close();
        }

        $result = new stdClass();
        $result->NumAtCard = $orderCode;
        $result->DocDate = $orderDate;
        // $result->DocDueDate = $deliveryDate;
        $result->CardCode = $customerCode;
        $result->Comments = $details;
        $result->SalesPersonCode = $salesPersonCode;
        $result->DocTotal=$grandTotal;
        $result->DocumentLines = $resultLines;

    }
    $stm-> close();

    return $result;
}


function getPdfFromID($pathToRoot,$filePrefix,$table,$idColumn,$idValue,$codeColumn){
    global $username;
    global $password;
    global $database;

    $result = '';

    $db9 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db9->set_charset("utf8");
    $stm9 = $db9->prepare("SELECT $codeColumn FROM $table WHERE $idColumn='$idValue'");
    $stm9-> execute();
    $stm9-> bind_result($code);
    while ($stm9->fetch()) {

        if(file_exists($pathToRoot."cop/media/pdfs/invoices/$filePrefix$code.pdf")) {
            $result = $pathToRoot."cop/media/pdfs/invoices/$filePrefix$code.pdf";
        } else if(file_exists($pathToRoot."backend/pdfs/invoices/$filePrefix$code.pdf")){
            $result = $pathToRoot."backend/pdfs/invoices/$filePrefix$code.pdf";
        }


    }
    $stm9->close();

    return $result;
}


function getTransferFromRequestChanges($wtID){

    $result = new stdClass();
    $result->request = '';
    $result->transfer = '';
    $result->lines = array();
    $wtID = intval($wtID);

    if($wtID == 0){return $result;}

    global $username, $password, $database;
    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $wtDetailsRequestDoc = '';
    $stm1 = $db1->prepare("SELECT warehouse_transaction_code,details FROM Warehouse_Transactions WHERE warehouse_transaction_id='$wtID' AND type='Transfer' AND details LIKE '%From Request%' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($wtCode,$wtDetails);
    while ($stm1->fetch()) {
        $wtDetailsRequestDoc = explode(':',"$wtDetails")[0];
        $wtDetailsRequestDoc = str_replace('From Request','',$wtDetailsRequestDoc);
        $wtDetailsRequestDoc = trim("$wtDetailsRequestDoc");
    }
    $stm1->close();

    $result->transfer = "$wtCode";


    if(strcmp("$wtDetailsRequestDoc","")==0){return $result;}

    $result->request = "$wtDetailsRequestDoc";

    $stm1 = $db1->prepare("SELECT warehouse_transaction_id FROM Warehouse_Transactions WHERE warehouse_transaction_code = '$wtDetailsRequestDoc' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($wtRequestID);
    while ($stm1->fetch()) {}
    $stm1->close();

    $wtRequestID = intval($wtRequestID);

    if($wtRequestID == 0){return $result;}

    $requestedItems = array();
    $stm1 = $db1->prepare("SELECT warehouse_transaction_item_id, item_id, batch_number, warehouse_id, qty, serialnumber, timestamp FROM Warehouse_Transaction_Item WHERE warehouse_transaction_id = '$wtRequestID'");
    $stm1-> execute();
    $stm1-> bind_result($wtItemID,$itemID,$batchNumber,$warehouseID,$qty,$serialNumber,$timestamp);
    while ($stm1->fetch()) {

        $itemCode = getItemCode($itemID);
        $requestedItems["$itemID"]['code'] = "$itemCode";
        $requestedItems["$itemID"]['status'] = 'Removed';
        $requestedItems["$itemID"]['requested'] += $qty;
        $requestedItems["$itemID"]['transfered'] = 0;


    }
    $stm1->close();

    $transferedItems = array();
    $stm1 = $db1->prepare("SELECT warehouse_transaction_item_id, item_id, batch_number, warehouse_id, qty, serialnumber, timestamp FROM Warehouse_Transaction_Item WHERE warehouse_transaction_id = '$wtID'");
    $stm1-> execute();
    $stm1-> bind_result($wtItemID,$itemID,$batchNumber,$warehouseID,$qty,$serialNumber,$timestamp);
    while ($stm1->fetch()) {

        $requestedQty = floatval($requestedItems["$itemID"]['requested']);

        $itemCode = getItemCode($itemID);
        $requestedItems["$itemID"]['code'] = "$itemCode";

        if($qty == 0){
            $requestedItems["$itemID"]['status'] = 'Removed';
        } else if($requestedQty == 0){
            $requestedItems["$itemID"]['status'] = 'Added';
            $requestedItems["$itemID"]['requested'] = $requestedQty;
        } else if($requestedQty == $qty){
            $requestedItems["$itemID"]['status'] = 'Transfered';
        } else if($requestedQty > $qty){
            $requestedItems["$itemID"]['status'] = 'Partially Transfered';
        } else if($requestedQty < $qty){
            $requestedItems["$itemID"]['status'] = 'Over Transfered';
        }

        $requestedItems["$itemID"]['transfered'] = $qty;

    }
    $stm1->close();

    foreach($requestedItems as $itemID => $requested){
        if(strcmp($requested['status'],'Transfered')==0){
            unset($requestedItems["$itemID"]);
        }
    }


    $result->lines = $requestedItems;


    return $result;
}

function getBankCodeFromName($bankName) {
    global $username;
    global $password;
    global $database;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT code FROM Banks WHERE name LIKE '$bankName' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($code);
    while ($stm1->fetch()) {
        return $code;
    }
    $stm1->close();
    return "$code";
}

function exportPickUpdates($pickID,$myfile='') {
    global $username,$password,$database;

    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stm = $db->prepare("SELECT Orders.order_id,order_code,customer_id,Orders.salesperson_id,date,delivery_method,Pick.pick_id,pick_code,Pick.notes,Orders.tender_id FROM Orders,Pick,Pick_Order WHERE Orders.order_id=Pick_Order.order_id AND Pick.pick_id=Pick_Order.pick_id AND Pick.pick_id='$pickID'");
    $stm-> execute();
    $stm-> bind_result($orderID,$orderCode,$customerID,$salespersonID,$pickDate,$warehouseID,$pickID,$pickCode,$details,$tenderID);
    while ($stm->fetch()) {

        $document= new stdClass();

        $resultLines=array();

        $lineCounter=0;
        $db2 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");
        $prevItemID = 0;
        $stm2 = $db2->prepare("SELECT pick_item_id,item_id,qty,notes,batch_number,replaced_reason FROM Pick_Item WHERE  pick_id='$pickID' ");
        $stm2-> execute();
        $stm2-> bind_result($pickItemID,$itemID,$qty,$freeText,$batchNumberBinLocation,$replacementCheck);
        while ($stm2->fetch()) {

            if(strcmp(strtolower("$replacementCheck"),strtolower("Split Pick Item"))==0){continue;}

            $itemCode = getItemCode($itemID);


            if(!is_array($resultLines["$itemID"])){$resultLines["$itemID"] = array();}

            if(!isset($resultLines["$itemID"]['baseLineCounter'])){$resultLines["$itemID"]['baseLineCounter'] = 0;}
            if($prevItemID != $itemID){
                $resultLines["$itemID"]['baseLineCounter']++;
                $lineCounter++;
                $prevItemID = $itemID;
            }

            $line=new stdClass();
            $line->AbsoluteEntry = $tenderID;
            $sapLineNumber = getBaseLineNumberFromOrder($orderID,$itemID);
            $line->LineNumber = $lineCounter -1;
            if($sapLineNumber == -1){
                $line->OrderRowID = $sapLineNumber;
            }


            $resultLines["$itemID"]["Item"]=$line;
            $resultLines["$itemID"]["Quantity"] += $qty;



            $batchNumberBinLocationExplode = explode(';BIN;',$batchNumberBinLocation);
            $batchNumber = $batchNumberBinLocationExplode[0];
            $binLocation = $batchNumberBinLocationExplode[1];

            if(strcmp(trim("$batchNumber"),"0")==0){$batchNumber="";}


            $serialNumber = new stdClass();
            $serialNumber->InternalSerialNumber = $batchNumber;
            $serialNumber->Quantity = $qty;
            $serialNumber->BaseLineNumber = $lineCounter -1;
            $serialNumber->ItemCode = $itemCode;


            if(!is_array($resultLines["$itemID"]["SerialNumbers"])){$resultLines["$itemID"]["SerialNumbers"] = array();}
            if(!is_array($resultLines["$itemID"]["DocumentLinesBinAllocations"])){$resultLines["$itemID"]["DocumentLinesBinAllocations"] = array();$SerialAndBatchNumbersBaseLine=0;}

            if(strcmp(trim("$serialNumber->InternalSerialNumber"),"")!=0){
                array_push($resultLines["$itemID"]["SerialNumbers"],$serialNumber);
            }

            $binAllocation = new stdClass();
            $binAllocation->BinAbsEntry = getBinLocationAbsEntry("$binLocation");
            $binAllocation->Quantity = $qty;
            $binAllocation->BaseLineNumber = $lineCounter -1;
            $binAllocation->AllowNegativeQuantity = "tNO";

            if(strcmp(trim("$serialNumber->InternalSerialNumber"),"")!=0){
                $binAllocation->SerialAndBatchNumbersBaseLine = $SerialAndBatchNumbersBaseLine;
            } else {
                $binAllocation->SerialAndBatchNumbersBaseLine = -1;
            }



            if(intval($binAllocation->BinAbsEntry) > 0){
                array_push($resultLines["$itemID"]["DocumentLinesBinAllocations"],$binAllocation);
                $SerialAndBatchNumbersBaseLine++;
            }



        }
        $stm2-> close();

        $pickItems = array();
        foreach($resultLines as $line){
            $pickItem = new stdClass();
            $pickItem = $line["Item"];
            $pickItem->PickedQuantity = $line["Quantity"];
            $pickItem->SerialNumbers = $line["SerialNumbers"];
            $pickItem->BatchNumbers = array();
            if(intval($pickItem->PickedQuantity) > 0){
                $pickItem->DocumentLinesBinAllocations = $line["DocumentLinesBinAllocations"];
            }
            array_push($pickItems,$pickItem);


        }

        $document->PickListsLines=$pickItems;
    }
    $stm-> close();

    return $document;
}
?>