<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

require_once('dbinfo.php');
include_once("exportFunctions.php");

require_once('SAPClient.php');
require_once('SAPClientPreferences.php');
require_once('importFunctions.php');

$client = new SAPClient($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB);
$client->startConnection();
$dateFilter = date('Y-m-d', strtotime("-1 days"));
$dateFilter='';

exportPicksAsWaybills($client,$dateFilter);

function exportPicksAsWaybills($client,$today)
{   
    global $username;
    global $password;
    global $database;

    echo "<br><b>---PICKS---</b><br>";

    $db11 = new mysqli(localhost,$username,$password,$database);
	 if (mysqli_connect_errno()) 
 	{
   	   printf("Connect failed: %s\n", mysqli_connect_error());
   	   exit();
 	}
	$db11->set_charset("utf8");
	$stm11 = $db11->prepare("SELECT Orders.order_id,order_code,customer_id,Orders.salesperson_id,date,delivery_method,Pick.pick_id,pick_code FROM Orders,Pick,Pick_Order WHERE Orders.order_id=Pick_Order.order_id AND Pick.pick_id=Pick_Order.pick_id AND Pick.status='Completed' AND Pick.company_id=0 AND Pick.pick_id NOT IN (SELECT id FROM Documents_Status WHERE type='15')");
	$stm11-> execute();
	$stm11-> bind_result($orderID,$orderCode,$customerID,$salespersonID,$pickDate,$warehouseID,$pickID,$pickCode);
	while ($stm11->fetch()) {
	    
	    echo "PICK $pickID";
	    
	    $isZeroPick = isZeroQtyPick($pickID);
	    
	    if($isZeroPick){
	        
	        $type   = 15;
	        $status = 1;
            $reason = "OK (Cancelled by App)";
            
	        insertDocumentStatuses($pickID,$type,$status,$reason);
	        setCompanyID($pickID);
	        
	    } else {
            $postData = exportPickAsWaybill($pickID,'');
            echo "<pre>";
                
            var_dump($postData);
            $result = $client->postData("DeliveryNotes",$postData);
            var_dump($result);
            
            echo "</pre><br>";
            
            $type = 15;
    
            $status = $result["error"]["code"];
            $reason = $result["error"]["message"]["value"];
            
            if(strcmp($status,'')==0 && strcmp($result["DocNum"],'')!=0){
                $status = 1;
                $reason = "OK ".$result["DocNum"];
            }
            
            if(strcmp($status,'')==0){
                $status = -1;
                $reason = "ERP NO ANSWER";
            }
            
            if(strcmp($status,"1")==0)
            {
                setCompanyID($pickID);
            }
            
            
            insertDocumentStatuses($pickID,$type,$status,$reason);
            // sendFailErrorEmail('Order',$code,$id,$status,$reason,$to='');
            
            echo "<pre>Status: $status - Reason:";
            var_dump($reason);
            echo "<pre><br>";
	    }
        
	}
	$stm11->close();
	

    echo "<b>---PICKS/---</b><br>";

}


?>