<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

require_once('dbinfo.php');
require_once('SAPClient.php');
require_once('SAPClientPreferences.php');
require_once('importFunctions.php');

$client = new SAPClient($b1Host,$b1Port,$b1UserName,$b1Password,$b1CompanyDB);
$client->startConnection();

importStockBatchFromCustomView($client);

function importStockBatchFromCustomView($client)
{   

    
    
    $myfile = fopen("PARSER_STOCK_BATCH_PROGRESS.txt", "w") or die("Unable to open file!");
    fwrite($myfile, "START\n"); 

    echo "<br><b>---STOCK BATCH---</b>";
    $hasMore = true;
    $skip = '';   
    $filterNext='';
    $itemIDs = array();
    $filterToday='';
    $counter=0;
    $pageCounter = 0;
    while($hasMore){
        
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1]; } 
        
        $pageCounter++;
        $txt = "PAGE $pageCounter START $skip - ".date("Y-m-d H:i:s")." \n";
        fwrite($myfile, $txt);
        
        $result = $client->requestData("SQLQueries('CoprimeQueryBatchStock')/List".$filterNext,$filterToday);
        
        $items = $result[0];
        $skip  = $result[1];
        
        if(strcmp($skip,'')!=0){$hasMore = true;} else {$hasMore = false;}
   
        foreach($items as $item){
            $item = (object)$item;
            
            $counter++;

            $itemCode      = "$item->ItemCode";
            $warehouseCode = "$item->WarehouseCode";
            $batchNumber   = "$item->BatchNumber";
            $expiryDate    = "$item->ExpiryDate";
            $available     = floatval($item->InStockQty);
            
            if(strcmp("$expiryDate","")!=0){
                $expiryDate = date_format( date_create_from_format('Ymd', $expiryDate), 'Y-m-d');
            }
            
            $itemID      = getItemID($itemCode);
            $warehouseID = getWarehouseID($warehouseCode);
            
            echo "$counter - Item: $itemCode ($itemID) - Warehouse: $warehouseCode ($itemID) - Batch: $batchNumber - Exp.: $expiryDate<br>";
            fwrite($myfile, "$counter - Item: $itemCode ($itemID) - Warehouse: $warehouseCode ($itemID) - Batch: $batchNumber - Exp.: $expiryDate");

            if ($itemID > 0 && $warehouseID > 0) {
                insertStockBatchExpiry($warehouseID,$itemID,$batchNumber,$available,$expiryDate);
                fwrite($myfile, " - insert Stock");

            }
            
            fwrite($myfile, "\n");

        }
        
        $txt = "PAGE $pageCounter END - ".date("H:i:s")." \n";
        fwrite($myfile, $txt);
    }
    echo "<b>---STOCK BATCH/---</b><br>";

    fwrite($myfile, "FINISHED"); 
    fclose($myfile);



}


?>