<?php
function importReturns($client,$today)
{

    echo "<br><b>---RETURNS---</b><br>";

    $skip = '';
    $filterNext = '';
    $hasMore = true;
    $isFirst = true;

    if(strcmp($today,'')!=0){
        $filterSelect= '$filter=UpdateDate ge '."'$today'";
    } else {
        $filterSelect= '';
    }

    $filterSelect = str_replace(' ','%20',$filterSelect);

    while($hasMore){

        if($isFirst){$isFirst=false;}else{$filterSelect='';}
        if(strcmp($skip,'')!=0){$filterNext= "?".explode('?',$skip)[1];}

        $result = $client->requestData('CreditNotes'.$filterNext,$filterSelect,true);

        $skip    = $result[1];
        $returns = $result[0];

        if(strcmp($skip,'')!=0){ $hasMore = true;} else {$hasMore = false;}

        foreach($returns AS $return){
            $return = (object)$return;

            $returnIdNumber = "$return->DocEntry";
            $sapCustomerCode = "$return->CardCode";
            $sapCustomerName = "$return->CardName";
            $sapCustomerAddress = str_replace("\r",", ","$return->Address");

            if(strcmp("$sapCustomerCode","")==0){
                $sapCustomerCode = "GenericCustomer";
                $sapCustomerName = "Generic Customer";
                $sapCustomerAddress = " ";
            }

            $returnsArray = array();
            $returnItems = array();

            $subtotals = 0;
            $discountTotals = 0;
            $vatTotals = 0;

            echo "<br>---------------- SAP Return $return->DocNum ($return->DocEntry) -------------------";

            foreach($return->DocumentLines AS $returnLine){
                $returnLine = (object)$returnLine;

                $warehouseID = getWarehouseID("$returnLine->WarehouseCode");
                $itemID = getItemID($returnLine->ItemCode);
                $qty = floatval($returnLine->Quantity);

                if(intval($itemID) == 0){
                    $itemID = importReturnItemFromSAP($client,$returnLine->ItemCode);
                }

                $vatID = getVatItemID($itemID);
                $vatPercent = getVatPercent($vatID);

                $lineDiscount = floatval($returnLine->UnitPrice) - floatval($returnLine->Price);
                $lineDiscount *= $qty;

                $lineTotal = floatval($returnLine->UnitPrice)*floatval($returnLine->Quantity);
                $vatTotal = ($lineTotal-$lineDiscount)*$vatPercent/100;

                $subtotals += $lineTotal;
                $discountTotals += $lineDiscount;
                $vatTotals += $vatTotal;

                $returnItem = new stdClass();
                $returnItem->itemID = $itemID;
                $returnItem->qty = $qty;
                $returnItem->unitPrice = $returnLine->UnitPrice;
                $returnItem->lineDiscount = $lineDiscount;
                $returnItem->globalDiscount = 0;
                $returnItem->vatTotal = $vatTotal;
                $returnItem->priceTypeID = 10000;
                $returnItem->vatID = $vatID;
                $returnItem->warehouseID = $warehouseID;
                $returnItem->batchNumber=0;
                $returnItem->serialNumber='';
                $returnItem->status='Good';
                $returnItem->cost=0;
                $returnItem->lineDiscountPercent = $returnLine->DiscountPercent;
                $returnItem->itemNotes = $returnLine->ItemDescription.' |CostingCode| '.$returnLine->CostingCode.' |AccountCode| '.$returnLine->AccountCode.' |DocEntry| '.$return->DocEntry.' |LineNum| '.$returnLine->LineNum;

                echo "<br> LineNum $returnLine->LineNum - Item($itemID): $returnLine->ItemCode - $returnLine->ItemDescription | UnitPrice: $returnLine->UnitPrice | FinalPrice: $returnLine->Price | DiscountPercent: $returnLine->DiscountPercent | Quantity: $qty  ";

                array_push($returnItems,$returnItem);


            }


            if(count($returnsArray) > 1){
                $sapCustomerCode = "MultiCustomer";
                $sapCustomerName = "Multiple Customers";
                $sapCustomerAddress = "";
            }


            $customerID = intval(getCustomerID($sapCustomerCode));

            if($customerID == 0){

                $customer_code="$sapCustomerCode";
                $customer_company_name="$sapCustomerName";
                $customer_report_name="";
                $logo="";
                $registration_code="";
                $mobile="";
                $website="";
                $email="";
                $description="";
                $type_of_business="Credit";
                $tic_code="";
                $vat_code="";
                $credit_limit=0;
                $address_code_eurosoft="";
                $customer_type="Credit";
                $balance=0;
                echo "<br>INSERT CUSTOMER $customer_code - $customer_company_name<br>";
                $customerID = intval(insertCustomer($customer_code,$customer_company_name,$customer_report_name,$logo,$registration_code,$mobile,$website,$email,$description,$type_of_business,$tic_code,$vat_code,$credit_limit,$address_code_eurosoft,$customer_type,$balance));
            }

            $coprimeCodeNumber = 10000 + intval($return->DocEntry);

            $returnBillingAddress = $return->AddressExtension['BillToStreet'];
            $returnDeliveryAddress = $return->AddressExtension['ShipToStreet'];

//            if(strcmp("$returnBillingAddress","")==0 && strcmp("$returnDeliveryAddress","")!=0){$returnBillingAddress = $returnDeliveryAddress;}
//            if(strcmp("$returnDeliveryAddress","")==0 && strcmp("$returnBillingAddress","")!=0){$returnDeliveryAddress = $returnBillingAddress;}

            $document = new stdClass();
            $document->CoprimeType = 'Return';
            $document->CoprimePrefix = '';
            $document->returnCode = $document->CoprimePrefix.$coprimeCodeNumber;
            $document->returnDate = explode('T',$return->DocDate)[0];
            $document->returnDueDate = explode('T',$return->DocDueDate)[0];
            $document->customerID = $customerID;
            $document->customerCode = $sapCustomerCode;
            $document->customerName = $sapCustomerName;
            $document->customerAddress = $sapCustomerAddress;
            $document->billingAddressID = getAddressIdFromStreet($customerID, "$returnBillingAddress");
            $document->deliveryAddressID = getAddressIdFromStreet($customerID, "$returnDeliveryAddress");
            $document->salespersonID = intval(getSalespersonID("$document->SalesPersonCode"));
            $document->details = trim(rtrim(trim("$return->DocNum - $return->Comments"),'-'));
            $document->lines = $returnItems;
            $document->status = 'Placed';
            $document->returnType = 'Credit';
            $document->vatIE = 'i';


            if(strcmp("$return->DocumentStatus","bost_Open")!=0){
                $document->status = str_replace('bost_','',$return->DocumentStatus);
            }


            $objectActionHash = sha1(json_encode($document));

            $paymentMethod = 0;
            $returnCode = $document->returnCode;
            $companyID = 0;
            $salespersonID = $document->salespersonID;
            $subtotal = floatval($subtotals);
            $vatTotal = floatval($vatTotals);
            $discount = floatval($discountTotals);
            $grandTotal = $subtotal+$vatTotal-$discount;
            $globalDiscountPercentage = 0;
            $returnAddress = intval($document->billingAddressID);
            $returnDate = "$document->returnDate";
            $dueDate = "$document->returnDueDate";
            $details = $document->details;
            $status = $document->status;
            $orderID = intval($returnIdNumber);
            $currencyID = 0;
            $actionHash = "$objectActionHash";
            $returnType = "$document->returnType";
            $vatIE = "$document->vatIE";


            if(!returnExists($returnCode)){
                if(strcmp("$return->Reference2","")!=0 && returnExists("$return->Reference2")){
                    $returnCode = "$return->Reference2";
                    echo "<br>--------- Coprime Return $returnCode -------------<br>";
                    continue;
                } else if(strcmp("$return->NumAtCard","")!=0 && returnExists("$return->NumAtCard")){
                    $returnCode = "$return->NumAtCard";
                    echo "<br>--------- Coprime Return $returnCode -------------<br>";
                    continue;
                }
            }

            if(returnExists($returnCode)){

                $returnID = updateReturnSingleTransaction($returnCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$returnAddress,$returnDate,$dueDate,$details,$globalDiscountPercentage,$status,$orderID,$vatIE,$returnType,$currencyID,$actionHash,$returnItems);
                if($returnID == -1){
                    echo "<br> ------------- $returnCode No Change -------------<br>";
                } else {
                    echo "<br> ------------- Updated Return $returnCode: $returnID -------------<br>";
                }

            } else {
                if(count($returnItems) > 0){
                    $returnID = insertReturnSingleTransaction($returnCode,$companyID,$customerID,$salespersonID,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$returnAddress,$returnDate,$dueDate,$details,$globalDiscountPercentage,$status,$orderID,$vatIE,$returnType,$currencyID,$actionHash,$returnItems);
                    echo "<br> ------------- Inserted Return $returnCode: $returnID -------------<br>";
                } else {
                    echo "<br> ------------- $returnCode No Items -------------<br>";
                }
            }


        }


    }
    echo "<br><b>---RETURNS/---</b><br>";

   
}

function importReturnItemFromSAP($client,$sapCode){

    $itemFilter = '$filter=ItemCode eq '."'$sapCode'";
    $itemFilter = str_replace(' ','%20',$itemFilter);
    $item = $client->requestData('Items',$itemFilter);
    $item = (object)$item[0][0];

    echo "<br><b>ADD Item---</b>";
    echo $item->ItemCode;
    echo " [ItemCode] ";
    echo $item->ItemName;
    echo " [ItemName] ";
    echo $item->UpdateDate;
    echo " [UpdateDate] ";

    $vatCode      = $item->SalesVATGroup;
    $categoryCode = $item->ItemsGroupCode;
    $isSalesItem  = $item->SalesItem;
    $itemType     = $item->ItemType;

    $itemCode       = $item->ItemCode;
    $itemSKU        = "".str_replace('-','',$itemCode);
    $companyID      = 0;
    $vatID          = getVatID($vatCode);
    $subunits       = 1;
    $salesUnits     = $item->SalesUnit;
    $manufacturerID = 0;
    $itemName       = $item->ItemName;
    $shortDesc      = $item->ForeignName;
    $longDesc       = "";
    $thumbnailURL   = "";
    $reorderLevel   = 0;
    $targetQty      = 0;
    $bundled        = " ";
    $maxStock       = 0;
    $minStock       = 0;
    $packing        = $item->SalesPackagingUnit;
    $stockControl   = "yes";
    $sellable       = trim(strtolower($item->SalesItem),'t');
    $weight         = $item->SalesUnitWeight;
    $cbm            = 0;
    $status         = 0;
    $inactive       = trim(strtolower($item->Frozen),'t');
    $defaultBarcode = $item->BarCode;

    if(strcmp($inactive,'yes')==0){$status = 'inactive';}


    if(strcmp($salesUnits,'')==0){$salesUnits = 'EACH';}
    if(strcmp($vatID,'')==0){$vatID = 0;}
    if(strcmp($weight,'')==0){$weight = 0;}
    if(strcmp($packing,'')==0){$packing = 0;}
    if(strcmp($weight,'')==0){$weight = 0;}
    if(strcmp($itemSKU,'')==0){$itemSKU = " ";}
    if(is_null($shortDesc)){$shortDesc = "";}
    if(strcmp($item->ManageSerialNumbers,"tYes")==0)
    {
        $manufacturerID=-400;
    }

    if(itemExits($itemCode)){
        $itemID = updateItem($itemCode,$vatID,$subunits,$salesUnits,$itemName,$shortDesc,$longDesc,$weight,$status,$packing);
        echo " -> updateItem $itemCode  : ID $itemID STATUS: $status, WEIGHT: $weight, Packing: $packing";

    } else {
        $itemID = insertItem($itemCode,$itemSKU,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$itemName,$shortDesc,$longDesc,$thumbnailURL,$reorderLevel,$targetQty,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status);
        echo " -> insertItem($itemCode,$itemSKU,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$itemName,$shortDesc,$longDesc,$thumbnailURL,$reorderLevel,$targetQty,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status)";
    }



    if(strcmp($item->U_Category1,'')!=0)
    {
        $categoryLevel = $item->U_Category1;
        if(categoryExists($categoryLevel)){
            $categoryID=getCategoryID($categoryLevel);
            insertItemToCategory($itemID,$categoryID);
        }

    }

    if(strcmp($item->U_Category2,'')!=0)
    {
        $categoryLevel = $item->U_Category2;
        if(categoryExists($categoryLevel)){
            $categoryID=getCategoryID($categoryLevel);
            insertItemToCategory($itemID,$categoryID);
        }

    }

    if(strcmp($item->U_Category3,'')!=0)
    {
        $categoryLevel = $item->U_Category2;
        if(categoryExists($categoryLevel)){
            $categoryID=getCategoryID($categoryLevel);
            insertItemToCategory($itemID,$categoryID);
        }

    }

    if($itemID > 0){
        if(categoryExists($categoryCode)){
            $categoryID = getCategoryID($categoryCode);
            if($categoryID >0){
                if(itemExistsInCategory($itemID, $categoryID)){
                    // echo "<b>Item Category---</b> Item $itemCode exists in Category $categoryCode<br>";
                } else {
                    insertItemToCategory($itemID,$categoryID);
                    // echo "<b>Item Category---</b> insertItemToCategory $categoryCode<br>";
                }
            }
        }
    }

    foreach($item->ItemPrices as $itemPrice){
        $itemPrice = (object)$itemPrice;

        $priceTypeCode = $itemPrice->PriceList;
        $price         = $itemPrice->Price;

        if(strcmp($priceTypeCode,'')!=0){
            if(strcmp($price,'')==0){$price=0;}
            $priceTypeID = getPriceTypeID($priceTypeCode);
            if($priceTypeID > 0){

                $prevPrice = getPrice($priceTypeID,$itemID);
                if($price !== $prevPrice){
                    insertPrices($itemID,$priceTypeID,$price);
                }
                updateSpecialPrices($itemID,$priceTypeID,$price);

            }
        }
    }
    foreach($item->ItemWarehouseInfoCollection as $itemStock){
        $itemStock = (object)$itemStock;

        $warehouseCode = $itemStock->WarehouseCode;
        $available = $itemStock->InStock;
        $reserved = $itemStock->Committed;
        $onOrder = $itemStock->Ordered;
        $locked=$itemStock->Locked;

        if(strcmp(trim($itemStock->U_BinLoc),'')!=0){
            updateItemLongDescription($itemID,"$itemStock->U_BinLoc");
        }

        $delivered = 0;

        if(strcmp($warehouseCode,'')!=0){
            $warehouseID = getWarehouseID($warehouseCode);
            $batchnumber = "0";

            if(strcmp($locked,"tYES")==0){
                $batchnumber = "0";
                $available=-10000;
            }

            if($warehouseID > 0){
                //  insertStock($warehouseID,$itemID,$batchnumber,$available,$onOrder,$reserved,$delivered);
            }
        }
    }

    $uomGroupID = $item->UoMGroupEntry;
    foreach($item->ItemUnitOfMeasurementCollection as $uom){
        $uom = (object)$uom;
        $uomID = $uom->UoMEntry;
        $multiplier = getUOMMultiplier($uomGroupID,$uomID);
        if(!UOMItemExists($itemID,$uomID,$multiplier)){
            insertUOMItem($itemID,$uomID,$position=1,$multiplier);
            // echo " -> insertUOMItem($itemID,$uomID,$position,$multiplier);";
        }
    }

    return $itemID;
}
?>