<?php
require_once("../param.php");
include_once(ROOT."/libs/phpexcel/vendor/autoload.php");



if(isset($_POST['excelFile']) && strcmp($_POST['excelFile'],'')!=0){

    $inputFile = $_POST['excelFile'];
    initiateFileConversion($inputFile);

} else {echo 0;}


function initiateFileConversion($inputFile)
{
//    $validationString['items.txt'] = "\n|||||||||||||||||||||||||||||||||||||\nMaster Data||||||||Categories||||||||||Pricing||||||||||||||Regulation|||||\nItem Code|Description|Sales Unit|Packing|Barcoce|Search Code|Supplier Part Number|Long Description|Category Code 1|Category Name 1|Category Code 2|Category Name 2|Category Code 3|Category Name 3|Category Code 4|Category Name 4|Category Code 5|Category Name 5|Gross Price|VAT Code|VAT Percentage|Promotion 1 Qty|Promotion 1 Free Qty|Promotion 2 Qty|Promotion 2 Free Qty|Promotion 3 Qty|Promotion 3 Free Qty|Promotion 4 Qty|Promotion 4 Free Qty|Promotion 5 Qty|Promotion 5 Free Qty|Promotion 6 Discount Percentage|MOH REGULATED|Supplier Regulated|Rebate %age|Offer Price|Rebate Amount|\n||||||||Brand (Number)|Brand|Supplier|Supplier|Product|Product Cat|Marketing|Marketing|||||||||||||||||||| ||";
//    $validationString['customers.txt'] = "\n||||||||||||||||||||||||||||||||||||||\n||Master Data|||Customer Groups||||||||||Billing Address||||||Contact Details|||||Primary Contact Person||||Payment Method|||||Flags|||\nCustomer Code|Compnay Name|Branch Code|Branch Name|Search Name|Group Code 1|Group Name 1|Group Code 2|Group Name 2|Group Code 3|Group Name 3|Group Code 4|Group Name 4|Group Code 5|Group Name 5|Address Line 1|Address Line 2|Region|City|VAT Number|Country|Phone 1|Phone 2|Fax|Email|Website| Contract Person Name|Position|Phone|Email|Credit/Cash|Code|Credit Terms Desp.|Credit Term Days|Delivery / Monthend / Invoice date|Flag 1|Flag 2|Flag 3|\n|||||Own / Group / Individual||Sales Man||Category (Pharmacy / Hosp / Govt. / Others)||||ABC Analysis||||Area|GeoSector||||||||||||Credit|90P|90 days PDC|90|||||";
//    $validationString['daily_customer_upload.txt'] = "\n||||\nCustomer Code|Monthly Running Balance|Credit Limit|Block Y/N|";
//    $validationString['special_customer_promotions.txt'] = "\n|||||||||||\n||||Type 1||Type 2|||Yes/No|Yes/No|\nPromotions Code|Customer Code|Group Code|Item Code|qty|qty Free|Percentage Discount|Valid From |Valid Until|On Order Date|On Delivery Date|";

    $convertedFiles = processXLSX($inputFile);
    if(count($convertedFiles) > 0) {
        echo "<br><b>-------------------- File Validation Start --------------------</b><br>";

        foreach ($convertedFiles as $file) {
            $fileName = basename($file);
            echo "<br><b>Validating File</b> $fileName: ";
            validateFile($file, $validationString[$fileName]);
        }
        echo "<br><br><b>-------------------- File Validation Complete --------------------</b><br><br>";
        echo "<button type='button' id='runParserButton' onclick='runParser();' class='btn btn-primary'>&nbsp; Import Data &nbsp;</button>";
    }
}

function processXLSX($inputFile)
{

    $inputDirectory = "./import/error/";
    $outputDirectory = "./import/error/";
    $archiveDirectory = "./import/archive/";

    $inputDelimiter = "";
    $outputDelimiter = "|";

    $startingRow = 0;
    $endingRow = 0;
    if(file_exists($inputDirectory.$inputFile)) {
        echo "Processing File: $inputFile<br>";
        echo "<br><b>-------------------- File Processing Start --------------------</b><br><br>";

        $objReader1 = PHPExcel_IOFactory::createReader('Excel2007');
        $objReader1->setReadDataOnly(true);

        $objPHPExcel1 = $objReader1->load($inputDirectory . $inputFile);
        $sheetCount = $objPHPExcel1->getSheetCount();
        echo "XLS Number of Sheets <i class='fa fa-arrow-right'></i> <b>$sheetCount</b> <br>";
        $filesCreated = "";
        $convertedFiles = array();
        for ($i = 0; $i < $sheetCount; $i++) {

            $sheet1 = $objPHPExcel1->getSheet($i);
            $sheetNameDisplay = $sheet1->getTitle();
            $sheetNumber = $i + 1;
            $lastColumn = $objPHPExcel1->setActiveSheetIndex($i)->getHighestColumn();
            $lastColumnNumber = PHPExcel_Cell::columnIndexFromString($lastColumn);
            $sheetName = strtolower(str_replace(' ', '_', $sheetNameDisplay));
            $outputFile = "$sheetName.txt";
            $ColumnArray = array();
            $lastColumnNumber += 1;
            for ($c = 0; $c <= $lastColumnNumber; $c++) {
                array_push($ColumnArray, $c);
            }
            echo "<br><b>Processing Sheet $sheetNumber (</b>$sheetName<b>):</b> <br>";
            $fileCreated = convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow, $ColumnArray, $i);
            array_push($convertedFiles, $fileCreated);
            $filesCreated .= basename($fileCreated) . "<br>";

            echo " <i class='fa fa-arrow-right'></i><b style='color: green'> Sheet $sheetNumber Complete! </b><br>";
        }

        echo "<br><b>-------------------- File Processing Complete -------------------- </b><br><br><b> Files Created: </b><br>$filesCreated";

        if (rename($inputDirectory . $inputFile, $archiveDirectory . date('d-m-y') . $inputFile)) {
            echo "<b>Files Archived: </b><br> $inputFile <br>";
        }
        return $convertedFiles;
    } else {
        echo "<b>$inputFile File not Found!</b>";
    }
}

function validateFile($fileDirectory,$validationString){
    $baseFile = basename($fileDirectory);
    $validationRows = explode("\n", $validationString);
    $validationRowsCount = sizeof($validationRows);

    $txt_file = file_get_contents($fileDirectory);
    $rows = explode("\n", $txt_file);
    $processedRows=0;
    $isValidCounter=0;
    foreach ($rows as $row => $data) {
        foreach ($validationRows as $vRow => $vData) {

            if(strcmp($data,$vData)==0){
                $isValidCounter++;
                break;
            }
        }
        $processedRows++;
        if($processedRows >= $validationRowsCount){break;}
    }
    if($isValidCounter >= $processedRows){
        if(rename($fileDirectory, "./import/converted/$baseFile")){
            echo "<b style='color: green'>Success!</b>";
        } else {
            echo "<b style='color: firebrick'>PROCESSING FAILED </b> <i class='fa fa-arrow-right'></i> Please Run the upload again.";
            echo "<script>$('#runParserButton').hide();</script>";
        }
    } else {
        echo "<b style='color: firebrick'>VALIDATION FAILED </b> <i class='fa fa-arrow-right'></i> XLS File Header(s) Changed. Please Correct Headers and upload again.";
        echo "<script>$('#runParserButton').hide();</script>";
        rename($fileDirectory, "./import/error/".date('d-m-y_H:i')."$baseFile");
    }
}



// ------ FILE CONFIGURATION END ---------


function convert($inputFile, $outputFile, $inputDirectory, $outputDirectory, $inputDelimiter, $outputDelimiter, $startingRow, $endingRow,$ColumnArray,$getSheet=0)
{
    $inputFileDirectory  = $inputDirectory.$inputFile;
    $outputFileDirectory = $outputDirectory.$outputFile;


    return XLSInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$outputDelimiter,$outputFileDirectory,$getSheet);

}

function XLSInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$outputDelimiter,$outputFileDirectory,$getSheet = 0)
{
    $file = fopen($outputFileDirectory, "w");
    $objReader = PHPExcel_IOFactory::createReader('Excel2007');
    $objReader->setReadDataOnly(true);

    $objPHPExcel = $objReader->load($inputFileDirectory);
    $sheet = $objPHPExcel->getSheet($getSheet);
    $highestRow = $sheet->getHighestRow();
    $highestColumn = $sheet->getHighestColumn();
    $highestColumn++;
    $colNumber = PHPExcel_Cell::columnIndexFromString($highestColumn);

    if($endingRow == 0){
        $endingRow = $highestRow;
    }

    echo "<b>Records (Including Headers):</b> $endingRow <i class='fa fa-arrow-right'></i> ";

//  Loop through each row of the worksheet in turn
    for ($row = $startingRow; $row <= $endingRow; $row++) {
        fwrite($file, "\n");
        for($column='A';$column != $highestColumn;$column++) {
            $cell = $sheet->getCell($column.$row);
            if($cell->isFormula()){
                $rowData = $cell->getOldCalculatedValue();

            } else {
                $rowData = $cell->getValue();
            }

            fwrite($file, $rowData);
            fwrite($file, $outputDelimiter);


            }
        }
        $displayRowsProcessed = $row - 1;
    echo "<b style='color: green'> $displayRowsProcessed rows Processed.</b><br>";
    echo "<b>File Created:</b> ".basename($outputFileDirectory).PHP_EOL." ";
    fclose($file);

    return $outputFileDirectory;

}

function TXTInput($inputFileDirectory,$startingRow,$endingRow,$ColumnArray,$inputDelimiter,$outputDelimiter,$outputFileDirectory)
{
    $file        = fopen($outputFileDirectory, "w");
    $txt_file    = file_get_contents($inputFileDirectory);
    $rows        = explode("\n", $txt_file);

    array_shift($rows);

    foreach($rows as $row => $fields)
    {
        $row_data = explode($inputDelimiter, $fields);
        $data     = array();

        if($row >= $startingRow) {
            if($row <= $endingRow || $endingRow == 0) {
                foreach ($row_data as $field) {
                    array_push($data, $field);
                }

                foreach ($ColumnArray as $col) {
                    fwrite($file, $data[$col]);
                    fwrite($file, $outputDelimiter);
                }
                fwrite($file, "\n");
            }
        }
    }
    fclose($file);
}


?>