<?php
include_once("../param.php");
require_once(ROOT . 'interface/getImportParserVariables.php');


$columns = $customersFile;

$parserVariables = '';
$counter = 0;
foreach ($columns as $key => $column) {

    if ($counter % 5 == 0) {
        $parserVariables .= "<section class='col col-3 no-margin'>";
    }
    $parserVariables .= "$key: $column<br />";
    $counter++;

    if ($counter % 5 == 0) {
        $parserVariables .="</section>";
    }
}
?>
<div id="main" role="main">

    <!-- Start CUSTOM CODE-->
    <!-- RIBBON -->
    <div id="ribbon" class="bg-color-blue">

				<span class="ribbon-button-alignment">
					<span id="refresh" class="btn btn-ribbon2" onclick="location.reload(true);" data-title="refresh" rel="tooltip" data-placement="bottom" data-original-title="<i class='text-warning fa fa-warning'></i> Reload Page?" data-html="true">
						<i class="fa fa-refresh"></i>
					</span>
				</span>
        <!-- breadcrumb -->
        <ol class="breadcrumb">
            <li class="txt-color-white">Home / Import Mapping</li>
        </ol>
        <!-- end breadcrumb -->
    </div>
    <!-- END RIBBON -->

    <!-- MAIN CONTENT -->
    <div id="content">

        <div class="row">
            <div class="col-xs-12 col-sm-8 col-md-9 col-lg-8">
                <h3 class="page-title txt-color-blueDark header-margin">
                    <i class="fa fa-arrow-circle-right"></i>
                    Import Mapping
                </h3>
            </div>
        </div>

        <!-- row -->
        <section id="widget-grid" class="">

            <div class="row" >

                <!-- NEW WIDGET START -->
                <!-- NEW WIDGET START -->
                <article class="col-xs-12 col-sm-12 col-md-12 col-lg-12">

                    <div class="jarviswidget jarviswidget-color-blueDark no-margin" id="wid-id-0" data-widget-editbutton="false" data-widget-deletebutton="false">
                        <header>
                            <span class="widget-icon"> <i class="fa fa-gears"></i> </span>
                            <h2>Import Mapping</h2>

                        </header>
                        <!-- widget div-->
                        <div>
                            <!-- widget content -->
                            <div class="widget-body no-padding">

                                <form action="" id="b2bUsersForm" class="smart-form" method="post">
                                    <input id='customerID' name='customerID' type='hidden' value='<?php echo $customerID?>'>
                                    <fieldset style="padding-top:10px;">
                                        <div class="row">
                                            <section class="col col-4 no-margin" style="padding-right:2px" >
                                                <section>
                                                    <i class="fa fa-info-circle"></i>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle">
                                                        Parser Helper
                                                    </h3>
                                                </section>
                                                <table id="basicDetailsTable" class="table" width="100%" border="0" cellpadding="0" cellspacing="0">
                                                    <thead >
                                                    </thead>
                                                    <tbody >
                                                    <tr >
                                                        <td class="custom-td-label-medium"><label class="label-bold  align-left">Select Parser: </label></td>
                                                        <td class="custom-td-input-medium">
                                                            <select class='text-center form-control slim-input' name="fileName" id="fileName">
                                                                <option value="" selected disabled></option>
                                                            <?php
                                                            $data = getData();
                                                            foreach ($data as $object) {
                                                                $fields = $object->fields;
                                                                $fieldVal = '';
                                                                foreach ($fields as $key =>$field){
                                                                    $fieldVal .= "$key: $field <br/>";
                                                                }
                                                                echo "<option value='$fieldVal'>$object->title</option>";
                                                            }

                                                            ?>
                                                            </select>
                                                        </td>
                                                    </tr>

                                                    </tbody>
                                                </table>
                                            </section>
                                            <section class="col col-6 no-margin" style="padding-right:2px" >
                                                <section>
                                                    <h3 style="display: inline;margin-left:6px;vertical-align: middle"> Parser Fields</h3>
                                                </section>
                                                <div id="varContainer" style="column-count: 3;column-gap: 4px;"></div>
                                            </section>
                                            <section class="col col-4 no-margin" style="padding-right:2px" >
                                                <section>
                                                    <div style="color: firebrick; text-align: center;" id="error">

                                                    </div>
                                                </section>
                                        </div>
                                    </fieldset>


                                    <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%" border="0" cellpadding="0" cellspacing="0">
                                        <thead>
                                        <tr>
                                            <th class='text-center' style="width: 2%"></th>
                                            <th class='text-center' style="width: 2%">#</th>
                                            <th class='text-center' style="width: 25%">Parser</th>
                                            <th class='text-center' style="width: 25%">Import File Name</th>
                                            <th class='text-center' style="width: 25%">Import File Columns</th>
                                            <th class='text-center' style="width: 3%">Import Delimiter</th>
                                            <th class='text-center' style="width: 3%">Export Delimiter</th>

                                        </tr>
                                        </thead>

                                        <tbody>
                                         <tr>
                                             <td>
                                                 <img class='deletRowButton' src='//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/img/deleteicon.png' style='width:20px;height:20px;'/>
                                             </td>

                                            <td class='index text-center' style='width:5%;'>
                                                <strong>1</strong>
                                            </td>

                                            <td>
                                                <select class='text-center form-control' name="parser" id="parser">
                                                    <option value="CustomerGroups.txt">Customer Groups</option>
                                                    <option value="Customers.txt">Customers</option>
                                                    <option value="CustomerAddress.txt">Customer Address</option>
                                                    <option value="ItemGroups.txt">Item Groups</option>
                                                    <option value="Items.txt">Items</option>
                                                    <option value="ItemPrices.txt">Item Prices</option>
                                                    <option value="Warehouses.txt">Warehouses</option>
                                                    <option value="CustomerItems.txt">Customer Items</option>
                                                    <option value="CustomerItems.txt">Customer Items</option>
                                                    <option value="ItemGroups.txt">Item Groups</option>
                                                    <option value="BarCodes.txt">BarCodes</option>
                                                </select>
                                            </td>



                                             <td  class='text-center'  >
											    <input style='width:100%;' class='text-center form-control' id='identifier' name='identifier' type='text' value='' />
                                             </td>
                                             <td  class='text-center'  >
                                                 <input style='width:100%;' class='text-center form-control' id='identifier' name='identifier' type='text' value='' />
                                             </td>
                                             <td  class='text-center'  >
                                                 <input style='width:100%;' class='text-center form-control' id='identifier' name='identifier' type='text' value='' />
                                             </td>
                                             <td  class='text-center'  >
                                                 <input style='width:100%;' class='text-center form-control' id='identifier' name='identifier' type='text' value='' />
                                             </td>

                                        </tr>

                                        </tbody>

                                    </table>
                                </form>
                            </div>
                            <!-- end widget content -->

                        </div>
                        <!-- end widget div -->

                    </div>
                    <!-- end widget -->
                </article>


            </div>

            <!-- end row -->

            <div class="row" style="margin-top:10px;" >
                <div class="col-sm-5">

                    <a style="width: 180px " target="_blank" id="newLineButton" class="btn btn-primary btn-block">
                        <i class="fa fa-plus  ">
                        </i>&nbsp; Add Line</a>

                </div>
                <div class="col-sm-5">

                    <a style="width: 100px;float: right; " target="_blank" id="newLineButton" class="btn btn-warning btn-block">
                        <i class="fa fa-exchange  ">
                        </i>&nbsp;Execute</a>

                </div>
                <div class="col-sm-2">

                    <a style="width: 180px;float: right; " target="_blank" id="newLineButton" class="btn btn-success btn-block">
                        <i class="fa fa-check  ">
                        </i>&nbsp;Save Configuration</a>

                </div>
            </div>



        </section>
    </div>
</div>

<style>

    td input {
        width:100%;
    }

    table#datatable_fixed_column tr td img { display:none;}
    table#datatable_fixed_column tr:hover td img { display:inline-block;}



    table#datatable_fixed_column tr td {
        padding-left:4px;
        padding-right:4px;
    }

    td.index {
        font-weight:bold;
    }

    tr td textarea {
        white-space: normal;
        text-align: justify;
        -moz-text-align-last: center; /* Firefox 12+ */
        text-align-last: center;
    }

    #detailsTable thead th {
        background-color: white !important;
        border:none;
        height:0px;
    }

</style>


<script type="text/javascript">

    function updateTrNumbering()
    {
        var $i = 0;
        $('#datatable_fixed_column tr').each(function (i, row) {

            // reference all the stuff you need first
            var $row = $(row);

            $row.find("td.index").text($i);
            $i++;
        });
    }


    function addNewLine()
    {
        $lastTr = $('tr:last', $('#datatable_fixed_column'));
        $lastTd = $('td:last', $lastTr);
        $newTr = $lastTr.clone();
        $lastTr.after($newTr);
        $newTr.find("input").val("");
        $newTr.find("textarea").text("");
        $newTr.find("label").text("");
        $i = $newTr.find("td.index").text();
        $i++;
        $newTr.find("td.index").text($i);


        $( ".deletRowButton" ).click(function() {
            deleteRow(this);
        });



    }

    function deleteRow(row)
    {
        var rowCount = $('#datatable_fixed_column tr').length;

        if (rowCount > 2) {
            $(row).parents('tr').remove();
        }
        updateTrNumbering();
    }

    function saveCustomer()
    {

        var customerID= $('#customerID').val();

        var b2bUsers = $('#datatable_fixed_column').tableToJSON(
            {
                ignoreColumns: [0,1],
                textExtractor : {
                    0 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    1 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    2 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    3 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    4 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    5 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    6 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    7 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    8 : function(cellIndex, $cell) {
                        return $cell.find('select').val();
                    }
                },
                ignoreHiddenRows: false,
                ignoreEmptyRows: false
            }
        );




        $.ajax({
            type: "POST",
            url: '#',
            data: {
                'customerID':customerID,
                'b2bUsers':b2bUsers
            },

            success: function (result) {
                //do somthing here
                $.smallBox({
                    title : "Success!",
                    content : "Customer successfully saved",
                    color : "#739E73",
                    timeout: 3000,
                    icon : "fa fa-user swing animated"
                });
            }
        });
    }

    function generateUser()
    {
        var email = $('#customerEmail').val();
        if(!email.trim())
        {
            alert("Customer Email required");
        }
        else
        {
            var username = email;
            var password = Math.random().toString(36).substr(2, 8);

            // Check if user already created
            if(true)
            {
                $('#username:first').val(username);
                $('#identifier:first').val(password);
            }

        }
    }

    function sendInfoAsEmail(ID)
    {
        var action = "WELCOME";

        $.ajax({
            type: "POST",
            url: './sendTemplateEmail.php',
            data: {
                'ID': ID,
                'action': action
            },
            success: function (result) {
                //do somthing here
                $.smallBox({
                    title: "Success!",
                    content: "Email Successfully Sent",
                    color: "#739E73",
                    timeout: 3000,
                    icon: "fa fa-user swing animated"
                });
            }
        });
        //  }
    }

    $(document).ready(function() {

        pageSetUp();
        updateTrNumbering();

        $('#fileName').change(function(){
            $('#varContainer').html( $('#fileName').val());
        });


        var fixHelperModified = function (e, tr) {
                var $originals = tr.children();
                var $helper = tr.clone();
                $helper.children().each(function (tr) {
                    $(this).width($originals.eq(tr).width())
                });
                return $helper;
            },
            updateIndex = function (e, ui) {
                $('td.index', ui.item.parent()).each(function (i) {
                    $(this).text(i + 1);
                });
            };

        $("#datatable_fixed_column tbody").sortable({
            helper: fixHelperModified,
            stop: updateIndex
        });

        $("#newLineButton").click(function () {
            addNewLine();
        });

        $(".deletRowButton").click(function () {
            deleteRow(this);
        });
    });




</script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/notification/SmartNotification.min.js"></script>
<script src="//<?php echo HTML_PATH ?>/cop/backend/themes/<?php echo THEME_NAME ?>/js/jquery.tabletojson.js"></script>
