<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *                                   ATTENTION!
 * If you see this message in your browser (Internet Explorer, Mozilla Firefox, Google Chrome, etc.)
 * this means that PHP is not properly installed on your web server. Please refer to the PHP manual
 * for more details: http://php.net/manual/install.php 
 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

    include_once dirname(__FILE__) . '/components/startup.php';
    include_once dirname(__FILE__) . '/components/application.php';
    include_once dirname(__FILE__) . '/' . 'authorization.php';


    include_once dirname(__FILE__) . '/' . 'database_engine/mysql_engine.php';
    include_once dirname(__FILE__) . '/' . 'components/page/page_includes.php';

    function GetConnectionOptions()
    {
        $result = GetGlobalConnectionOptions();
        $result['client_encoding'] = 'utf8';
        GetApplication()->GetUserAuthentication()->applyIdentityToConnectionOptions($result);
        return $result;
    }

    
    
    
    // OnBeforePageExecute event handler
    
    
    
    class Sync_ServicePage extends Page
    {
        protected function DoBeforeCreate()
        {
            $this->SetTitle('Sync Service Sales');
            $this->SetMenuLabel('Sync Service Sales');
    
            $this->dataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`Sync_Service`');
            $this->dataset->addFields(
                array(
                    new IntegerField('id', true, true, true),
                    new IntegerField('device_id', true),
                    new StringField('type', true),
                    new IntegerField('period', true),
                    new StringField('time', true),
                    new StringField('active', true),
                    new DateTimeField('timestamp', true)
                )
            );
            $this->dataset->AddLookupField('device_id', 'Devices', new IntegerField('device_id'), new StringField('activation_code', false, false, false, false, 'device_id_activation_code', 'device_id_activation_code_Devices'), 'device_id_activation_code_Devices');
        }
    
        protected function DoPrepare() {
    
        }
    
        protected function CreatePageNavigator()
        {
            $result = new CompositePageNavigator($this);
            
            $partitionNavigator = new PageNavigator('pnav', $this, $this->dataset);
            $partitionNavigator->SetRowsPerPage(20);
            $result->AddPageNavigator($partitionNavigator);
            
            return $result;
        }
    
        protected function CreateRssGenerator()
        {
            return null;
        }
    
        protected function setupCharts()
        {
    
        }
    
        protected function getFiltersColumns()
        {
            return array(
                new FilterColumn($this->dataset, 'id', 'id', 'Id'),
                new FilterColumn($this->dataset, 'device_id', 'device_id_activation_code', 'Device'),
                new FilterColumn($this->dataset, 'type', 'type', 'Type'),
                new FilterColumn($this->dataset, 'period', 'period', 'Period'),
                new FilterColumn($this->dataset, 'time', 'time', 'Time'),
                new FilterColumn($this->dataset, 'active', 'active', 'Active'),
                new FilterColumn($this->dataset, 'timestamp', 'timestamp', 'Timestamp')
            );
        }
    
        protected function setupQuickFilter(QuickFilter $quickFilter, FixedKeysArray $columns)
        {
            $quickFilter
                ->addColumn($columns['device_id'])
                ->addColumn($columns['type'])
                ->addColumn($columns['period'])
                ->addColumn($columns['time'])
                ->addColumn($columns['active']);
        }
    
        protected function setupColumnFilter(ColumnFilter $columnFilter)
        {
            $columnFilter
                ->setOptionsFor('device_id');
        }
    
        protected function setupFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
            $main_editor = new DynamicCombobox('device_id_edit', $this->CreateLinkBuilder());
            $main_editor->setAllowClear(true);
            $main_editor->setMinimumInputLength(0);
            $main_editor->SetAllowNullValue(false);
            $main_editor->SetHandlerName('filter_builder_Sync_Service_device_id_search');
            
            $multi_value_select_editor = new RemoteMultiValueSelect('device_id', $this->CreateLinkBuilder());
            $multi_value_select_editor->SetHandlerName('filter_builder_Sync_Service_device_id_search');
            
            $filterBuilder->addColumn(
                $columns['device_id'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new ComboBox('type_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $main_editor->addChoice('repeat', 'repeat');
            $main_editor->addChoice('time', 'time');
            $main_editor->SetAllowNullValue(false);
            
            $multi_value_select_editor = new MultiValueSelect('type');
            $multi_value_select_editor->setChoices($main_editor->getChoices());
            
            $text_editor = new TextEdit('type');
            
            $filterBuilder->addColumn(
                $columns['type'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('period_edit');
            
            $filterBuilder->addColumn(
                $columns['period'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new TextEdit('time_edit');
            $main_editor->SetMaxLength(10);
            
            $filterBuilder->addColumn(
                $columns['time'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $main_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $main_editor,
                    FilterConditionOperator::BEGINS_WITH => $main_editor,
                    FilterConditionOperator::ENDS_WITH => $main_editor,
                    FilterConditionOperator::IS_LIKE => $main_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $main_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
            
            $main_editor = new ComboBox('active_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $main_editor->addChoice('true', 'true');
            $main_editor->addChoice('false', 'false');
            $main_editor->SetAllowNullValue(false);
            
            $multi_value_select_editor = new MultiValueSelect('active');
            $multi_value_select_editor->setChoices($main_editor->getChoices());
            
            $text_editor = new TextEdit('active');
            
            $filterBuilder->addColumn(
                $columns['active'],
                array(
                    FilterConditionOperator::EQUALS => $main_editor,
                    FilterConditionOperator::DOES_NOT_EQUAL => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN => $main_editor,
                    FilterConditionOperator::IS_GREATER_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN => $main_editor,
                    FilterConditionOperator::IS_LESS_THAN_OR_EQUAL_TO => $main_editor,
                    FilterConditionOperator::IS_BETWEEN => $main_editor,
                    FilterConditionOperator::IS_NOT_BETWEEN => $main_editor,
                    FilterConditionOperator::CONTAINS => $text_editor,
                    FilterConditionOperator::DOES_NOT_CONTAIN => $text_editor,
                    FilterConditionOperator::BEGINS_WITH => $text_editor,
                    FilterConditionOperator::ENDS_WITH => $text_editor,
                    FilterConditionOperator::IS_LIKE => $text_editor,
                    FilterConditionOperator::IS_NOT_LIKE => $text_editor,
                    FilterConditionOperator::IN => $multi_value_select_editor,
                    FilterConditionOperator::NOT_IN => $multi_value_select_editor,
                    FilterConditionOperator::IS_BLANK => null,
                    FilterConditionOperator::IS_NOT_BLANK => null
                )
            );
        }
    
        protected function AddOperationsColumns(Grid $grid)
        {
            $actions = $grid->getActions();
            $actions->setCaption($this->GetLocalizerCaptions()->GetMessageString('Actions'));
            $actions->setPosition(ActionList::POSITION_LEFT);
            
            if ($this->GetSecurityInfo()->HasViewGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('View'), OPERATION_VIEW, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
            
            if ($this->GetSecurityInfo()->HasEditGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Edit'), OPERATION_EDIT, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowEditButtonHandler', $this);
            }
            
            if ($this->deleteOperationIsAllowed()) {
                $operation = new AjaxOperation(OPERATION_DELETE,
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'),
                    $this->GetLocalizerCaptions()->GetMessageString('Delete'), $this->dataset,
                    $this->GetModalGridDeleteHandler(), $grid
                );
                $operation->setUseImage(true);
                $actions->addOperation($operation);
                $operation->OnShow->AddListener('ShowDeleteButtonHandler', $this);
            }
            
            
            if ($this->GetSecurityInfo()->HasAddGrant())
            {
                $operation = new LinkOperation($this->GetLocalizerCaptions()->GetMessageString('Copy'), OPERATION_COPY, $this->dataset, $grid);
                $operation->setUseImage(true);
                $actions->addOperation($operation);
            }
        }
    
        protected function AddFieldColumns(Grid $grid, $withDetails = true)
        {
            //
            // View column for activation_code field
            //
            $column = new TextViewColumn('device_id', 'device_id_activation_code', 'Device', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for type field
            //
            $column = new TextViewColumn('type', 'type', 'Type', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for period field
            //
            $column = new NumberViewColumn('period', 'period', 'Period', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for time field
            //
            $column = new TextViewColumn('time', 'time', 'Time', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
            //
            // View column for active field
            //
            $column = new TextViewColumn('active', 'active', 'Active', $this->dataset);
            $column->SetOrderable(true);
            $column->setMinimalVisibility(ColumnVisibility::PHONE);
            $grid->AddViewColumn($column);
        }
    
        protected function AddSingleRecordViewColumns(Grid $grid)
        {
            //
            // View column for activation_code field
            //
            $column = new TextViewColumn('device_id', 'device_id_activation_code', 'Device', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for type field
            //
            $column = new TextViewColumn('type', 'type', 'Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for period field
            //
            $column = new NumberViewColumn('period', 'period', 'Period', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for time field
            //
            $column = new TextViewColumn('time', 'time', 'Time', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
            
            //
            // View column for active field
            //
            $column = new TextViewColumn('active', 'active', 'Active', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddSingleRecordViewColumn($column);
        }
    
        protected function AddEditColumns(Grid $grid)
        {
            //
            // Edit column for device_id field
            //
            $editor = new DynamicCombobox('device_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`Devices`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('device_id', true, true),
                    new StringField('gcm_id', true),
                    new StringField('activation_code', true),
                    new StringField('android_id', true),
                    new StringField('prefix', true),
                    new StringField('display_prefix', true),
                    new DateField('activation_date', true),
                    new StringField('status', true),
                    new DateTimeField('last_update_from', true),
                    new IntegerField('sales_person_id', true),
                    new DateField('expiry_date', true),
                    new StringField('app_version'),
                    new StringField('android_version'),
                    new StringField('begin_tender_number', true),
                    new StringField('begin_waybill_number', true),
                    new StringField('begin_order_number', true),
                    new StringField('begin_invoice_number', true),
                    new StringField('begin_receipt_number', true),
                    new StringField('begin_return_number', true),
                    new StringField('begin_warehouse_transaction_number', true),
                    new StringField('begin_customer_stock_taking_number', true),
                    new StringField('begin_service_call_number', true),
                    new StringField('begin_z_number', true),
                    new StringField('begin_opportunity_number', true),
                    new StringField('coprime_version', true)
                )
            );
            $lookupDataset->setOrderByField('activation_code', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Device', 'device_id', 'device_id_activation_code', 'edit_Sync_Service_device_id_search', $editor, $this->dataset, $lookupDataset, 'device_id', 'activation_code', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for type field
            //
            $editor = new ComboBox('type_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $editor->addChoice('repeat', 'repeat');
            $editor->addChoice('time', 'time');
            $editColumn = new CustomEditColumn('Type', 'type', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for period field
            //
            $editor = new TextEdit('period_edit');
            $editColumn = new CustomEditColumn('Period', 'period', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for time field
            //
            $editor = new TextEdit('time_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Time', 'time', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
            
            //
            // Edit column for active field
            //
            $editor = new ComboBox('active_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $editor->addChoice('true', 'true');
            $editor->addChoice('false', 'false');
            $editColumn = new CustomEditColumn('Active', 'active', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddEditColumn($editColumn);
        }
    
        protected function AddMultiEditColumns(Grid $grid)
        {
            //
            // Edit column for device_id field
            //
            $editor = new DynamicCombobox('device_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`Devices`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('device_id', true, true),
                    new StringField('gcm_id', true),
                    new StringField('activation_code', true),
                    new StringField('android_id', true),
                    new StringField('prefix', true),
                    new StringField('display_prefix', true),
                    new DateField('activation_date', true),
                    new StringField('status', true),
                    new DateTimeField('last_update_from', true),
                    new IntegerField('sales_person_id', true),
                    new DateField('expiry_date', true),
                    new StringField('app_version'),
                    new StringField('android_version'),
                    new StringField('begin_tender_number', true),
                    new StringField('begin_waybill_number', true),
                    new StringField('begin_order_number', true),
                    new StringField('begin_invoice_number', true),
                    new StringField('begin_receipt_number', true),
                    new StringField('begin_return_number', true),
                    new StringField('begin_warehouse_transaction_number', true),
                    new StringField('begin_customer_stock_taking_number', true),
                    new StringField('begin_service_call_number', true),
                    new StringField('begin_z_number', true),
                    new StringField('begin_opportunity_number', true),
                    new StringField('coprime_version', true)
                )
            );
            $lookupDataset->setOrderByField('activation_code', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Device', 'device_id', 'device_id_activation_code', 'multi_edit_Sync_Service_device_id_search', $editor, $this->dataset, $lookupDataset, 'device_id', 'activation_code', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for type field
            //
            $editor = new ComboBox('type_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $editor->addChoice('repeat', 'repeat');
            $editor->addChoice('time', 'time');
            $editColumn = new CustomEditColumn('Type', 'type', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for period field
            //
            $editor = new TextEdit('period_edit');
            $editColumn = new CustomEditColumn('Period', 'period', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for time field
            //
            $editor = new TextEdit('time_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Time', 'time', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
            
            //
            // Edit column for active field
            //
            $editor = new ComboBox('active_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $editor->addChoice('true', 'true');
            $editor->addChoice('false', 'false');
            $editColumn = new CustomEditColumn('Active', 'active', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddMultiEditColumn($editColumn);
        }
    
        protected function AddToggleEditColumns(Grid $grid)
        {
    
        }
    
        protected function AddInsertColumns(Grid $grid)
        {
            //
            // Edit column for device_id field
            //
            $editor = new DynamicCombobox('device_id_edit', $this->CreateLinkBuilder());
            $editor->setAllowClear(true);
            $editor->setMinimumInputLength(0);
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`Devices`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('device_id', true, true),
                    new StringField('gcm_id', true),
                    new StringField('activation_code', true),
                    new StringField('android_id', true),
                    new StringField('prefix', true),
                    new StringField('display_prefix', true),
                    new DateField('activation_date', true),
                    new StringField('status', true),
                    new DateTimeField('last_update_from', true),
                    new IntegerField('sales_person_id', true),
                    new DateField('expiry_date', true),
                    new StringField('app_version'),
                    new StringField('android_version'),
                    new StringField('begin_tender_number', true),
                    new StringField('begin_waybill_number', true),
                    new StringField('begin_order_number', true),
                    new StringField('begin_invoice_number', true),
                    new StringField('begin_receipt_number', true),
                    new StringField('begin_return_number', true),
                    new StringField('begin_warehouse_transaction_number', true),
                    new StringField('begin_customer_stock_taking_number', true),
                    new StringField('begin_service_call_number', true),
                    new StringField('begin_z_number', true),
                    new StringField('begin_opportunity_number', true),
                    new StringField('coprime_version', true)
                )
            );
            $lookupDataset->setOrderByField('activation_code', 'ASC');
            $editColumn = new DynamicLookupEditColumn('Device', 'device_id', 'device_id_activation_code', 'insert_Sync_Service_device_id_search', $editor, $this->dataset, $lookupDataset, 'device_id', 'activation_code', '');
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for type field
            //
            $editor = new ComboBox('type_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $editor->addChoice('repeat', 'repeat');
            $editor->addChoice('time', 'time');
            $editColumn = new CustomEditColumn('Type', 'type', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for period field
            //
            $editor = new TextEdit('period_edit');
            $editColumn = new CustomEditColumn('Period', 'period', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for time field
            //
            $editor = new TextEdit('time_edit');
            $editor->SetMaxLength(10);
            $editColumn = new CustomEditColumn('Time', 'time', $editor, $this->dataset);
            $editColumn->SetAllowSetToNull(true);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            
            //
            // Edit column for active field
            //
            $editor = new ComboBox('active_edit', $this->GetLocalizerCaptions()->GetMessageString('PleaseSelect'));
            $editor->addChoice('true', 'true');
            $editor->addChoice('false', 'false');
            $editColumn = new CustomEditColumn('Active', 'active', $editor, $this->dataset);
            $validator = new RequiredValidator(StringUtils::Format($this->GetLocalizerCaptions()->GetMessageString('RequiredValidationMessage'), $editColumn->GetCaption()));
            $editor->GetValidatorCollection()->AddValidator($validator);
            $this->ApplyCommonColumnEditProperties($editColumn);
            $grid->AddInsertColumn($editColumn);
            $grid->SetShowAddButton(true && $this->GetSecurityInfo()->HasAddGrant());
        }
    
        private function AddMultiUploadColumn(Grid $grid)
        {
    
        }
    
        protected function AddPrintColumns(Grid $grid)
        {
            //
            // View column for activation_code field
            //
            $column = new TextViewColumn('device_id', 'device_id_activation_code', 'Device', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for type field
            //
            $column = new TextViewColumn('type', 'type', 'Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for period field
            //
            $column = new NumberViewColumn('period', 'period', 'Period', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddPrintColumn($column);
            
            //
            // View column for time field
            //
            $column = new TextViewColumn('time', 'time', 'Time', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
            
            //
            // View column for active field
            //
            $column = new TextViewColumn('active', 'active', 'Active', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddPrintColumn($column);
        }
    
        protected function AddExportColumns(Grid $grid)
        {
            //
            // View column for activation_code field
            //
            $column = new TextViewColumn('device_id', 'device_id_activation_code', 'Device', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for type field
            //
            $column = new TextViewColumn('type', 'type', 'Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for period field
            //
            $column = new NumberViewColumn('period', 'period', 'Period', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddExportColumn($column);
            
            //
            // View column for time field
            //
            $column = new TextViewColumn('time', 'time', 'Time', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
            
            //
            // View column for active field
            //
            $column = new TextViewColumn('active', 'active', 'Active', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddExportColumn($column);
        }
    
        private function AddCompareColumns(Grid $grid)
        {
            //
            // View column for activation_code field
            //
            $column = new TextViewColumn('device_id', 'device_id_activation_code', 'Device', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for type field
            //
            $column = new TextViewColumn('type', 'type', 'Type', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for period field
            //
            $column = new NumberViewColumn('period', 'period', 'Period', $this->dataset);
            $column->SetOrderable(true);
            $column->setNumberAfterDecimal(0);
            $column->setThousandsSeparator(',');
            $column->setDecimalSeparator('');
            $grid->AddCompareColumn($column);
            
            //
            // View column for time field
            //
            $column = new TextViewColumn('time', 'time', 'Time', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
            
            //
            // View column for active field
            //
            $column = new TextViewColumn('active', 'active', 'Active', $this->dataset);
            $column->SetOrderable(true);
            $grid->AddCompareColumn($column);
        }
    
        private function AddCompareHeaderColumns(Grid $grid)
        {
    
        }
    
        public function GetPageDirection()
        {
            return null;
        }
    
        public function isFilterConditionRequired()
        {
            return false;
        }
    
        protected function ApplyCommonColumnEditProperties(CustomEditColumn $column)
        {
            $column->SetDisplaySetToNullCheckBox(false);
            $column->SetDisplaySetToDefaultCheckBox(false);
    		$column->SetVariableContainer($this->GetColumnVariableContainer());
        }
    
        function GetCustomClientScript()
        {
            return ;
        }
        
        function GetOnPageLoadedClientScript()
        {
            return ;
        }
    
        protected function CreateGrid()
        {
            $result = new Grid($this, $this->dataset);
            if ($this->GetSecurityInfo()->HasDeleteGrant())
               $result->SetAllowDeleteSelected(true);
            else
               $result->SetAllowDeleteSelected(false);   
            
            ApplyCommonPageSettings($this, $result);
            
            $result->SetUseImagesForActions(true);
            $result->SetUseFixedHeader(false);
            $result->SetShowLineNumbers(false);
            $result->SetShowKeyColumnsImagesInHeader(false);
            $result->SetViewMode(ViewMode::TABLE);
            $result->setEnableRuntimeCustomization(true);
            $result->setAllowCompare(true);
            $this->AddCompareHeaderColumns($result);
            $this->AddCompareColumns($result);
            $result->setMultiEditAllowed($this->GetSecurityInfo()->HasEditGrant() && true);
            $result->setTableBordered(false);
            $result->setTableCondensed(false);
            
            $result->SetHighlightRowAtHover(true);
            $result->SetWidth('');
            $this->AddOperationsColumns($result);
            $this->AddFieldColumns($result);
            $this->AddSingleRecordViewColumns($result);
            $this->AddEditColumns($result);
            $this->AddMultiEditColumns($result);
            $this->AddToggleEditColumns($result);
            $this->AddInsertColumns($result);
            $this->AddPrintColumns($result);
            $this->AddExportColumns($result);
            $this->AddMultiUploadColumn($result);
    
    
            $this->SetShowPageList(false);
            $this->SetShowTopPageNavigator(true);
            $this->SetShowBottomPageNavigator(true);
            $this->setAllowedActions(array('view', 'insert', 'copy', 'edit', 'multi-edit', 'delete', 'multi-delete'));
            $this->setPrintListAvailable(true);
            $this->setPrintListRecordAvailable(false);
            $this->setPrintOneRecordAvailable(true);
            $this->setAllowPrintSelectedRecords(true);
            $this->setExportListAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportSelectedRecordsAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->setExportListRecordAvailable(array());
            $this->setExportOneRecordAvailable(array('pdf', 'excel', 'word', 'xml', 'csv'));
            $this->SetHidePageListByDefault(true);
    
            return $result;
        }
     
        protected function setClientSideEvents(Grid $grid) {
    
        }
    
        protected function doRegisterHandlers() {
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`Devices`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('device_id', true, true),
                    new StringField('gcm_id', true),
                    new StringField('activation_code', true),
                    new StringField('android_id', true),
                    new StringField('prefix', true),
                    new StringField('display_prefix', true),
                    new DateField('activation_date', true),
                    new StringField('status', true),
                    new DateTimeField('last_update_from', true),
                    new IntegerField('sales_person_id', true),
                    new DateField('expiry_date', true),
                    new StringField('app_version'),
                    new StringField('android_version'),
                    new StringField('begin_tender_number', true),
                    new StringField('begin_waybill_number', true),
                    new StringField('begin_order_number', true),
                    new StringField('begin_invoice_number', true),
                    new StringField('begin_receipt_number', true),
                    new StringField('begin_return_number', true),
                    new StringField('begin_warehouse_transaction_number', true),
                    new StringField('begin_customer_stock_taking_number', true),
                    new StringField('begin_service_call_number', true),
                    new StringField('begin_z_number', true),
                    new StringField('begin_opportunity_number', true),
                    new StringField('coprime_version', true)
                )
            );
            $lookupDataset->setOrderByField('activation_code', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'insert_Sync_Service_device_id_search', 'device_id', 'activation_code', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`Devices`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('device_id', true, true),
                    new StringField('gcm_id', true),
                    new StringField('activation_code', true),
                    new StringField('android_id', true),
                    new StringField('prefix', true),
                    new StringField('display_prefix', true),
                    new DateField('activation_date', true),
                    new StringField('status', true),
                    new DateTimeField('last_update_from', true),
                    new IntegerField('sales_person_id', true),
                    new DateField('expiry_date', true),
                    new StringField('app_version'),
                    new StringField('android_version'),
                    new StringField('begin_tender_number', true),
                    new StringField('begin_waybill_number', true),
                    new StringField('begin_order_number', true),
                    new StringField('begin_invoice_number', true),
                    new StringField('begin_receipt_number', true),
                    new StringField('begin_return_number', true),
                    new StringField('begin_warehouse_transaction_number', true),
                    new StringField('begin_customer_stock_taking_number', true),
                    new StringField('begin_service_call_number', true),
                    new StringField('begin_z_number', true),
                    new StringField('begin_opportunity_number', true),
                    new StringField('coprime_version', true)
                )
            );
            $lookupDataset->setOrderByField('activation_code', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'filter_builder_Sync_Service_device_id_search', 'device_id', 'activation_code', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`Devices`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('device_id', true, true),
                    new StringField('gcm_id', true),
                    new StringField('activation_code', true),
                    new StringField('android_id', true),
                    new StringField('prefix', true),
                    new StringField('display_prefix', true),
                    new DateField('activation_date', true),
                    new StringField('status', true),
                    new DateTimeField('last_update_from', true),
                    new IntegerField('sales_person_id', true),
                    new DateField('expiry_date', true),
                    new StringField('app_version'),
                    new StringField('android_version'),
                    new StringField('begin_tender_number', true),
                    new StringField('begin_waybill_number', true),
                    new StringField('begin_order_number', true),
                    new StringField('begin_invoice_number', true),
                    new StringField('begin_receipt_number', true),
                    new StringField('begin_return_number', true),
                    new StringField('begin_warehouse_transaction_number', true),
                    new StringField('begin_customer_stock_taking_number', true),
                    new StringField('begin_service_call_number', true),
                    new StringField('begin_z_number', true),
                    new StringField('begin_opportunity_number', true),
                    new StringField('coprime_version', true)
                )
            );
            $lookupDataset->setOrderByField('activation_code', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'edit_Sync_Service_device_id_search', 'device_id', 'activation_code', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
            
            $lookupDataset = new TableDataset(
                MySqlIConnectionFactory::getInstance(),
                GetConnectionOptions(),
                '`Devices`');
            $lookupDataset->addFields(
                array(
                    new IntegerField('device_id', true, true),
                    new StringField('gcm_id', true),
                    new StringField('activation_code', true),
                    new StringField('android_id', true),
                    new StringField('prefix', true),
                    new StringField('display_prefix', true),
                    new DateField('activation_date', true),
                    new StringField('status', true),
                    new DateTimeField('last_update_from', true),
                    new IntegerField('sales_person_id', true),
                    new DateField('expiry_date', true),
                    new StringField('app_version'),
                    new StringField('android_version'),
                    new StringField('begin_tender_number', true),
                    new StringField('begin_waybill_number', true),
                    new StringField('begin_order_number', true),
                    new StringField('begin_invoice_number', true),
                    new StringField('begin_receipt_number', true),
                    new StringField('begin_return_number', true),
                    new StringField('begin_warehouse_transaction_number', true),
                    new StringField('begin_customer_stock_taking_number', true),
                    new StringField('begin_service_call_number', true),
                    new StringField('begin_z_number', true),
                    new StringField('begin_opportunity_number', true),
                    new StringField('coprime_version', true)
                )
            );
            $lookupDataset->setOrderByField('activation_code', 'ASC');
            $handler = new DynamicSearchHandler($lookupDataset, 'multi_edit_Sync_Service_device_id_search', 'device_id', 'activation_code', null, 20);
            GetApplication()->RegisterHTTPHandler($handler);
        }
       
        protected function doCustomRenderColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderPrintColumn($fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomRenderExportColumn($exportType, $fieldName, $fieldData, $rowData, &$customText, &$handled)
        { 
    
        }
    
        protected function doCustomDrawRow($rowData, &$cellFontColor, &$cellFontSize, &$cellBgColor, &$cellItalicAttr, &$cellBoldAttr)
        {
    
        }
    
        protected function doExtendedCustomDrawRow($rowData, &$rowCellStyles, &$rowStyles, &$rowClasses, &$cellClasses)
        {
    
        }
    
        protected function doCustomRenderTotal($totalValue, $aggregate, $columnName, &$customText, &$handled)
        {
    
        }
    
        protected function doCustomDefaultValues(&$values, &$handled) 
        {
    
        }
    
        protected function doCustomCompareColumn($columnName, $valueA, $valueB, &$result)
        {
    
        }
    
        protected function doBeforeInsertRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeUpdateRecord($page, $oldRowData, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doBeforeDeleteRecord($page, &$rowData, $tableName, &$cancel, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterInsertRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterUpdateRecord($page, $oldRowData, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doAfterDeleteRecord($page, $rowData, $tableName, &$success, &$message, &$messageDisplayTime)
        {
    
        }
    
        protected function doCustomHTMLHeader($page, &$customHtmlHeaderText)
        { 
    
        }
    
        protected function doGetCustomTemplate($type, $part, $mode, &$result, &$params)
        {
    
        }
    
        protected function doGetCustomExportOptions(Page $page, $exportType, $rowData, &$options)
        {
    
        }
    
        protected function doFileUpload($fieldName, $rowData, &$result, &$accept, $originalFileName, $originalFileExtension, $fileSize, $tempFileName)
        {
    
        }
    
        protected function doPrepareChart(Chart $chart)
        {
    
        }
    
        protected function doPrepareColumnFilter(ColumnFilter $columnFilter)
        {
    
        }
    
        protected function doPrepareFilterBuilder(FilterBuilder $filterBuilder, FixedKeysArray $columns)
        {
    
        }
    
        protected function doGetSelectionFilters(FixedKeysArray $columns, &$result)
        {
    
        }
    
        protected function doGetCustomFormLayout($mode, FixedKeysArray $columns, FormLayout $layout)
        {
    
        }
    
        protected function doGetCustomColumnGroup(FixedKeysArray $columns, ViewColumnGroup $columnGroup)
        {
    
        }
    
        protected function doPageLoaded()
        {
    
        }
    
        protected function doCalculateFields($rowData, $fieldName, &$value)
        {
    
        }
    
        protected function doGetCustomRecordPermissions(Page $page, &$usingCondition, $rowData, &$allowEdit, &$allowDelete, &$mergeWithDefault, &$handled)
        {
    
        }
    
        protected function doAddEnvironmentVariables(Page $page, &$variables)
        {
    
        }
    
    }

    SetUpUserAuthorization();

    try
    {
        $Page = new Sync_ServicePage("Sync_Service", "Sync_Service.php", GetCurrentUserPermissionsForPage("Sync_Service"), 'UTF-8');
        $Page->SetRecordPermission(GetCurrentUserRecordPermissionsForDataSource("Sync_Service"));
        GetApplication()->SetMainPage($Page);
        GetApplication()->Run();
    }
    catch(Exception $e)
    {
        ShowErrorPage($e);
    }
	
