<?php
// List of events

include_once("../../param.php");
require(ROOT . "concc/dbhelpers/dbhelper.php");

$where="WHERE Service_Call.customer_id=Customers.customer_id AND Service_Call.type_id= SC_Types.type_id AND Service_Call.status_id=SC_Status.status_id AND schedule_start_date>'0000-00-00 00:00:00' AND schedule_end_date>'0000-00-00 00:00:00' AND schedule_start_date<schedule_end_date AND (SC_Status.visible IS NULL OR NOT SC_Status.visible='no')";

if(isset($_GET['customerID']))
{
    $customer=$_GET['customerID'];

    if(strcmp($customer,"")!=0)
    {
        $where=$where." AND Service_Call.customer_id IN($customer)";
    }
}

if(isset($_GET['typeSelect']))
{
    $types=$_GET['typeSelect'];

    if(strcmp($types,"")!=0)
    {
        $where=$where." AND SC_Types.type_id IN($types)";
    }
}


if(isset($_GET['userSelect']))
{
    $users=$_GET['userSelect'];

    if(strcmp($users,"")!=0)
    {
        $where=$where." AND Service_Call.assign_to IN($users)";
    }
}


if(isset($_GET['prioritySelect']))
{
    $priorities=$_GET['prioritySelect'];

    if(strcmp($priorities,"")!=0)
    {
        $where=$where." AND Service_Call.priority_id IN($priorities)";
    }
}


if(isset($_GET['statusSelect']))
{
    $statuses=$_GET['statusSelect'];

    if(strcmp($statuses,"")!=0)
    {
        $where=$where." AND Service_Call.status_id IN($statuses)";
    }
}

$objects = array();

// Query that retrieves events
$request = "SELECT service_call_id,service_call_code,topic,schedule_start_date,schedule_end_date,customer_company_name,type_name,status_name,priority_id FROM Service_Call,Customers,SC_Types,SC_Status $where ORDER BY service_call_id";


$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stmt = $db->prepare($request);
$stmt->execute();
$stmt->bind_result($serviceCallID,$serviceCallCode,$serviceCallTitle,$serviceCallDate,$serviceCallDateDue,$customerName,$type,$status,$priorityID);
while ($stmt->fetch()) {
    $serviceCallTitle=str_replace("'","",$serviceCallTitle);
    $serviceCallTitle=str_replace("\"","",$serviceCallTitle);
    $customerName=str_replace("'","",$customerName);
    $customerName=str_replace("\"","",$customerName);
    $object = "";
    $object->id = $serviceCallID;
    $object->title = $serviceCallCode." - ".$serviceCallTitle.': '.$status;
    $object->start = $serviceCallDate;
    $object->end = $serviceCallDateDue;

    $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $serviceCallDate);
    $firstDate = $myDateTime->format('Y-m-d');


    $myDateTime = DateTime::createFromFormat('Y-m-d H:i:s', $serviceCallDateDue);
    $secondDate = $myDateTime->format('Y-m-d');

    if (strcmp($firstDate,$secondDate)!=0) {

        $object->allDay=true;

    }



    if($priorityID == 1)
    {
        $object->color = "#b22222";
    }
    else  if($priorityID == 2)
    {
        $object->color = "#CC8E53";
    }
    else  if($priorityID == 3)
    {
        $object->color = "#4682B4";
    }
    else  if($priorityID == 4)
    {
        $object->color = "#008080";
    }



    array_push($objects,$object);

}

$stmt->close();



// sending the encoded result to success page
echo json_encode($objects);

?>
