<?php
include ('./FirebasePushNotification.php');
include ('../../concc/dbinfo.php');

//require("../dbinfo.php");
global $username, $password, $database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
//time server
$timeIntervalMinutes = 3 * 60;
$protectionBufferMinutes = 10;

$startTimeInterval = $timeIntervalMinutes - $protectionBufferMinutes;
$endTimeInterval = $timeIntervalMinutes + $protectionBufferMinutes;

$db->set_charset("utf8");
$arrayDevicesToSend = array();
$stm = $db->prepare("SELECT id,device_id,sender_id,coprime_app,title,body,schedule_date,notification_type,schedule_batch FROM Firebase_Notifications WHERE notification_type='Schedule' AND (schedule_date <= NOW() + INTERVAL '$endTimeInterval' MINUTE AND schedule_date >= NOW() + INTERVAL '$startTimeInterval' MINUTE) AND NOT status='Canceled' AND NOT status='Send';");
$stm-> execute();
$stm-> bind_result($id,$deviceID,$senderID,$deviceType,$title,$body,$dateTime,$notificationType,$batchSchedule);
while ($stm->fetch()) {
    $sheduleNotification = new stdClass();
    $sheduleNotification->id = $id;
    $sheduleNotification->deviceID = $deviceID;
    $sheduleNotification->senderID = $senderID;
    $sheduleNotification->deviceType = $deviceType;
    $sheduleNotification->title = $title;
    $sheduleNotification->body = $body;
    $sheduleNotification->date = $dateTime;
    $sheduleNotification->notificationType = $notificationType;
    $sheduleNotification->batchSchedule = $batchSchedule;
    array_push($arrayDevicesToSend,$sheduleNotification);
}
$stm-> close();

//echo "<pre>";
//var_dump($arrayDevicesToSend);


foreach ($arrayDevicesToSend as $deviceObj){

    $deviceID = $deviceObj->deviceID;
    $deviceType = $deviceObj->deviceType;
    $title = $deviceObj->title;
    $body = $deviceObj->body;
    $senderID = $deviceObj->senderID;

    if(strcmp($deviceType,'pur')==0){
        $deviceTable = 'Devices_Pop';
        $deviceIdColumn = 'device_pop_id';
    } else {
        $deviceTable = 'Devices';
        $deviceIdColumn = 'device_id';
    }

    if(isset($deviceID) && $deviceID > 0 && strcmp($title,'')!=0) {

        $push = new FirebasePushNotification($db);
        $push->senderID($senderID);
        $push->selectDeviceByID($deviceTable,$deviceIdColumn,$deviceID);
        $push->notificationType('Notification');
        $push->title($title);
        $push->body($body);
        $push->send();
        updateScheduleNotification($deviceObj->id , 'Sent');
    }
}


function updateScheduleNotification($id,$status){
    global $username, $password, $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    if (strcmp($id,'')!=0){
        $stm1 = $db->prepare("UPDATE Firebase_Notifications SET status=? WHERE id=?");
        $stm1->bind_param('si', $status,$id);
        $stm1->execute();
        $stm1->close();
    }
}

?>