// Andreas Spanos @ 09/07/2019 Added action_code button

(function (factory) {
  /* global define */
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['jquery'], factory);
  } else if (typeof module === 'object' && module.exports) {
    // Node/CommonJS
    module.exports = factory(require('jquery'));
  } else {
    // Browser globals
    factory(window.jQuery);
  }
}(function ($) {

  // Extends plugins for adding hello.
  //  - plugin is external module for customizing.
  $.extend($.summernote.plugins, {

    'customer_company_name': function (context) {

      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.customer_company_name', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-user"/> Customer Name',
          tooltip: 'customer_company_name',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{customer_company_name}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

    'customer_code': function (context) {

        var self = this;
        var ui = $.summernote.ui;

        // add hello button
        context.memo('button.customer_code', function () {
          // create button
          var button = ui.button({
            contents: '<i class="fa fa-info"/> Customer Code',
            tooltip: 'customer_code',
            click: function () {
              self.$panel.show();
              self.$panel.hide(500);
              // invoke insertText method with 'hello' on editor module.
              context.invoke('editor.insertText', '{customer_code}');
            }
          });

          // create jQuery object from button instance.
          var $name = button.render();
          return $name;
        });

        // This events will be attached when editor is initialized.
        this.events = {
          // This will be called after modules are initialized.
          'summernote.init': function (we, e) {
            console.log('summernote initialized', we, e);
          },
          // This will be called when user releases a key on editable.
          'summernote.keyup': function (we, e) {
            console.log('summernote keyup', we, e);
          }
        };

        // This method will be called when editor is initialized by $('..').summernote();
        // You can create elements for plugin
        this.initialize = function () {
          this.$panel = $('<div class="hello-panel"/>').hide();

          this.$panel.appendTo('body');
        };

        // This methods will be called when editor is destroyed by $('..').summernote('destroy');
        // You should remove elements on `initialize`.
        this.destroy = function () {
          this.$panel.remove();
          this.$panel = null;
        };
      }

    });

  $.extend($.summernote.plugins, {

    'company_name': function (context) {

      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.company_name', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-building"/> Company Name',
          tooltip: 'company_name',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{company_name}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

    'company_logo': function (context) {

      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.company_logo', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-image"/> Company Logo',
          tooltip: 'company_logo',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{company_logo}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

    'b2b_user_name': function (context) {

      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.b2b_user_name', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-user"/> B2B User ',
          tooltip: 'b2b_user_name',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{b2b_user_name}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

    'b2b_user_password': function (context) {

      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.b2b_user_password', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-asterisk"/> B2B Password',
          tooltip: 'b2b_user_password',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{b2b_user_password}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

    'reset_password_link': function (context) {

      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.reset_password_link', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-link"/> B2B Reset Password Link',
          tooltip: 'reset_password_link',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{reset_password_link}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

    'grand_total': function (context) {
      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.grand_total', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-money"/> Total Amount',
          tooltip: 'grand_total',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{grand_total}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

    'action_date': function (context) {
      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.action_date', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-calendar-o"/>  Action Date',
          tooltip: 'action_date',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{action_date}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

    'action_details': function (context) {
      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.action_details', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-table"/>  Action Details',
          tooltip: 'action_details',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{action_details}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

      'b2b_username': function (context) {
        var self = this;
        var ui = $.summernote.ui;

        // add hello button
        context.memo('button.b2b_username', function () {
          // create button
          var button = ui.button({
            contents: '<i class="fa fa-user"/>  B2B Username',
            tooltip: 'b2b_username',
            click: function () {
              self.$panel.show();
              self.$panel.hide(500);
              // invoke insertText method with 'hello' on editor module.
              context.invoke('editor.insertText', '{b2b_username}');
            }
          });

          // create jQuery object from button instance.
          var $name = button.render();
          return $name;
        });

        // This events will be attached when editor is initialized.
        this.events = {
          // This will be called after modules are initialized.
          'summernote.init': function (we, e) {
            console.log('summernote initialized', we, e);
          },
          // This will be called when user releases a key on editable.
          'summernote.keyup': function (we, e) {
            console.log('summernote keyup', we, e);
          }
        };

        // This method will be called when editor is initialized by $('..').summernote();
        // You can create elements for plugin
        this.initialize = function () {
          this.$panel = $('<div class="hello-panel"/>').hide();

          this.$panel.appendTo('body');
        };

        // This methods will be called when editor is destroyed by $('..').summernote('destroy');
        // You should remove elements on `initialize`.
        this.destroy = function () {
          this.$panel.remove();
          this.$panel = null;
        };
      }

    });

  $.extend($.summernote.plugins, {

    'action_code': function (context) {

      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.action_code', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-info"/> Action Code',
          tooltip: 'action_code',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{action_code}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

    'delivery_date': function (context) {
      var self = this;
      var ui = $.summernote.ui;

      // add hello button
      context.memo('button.delivery_date', function () {
        // create button
        var button = ui.button({
          contents: '<i class="fa fa-calendar"/>  Delivery Date',
          tooltip: 'delivery_date',
          click: function () {
            self.$panel.show();
            self.$panel.hide(500);
            // invoke insertText method with 'hello' on editor module.
            context.invoke('editor.insertText', '{delivery_date}');
          }
        });

        // create jQuery object from button instance.
        var $name = button.render();
        return $name;
      });

      // This events will be attached when editor is initialized.
      this.events = {
        // This will be called after modules are initialized.
        'summernote.init': function (we, e) {
          console.log('summernote initialized', we, e);
        },
        // This will be called when user releases a key on editable.
        'summernote.keyup': function (we, e) {
          console.log('summernote keyup', we, e);
        }
      };

      // This method will be called when editor is initialized by $('..').summernote();
      // You can create elements for plugin
      this.initialize = function () {
        this.$panel = $('<div class="hello-panel"/>').hide();

        this.$panel.appendTo('body');
      };

      // This methods will be called when editor is destroyed by $('..').summernote('destroy');
      // You should remove elements on `initialize`.
      this.destroy = function () {
        this.$panel.remove();
        this.$panel = null;
      };
    }

  });

  $.extend($.summernote.plugins, {

      'notification_acceptance_link': function (context) {
        var self = this;
        var ui = $.summernote.ui;

        // add hello button
        context.memo('button.notification_acceptance_link', function () {
          // create button
          var button = ui.button({
            contents: '<i class="fa fa-link"/>  Notification Acceptance Link',
            tooltip: 'notification_acceptance_link',
            click: function () {
              self.$panel.show();
              self.$panel.hide(500);
              // invoke insertText method with 'hello' on editor module.
              context.invoke('editor.insertText', '{notification_acceptance_link}');
            }
          });

          // create jQuery object from button instance.
          var $name = button.render();
          return $name;
        });

        // This events will be attached when editor is initialized.
        this.events = {
          // This will be called after modules are initialized.
          'summernote.init': function (we, e) {
            console.log('summernote initialized', we, e);
          },
          // This will be called when user releases a key on editable.
          'summernote.keyup': function (we, e) {
            console.log('summernote keyup', we, e);
          }
        };

        // This method will be called when editor is initialized by $('..').summernote();
        // You can create elements for plugin
        this.initialize = function () {
          this.$panel = $('<div class="hello-panel"/>').hide();

          this.$panel.appendTo('body');
        };

        // This methods will be called when editor is destroyed by $('..').summernote('destroy');
        // You should remove elements on `initialize`.
        this.destroy = function () {
          this.$panel.remove();
          this.$panel = null;
        };
      }

    });


}));
