<?php
session_start();
include_once("../param.php");
if(!isset($_SESSION['customerID']) ) {
    redirect("login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

$companyID = $_SESSION['companyID'];
$orderID=$_SESSION['orderID'];
$customerID = $_SESSION['customerID'];
$userID=$_SESSION['userID'];

global $username, $password, $database;
$db = new mysqli('localhost', $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");



$isB2C = false;
$showPrices=true;
$stm = $db->prepare("SELECT primary_language,show_prices,use_as_b2c,css_theme,footer,anonymous_checkout_customer_id FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$useAsB2C,$cssTheme,$footerLabel,$anonymousCustomerForCheckoutID);

while ($stm->fetch()) {
    if(strcmp($showPrices,"no")==0 && $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }
    if(strcmp($useAsB2C,"yes")==0){$isB2C = true;}
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}
$stm-> close();
if(strcmp($anonymousCustomerForCheckoutID,'')==0){$anonymousCustomerForCheckoutID = 0;}


$stm = $db->prepare("SELECT customer_code,customer_company_name,balance FROM Customers WHERE customer_id='$customerID' AND NOT customer_id='$anonymousCustomerForCheckoutID'");
$stm->execute();
$stm->bind_result($customerCode, $customerName,$balance);

while ($stm->fetch()) {

    $companyFiled = $customerCode." - ".$customerName;

}
$stm->close();


if(!$showPrices)
{
    $balance="Hidden";
}


$stm = $db->prepare("SELECT username,email,first_name,last_name,mobile,B2C_User FROM B2B_User WHERE b2b_user_id='$userID'");
$stm->execute();
$stm->bind_result($userName, $email,$firstName,$lastName,$mobile,$isB2CUser);
while ($stm->fetch()) {}
$stm->close();

if(strcmp($isB2CUser,"yes")==0 && $isB2C){$isB2C = true;}else{$isB2C = false;}

if($isB2C){

    $stm = $db->prepare("SELECT show_balance FROM B2C_Configuration");
    $stm-> execute();
    $stm-> bind_result($showBalance);
    while ($stm->fetch()) {}
    $stm-> close();
    if(strcmp("$showBalance","yes")!=0){$hideBalance = "display: none;";}
    if(strcmp("$customerName","$firstName $lastName")==0){$hideCompany = "display: none;";}
    if(strcmp("$userName","$email")==0){$hideUserName = "display: none;";}

}


if(true){
    $stm = $db->prepare("SELECT payment_method_id,name,alter_name FROM B2C_Payment_Methods WHERE payment_method_code='JCC_V2' AND active IN('yes','balance') AND balance_payment='yes' LIMIT 1");
    $stm->execute();
    $stm->bind_result($jccv2Check,$jccv2Name,$jccv2AlterName);
    while ($stm->fetch()) {}
    $stm->close();

    if(intval($jccv2Check) > 0){
        if(isset($_SESSION['lang']) && $_SESSION['lang'] == 'el' && strcmp($jccv2AlterName,'')!=0){
            $jccv2Name = "$jccv2AlterName";
        }
        $allowPaymentOnBalance = true;
    } else {
        $allowPaymentOnBalance = false;
    }

}

if($allowPaymentOnBalance) {
    $redirectionFromJCC = false;
    $paymentStatusStyle = '';
    if (isset($_GET['cbid']) && $_GET['cbid'] > 0) {
        $customerBalanceID = intval($_GET['cbid']);
        $stm = $db->prepare("SELECT jcc_status FROM B2B_JCC_V2_Customer_Balance WHERE customer_balance_id='$customerBalanceID' AND customer_id='$customerID' AND customer_balance_id > 0 LIMIT 1");
        $stm->execute();
        $stm->bind_result($jccPaymentBalanceStatus);
        while ($stm->fetch()) {}
        $stm->close();
        $redirectionFromJCC = true;

        if (strcmp(trim(strtolower($jccPaymentBalanceStatus)), "success") == 0) {
            if ($_SESSION['lang'] == 'el') {
                $jccPaymentBalanceStatus = "<div style='background-color: #cff3ce;border-bottom: 2px solid silver;border-top: 2px solid silver;margin-top:-23px;padding: 15px 5px;margin-bottom: 10px;'>
                                        Η πληρωμή σας ολοκληρώθηκε με <br>
                                        επιτυχία από τον Πάροχο Πληρωμών.<br>
                                        <br>
                                        Το υπόλοιπό σας θα αλλάξει σύντομα.<br>
                                    </div>
                                    Θα θέλατε να συνεχίσετε με μια άλλη πληρωμή;";
            } else {
                $jccPaymentBalanceStatus = "<div style='background-color: #cff3ce;border-bottom: 2px solid silver;border-top: 2px solid silver;margin-top:-23px;padding: 15px 5px;margin-bottom: 10px;'>
                                        Your payment has been successfully<br>
                                        processed by the Payment Provider.<br>
                                        <br>
                                        Your balance will change shortly.<br>
                                    </div>
                                    Would you like to proceed with another payment?";
            }

        }

        if (isset($_GET['p']) && $_GET['p'] > 0) {
            $paymentStatusStyle = "color: #016400;";
        } else {
            $paymentStatusStyle = "color: firebrick;";
        }
    }
}


include_once("headerImports.php");

?>


    <body id="home" class="wide">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- Popup: Shopping cart items -->
            <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div id='cartItems' class="container">

                    </div>
                </div>
            </div>

            <!-- /Popup: Shopping cart items -->

            <!-- HEADER -->
                <?php
                $topmenu = "topMenu$cssTheme.php";

                if(strcmp($topmenu,"topMenu2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }

                include_once("$topmenu");
                if(strcmp($topmenu,"topMenu.php")==0) {
                    include_once("navigationMenu.php");
                }
                ?>
            </header>

            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area">
                <section class="page-section">
                    <div class=" container" >
                        <div class="row">

                            <!--start sidebar-->
                            <?php

                            include_once("navigationAccountMenu.php");
                            ?>
                            <!--end sidebar-->

                            <!--start main contain of page-->
                            <div class="col-lg-9 col-md-9 col-sm-8">
                                <div class="information-title" ><?php echo $langu['account_title_label_right'] ?></div>
                                <div class="details-wrap">
<!--                                    <div class="block-title alt"> <i class="fa fa-angle-down"></i>--><?php //echo $langu['account_personal_details_label'] ?><!--</div>-->
                                    <div class="details-box">
                                        <form class="form form-inline" action="#">
                                            <div class="row">
                                                <div class="form-group col-md-12 col-sm-12" style="<?php echo $hideCompany?>">
                                                   <label style="display:inline-block;font-weight:bold;color:black;border: none;min-width:150px;" class="form-control"><?php echo $langu['account_table_company_label'] ?></label>
                                                   <label style="display:inline-block;word-wrap: break-word;overflow-y: auto;min-width:300px;" class="form-control"><?php echo"$companyFiled"?></label>
                                                </div>
                                                <div class="form-group col-md-12 col-sm-12 " style="margin-top:15px;<?php echo $hideUserName?>">
                                                    <label style="display:inline-block;font-weight:bold;color:black;border: none;;min-width:150px;" class="form-control"><?php echo $langu['account_table_username_label'] ?></label>
                                                    <label  style="display:inline-block;word-wrap: break-word;overflow-y: auto;min-width:300px;" class="form-control"><?php echo"$userName"?></label>
                                                </div>
                                                <div class="form-group col-md-12 col-sm-12 " style="margin-top:15px;">
                                                    <label style="display:inline-block;font-weight:bold;color:black;border: none;min-width:150px;" class="form-control"><?php echo $langu['account_table_first_name_label'] ?></label>
                                                    <label  style="display:inline-block;word-wrap: break-word;overflow-y: auto;min-width:300px;" class="form-control"><?php echo"$firstName"?></label>
                                                </div>
                                                <div class="form-group col-md-12 col-sm-12 " style="margin-top:15px;">
                                                    <label style="display:inline-block;font-weight:bold;color:black;border: none;min-width:150px;" class="form-control"><?php echo $langu['account_table_last_name_label'] ?></label>
                                                    <label  style="display:inline-block;word-wrap: break-word;overflow-y: auto;min-width:300px;" class="form-control"><?php echo"$lastName"?></label>
                                                </div>
                                                <div class="form-group col-md-12 col-sm-12 " style="margin-top:15px;">
                                                    <label style="display:inline-block;font-weight:bold;color:black;border: none;min-width:150px;" class="form-control"><?php echo $langu['account_table_email_label'] ?></label>
                                                    <label  style="display:inline-block;word-wrap: break-word;overflow-y: auto;min-width:300px;" class="form-control"><?php echo"$email"?></label>
                                                </div>
                                                <div class="form-group col-md-12 col-sm-12 " style="margin-top:15px;">
                                                    <label style="display:inline-block;font-weight:bold;color:black;border: none;min-width:150px;" class="form-control"><?php echo $langu['account_table_mobile_label'] ?></label>
                                                    <label  style="display:inline-block;word-wrap: break-word;overflow-y: auto;min-width:300px;" class="form-control"><?php echo"$mobile"?></label>
                                                </div>

                                                <div class="form-group col-md-12 col-sm-12 " style="margin-top:15px;<?php echo $hideBalance?>">
                                                    <label style="display:inline-block;font-weight:bold;color:black;border: none;min-width:150px;" class="form-control"><?php echo $langu['account_table_balance_label'] ?></label>
                                                    <label  style="display:inline-block;word-wrap: break-word;overflow-y: auto;min-width:300px;" class="form-control"><?php echo"$balance"?></label>
                                                    <?php if($allowPaymentOnBalance){ echo '<button type="button" class="btn btn-theme" style="margin-top:0px;padding:8px 10px;" onclick="$(\'#paymentOnAccountModal\').modal(\'show\');">'.$langu['payment_on_account'].'</button>'; } ?>
                                                </div>

                                                <?php
                                                if($isB2C){
                                                    echo '<div class="form-group col-md-12 col-sm-12 " style="margin:15px;">';
                                                    echo "<a href='user_info_form.php' class='btn btn-theme ' style='margin: 5px;'>". $langu['edit_account_label'] ."</a>";
                                                    echo "<a href='myAddress.php' class='btn btn-theme ' style='margin: 5px;'>". $langu['order_delivery_address'] ."</a>";
                                                    echo "<a href='change_password.php' class='btn btn-theme ' style='margin: 5px;'>". $langu['change_password'] ."</a>";
                                                    echo "<button onclick=\"$('#modalRemoveAccountUser').modal('show');\" class='btn btn-theme ' style='margin: 5px;'>". $langu['delete_account'] ."</button>";
                                                    echo '</div>';
                                                }
                                                ?>

                                            </div>
                                        </form>
                                    </div>
                                </div>                                
                            </div>
                            <!--end main contain of page-->


                        </div>

                    </div>
                </section>
            </div>
            <!-- /CONTENT AREA -->

            <!-- FOOTER -->
            <?php
            if(strcmp($footerLabel,'')==0){$footerLabel = 'Powered by Coprime - 25311504';}
            if(strcmp($topmenu,"topMenu2.php")==0  || strcmp($topmenu,"topMenu3.php")==0) {
                echo '<footer class="footer" style="border: 0px;" >
                            <div class="footer-meta footer-custom" style="background: linear-gradient(to bottom, white  0%, whitesmoke 5%, '.$themeColor.' 15%);border: 0px;">
                                <div class="container" style="width: 100%" >
                                    <div class="row" >
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" style="color: whitesmoke;border-color: transparent">
                                                 '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
            } else {
                echo '<footer class="footer">
                            <div class="footer-meta footer-custom">
                                <div class="container">
                                    <div class="row">
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" >
                                                '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
            }
            ?>

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>

        <div class="modal fade" id="modalRemoveAccountUser" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <center><div class="modal-dialog" style="width: 80%;" >
                <div class="modal-content" >
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <center><h4 class="modal-title" style='font-family: "Gill Sans", sans-serif;'><b>CLOSE ACCOUNT</b></h4></center>
                    </div>
                    <div class="modal-body" style="text-align: left">
                       <p>Are you sure you want to close your account?</p>
                        <p>
                            This action is irreversible and will
                            result in the permanent deletion of all
                            your account data.
                        </p>
                        <p>
                            Please select one of the following
                            options:
                        </p>
                        <p>
                            - Confirm: By selecting "Continue" you
                            acknowledge that you understand the
                            consequences, and your account will
                            be closed immediately. Your data will
                            be permanently deleted in 30 days.
                        </p>
                        <p>
                            - Cancel: If you do not want to
                            proceed with closing your account,
                            select "Cancel" to return to your
                            account and keep your data intact.
                        </p>
                    </div>
                    <div class="modal-footer" >
                        <button class="btn btn-primary pull-right" id="buttonRemoveAccountUser" type="button" style="margin-right:20px;" onclick="removeUser();">Continue</button>
                        <button type="button" class="btn btn-theme-transparent pull-left" onclick="$('#modalRemoveAccountUser').modal('hide');" >Cancel</button>
                    </div>
                </div>
            </div></center>
        </div>
        <!-- /WRAPPER -->

        <div class="modal fade" id="paymentOnAccountModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <center><div class="modal-dialog"  >
                    <div class="modal-content" >
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                            <center><h4 class="modal-title" style='font-family: "Gill Sans", sans-serif;text-transform: uppercase;'><b><?php echo $langu['payment_on_account']; ?></b></h4></center>
                        </div>
                        <div class="modal-body" style="text-align: left;padding: 0px;">
                            <form action="./dbaccess/createCustomerBalancePaymentJCCv2.php" method="post" id="paymentOnAccountForm">
                                <center>
                                    <table style="width: 100%;">

                                        <tr>
                                            <td style="background-color: #cadbf7;border-bottom: 3px solid silver;border-top: 3px solid silver;padding: 5px;">
                                                <center>
                                                    <span style="font-size: 18px;color:black;"><?php if($_SESSION['lang'] == 'el'){ echo "Το τρέχον υπόλοιπό σας";}else{ echo "Your current balance";} ?></span>
                                                    <span class="form-control" style="width: 200px;font-size: 18px;border-color: transparent;color:black;font-weight: bolder;background-color: transparent;"><?php if ($allowPaymentOnBalance){echo number_format($balance,2);} ?></span>
                                                </center>
                                            </td>

                                        </tr>
                                        <tr>
                                            <td>
                                                <center>
                                                    <h3 style="<?php echo $paymentStatusStyle; ?>" id="paymentOnAccountInfoBox">
                                                        <?php echo "$jccPaymentBalanceStatus"?>
                                                    </h3>
                                                </center>
                                            </td>
                                        </tr>

                                        <tr>
                                            <td>
                                                <center>
                                                    <span style="font-size: 15px;color:black;"><?php echo $langu['enter_payment_amount']; ?></span>
                                                    <input type="number" min="0" max="<?php echo $balance; ?>" step="0.01" class="form-control" style="width: 200px;" name="amountToPay" id="amountToPay" placeholder="<?php echo $langu['payment_amount'];?>" />
                                                </center>
                                            </td>

                                        </tr>
                                        <tr>
                                            <td ><br></td>
                                        </tr>
                                        <tr>
                                            <td >
                                                <center>
                                                    <button type="button" class="btn btn-theme" style="margin-top: 10px;" id="paymentOnAccountValidationButton" onclick="paymentOnAccountValidation();" ><?php echo $langu['proceed_with_payment'];?></button>
                                                    <button type="button" class="btn btn-theme" style="margin-top: 10px;background-color: #77a63f;border-color: #77a63f;border-radius: 25px;" id="paymentOnAccountSubmitButton"  ><?php if($_SESSION['lang'] == 'el'){ echo "Πληρωμη μεσω $jccv2Name";} else { echo "Pay with $jccv2Name";} ?></button>
                                                </center>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td ><br></td>
                                        </tr>
                                    </table>
                                </center>
                            </form>


                        </div>
                        <div class="modal-footer" >
                            <button type="button" class="btn btn-theme-transparent pull-right" onclick="$('#paymentOnAccountModal').modal('hide');" >close</button>
                        </div>
                    </div>
                </div></center>
        </div>
        <!-- /WRAPPER -->

        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>


        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>

        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>

        <!--<![endif]-->

    <script>
        <?php
        if($redirectionFromJCC){
            echo "$('#paymentOnAccountModal').modal('show');";
        }
        ?>

        $('#paymentOnAccountSubmitButton').hide();

        $('#amountToPay').change(function(){
            $('#amountToPay').css('border-color','');
            $('#paymentOnAccountValidationButton').show();
            $('#paymentOnAccountSubmitButton').attr('onclick','').hide();
        });
        $('#amountToPay').focus(function(){
            $('#amountToPay').css('border-color','');
            $('#paymentOnAccountValidationButton').show();
            $('#paymentOnAccountSubmitButton').attr('onclick','').hide();
        });

        function paymentOnAccountValidation(){
            $('#paymentOnAccountValidationButton').show();
            $('#paymentOnAccountSubmitButton').attr('onclick','').hide();
            $('#paymentOnAccountInfoBox').html('');
            var amountToPay = $('#amountToPay').val();
            var balance = <?php echo floatval($balance); ?>;

            if(parseFloat(amountToPay) <= 0 || isNaN(amountToPay) || amountToPay === ''){
                $('#paymentOnAccountInfoBox').css('color','firebrick').html('<?php if($_SESSION['lang'] == 'el'){ echo 'Εισαγάγετε το ποσό πληρωμής.';}else{echo 'Please enter Payment amount.';} ?>');
                $('#amountToPay').css('border-color','firebrick');
                return;
            }
            if(amountToPay > balance ){
                $('#paymentOnAccountInfoBox').css('color','firebrick').html('<?php if($_SESSION['lang'] == 'el'){ echo 'Το ποσό πληρωμής δεν μπορεί να είναι<br>μεγαλύτερο από το τρέχον υπόλοιπό σας.';}else{echo 'Payment amount cannot be greater<br>than your current balance.';} ?>');
                $('#amountToPay').css('border-color','firebrick');
                return;
            }
            $('#amountToPay').css('border-color','#77a63f');
            $('#paymentOnAccountValidationButton').hide();
            $('#paymentOnAccountSubmitButton').attr('onclick','paymentOnAccountSubmit()').show();
        }

        function paymentOnAccountSubmit(){
            $('#paymentOnAccountInfoBox').html('');
            var amountToPay = $('#amountToPay').val();
            var balance = <?php if($allowPaymentOnBalance){echo floatval($balance);}else{echo "0";} ?>;

            if(parseFloat(amountToPay) <= 0 || isNaN(amountToPay) || amountToPay === ''){
                $('#paymentOnAccountInfoBox').css('color','firebrick').html('<?php if($_SESSION['lang'] == 'el'){ echo 'Εισαγάγετε το ποσό πληρωμής.';}else{echo 'Please enter Payment amount.';} ?>');
                $('#amountToPay').css('border-color','firebrick');
                return;
            }
            if(amountToPay > balance ){
                $('#paymentOnAccountInfoBox').css('color','firebrick').html('<?php if($_SESSION['lang'] == 'el'){ echo 'Το ποσό πληρωμής δεν μπορεί να είναι<br>μεγαλύτερο από το τρέχον υπόλοιπό σας.';}else{echo 'Payment amount cannot be greater<br>than your current balance.';} ?>');
                $('#amountToPay').css('border-color','firebrick');
                return;
            }
            $('#paymentOnAccountForm').submit();
        }


        function removeUser(){
            $.ajax({
                type: "POST",
                url: "./dbaccess/deleteUserAppJson.php",
                success: function (result) {
                    $('#modalRemoveAccountUser').modal('hide');
                    window.location.href='logout.php';
                }
            });
        }
        // Fixed menu toggle
        $('.menu-toggle').on('click', function () {
            if (navigation.hasClass('opened')) {
                navigation.removeClass('opened').addClass('closed');
            } else {
                navigation.removeClass('closed').addClass('opened');
            }
        });
        $('.menu-toggle-close').on('click', function () {
            if (navigation.hasClass('opened')) {
                navigation.removeClass('opened').addClass('closed');
            } else {
                navigation.removeClass('closed').addClass('opened');
            }
        });
    </script>

    </body>
</html>