<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");

$userID=$_SESSION['userID'];
if (isset($_POST['customer_address_id']) && $_POST['customer_address_id']>0 && isset($_POST['type'])){
    $customerAddressesID = $_POST['customer_address_id'];
    $type = trim($_POST['type']);
}else{
    $customerAddressesID = 0;
    $type = '';
}

//$type = 'delete';
//$type = 'update';
//$type = 'set_primary';


global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$customerID = 0;
$stm = $db->prepare("SELECT customer_id FROM B2B_User WHERE b2b_user_id=?");
$stm->bind_param('i',$userID);
$stm-> execute();
$stm-> bind_result($customerID);
while ($stm->fetch()) {}
$stm-> close();

if ($customerID>0 && $customerAddressesID>0){
    switch ($type) {
        case 'delete':

            $stmt = $db->prepare("DELETE FROM CustomerAddress WHERE customer_id=? AND customer_address_id=?");
            $stmt-> bind_param('ii',$customerID,$customerAddressesID);
            $stmt-> execute();
            $stmt->close();

            echo "delete";
            break;
        case 'update':
            $country                = trim($_POST['country']);
            $city                   = trim($_POST['city']);
            $addressLine1           = trim($_POST['address_line_1']);
            $addressLine2           = trim($_POST['address_line_2']);
            $postcode               = trim($_POST['postcode']);
            $region                 = trim($_POST['region']);
            $lat                    = trim($_POST['lat']);
            $lng                    = trim($_POST['lng']);

            $stmt = $db->prepare("UPDATE CustomerAddress SET country=?,city=?,address_line_1=?,address_line_2=?,postcode=?,region=?,lat=?,lng=?,timestamp=NOW() WHERE customer_address_id=? AND customer_id=?");
            $stmt->bind_param('ssssssssii', $country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng,$customerAddressesID,$customerID);
            $stmt->execute();
            $stmt->close();
            echo "update";
            break;
        case 'set_primary':
            $stmt = $db->prepare("UPDATE CustomerAddress SET primary_address='no',timestamp=NOW() WHERE customer_id=?");
            $stmt->bind_param('i', $customerID);
            $stmt->execute();
            $stmt->close();

            $stmt = $db->prepare("UPDATE CustomerAddress SET primary_address='yes',timestamp=NOW() WHERE customer_id=? AND customer_address_id=?");
            $stmt->bind_param('ii', $customerID,$customerAddressesID);
            $stmt->execute();
            $stmt->close();

            echo "set_primary";
            break;
        case 'insert':
            $country                = trim($_POST['country']);
            $city                   = trim($_POST['city']);
            $addressLine1           = trim($_POST['address_line_1']);
            $addressLine2           = trim($_POST['address_line_2']);
            $postcode               = trim($_POST['postcode']);
            $region                 = trim($_POST['region']);
            $lat                    = trim($_POST['lat']);
            $lng                    = trim($_POST['lng']);

            $stmt = $db->prepare("INSERT INTO CustomerAddress (customer_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,timestamp) values (?,?,?,?,?,?,?,?,?,NOW())");
            $stmt->bind_param('issssssss', $customerID, $country, $city, $addressLine1, $addressLine2, $postcode,$region,$lat,$lng);
            $stmt->execute();
            $stmt->close();

            echo "insert";
            break;
        default:
            echo "none";
    }
}else{
    echo 0;
}


?>
