<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
session_start();

$subDirectory = explode('/cop',str_replace($_SERVER['DOCUMENT_ROOT'],'' ,__DIR__ ))[0];
define("HTML_PATH", $_SERVER['SERVER_NAME'] ."$subDirectory");

include_once('dbhelper.php');

$customerID = $_SESSION['customerID'];
$userID = $_SESSION['userID'];

$send = 'tCopSend';

//$_POST['prefix'] = 'CYP';
//$_POST['domain'] = "new.coprimeglobal.com";



if(isset($_POST['copSend']) && strcmp($_POST['copSend'],'')!=0) {
    $send = $_POST['copSend'];
}
if(isset($_POST['domain']) && strcmp($_POST['domain'],'')!=0) {
    $domainURL = $_POST['domain'];
}
if(isset($_POST['prefix']) && strcmp($_POST['prefix'],'')!=0) {
    $regionPrefix = $_POST['prefix'];
}

if(isset($_GET['copSend']) && strcmp($_GET['copSend'],'')!=0) {
    $send = $_GET['copSend'];
}
if(isset($_GET['domain']) && strcmp($_GET['domain'],'')!=0) {
    $domainURL = $_GET['domain'];
}
if(isset($_GET['prefix']) && strcmp($_GET['prefix'],'')!=0) {
    $regionPrefix = $_GET['prefix'];
}

$postURL = "https://$domainURL/cop/b2b/dbaccess/changeRegion.php";
$redirectUrl = "https://$domainURL/cop/b2b/logout.php";

if(strcmp($send,'tCopReceive')==0){
    $regionCustomerJson = json_decode($_POST['copCust']);
    $user = $regionCustomerJson->user;

    $customerCode = "$regionCustomerJson->code";
    $b2bUserName  = "$user->username";
    $b2bUserEmail = "$user->email";

    $originalCustomerCodeArray = explode('-',$customerCode);
    $originalCustomerCode = end($originalCustomerCodeArray);

    $existingUser = false;
    $existingCustomer = false;

    if(strcmp($customerCode,'')!=0 && strcmp($b2bUserName,'')!=0 && strcmp($b2bUserEmail,'')!=0){

        global $username, $password, $database;
        $db = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $stmt = $db->prepare("SELECT Customers.customer_id,b2b_user_id,customer_code FROM B2B_User,Customers WHERE  B2B_User.customer_id=Customers.customer_id AND B2B_User.username=? AND B2B_User.email=? AND (customer_code=? OR customer_code=?) LIMIT 1");
        $stmt->bind_param("isss", $b2bUserName, $b2bUserEmail,$customerCode,$originalCustomerCode);
        $stmt->execute();
        $stmt->bind_result($existingCustomerID,$existingUserID,$existingCustomerCode);
        if ($stmt->fetch()) {

            if($existingUserID > 0) {$existingUser = true;}
            if($existingCustomerID > 0 && strcmp($existingCustomerCode,'')!=0){$existingCustomer = true;}


        }
        $stmt->close();


        if($existingCustomer && $existingUser){
            redirect($redirectUrl);
        } else {

            $balance= 0;
            $customerAddressID = 0;
            $errorText = '';
            $error = false;
            try {
                $db->begin_transaction();

                if(!$error) {
                    $customerID = getNextKey("Customers", "customer_id");
                    $stmt = $db->prepare("INSERT INTO Customers (customer_id,customer_code,customer_company_name,customer_report_name,registration_code,mobile,website,email,description,tic_code,vat_code,credit_limit,customer_type,balance,type_of_business,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
                    $stmt->bind_param('issssssssssssds', $customerID, $regionCustomerJson->code, $regionCustomerJson->company_name, $regionCustomerJson->report_name, $regionCustomerJson->registration_code, $regionCustomerJson->mobile, $regionCustomerJson->website, $regionCustomerJson->email, $regionCustomerJson->description, $regionCustomerJson->tic_code, $regionCustomerJson->vat_code, $regionCustomerJson->credit_limit, $regionCustomerJson->customer_type, $balance, $regionCustomerJson->type_of_business);
                    $stmt->execute();
                    if (strcmp($stmt->error, "") != 0) {$errorText .= $stmt->error; $error = true;}
                    $stmt->close();
                }

                if(!$error) {
                    $b2bUserID = getNextKey("B2B_User", "b2b_user_id");
                    $stmt = $db->prepare("INSERT INTO B2B_User (b2b_user_id,customer_id,default_address_id,username,identifier,email,first_name,last_name,mobile,show_stock, show_prices,B2C_User, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
                    $stmt->bind_param('iiisssssssss', $b2bUserID, $customerID, $customerAddressID, $user->username, $user->identifier, $user->email, $user->first_name, $user->last_name, $user->mobile, $user->show_stock, $user->show_prices, $user->B2C_User);
                    $stmt->execute();
                    if (strcmp($stmt->error, "") != 0) {$errorText .= $stmt->error; $error = true;}
                    $stmt->close();
                }

                if($error){
                    $db->rollback();
                    echo "<center><br><h3>504</h3>$errorText</center>";
                } else {
                    $db->commit(true);
                    redirect($redirectUrl);
                }

            } catch (Exception  $e) {
                $db->rollback();
                redirect($redirectUrl);
            }

        }
    } else {
        if(strcmp($b2bUserEmail,'')==0){
            echo "<center><br><h3>404: Missing email address of user.</h3><br></center>";
            echo "<center><button style='cursor:pointer;padding:10px;background-color:white;border: 2px solid white; border-radius: 10px;box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;' onclick='history.back();'>< Go Back</button></center>";
        } else {
            echo "<center><br><h3>404: Missing Credentials.</h3><br></center>";
            echo "<center><button style='cursor:pointer;padding:10px;background-color:white;border: 2px solid white; border-radius: 10px;box-shadow: rgba(50, 50, 93, 0.25) 0px 50px 100px -20px, rgba(0, 0, 0, 0.3) 0px 30px 60px -30px, rgba(10, 37, 64, 0.35) 0px -2px 6px 0px inset;' onclick='history.back();'>< Go Back</button></center>";
        }
    }



}
else if(strcmp($send,'tCopSend')==0) {

    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $hasUser = false;
    $hasCustomer = false;

    $stmt = $db->prepare("SELECT b2b_user_id, customer_id, default_address_id, username, identifier, email, active, first_name, last_name, phone, mobile, show_promo, show_stock, show_prices, show_sc_replies, token, login_times, acceptance1, acceptance2, B2C_User FROM B2B_User WHERE B2B_User.customer_id=? AND B2B_User.b2b_user_id=? LIMIT 1");
    $stmt->bind_param("ii", $customerID, $userID);
    $stmt->execute();
    $stmt->bind_result($b2b_user_id, $customer_id, $default_address_id, $b2b_username, $b2b_identifier, $email, $active, $first_name, $last_name, $phone, $mobile, $show_promo, $show_stock, $show_prices, $show_sc_replies, $token, $login_times, $acceptance1, $acceptance2, $B2C_User);
    if ($stmt->fetch()) {
        $hasUser = true;
    }
    $stmt->close();

    if ($hasUser && $customer_id > 0) {
        $stmt = $db->prepare("SELECT customer_id, customer_code, customer_company_name, customer_report_name, logo, registration_code, mobile, website, email, description, type_of_business, tic_code, vat_code, credit_limit, address_code_eurosoft, customer_type FROM Customers WHERE customer_id=? LIMIT 1");
        $stmt->bind_param("i", $customer_id);
        $stmt->execute();
        $stmt->bind_result($customer_id, $customer_code, $customer_company_name, $customer_report_name, $logo, $registration_code, $mobile, $website, $email, $description, $type_of_business, $tic_code, $vat_code, $credit_limit, $address_code_eurosoft, $customer_type);
        if ($stmt->fetch()) {
            $hasCustomer = true;
        }
        $stmt->close();
    }

    if ($hasCustomer && $customer_id > 0 && $hasUser && $b2b_user_id > 0) {

        $user = new stdClass();
        $user->username = "$b2b_username";
        $user->identifier = "$b2b_identifier";
        $user->email = "$email";
        $user->active = "$active";
        $user->first_name = "$first_name";
        $user->last_name = "$last_name";
        $user->phone = "$phone";
        $user->mobile = "$mobile";
        $user->show_promo = "$show_promo";
        $user->show_stock = "$show_stock";
        $user->show_prices = "$show_prices";
        $user->show_sc_replies = "$show_sc_replies";
        $user->token = $token;
        $user->login_times = "$login_times";
        $user->acceptance1 = "$acceptance1";
        $user->acceptance2 = "$acceptance2";
        $user->B2C_User = "$B2C_User";

        $customer = new stdClass();
        $customer->code = $regionPrefix . '-' . $customer_code;
        $customer->company_name = "$customer_company_name";
        $customer->report_name = "$customer_report_name";
        $customer->logo = "$logo";
        $customer->registration_code = "$registration_code";
        $customer->mobile = "$mobile";
        $customer->website = "$website";
        $customer->email = "$email";
        $customer->description = "$description";
        $customer->type_of_business = "$type_of_business";
        $customer->tic_code = "$tic_code";
        $customer->vat_code = "$vat_code";
        $customer->credit_limit = "$credit_limit";
        $customer->address_code_eurosoft = "$address_code_eurosoft";
        $customer->customer_type = "$customer_type";
        $customer->user = $user;

        $postRequest = array('copSend'=>'tCopReceive','domain'=>"$domainURL",'copCust'=>json_encode($customer));

        redirect_post($postURL, $postRequest);


    } else {
        redirect($redirectUrl);
    }

}
else {
    redirect($redirectUrl);
}

function redirect($url){
    die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
}

function redirect_post($url, $data=array(), $headers = null) {
    $params = [
        'http' => [
            'method' => 'POST',
            'content' => http_build_query($data)
        ]
    ];

    if (!is_null($headers)) {
        $params['http']['header'] = '';
        foreach ($headers as $k => $v) {
            $params['http']['header'] .= "$k: $v\n";
        }
    }

    $ctx = stream_context_create($params);
    $fp = @fopen($url, 'rb', false, $ctx);

    if ($fp) {
        echo @stream_get_contents($fp);
        die();
    } else {
        $php_errormsg = json_encode(error_get_last());
        echo "Error loading '$url', $php_errormsg <br>";
    }
}
?>