<?php
include_once('../../param.php');
session_start();
$_SESSION['AMT']='';
$customerID = intval($_SESSION['customerID']);
$userID= intval($_SESSION['userID']);
$amount = floatval($_POST['amountToPay']);
$_SESSION['AMT']=$amount;



if(isset($customerID) && $customerID > 0 && isset($userID) && $userID > 0 && $amount > 0) {
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT merchant_id,password,currency_iso_code,post_url FROM B2C_Payment_Methods WHERE payment_method_code = 'JCC_V2' LIMIT 1");
    $stm->execute();
    $stm->bind_result($userNameJCC, $passwordJCC, $currencyJCC,$postURL);
    while ($stm->fetch()) {}
    $stm->close();

    $stm = $db->prepare("SELECT customer_code,balance FROM Customers WHERE customer_id = ? LIMIT 1");
    $stm->bind_param('i',$customerID);
    $stm->execute();
    $stm->bind_result($customerCode,$prevBalance);
    while ($stm->fetch()) {}
    $stm->close();

    $d = new DateTime("now", new DateTimeZone("Europe/Athens"));
    $time = $d->format("dmy-His");

    $orderCode = "BP-$customerCode-$time";

    $orderCode = make_greeklish($orderCode);
    $orderCode = transliterateString($orderCode);

    $customerBalanceID = 0;
    $newBalance = floatval($prevBalance) - $amount;
    $amount = round($amount*100);

    $returnURL = "https://".HTML_PATH."/cop/b2b/jccV2/successOnBalance.php?UID=$userID&CID=$customerID&AMT=$amount";
    $apiURL = "$postURL/rest/register.do";

    $ch = curl_init();
    curl_setopt_array($ch, array(
        CURLOPT_URL => "$apiURL",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => array('userName' => "$userNameJCC",'password' => "$passwordJCC",'orderNumber' => "$orderCode",'amount' => "$amount",'language' => 'en','returnUrl'=>"$returnURL",'currency'=>"$currencyJCC"),
    ));
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        $jccOrderID = 0;
        $urlToPaid = '';
        $jccError = curl_error($ch);
        $paymentRedirects =1;
        $customerBalanceID = logJccOrderTransactions($db,$customerID,$userID,$prevBalance,floatval(intval($amount)/100),$newBalance,$jccOrderID,$paymentRedirects,$urlToPaid,$jccError,$orderCode,$customerBalanceID);
    } else {
        $body = json_decode($response, true);
        $urlToPaid = '';
        $jccOrderID = '';
        if(isset($body['formUrl'])){$urlToPaid = $body['formUrl'];}
        if(isset($body['orderId'])){$jccOrderID = $body['orderId'];}
        $_SESSION['JCCIDV2']=$jccOrderID;
        $_SESSION['orderCodeJCCV2']=$orderCode;
        if (strcmp("$urlToPaid",'')!=0){
            $jccError = '';
            $paymentRedirects =1;
            $customerBalanceID = logJccOrderTransactions($db,$customerID,$userID,$prevBalance,floatval(intval($amount)/100),$newBalance,$jccOrderID,$paymentRedirects,$urlToPaid,$jccError,$orderCode,$customerBalanceID);
            $_SESSION['customerBalanceID']=$customerBalanceID;
            header("Location: $urlToPaid");
        }else{
            $stm = $db->prepare("SELECT jcc_order_id,jcc_redirect_url,payment_redirects FROM B2B_JCC_V2_Customer_Balance WHERE customer_balance_id='$customerBalanceID' LIMIT 1");
            $stm->execute();
            $stm->bind_result($jccOrderID,$urlToPaid,$paymentRedirects);
            while ($stm->fetch()) {}
            $stm->close();

            $paymentRedirects++;

            $returnURL = "https://".HTML_PATH."/cop/b2b/jccV2/successOnBalance.php?UID=$userID&CID=$customerID&AMT=$amount";
            $apiURL = "$postURL/rest/register.do";

            $ch = curl_init();
            curl_setopt_array($ch, array(
                CURLOPT_URL => "$apiURL",
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => array('userName' => "$userNameJCC",'password' => "$passwordJCC",'orderNumber' => "$orderCode",'amount' => "$amount",'language' => 'en','returnUrl'=>"$returnURL",'currency'=>"$currencyJCC"),
            ));
            $response = curl_exec($ch);

            if (curl_errno($ch)) {
                $jccOrderID = 0;
                $urlToPaid = '';
                $jccError = curl_error($ch);
                $customerBalanceID = logJccOrderTransactions($db,$customerID,$userID,$prevBalance,floatval(intval($amount)/100),$newBalance,$jccOrderID,$paymentRedirects,$urlToPaid,$jccError,$orderCode,$customerBalanceID);
            }
            $body = json_decode($response, true);
            $urlToPaid = '';
            $jccOrderID = '';
            if(isset($body['formUrl'])){$urlToPaid = $body['formUrl'];}
            if(isset($body['orderId'])){$jccOrderID = $body['orderId'];}
            if (strcmp("$urlToPaid",'')!=0){
                $_SESSION['JCCIDV2']=$jccOrderID;
                $_SESSION['orderCodeJCCV2']=$orderCode;
                $jccError = 'Created';
                $customerBalanceID = logJccOrderTransactions($db,$customerID,$userID,$prevBalance,floatval(intval($amount)/100),$newBalance,$jccOrderID,$paymentRedirects,$urlToPaid,$jccError,$orderCode,$customerBalanceID);
                $_SESSION['customerBalanceID']=$customerBalanceID;
                header("Location: $urlToPaid");
            } else {
                $jccError = ''.json_encode($body);
                $customerBalanceID = logJccOrderTransactions($db,$customerID,$userID,$prevBalance,floatval(intval($amount)/100),$newBalance,$jccOrderID,$paymentRedirects,$urlToPaid,$jccError,$orderCode,$customerBalanceID);
            }
        }
    }
    curl_close($ch);
}
function logJccOrderTransactions($db,$customerID,$userID,$prevBalance,$payment,$newBalance,$jccOrderID,$paymentRedirects,$urlToPaid,$jccError,$orderCode,$customerBalanceID=0){

    if(intval($customerBalanceID) > 0){
        $stmt = $db->prepare("UPDATE B2B_JCC_V2_Customer_Balance SET order_code=?,jcc_order_id=?,jcc_redirect_url=?,jcc_status=?,payment_redirects=?,new_balance=? WHERE customer_balance_id = ?");
        $stmt->bind_param('ssssssi',$orderCode,$jccOrderID,$urlToPaid,$jccError,$paymentRedirects,$newBalance,$customerBalanceID);
        $stmt->execute();
        $stmt->close();
    } else {
        $stmt = $db->prepare("INSERT INTO B2B_JCC_V2_Customer_Balance ( customer_id, user_id, order_code, prev_balance, payment, new_balance, jcc_order_id, payment_redirects, jcc_redirect_url, jcc_status, timestamp) values (?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iissssssss',$customerID,$userID,$orderCode,$prevBalance,$payment,$newBalance,$jccOrderID,$paymentRedirects,$urlToPaid,$jccError);
        $stmt->execute();
        $customerBalanceID = $stmt->insert_id;
        $stmt->close();
    }
    return $customerBalanceID;

}


function make_greeklish($text) {
    $expressions = array(
        '/[αΑ][ιίΙΊ]/u' => 'e',
        '/[οΟΕε][ιίΙΊ]/u' => 'i',
        '/[αΑ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'af$1',
        '/[αΑ][υύΥΎ]/u' => 'av',
        '/[εΕ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'ef$1',
        '/[εΕ][υύΥΎ]/u' => 'ev',
        '/[οΟ][υύΥΎ]/u' => 'ou',
        '/(^|\s)[μΜ][πΠ]/u' => '$1b',
        '/[μΜ][πΠ](\s|$)/u' => 'b$1',
        '/[μΜ][πΠ]/u' => 'mp',
        '/[νΝ][τΤ]/u' => 'nt',
        '/[τΤ][σΣ]/u' => 'ts',
        '/[τΤ][ζΖ]/u' => 'tz',
        '/[γΓ][γΓ]/u' => 'ng',
        '/[γΓ][κΚ]/u' => 'gk',
        '/[ηΗ][υΥ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'if$1',
        '/[ηΗ][υΥ]/u' => 'iu',
        '/[θΘ]/u' => 'th',
        '/[χΧ]/u' => 'ch',
        '/[ψΨ]/u' => 'ps',
        '/[αά]/u' => 'a',
        '/[βΒ]/u' => 'v',
        '/[γΓ]/u' => 'g',
        '/[δΔ]/u' => 'd',
        '/[εέΕΈ]/u' => 'e',
        '/[ζΖ]/u' => 'z',
        '/[ηήΗΉ]/u' => 'i',
        '/[ιίϊΙΊΪ]/u' => 'i',
        '/[κΚ]/u' => 'k',
        '/[λΛ]/u' => 'l',
        '/[μΜ]/u' => 'm',
        '/[νΝ]/u' => 'n',
        '/[ξΞ]/u' => 'x',
        '/[οόΟΌ]/u' => 'o',
        '/[πΠ]/u' => 'p',
        '/[ρΡ]/u' => 'r',
        '/[σςΣ]/u' => 's',
        '/[τΤ]/u' => 't',
        '/[υύϋΥΎΫ]/u' => 'i',
        '/[φΦ]/iu' => 'f',
        '/[ωώ]/iu' => 'o',
    );

    $text = preg_replace( array_keys($expressions), array_values($expressions), $text);
    return $text;
}

function transliterateString($txt) {
    $transliterationTable = array('á' => 'a', 'Á' => 'A', 'à' => 'a', 'À' => 'A', 'ă' => 'a', 'Ă' => 'A', 'â' => 'a', 'Â' => 'A', 'å' => 'a', 'Å' => 'A', 'ã' => 'a', 'Ã' => 'A', 'ą' => 'a', 'Ą' => 'A', 'ā' => 'a', 'Ā' => 'A', 'ä' => 'ae', 'Ä' => 'AE', 'æ' => 'ae', 'Æ' => 'AE', 'ḃ' => 'b', 'Ḃ' => 'B', 'ć' => 'c', 'Ć' => 'C', 'ĉ' => 'c', 'Ĉ' => 'C', 'č' => 'c', 'Č' => 'C', 'ċ' => 'c', 'Ċ' => 'C', 'ç' => 'c', 'Ç' => 'C', 'ď' => 'd', 'Ď' => 'D', 'ḋ' => 'd', 'Ḋ' => 'D', 'đ' => 'd', 'Đ' => 'D', 'ð' => 'dh', 'Ð' => 'Dh', 'é' => 'e', 'É' => 'E', 'è' => 'e', 'È' => 'E', 'ĕ' => 'e', 'Ĕ' => 'E', 'ê' => 'e', 'Ê' => 'E', 'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'ė' => 'e', 'Ė' => 'E', 'ę' => 'e', 'Ę' => 'E', 'ē' => 'e', 'Ē' => 'E', 'ḟ' => 'f', 'Ḟ' => 'F', 'ƒ' => 'f', 'Ƒ' => 'F', 'ğ' => 'g', 'Ğ' => 'G', 'ĝ' => 'g', 'Ĝ' => 'G', 'ġ' => 'g', 'Ġ' => 'G', 'ģ' => 'g', 'Ģ' => 'G', 'ĥ' => 'h', 'Ĥ' => 'H', 'ħ' => 'h', 'Ħ' => 'H', 'í' => 'i', 'Í' => 'I', 'ì' => 'i', 'Ì' => 'I', 'î' => 'i', 'Î' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ĩ' => 'i', 'Ĩ' => 'I', 'į' => 'i', 'Į' => 'I', 'ī' => 'i', 'Ī' => 'I', 'ĵ' => 'j', 'Ĵ' => 'J', 'ķ' => 'k', 'Ķ' => 'K', 'ĺ' => 'l', 'Ĺ' => 'L', 'ľ' => 'l', 'Ľ' => 'L', 'ļ' => 'l', 'Ļ' => 'L', 'ł' => 'l', 'Ł' => 'L', 'ṁ' => 'm', 'Ṁ' => 'M', 'ń' => 'n', 'Ń' => 'N', 'ň' => 'n', 'Ň' => 'N', 'ñ' => 'n', 'Ñ' => 'N', 'ņ' => 'n', 'Ņ' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ò' => 'o', 'Ò' => 'O', 'ô' => 'o', 'Ô' => 'O', 'ő' => 'o', 'Ő' => 'O', 'õ' => 'o', 'Õ' => 'O', 'ø' => 'oe', 'Ø' => 'OE', 'ō' => 'o', 'Ō' => 'O', 'ơ' => 'o', 'Ơ' => 'O', 'ö' => 'oe', 'Ö' => 'OE', 'ṗ' => 'p', 'Ṗ' => 'P', 'ŕ' => 'r', 'Ŕ' => 'R', 'ř' => 'r', 'Ř' => 'R', 'ŗ' => 'r', 'Ŗ' => 'R', 'ś' => 's', 'Ś' => 'S', 'ŝ' => 's', 'Ŝ' => 'S', 'š' => 's', 'Š' => 'S', 'ṡ' => 's', 'Ṡ' => 'S', 'ş' => 's', 'Ş' => 'S', 'ș' => 's', 'Ș' => 'S', 'ß' => 'SS', 'ť' => 't', 'Ť' => 'T', 'ṫ' => 't', 'Ṫ' => 'T', 'ţ' => 't', 'Ţ' => 'T', 'ț' => 't', 'Ț' => 'T', 'ŧ' => 't', 'Ŧ' => 'T', 'ú' => 'u', 'Ú' => 'U', 'ù' => 'u', 'Ù' => 'U', 'ŭ' => 'u', 'Ŭ' => 'U', 'û' => 'u', 'Û' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ű' => 'u', 'Ű' => 'U', 'ũ' => 'u', 'Ũ' => 'U', 'ų' => 'u', 'Ų' => 'U', 'ū' => 'u', 'Ū' => 'U', 'ư' => 'u', 'Ư' => 'U', 'ü' => 'ue', 'Ü' => 'UE', 'ẃ' => 'w', 'Ẃ' => 'W', 'ẁ' => 'w', 'Ẁ' => 'W', 'ŵ' => 'w', 'Ŵ' => 'W', 'ẅ' => 'w', 'Ẅ' => 'W', 'ý' => 'y', 'Ý' => 'Y', 'ỳ' => 'y', 'Ỳ' => 'Y', 'ŷ' => 'y', 'Ŷ' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y', 'ź' => 'z', 'Ź' => 'Z', 'ž' => 'z', 'Ž' => 'Z', 'ż' => 'z', 'Ż' => 'Z', 'þ' => 'th', 'Þ' => 'Th', 'µ' => 'u', 'а' => 'a', 'А' => 'a', 'б' => 'b', 'Б' => 'b', 'в' => 'v', 'В' => 'v', 'г' => 'g', 'Г' => 'g', 'д' => 'd', 'Д' => 'd', 'е' => 'e', 'Е' => 'E', 'ё' => 'e', 'Ё' => 'E', 'ж' => 'zh', 'Ж' => 'zh', 'з' => 'z', 'З' => 'z', 'и' => 'i', 'И' => 'i', 'й' => 'j', 'Й' => 'j', 'к' => 'k', 'К' => 'k', 'л' => 'l', 'Л' => 'l', 'м' => 'm', 'М' => 'm', 'н' => 'n', 'Н' => 'n', 'о' => 'o', 'О' => 'o', 'п' => 'p', 'П' => 'p', 'р' => 'r', 'Р' => 'r', 'с' => 's', 'С' => 's', 'т' => 't', 'Т' => 't', 'у' => 'u', 'У' => 'u', 'ф' => 'f', 'Ф' => 'f', 'х' => 'h', 'Х' => 'h', 'ц' => 'c', 'Ц' => 'c', 'ч' => 'ch', 'Ч' => 'ch', 'ш' => 'sh', 'Ш' => 'sh', 'щ' => 'sch', 'Щ' => 'sch', 'ъ' => '', 'Ъ' => '', 'ы' => 'y', 'Ы' => 'y', 'ь' => '', 'Ь' => '', 'э' => 'e', 'Э' => 'e', 'ю' => 'ju', 'Ю' => 'ju', 'я' => 'ja', 'Я' => 'ja');
    return str_replace(array_keys($transliterationTable), array_values($transliterationTable), $txt);
}
?>

