<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");

$table = 'Orders';
$primaryKey = "order_code";

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
 

$columns = array(
    array( 'db' => '`o`.`order_id`', 'dt' =>  'id', 'formatter' => function( $d, $row ) {$GLOBALS['order_id']=$d;return $d;}, 'field' =>'order_id' ),
    array( 'db' => '`o`.`order_code`', 'dt' =>  'code', 'field' =>'order_code' ),
    array( 'db' => '`o`.`order_date`', 'dt' => 'date' , 'field' => 'order_date' ),
    array( 'db' => '`o`.`delivery_date`', 'dt' => 'ddate' ,'field' => 'delivery_date' ),
    array( 'db' => '`o`.`status`', 'dt' =>  'status', 'field' =>'status' ),
    array( 'db' => '`o`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) use ($db) {

        $orderID = $GLOBALS['order_id'];
        $displayGrandTotal = CURRENCY_SYMBOL .''.  strval(number_format(floatval($d),2));

        $stm = $db->prepare("SELECT grand_total_currency,currency_sign FROM Multi_Currency_Orders WHERE Multi_Currency_Orders.order_id='$orderID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($grandTotalCurrency,$currencySign);
        while ($stm->fetch()) {
            if($grandTotalCurrency >  0){$displayGrandTotal = $currencySign.''.number_format(floatval($grandTotalCurrency),2);}
        }
        $stm-> close();

        return $displayGrandTotal;

    }, 'field' => 'grand_total' ),

    array( 'db' => '`o`.`order_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {

        return '2nd api call button Development';
//        return '<form id="'.$d.'"action="viewsingleorder.php" method="post">
//           		<input type="hidden" name="orderID" value="'.$d.'"><center>
//			<button  type="submit" class="btn btn-primary" style="font-size:13px;border-radius: 20%;"><i class="fa fa-eye"></i></button>
//			</form>';

    }, 'field' => 'order_id' )
);


$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 


$stm = $db->prepare("SELECT anonymous_checkout_customer_id FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($anonymousCustomerForCheckoutID);
while ($stm->fetch()) {}
$stm-> close();

if(strcmp($anonymousCustomerForCheckoutID,'')==0){$anonymousCustomerForCheckoutID = 0;}

$customerID =$_SESSION['customerID'];

$joinQuery = "FROM `Orders` AS `o` LEFT JOIN `Customers` AS `c` ON (`o`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`o`.`salesperson_id` = `s`.`salesperson_id`)";
$where = "`o`.`customer_id`='$customerID' AND NOT `o`.`customer_id`='$anonymousCustomerForCheckoutID'";
require( 'ssp2.class.php' );



$getColumns = '';
foreach ($columns as $key => $value) {
    $getColumns .= '{"data":"'.$value['dt'].'","orderable":"true"},';
}
$getColumns = '['.substr($getColumns, 0, -1).']';

if($_POST['order'] == null) {
    $_POST['order'] = '[{"column":"2","dir":"desc"},{"column":"1","dir":"desc"}]';
}


$_POST['order']   = json_decode($_POST['order'],true);
$_POST['columns'] = json_decode($getColumns,true);

$loggedInUserID = intval($_SESSION['userID']);
$loggedInCustomerID = intval($_SESSION['customerID']);

if(isset($loggedInUserID) && $loggedInUserID > 0 && isset($loggedInCustomerID) && $loggedInCustomerID > 0){
    $loggedin = 'true';
} else {
    $loggedin = 'false';
}

$object = new stdClass();
$object->orders = SSP::simple( $_POST, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where);
$object->loggedin = $loggedin;

echo json_encode($object);

?>