<?php
session_start();
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../param.php");
require("dbhelper.php");
// DB table to use
$table = 'Orders';
 
// Table's primary key
$primaryKey = "order_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`o`.`order_id`', 'dt' =>  'id', 'formatter' => function( $d, $row ) {$GLOBALS['order_id']=$d;return'';}, 'field' =>'order_id' ),
    array( 'db' => '`o`.`order_code`', 'dt' =>  'code', 'field' =>'order_code' ),
    array( 'db' => '`o`.`order_date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'order_date' ),
    array( 'db' => '`o`.`delivery_date`', 'dt' => 'ddate' , 'formatter' => function( $d, $row ) {
        return date('d-m-Y',strtotime($d));},'field' => 'delivery_date' ),
    array( 'db' => '`o`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) {

        $orderID = $GLOBALS['order_id'];
        $displayGrandTotal = CURRENCY_SYMBOL .' '.  strval(number_format(floatval($d),2));

        global $username,$password,$database;
        $db = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT grand_total_currency,currency_sign FROM Multi_Currency_Orders WHERE Multi_Currency_Orders.order_id='$orderID' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($grandTotalCurrency,$currencySign);
        while ($stm->fetch()) {
            if($grandTotalCurrency >  0){$displayGrandTotal = $currencySign.' '.number_format(floatval($grandTotalCurrency),2);}
        }
        $stm-> close();


        return $displayGrandTotal;

    }, 'field' => 'grand_total' ),

    array( 'db' => '`o`.`status`', 'dt' =>  'status', 'field' =>'status' ),
    array( 'db' => '`o`.`order_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
        return '<form id="'.$d.'"action="viewsingleorder.php" method="post">
           		<input type="hidden" name="orderID" value="'.$d.'"><center>
			<button  type="submit" class="btn btn-primary" style="font-size:13px;border-radius: 20%;"><i class="fa fa-eye"></i></button>
			</form>';},
        'field' => 'order_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$db2 = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$stm2 = $db2->prepare("SELECT anonymous_checkout_customer_id FROM B2B_Configuration");
$stm2-> execute();
$stm2-> bind_result($anonymousCustomerForCheckoutID);
while ($stm2->fetch()) {}
$stm2-> close();
if(strcmp($anonymousCustomerForCheckoutID,'')==0){$anonymousCustomerForCheckoutID = 0;}

$customerID =$_SESSION['customerID'];
$joinQuery = "FROM `Orders` AS `o` LEFT JOIN `Customers` AS `c` ON (`o`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`o`.`salesperson_id` = `s`.`salesperson_id`)";
$where = "`o`.`customer_id`='$customerID' AND NOT `o`.`customer_id`='$anonymousCustomerForCheckoutID'";
require( 'ssp2.class.php' );

echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );

?>