<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);
session_start();

include_once("../../param.php");
require("dbhelper.php");
require_once("../assets/mobiledetect/Mobile_Detect.php");



$categoryID = $_POST['category'];
$selectedFilters = $_POST['selectedFilters'];
if(isset($selectedFilters) && strcmp($selectedFilters,'')!=0){
    $selectedFilterOptions = explode(',',$selectedFilters);
} else {
    $selectedFilterOptions = array();
}



if(strcmp($categoryID,'search')!=0 && is_numeric($categoryID)) {
    echo getCategoryFilters($categoryID,$selectedFilterOptions);
}

function getCategoryFilters($categoryID,$selectedFilterOptions = array()){

    if(file_exists('../langs/'.$_SESSION['lang'].'.php')) {
        include('../langs/' . $_SESSION['lang'] . '.php');
    } else {
        include('../langs/en.php');
    }

    $result = '';

    $modalStart = '
<style>
    .filters-button{
        box-shadow: rgba(0, 0, 0, 0.17) 0px -23px 25px 0px inset, rgba(0, 0, 0, 0.15) 0px -36px 30px 0px inset, rgba(0, 0, 0, 0.1) 0px -79px 40px 0px inset,   rgba(0, 0, 0, 0.09) 0px 32px 16px;
        padding: 10px 15px;
        height: fit-content;
        width: fit-content;
        border-radius: 20px;
        position: fixed;
        left: 15px;
        bottom: 15px;
        z-index: 9;
        text-transform: unset;
        transition: all 0.1s ease-in-out;

    }
</style>
<button type="button" class="btn btn-theme filters-button" onclick="$(\'#selectFiltersModal\').modal(\'show\');">
    <i class="fa fa-sliders text-color-white"></i>&nbsp; '.$langu['filters_label'].'
</button>

<!-- Modal -->
<div class="modal fade" id="selectFiltersModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header" style="padding: 5px;">  
                <div class="modal-title" >
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true" style="margin-top:1px !important;">
                <i class="fa fa-lg fa-fw fa-times"></i>
                </button>
            
                <strong style="padding-left:5px;font-size: 19px;">'.$langu['filters_label'].'</strong>
            </div>
            </div>
            <div class="modal-body custom-scroll terms-body">';

    $modalEnd = '
            </div>

            <footer class="modal-footer" style="padding: 0px;">
                <button onclick="$(\'#selectFiltersModal\').modal(\'hide\');" class="btn btn-block btn-theme" type="button" style="margin-right:10px;text-transform: unset;" >
                    '.$langu['apply_filters_label'].'
                </button>



            </footer>

        </div><!-- /.modal-content -->
    </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

';


    $script = "<script type='text/javascript'>
                    function applyCategoryOptionsFilters(){
                         $('#selectFiltersModal').modal('hide');
                         setTimeout(function(){
                             var totalNumRecords = $('#productGrid').find('#counter').val();
                             var recordsPerPage =  parseInt($('#numItemsSelect').val());
                             pagination(recordsPerPage, totalNumRecords,false);
                         }, 300);
                         
                         run_waitMe('bounce');
                         setTimeout(function(){
                             var totalNumRecords = $('#productGrid').find('#counter').val();
                             var recordsPerPage =  parseInt($('#numItemsSelect').val());
                             pagination(recordsPerPage, totalNumRecords,false); 
                         }, 1000);
                    }
               </script>";

    global $username, $password, $database;
    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");

    $stm2 = $db2->prepare("SELECT primary_language,theme FROM B2B_Configuration LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($primaryLanguage,$themeColor);
    while ($stm2->fetch()) {

    }
    $stm2-> close();

    if(strcmp($themeColor,'')!=0){
        if(strcmp($themeColor,'red')==0 || strcmp($themeColor,'Red')==0 ){
            $themeColor = "firebrick";
        }  else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
            $themeColor = "#000080";
        } else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
            $themeColor = "#1d4f9c";
        }  else if(strcmp($themeColor,'gold')==0 || strcmp($themeColor,'Gold')==0){
            $themeColor = "goldenrod";
        } else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'DarkSlateBlue')==0) {
            $themeColor = "#1d4f9c";
        }  else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
            $themeColor = "#000080";
        } else if(strcmp($themeColor,'black')==0 || strcmp($themeColor,'Black')==0){
            $themeColor = "black";
            $textColor = "white";
        } else if(strcmp($themeColor,'yellow')==0 || strcmp($themeColor,'Yellow')==0){
            $themeColor = "yellow";
            $textColor = "black";
        } else {
            if(strpos($themeColor,'#')===false ) {
                $themeColor = str_replace('darkdark','dark',"dark$themeColor");
            }
        }

    } else {
        $themeColor = "#6796d3";
    }



    $filters = array();
    $filterIDs = array();
    $stm2 = $db2->prepare("SELECT Filters.filter_id, Filters.filter_code, Filters.name, Filters.description, Filters.type, Filters.class, Filters.css 
                                 FROM Filters,Filter_Category 
                                 WHERE Filters.filter_id=Filter_Category.filter_id 
                                 AND (category_id='$categoryID' OR category_id=1) 
                                 AND Filters.active='yes' 
                                 ORDER BY Filter_Category.position ASC,Filters.position ASC");
    $stm2-> execute();
    $stm2-> bind_result($filterID,$filterCode,$filterName,$filterDescription,$filterType,$filterClass,$filterCss);
    while ($stm2->fetch()) {

        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($filterDescription) && strcmp($filterDescription,'')!=0 )
        {
            $filterName=$filterDescription;
        }

        $filter = new stdClass();
        $filter->id     = $filterID;
        $filter->code   = $filterCode;
        $filter->name   = $filterName;
        $filter->desc   = $filterDescription;
        $filter->type   = $filterType;
        $filter->class  = $filterClass;
        $filter->css    = $filterCss;
        $filters[$filterID] = $filter;
        array_push($filterIDs,$filterID);
    }
    $stm2-> close();

    $filterIDsImplode = implode(',',$filterIDs);

    if(strcmp($filterIDsImplode,'')!=0) {
        $filterOptions = array();
        $stm2 = $db2->prepare("SELECT filter_option_id, filter_id, option_name, description,position FROM Filter_Options WHERE filter_id IN ($filterIDsImplode) AND active='yes' ORDER BY filter_id,position ASC");
        $stm2->execute();
        $stm2->bind_result($filterOptionID,$filterID,$optionName,$optionDescription,$position);
        while ($stm2->fetch()) {
            $filterOption = new stdClass();
            $filterOption->id    = $filterOptionID;
            $filterOption->name  = $optionName;
            $filterOption->desc  = $optionDescription;
            $filterOption->range = $position;
            $filterOptions[$filterID][$filterOptionID] = $filterOption;

        }
        $stm2->close();

        foreach ($filters as $filter){


            if(isset($filterOptions[$filter->id]) && count($filterOptions[$filter->id]) == 0 && strcmp($filter->type,'price')!=0){continue;}


            $result.= "<div class='widget' style='display: block;margin: 0px;border: 2px solid whitesmoke;margin-bottom:3px;'>";

            $result.= "<h4 style='border:1px solid transparent;padding: 5px;margin: 0px; background-color: whitesmoke; color: $themeColor;' id='filterTitle-$filter->id' class='widget' onclick='$(\"#toggle$filter->id\").toggle();$(\"#icon$filter->id\").toggleClass(\"fa fa-plus fa fa-minus\");'><span style='text-transform: capitalize;'>$filter->name</span><span style='text-transform: capitalize;'><i id='icon$filter->id' class='fa fa-plus pull-right' style='color:$themeColor' ></i></span></h4>";
            $result.= "<center><table style='width: 95%;display:none;' id='toggle$filter->id'>";

            if(strcmp($filter->type,'range')==0 || strcmp($filter->type,'price')==0){

                if(strcmp($filter->type,'range')==0) {

                    $pricePrefixFLag = 'R-';

                    $minRange = reset($filterOptions[$filter->id])->range;
                    $maxRange = end($filterOptions[$filter->id])->range;

                    $minRangeDisplay = $minRange;
                    $maxRangeDisplay = $maxRange;

                } else {


                    $stm2 = $db2->prepare("SELECT b2b_price_list,b2c_price_list,show_prices_with_vat,use_as_b2c FROM B2B_Configuration LIMIT 1");
                    $stm2->execute();
                    $stm2->bind_result($b2bPriceList,$b2cPriceList,$priceWithVat,$useAsB2C);
                    while ($stm2->fetch()) {}
                    $stm2->close();

                    $stm2 = $db2->prepare("SELECT pricetype_id FROM PriceTypes WHERE default_type='yes' LIMIT 1 ");
                    $stm2->execute();
                    $stm2->bind_result($defaultPriceTypeID);
                    while ($stm2->fetch()) {}
                    $stm2->close();


                    $categoryItems = array();
                    $stm2 = $db2->prepare("SELECT Category_Item.item_id FROM Category_Item,Items WHERE Category_Item.item_id=Items.item_id AND category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no'");
                    $stm2->execute();
                    $stm2->bind_result($categoryItemID);
                    while ($stm2->fetch()) {array_push($categoryItems,$categoryItemID);}
                    $stm2->close();

                    $categoryItemsFilter = implode(',',$categoryItems);
                    $currencySign = getCurrencySign();
                    $priceTypeID = $defaultPriceTypeID;

                    if($b2bPriceList > 0 ){$priceTypeID=$b2bPriceList;}
                    if($b2cPriceList > 0 && strcmp($useAsB2C,'yes')==0){$priceTypeID=$b2bPriceList;}

                    $pricePrefixFLag = "P-$categoryID-$priceTypeID-";

                    if($priceTypeID > 0 && strcmp($categoryItemsFilter,'')!=0) {

                        $stm2 = $db2->prepare("SELECT MAX(price),MIN(price) FROM Prices WHERE pricetype_id='$priceTypeID' AND item_id IN ($categoryItemsFilter) AND price > 0");
                        $stm2->execute();
                        $stm2->bind_result($maxPrice, $minPrice);
                        while ($stm2->fetch()) {}
                        $stm2->close();

                        if($minPrice < 1){$minPrice = 0;}
                        if($maxPrice < 1){$maxPrice = 1;}

                        $minRange = round($minPrice);
                        $maxRange = round($maxPrice);

                        $minRangeDisplay = $currencySign.number_format(round(floatval($minRange)), 2);
                        $maxRangeDisplay = $currencySign.number_format(round(floatval($maxRange)), 2);


                    } else {
                        $minRange = 1;
                        $maxRange = 100;

                        $minRangeDisplay = $currencySign.number_format(floatval($minRange), 2);
                        $maxRangeDisplay = $currencySign.number_format(floatval($maxRange), 2);
                    }

                }

                $selectedFiltersValues = '';
                $togglefilter = "";
                $minRangeValue = $minRange;
                $maxRangeValue = $maxRange;
                foreach ($selectedFilterOptions as $selectedFilterOption) {
                    $selectedFilterOptionParts = explode('-',$selectedFilterOption);
                    if($selectedFilterOptionParts[0] == 'P' && $selectedFilterOptionParts[1] == $categoryID && $selectedFilterOptionParts[2] == $priceTypeID && $selectedFilterOptionParts[3] == $filter->id){
                        $minRangeValue = $selectedFilterOptionParts[4];
                        $maxRangeValue = $selectedFilterOptionParts[5];
                        $selectedFiltersValues = $selectedFilterOption;
                        $togglefilter = "$('#filterTitle-$filter->id').click();";
                    }
                }

                $result.= "<tr>";
                $result.= "<td style='padding: 1px;text-align: left;vertical-align: top'>$minRangeDisplay</td>";
                $result.= "<td style='padding: 1px;text-align: right;vertical-align: top'>$maxRangeDisplay</td>";
                $result.= "</tr>";
                $result.= "<tr>";
                $result.= "<td style='padding-top: 12px;' colspan='2'>";

                $result.= "<style>
                            .range-slider-filter-$filter->id {height: 5px;position: relative;background-color: #e1e9f6;border-radius: 2px;}
                            .range-selected-filter-$filter->id {height: 100%;left: 0%;right: 0%;position: absolute;border-radius: 5px;background-color: $themeColor;}
                            .range-input-filter-$filter->id {position: relative;}
                            .range-input-filter-$filter->id input {position: absolute;width: 100%;height: 5px;top: -7px;background: none;pointer-events: none;-webkit-appearance: none;-moz-appearance: none;}
                            .range-input-filter-$filter->id input::-webkit-slider-thumb {margin-top:3px;height: 22px;width: 22px;border-radius: 50%;border: 7px solid $themeColor;background-color: white;pointer-events: auto;-webkit-appearance: none;}
                            .range-input-filter-$filter->id input::-moz-range-thumb {height: 15px;width: 15px;border-radius: 50%;border: 3px solid $themeColor;background-color: $themeColor;pointer-events: auto;-moz-appearance: none;}
                            .range-price-filter-$filter->id {margin: 30px 0;width: 100%;display: flex;justify-content: center;align-items: center;}
                            .range-price-filter-$filter->id label {margin-right: 5px;color: rgba(0,0,0,0.5);}
                            .range-price-filter-$filter->id input {width: 90px;padding: 5px;text-align: center;border-radius: 20px;border-color: rgba(0,0,0,0.19) !important;}
                            .range-price-filter-$filter->id input:first-of-type {margin-right: 15px;}
                            </style>";

                $result.= "<div class='range-filter-$filter->id'>
                               <div class='range-slider-filter-$filter->id'>
                                 <span class='range-selected-filter-$filter->id'></span>
                               </div>
                               <div class='range-input-filter-$filter->id'>
                                 <input type='range' class='min-filter-$filter->id' min='$minRange' max='$maxRange' value='$minRangeValue' step='1'>
                                 <input type='range' class='max-filter-$filter->id' min='$minRange' max='$maxRange' value='$maxRangeValue' step='1'>
                               </div>
                               <div class='range-price-filter-$filter->id'>      
                                 <label for='min'>Min</label>
                                 <input type='number' name='min-filter-$filter->id' id='min-filter-$filter->id' value='$minRangeValue' style='cursor: default;' disabled>      
                                 <label for='max'>Max</label>
                                 <input type='number' name='max-filter-$filter->id' id='max-filter-$filter->id' value='$maxRangeValue' style='cursor: default;' disabled>      
                               </div>
                             </div>";

                $result.= "</td>";
                $result.= "</tr>";
                $result.= "<tr>";
                $result.= "<td style='padding-top: 12px;' colspan='2'><br></td>";
                $result.= "</tr>";

                $script .= "<input type='hidden' value='$selectedFiltersValues' id='selectedRangeForFilter$filter->id' class='optionFilterValueInputs'>
                            <script type='text/javascript'>
                               console.log('selectedFiltersValues PRICE: ' + '$selectedFiltersValues');

                                $togglefilter
                                var rangeMin = 0;
                                var range = document.querySelector('.range-selected-filter-$filter->id');
                                var rangeInput = document.querySelectorAll('.range-input-filter-$filter->id input');
                                var rangePrice = document.querySelectorAll('.range-price-filter-$filter->id input');
                                rangeInput.forEach((input) => {
                                    let minRange = parseFloat(rangeInput[0].value);
                                    let maxRange = parseFloat(rangeInput[1].value);
                                    if (maxRange - minRange < rangeMin) {     
                                      if (e.target.className === 'min-filter-$filter->id') {
                                        rangeInput[0].value = maxRange - rangeMin;        
                                      } else {
                                        rangeInput[1].value = minRange + rangeMin;        
                                      }
                                    } else {
                                      rangePrice[0].value = minRange;
                                      rangePrice[1].value = maxRange;
                                      range.style.left = (minRange / rangeInput[0].max) * 100 + '%';
                                      range.style.right = 100 - (maxRange / rangeInput[1].max) * 100 + '%';
                                    }
                                  input.addEventListener('input', (e) => {
                                    let minRange = parseFloat(rangeInput[0].value);
                                    let maxRange = parseFloat(rangeInput[1].value);
                                    if (maxRange - minRange < rangeMin) {     
                                      if (e.target.className === 'min-filter-$filter->id') {
                                        rangeInput[0].value = maxRange - rangeMin;        
                                      } else {
                                        rangeInput[1].value = minRange + rangeMin;        
                                      }
                                    } else {
                                      rangePrice[0].value = minRange;
                                      rangePrice[1].value = maxRange;
                                      range.style.left = (minRange / rangeInput[0].max) * 100 + '%';
                                      range.style.right = 100 - (maxRange / rangeInput[1].max) * 100 + '%';
                                    }
                                  });
                                  input.addEventListener('mouseup', range".$filter->id."Change);
                                });

                               
                                
                                function range".$filter->id."Change(){
                                    var min = $('#min-filter-$filter->id').val();
                                    var max = $('#max-filter-$filter->id').val();
                                    var values = '$pricePrefixFLag' + '$filter->id' + '-' + min + '-' + max;
                                    
                                    $('#selectedRangeForFilter$filter->id').val(values);
                                    applyCategoryOptionsFilters()
                                }
                             </script>
                             ";

            } else {
                switch ($filter->type) {
                    case 'checkbox':
                        $selectedFiltersValues = '';
                        $togglefilter = "";
                        foreach ($selectedFilterOptions as $selectedFilterOption) {
                            $selectedFilterOptionParts = explode('-',$selectedFilterOption);
                            if($selectedFilterOptionParts[0] == 'M' && $selectedFilterOptionParts[1] == $filter->id){
                                $selectedFiltersValues .= $selectedFilterOption.',';
                                $togglefilter = "$('#filterTitle-$filter->id').click();";
                            }
                        }
                        $selectedFiltersValues = rtrim($selectedFiltersValues,',');
                        $script .= "<input type='hidden' value='$selectedFiltersValues' id='selectedcheckboxesForFilter$filter->id' class='optionFilterValueInputs'>
                                    <script type='text/javascript'>
                                        $togglefilter
                                        function check".$filter->id."Checkboxes(checkBoxClass){
                                            var checkboxes = $('.' + checkBoxClass + ':checkbox:checked').map(function() {return this.value;}).get();
                                            var values = checkboxes.join(',');
                                            $('#selectedcheckboxesForFilter$filter->id').val(values);
                                            applyCategoryOptionsFilters()
                                        }
                                    </script>";
                        break;
                    case 'radio':
                        $selectedFiltersValues = '';
                        $togglefilter = "";
                        foreach ($selectedFilterOptions as $selectedFilterOption) {
                            $selectedFilterOptionParts = explode('-',$selectedFilterOption);
                            if($selectedFilterOptionParts[0] == 'S' && $selectedFilterOptionParts[1] == $filter->id){
                                $selectedFiltersValues = $selectedFilterOption;
                                $togglefilter = "$('#filterTitle-$filter->id').click();";
                            }
                        }
                        $selectedFiltersValues = rtrim($selectedFiltersValues,',');

                        $script .= "<input type='hidden' value='$selectedFiltersValues' id='selectedRadioForFilter$filter->id' class='optionFilterValueInputs'>
                                    <script type='text/javascript'>
                                        $togglefilter
                                        function check".$filter->id."Radio(radioElement){
                                            var values = $(radioElement).val();
                                            $('#selectedRadioForFilter$filter->id').val(values);
                                            applyCategoryOptionsFilters()
                                        }
                                    </script>";

                        $result .= "<tr>
                                            <td style='padding: 3px !important;padding-left: 20px !important;width: 1%;'>
                                                <input type='radio' style='width: 20px;height: 20px;margin-top:6px;accent-color: $themeColor;' id='option$optionID' name='options$filter->id' class='categoryFilterOptions$filter->id' value='' onclick='check".$filter->id."Radio(this)' checked/>
                                            </td>
                                            <td style='color: black;padding: 1px !important;'>All $filter->name</td>
                                        </tr>";
                        break;
                }

                foreach ($filterOptions[$filter->id] as $optionID => $option) {
                    $name = $option->name;

                    switch ($filter->type) {
                        case 'checkbox':

                            if(in_array("M-$filter->id-$optionID",$selectedFilterOptions)){
                                $checked = 'checked="checked"';
                            } else {
                                $checked = '';
                            }
                            $result .= "<tr>
                                            <td style='padding: 3px !important;padding-left: 20px !important;width: 1%;'>
                                                <input type='checkbox' style='width: 20px;height: 20px;margin-top:6px;accent-color: $themeColor !important;' id='option$optionID' class='categoryFilterOptions$filter->id' value='M-$filter->id-$optionID' onclick='check".$filter->id."Checkboxes(\"categoryFilterOptions$filter->id\");' $checked />
                                            </td>
                                            <td style='color: black;padding: 1px !important;'>$name</td>
                                        </tr>";

                            break;
                        case 'radio':

                            if(strcmp($selectedFiltersValues,"")==0){
                                $checked = '';
                            } else {
                                if(strcmp($selectedFiltersValues,"S-$filter->id-$optionID")==0){
                                    $checked = 'checked="checked"';
                                } else {
                                    $checked = '';
                                }
                            }
                            $result .= "<tr>
                                            <td style='padding: 3px !important;padding-left: 20px !important;width: 1%;'>
                                                <input type='radio' style='width: 20px;height: 20px;margin-top:6px;accent-color: $themeColor;' id='option$optionID' name='options$filter->id' class='categoryFilterOptions$filter->id' value='S-$filter->id-$optionID' onclick='check".$filter->id."Radio(this)' $checked/>
                                            </td>
                                            <td style='color: black;padding: 1px !important;'>$name</td>
                                        </tr>";

                            break;
                    }
                }

            }



            $result.= "</table>";
            $result.= "</div>";

        }

    }

    $detect = new Mobile_Detect;
    $isMobile = false;
    if ( $detect->isMobile() ) {
        $isMobile = true;
    }
    if($isMobile && strcmp($result,'')!=0){
        return $modalStart.$result.$script.$modalEnd;
    } else {
        return $result.$script;

    }
}

function getSubCategoriesAsFilters($categoryID,$name,$description,$level,$showLevel){
    $result = '';
    if($level <= $showLevel) {

        global $username, $password, $database;

        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $stm2 = $db2->prepare("SELECT primary_language FROM B2B_Configuration LIMIT 1");
        $stm2-> execute();
        $stm2-> bind_result($primaryLanguage);
        while ($stm2->fetch()) {}
        $stm2-> close();

        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT Categories.category_id,name,description FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ORDER BY name");
        $stm2->execute();
        $stm2->bind_result($subCategoryID, $subName, $descriptionSub);
        while ($stm2->fetch()) {

            if (strcmp($_SESSION['lang'], $primaryLanguage) != 0 && isset($descriptionSub) && strcmp($descriptionSub, '') != 0) {
                $subName = $descriptionSub;
            }

            $subName = ucfirst(strtolower(grstrtolower($subName)));

            $db3 = new mysqli('localhost', $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $stm3 = $db3->prepare("SELECT COUNT(Categories.category_id) FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$subCategoryID\" AND Categories.category_id=Subcategories.subcategory_id");
            $stm3->execute();
            $stm3->bind_result($subCounter);
            while ($stm3->fetch()) {}
            $stm3->close();
            if ($subCounter > 0 && $level < $showLevel) {
                $nextLevel = $level + 1;
                $result .= getSubCategoriesAsFilters($subCategoryID, $subName, $descriptionSub, $nextLevel, $showLevel);
            } else {
                $result .= " <li>
                                    <a style='padding-top:3px;padding-bottom:3px;font-size:13px;text-transform:capitalize;' class='selectCategoryStandard pointer' data-index='$subCategoryID'>$subName
                                    </a>
                                </li>";
            }


        }
        $stm2->close();

    }

    return $result;

}

function uc_without_accents($string, $enc = "utf-8") {
    return strtr(mb_strtoupper($string, $enc),
        array('Ά' => 'Α', 'Έ' => 'Ε', 'Ί' => 'Ι', 'Ή' => 'Η', 'Ύ' => 'Υ',
            'Ό' => 'Ο', 'Ώ' => 'Ω', 'A' => 'A', 'A' => 'A', 'A' => 'A', 'A' => 'A',
            'Y' => 'Y','ΐ' => 'Ϊ'
        ));
}

function grstrtolower($string) {

    $string .= " ";

    $latin_check = '/[\x{0030}-\x{007f}]/u';

    if (preg_match($latin_check, $string))
    {

        $string = strtoupper($string);

    }

    $letters  								= array('α', 'β', 'γ', 'δ', 'ε', 'ζ', 'η', 'θ', 'ι', 'κ', 'λ', 'μ', 'ν', 'ξ', 'ο', 'π', 'ρ', 'σ', 'τ', 'υ', 'φ', 'χ', 'ψ', 'ω');
    $letters_accent 						= array('ά', 'έ', 'ή', 'ί', 'ό', 'ύ', 'ώ');
    $letters_upper_accent 					= array('Ά', 'Έ', 'Ή', 'Ί', 'Ό', 'Ύ', 'Ώ');
    $letters_upper_solvents 				= array('ϊ', 'ϋ');
    $letters_other 							= array('ς');

    $letters_to_uppercase					= array('Α', 'Β', 'Γ', 'Δ', 'Ε', 'Ζ', 'Η', 'Θ', 'Ι', 'Κ', 'Λ', 'Μ', 'Ν', 'Ξ', 'Ο', 'Π', 'Ρ', 'Σ', 'Τ', 'Υ', 'Φ', 'Χ', 'Ψ', 'Ω');
    $letters_accent_to_uppercase 			= array('Ά', 'Έ', 'Ή', 'Ί', 'Ό', 'Ύ', 'Ώ');
    $letters_upper_accent_to_uppercase 		= array('Α', 'Ε', 'Η', 'Ι', 'Ο', 'Υ', 'Ω');
    $letters_upper_solvents_to_uppercase 	= array('Ι', 'Υ');
    $letters_other_to_uppercase 			= array('Σ');

    $lowercase = array_merge($letters, $letters_accent, $letters_upper_accent, $letters_upper_solvents, $letters_other);
    $uppercase = array_merge($letters_to_uppercase, $letters_accent_to_uppercase, $letters_upper_accent_to_uppercase, $letters_upper_solvents_to_uppercase, $letters_other_to_uppercase);

    $uppecase_string = str_replace($uppercase,$lowercase, $string);
    $uppecase_string = str_replace('σ ', 'ς ', $uppecase_string);


    return $uppecase_string;

}

?>