<?php

if(isset($_POST['type']) && strcmp($_POST['type'],'jsonTotal')==0){
    include_once('dbhelper.php');
    echo getItemsInCartForOrder($_SESSION['orderID'],$_SESSION['customerID'])->grandTotal;
}

function getItemsInCartForOrder($orderID,$customerID)
{

    $dbOrderItems = array();
    $dbOrderDeliveryFeeItems = array();
    $dbOrderWeightFeeItems = array();
    $dbOrderSubTotal = 0;
    $dbOrderVatTotal = 0;
    $dbOrderDiscountTotal = 0;
    $dbOrderDeliveryTotal = 0;
    $dbOrderWeightFeeTotal = 0;
    $dbOrderSumWeight = 0;

    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT deposit_amount  FROM Online_Orders WHERE order_id='$orderID' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($claimedLoyaltyPointsOfOrder);
    while ($stm->fetch()) {}
    $stm-> close();

    $addItemByUnits = true;
    $stm = $db->prepare("SELECT order_qty_by_subunits FROM B2B_Configuration");
    $stm->execute();
    $stm->bind_result($orderQtyBySubunits);
    while ($stm->fetch()) {
        if(strcmp($orderQtyBySubunits,'yes')==0){
            $addItemByUnits = false;
        }
    }
    $stm->close();

    $stm = $db->prepare("SELECT Online_Order_Item.item_id,Online_Order_Item.qty,Online_Order_Item.unit_price,Online_Order_Item.line_discount,Online_Order_Item.global_discount,Online_Order_Item.description,Online_Order_Item.master_item,Items.vat_id,Online_Order_Item.promotion_id,Items.weight FROM Online_Order_Item,Items WHERE Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($itemID, $qty, $unitPrice, $lineDiscount,$globalDiscount, $lineNotes, $masterItem, $vatID, $promoID,$itemWeight);
    while ($stm->fetch()) {

        if($addItemByUnits) {
            $qty = $qty / floatval(getSubUnits($itemID));
            $lineTotal = $unitPrice*$qty;
        } else {
            $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
        }

        $dbOrderSumWeight += (float)$itemWeight*$qty;

        $vatAmount = ($lineTotal - $globalDiscount) * getVatPercentage($vatID) / 100;

        $dbOrderSubTotal += $lineTotal;
        $dbOrderVatTotal += $vatAmount;
        $dbOrderDiscountTotal += $lineDiscount + $globalDiscount;

        $dbItem = new stdClass();
        $dbItem->itemID = $itemID;
        $dbItem->qty = $qty;
        $dbItem->unitPrice = $unitPrice;
        $dbItem->vatAmount = $vatAmount;
        $dbItem->lineDiscount = $lineDiscount;
        $dbItem->globalDiscount = $globalDiscount;
        $dbItem->lineTotal = $lineTotal;
        $dbItem->description = $lineNotes;
        $dbItem->masterItem = $masterItem;
        $dbItem->vatID = $vatID;
        $dbItem->promoID = $promoID;

        array_push($dbOrderItems, $dbItem);
    }
    $stm->close();

    $deliveryFeeAndNotes=getDeliveryCost($dbOrderSubTotal,count($dbOrderItems),$customerID);
    $extraDeliveryFee=$deliveryFeeAndNotes[0];
    $deliveryFeeItemID = $deliveryFeeAndNotes[2];

    if ($extraDeliveryFee > 0) {

        $itemID = $deliveryFeeItemID;
        $vatID = getItemVatID($itemID, $db);
        $qty = 1;
        $lineDiscount = 0;
        $unitPrice = $extraDeliveryFee / getPriceRate();

        $lineTotal = ((float)$qty * (float)$unitPrice) - $lineDiscount;
        $vatAmount = $lineTotal * getVatPercentage($vatID) / 100;

        $dbOrderDeliveryTotal += $lineTotal;
        $dbOrderVatTotal += $vatAmount;
        $dbOrderDiscountTotal += $lineDiscount;

        $dbItem = new stdClass();
        $dbItem->itemID = $itemID;
        $dbItem->qty = $qty;
        $dbItem->unitPrice = $unitPrice;
        $dbItem->vatAmount = $vatAmount;
        $dbItem->lineDiscount = $lineDiscount;
        $dbItem->lineTotal = $lineTotal;
        $dbItem->description = 'Delivery Fee';
        $dbItem->masterItem = '';
        $dbItem->vatID = $vatID;
        $dbItem->promoID = 0;


        array_push($dbOrderDeliveryFeeItems, $dbItem);
    }

    $stm = $db->prepare("SELECT delivery_method FROM Online_Orders,Items WHERE concat('',Online_Orders.delivery_method * 1) = Online_Orders.delivery_method AND Online_Orders.delivery_method=Items.item_id AND Online_Orders.order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($deliveryFeeItem);
    while ($stm->fetch()) {

        $itemID = $deliveryFeeItem;
        $qty = 1;
        $lineDiscount = 0;
        $vatID = getItemVatID($itemID);
        $unitPrice = getDefaultPrice($itemID, $customerID,'',$qty) / getPriceRate();

        if ($unitPrice > 0) {

            $lineTotal = ((float)$qty * (float)$unitPrice) - $lineDiscount;
            $vatAmount = $lineTotal * getVatPercentage($vatID) / 100;

            $dbOrderDeliveryTotal += $lineTotal;
            $dbOrderVatTotal += $vatAmount;
            $dbOrderDiscountTotal += $lineDiscount;


            $dbItem = new stdClass();
            $dbItem->itemID = $itemID;
            $dbItem->qty = $qty;
            $dbItem->unitPrice = $unitPrice;
            $dbItem->vatAmount = $vatAmount;
            $dbItem->lineDiscount = $lineDiscount;
            $dbItem->lineTotal = $lineTotal;
            $dbItem->description = 'Delivery Fee';
            $dbItem->masterItem = '';
            $dbItem->vatID = $vatID;
            $dbItem->promoID = 0;


            array_push($dbOrderDeliveryFeeItems, $dbItem);

        }


    }
    $stm->close();

    $stm = $db->prepare("SELECT weight_fee_item_id FROM B2B_Configuration LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($weightFeeItem);
    while ($stm->fetch()) {}
    $stm->close();

    if((int)$weightFeeItem > 0) {
        $stm = $db->prepare("SELECT item_id,vat_id,sales_units,name FROM Items WHERE item_id='$weightFeeItem' LIMIT 1");
        $stm->execute();
        $stm->bind_result($weightFeeItemID, $weightFeeItemVatID, $weightFeeItemUOM,$weightFeeItemName);
        while ($stm->fetch()) {
            if ($dbOrderSumWeight > 0) {
                $weightFeeUnitPrice = getDefaultPrice($weightFeeItemID, $customerID,'',1) / getPriceRate();
                $weightFeeItemVat = $weightFeeUnitPrice * $dbOrderSumWeight * getVatPercentage($weightFeeItemVatID) / 100;

                $lineTotal = $dbOrderSumWeight * $weightFeeUnitPrice;

                $dbOrderWeightFeeTotal += $lineTotal;
                $dbOrderVatTotal += (float)$weightFeeItemVat;
                $dbOrderSubTotal += (float)$lineTotal;

                $dbItem = new stdClass();
                $dbItem->itemID = $weightFeeItemID;
                $dbItem->qty = $dbOrderSumWeight;
                $dbItem->unitPrice = $weightFeeUnitPrice;
                $dbItem->vatAmount = $weightFeeItemVat;
                $dbItem->lineDiscount = 0;
                $dbItem->lineTotal = $lineTotal;
                $dbItem->description = $weightFeeItemName;
                $dbItem->masterItem = '';
                $dbItem->vatID = $weightFeeItemVatID;
                $dbItem->promoID = 0;


                array_push($dbOrderWeightFeeItems, $dbItem);
            }
        }
        $stm->close();
    }


    $dbOrderSubTotal = round($dbOrderSubTotal, 2);
    $dbOrderVatTotal = round($dbOrderVatTotal, 2);
    $dbOrderDiscountTotal = round($dbOrderDiscountTotal, 2);
    $dbOrderDeliveryTotal = round($dbOrderDeliveryTotal, 2);
    $dbOrderWeightFeeTotal = round($dbOrderWeightFeeTotal, 2);

    $dbOrder = new stdClass();
    $dbOrder->orderID = $orderID;
    $dbOrder->subTotal = $dbOrderSubTotal;
    $dbOrder->deliveryTotal = $dbOrderDeliveryTotal;
    $dbOrder->weightFeeTotal = $dbOrderWeightFeeTotal;
    $dbOrder->subTotalWithDelivery = $dbOrderSubTotal + $dbOrderDeliveryTotal;
    $dbOrder->discountTotal = $dbOrderDiscountTotal;
    $dbOrder->vatTotal = $dbOrderVatTotal;
    $dbOrder->grandTotal = $dbOrderSubTotal + $dbOrderVatTotal + $dbOrderDeliveryTotal - $dbOrderDiscountTotal;
    $dbOrder->items = $dbOrderItems;
    $dbOrder->deliveryFees = $dbOrderDeliveryFeeItems;
    $dbOrder->weightFees = $dbOrderWeightFeeItems;
    $dbOrder->loyaltyPointsClaimed = $claimedLoyaltyPointsOfOrder;

    return $dbOrder;
}




?>