<?php
session_start();


include_once("../../param.php");
require("dbhelper.php");

$showPrices=true;
global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT primary_language,show_prices FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices);

while ($stm->fetch()) {
    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }
}
$stm-> close();

if(strcmp($_SESSION['lang'],"")!=0){
    include('../langs/'.$_SESSION['lang'].'.php');
} else if(strcmp($primaryLanguage,"")!=0){
    include('../langs/'.$_SESSION['lang'].'.php');
} else {
    include('../langs/en.php');
}

$onlineOrderID=$_SESSION['orderID'];
$customerID =$_SESSION['customerID'];
$companyID =$_SESSION['companyID'];
$salespersonID =$_SESSION['userID'];
$userID=$_SESSION['userID'];
$orderCode = getNextCode('Tenders','tender_code',"T","CLOUD",$db);
$dataPOST = trim(file_get_contents('php://input'));

$myfile = fopen("tata.txt", "w") or die("Unable to open file!");

fwrite($myfile, $dataPOST);
fwrite($myfile, "\n".$orderCode);
fclose($myfile);
$orderDate = date('Y/m/d', time());

$subtotal = $_POST['subtotal'];
$vatAmount=$_POST['vatAmount'];
$grandTotal=$_POST['grandTotal'];
$orderAddressID = $_POST['billAddress'];
$deliveryAddressID=$_POST['address'];

if(strcmp($orderAddressID,'')==0 || $orderAddressID == 0){
    $orderAddressID = $deliveryAddressID;
}

if(isset($_POST['details'])) {
    $details = $_POST['details'];
}
else{
    $details="";
}

$status="Placed";
$printCount=0;

$currencyID=$globalDiscountPercentage=$depositAmount=$discountAmount=0;
$vatIE="I";
$deliveryDate = date('Y/m/d', time());
$deliveryMethod="Not Set";

$customerName = '';
$addressLine1 = '';
$addressLine2 = '';

$anonymousCheckout = $_POST['anonymousCheckout'];
if($anonymousCheckout){
    if(isset($_POST['anonymousCheckoutCustomer']) && $_POST['anonymousCheckoutCustomer'] > 0){
        $customerID = $_POST['anonymousCheckoutCustomer'];
        $salespersonID = 0;
        $customerInfo = explode("\nCustomer:",$details)[1];
        $customerDetailsArray = explode("\nAddress:",$customerInfo );

        $customerName= trim($customerDetailsArray[0]);
        $addressesArray = explode("\nPhone:",$customerDetailsArray[1] );
        $contactArray = explode("\nEmail:",$addressesArray[1] );
        $addressLine1 = $addressesArray[0].", Phone:".$contactArray[0];
        $addressLine2 = "Email:".$contactArray[1];



    }
}


$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT salesperson_for_order FROM B2B_Configuration LIMIT 1");
$stm->execute();
$stm->bind_result($defaultSalesPerson);
while ($stm->fetch()) {
    if (strcmp($defaultSalesPerson, '') != 0 && $defaultSalesPerson > 0) {
        $salespersonID = $defaultSalesPerson;
    }
}
$stm->close();

if (strcmp($companyID, '') == 0) {
    $companyID = 0;
}

if(strcmp($grandTotal,'')==0){
    include_once('getItemsInCartForOrder.php');
    $dbOrder = getItemsInCartForOrder($onlineOrderID,$customerID);

    $subtotal   = $dbOrder->subTotal;
    $vatAmount  = $dbOrder->vatTotal;
    $grandTotal = $dbOrder->grandTotal;

}

$tenderID = 0;
$stmt = $db->prepare("INSERT INTO Tenders (tender_id,tender_code,online_tender_id,company_id,customer_id,salesperson_id,tender_date,subtotal,grand_total,vat_amount,discount_amount,details,status,address_line_1,address_line_2,name,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
$stmt->bind_param('issiiisddddsssss',$tenderID,$orderCode,$onlineOrderID,$companyID,$customerID,$salespersonID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$details,$status,$addressLine1,$addressLine2,$customerName);
$stmt->execute();
echo $stmt->error;
$stmt->close();

$stm = $db->prepare("SELECT tender_id FROM Tenders WHERE online_tender_id='$onlineOrderID'");
$stm->execute();
$stm->bind_result($tenderID);
while ($stm->fetch()) {}
$stm->close();


$stm = $db->prepare("SELECT Online_Order_Item.item_id,qty,unit_price,Items.vat_id FROM Online_Order_Item,Items WHERE Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$onlineOrderID'");
$stm-> execute();
$stm-> bind_result($itemID,$qty,$unitPrice,$vatID);


while ($stm->fetch()) {


    $lineTotal = $unitPrice*$qty;
    $vatAmount = $lineTotal * getVatPercentage($vatID)/100;
    $qtyDelivered=$qtyInvoiced=$lineDiscount=$globalDiscount=$lineDiscountPercentage=0;
    $description="";
    $pricetypeID=0;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");
    $tender_item_id = 0;
    $stmt1 = $db1->prepare("INSERT INTO Tender_Item (tender_item_id,tender_id,item_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt1->bind_param('iiiddddddiis',$tender_item_id,$tenderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$pricetypeID,$vatID,$description);
    $stmt1->execute();
    $stmt1->close();

}

$stm->close();


$stmt = $db->prepare("DELETE FROM Online_Orders WHERE order_id='$onlineOrderID'");
$stmt->execute();
$stmt->close();

$stmt = $db->prepare("DELETE FROM Online_Order_Item WHERE order_id='$onlineOrderID'");
$stmt->execute();
$stmt->close();

//setNextTenderCode("CLOUD");
$_SESSION['orderID'] = getAvailableOrderID($customerID,$userID);





if($showPrices) {
    echo "
            <script>
            $('#home').removeClass('modal-open');
            </script>
                    <div class='message-box col-sm-8 col-sm-offset-2'>
                        <div class='message-box-inner'>
                            <h2 style='text-transform: capitalize; font-size:14px;font-family: Open Sans, Arial, Helvetica, Sans-Serif'>".$langu['place_quotation_message']."<br><br> $orderCode </h2>
                        </div>
                    </div>
                    <br>
                    <div>
                        <form style='margin:0 auto;width:50%;margin-bottom:20px;' method='POST' action='./dbaccess/printTenderPDF.php' target='_blank'>
                           <input type='hidden' name='tenderID' id='orderIDEmail' value='$tenderID'/>
                           <input type='hidden' name='tenderCode' value='$orderCode'/>
                           <div style='margin: 0 auto;width:80%'><center>
                           <input type='submit' class='btn btn-theme btn-theme-dark' style='display:inline-block;margin-top:15px;text-transform: capitalize;'id='printOrderButton' value='" . $langu['print_order'] . "'/>
                           <a href='./' class='btn btn-theme' style='display:inline-block;margin-top:15px;text-transform: capitalize;'>" . $langu['back_to_catalogue_label'] . "</a>
                           </div>
                        </form>
                      </div>
                        ";
    echo getTenderPDF($tenderID);
} else {
    echo "
            <script>
            $('#home').removeClass('modal-open');
            </script>
                    <div class='message-box col-sm-8 col-sm-offset-2'>
                        <div class='message-box-inner'>
                            <h2 style='text-transform: capitalize; font-size:14px;font-family: Open Sans, Arial, Helvetica, Sans-Serif'>".$langu['place_quotation_message']."<br><br> $orderCode </h2>
                        </div>
                    </div>   
                    <div>
                    </div>
                        ";
}

if($showPrices) {
    echo "<script>
                      $.ajax({
                        type:'POST',
                        url: './dbaccess/emailTender.php',
                        data:{'orderID':'$tenderID','showPrices':'yes'},
                        success:function(result){}
                      });
                  </script>";

} else {
    echo "<script>
                      $.ajax({
                        type:'POST',
                        url: './dbaccess/emailTender.php',
                        data:{'orderID':'$tenderID','showPrices':'no'},
                        success:function(result){}
                      });
                  </script>";
}
?>