<?php
session_start();
error_reporting(0);
include_once("../../param.php");
include_once("../MPDF57/mpdf.php");
include_once("dbhelper.php");

function getTenderPDFForPrinting($tenderID)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT tender_code,tender_date,valid_until,subtotal,grand_total,vat_amount,customer_id,company_id,name,address_line_1,address_line_2 FROM Tenders WHERE tender_id='$tenderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate,$validUntil, $subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$anonymousCustomerName,$anonymousAddressLine1,$anonymousAddressLine2);

    while ($stm->fetch()) {


    }
    $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');
    $validUntil = date_format( date_create_from_format('Y-m-d', $validUntil), 'd-m-Y');

    $subtotal = number_format(floatval($subtotal),2);
    $grandTotal = number_format(floatval($grandTotal),2);
    $vatAmount = number_format(floatval($vatAmount),2);


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();

    $addItemByUnits = true;
    $stm = $db->prepare("SELECT anonymous_checkout_customer_id,order_qty_by_subunits FROM B2B_Configuration");
    $stm-> execute();
    $stm-> bind_result($anonymousCheckoutCustomerID,$orderQtyBySubunits);
    while ($stm->fetch()) {
        if(strcmp($orderQtyBySubunits,'yes')==0){
            $addItemByUnits = false;
        }
    }
    $stm->close();


    if($customerID == $anonymousCheckoutCustomerID){
        $customerName = "Customer";
        $customerCode = $anonymousCustomerName;
        $addressLine1 = str_replace(",","<br>",$anonymousAddressLine1);
        $addressLine2 = str_replace(",","<br>",$anonymousAddressLine2);
    } else {


        $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_id='$customerID' AND primary_address='yes'");
        $stm->execute();
        $stm->bind_result($addressLine1, $addressLine2, $postcode, $city, $landline);

        while ($stm->fetch()) {
            if (strcmp($addressLine2, '') != 0 && strcmp($city, '') != 0) {
                $addressLine2 .= ",";
            }
            if (strcmp($postcode, '') != 0 && strcmp($city, '') != 0) {
                $postcode .= ",";
            }
            if (strcmp($landline, '') != 0) {
                $landline = "Tel.: " . $landline;
            }

        }
        $stm->close();
    }
    $displayDate =$orderDate;
    $displayDeliveryDate =$deliveryDate;



    $result= "
<div class='row'>
<div  class='col-sm-8 col-sm-offset-2'>

<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:14pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


       @page {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>


<htmlpageheader name='myHTMLHeader1'>
    <table class='heading' >
          <tr>
              <td valign='top' style='width:30%'>
                  <img style='display:block;max-width: 200px;' src='//" . HTML_PATH . "/cop/media/pdfimage/logo.png'/>
              </td>
              <td  valign='top' style='width:40%' align='center'>
                 <p style='display:block;font-weight:bold; font-size:24px; width:100%'>Online Quotation Request</p>
              </td>
              <td valign='top' style='width:30%' align='right'>
                 <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;'>$line1</h1>
                            <h2 class='heading'>
                                $line2<br/>
                                $line3<br/>
                                $line4<br/>
                                $line5<br/>
                                $line6<br/>
                                $line7
                            </h2>
              </td>
           </tr>
      </table>
    
    <table class='heading' style='width:100%;'>
        <tr>

            <td  valign='top' align='left' style='padding:1mm;'>
                <table>
                    <tr><td style='font-weight:bold' colspan='2'><h3>Quotation Details</h3></td></tr>
                    <tr><td >Quotation No.: </td><td>$orderCode</td></tr>
                    <tr><td >Quotation Type: </td><td>Online Quotation</td></tr>
                    <tr><td >Quotation Date: </td><td>$displayDate</td></tr>
                    <tr><td >&nbsp;</td><td>&nbsp;</td></tr>
                </table>
            </td>
            <td ></td>
            <td class='customer' align='right'>
                <table >
                    <tr><td style='font-weight:bold'  align='right'><h3>Customer Details</h3></td></tr>
                    <tr><td align='right'>$customerName - $customerCode</td></tr>
                    <tr><td align='right'>$addressLine1</td></tr>
                    <tr><td align='right'>$postcode $addressLine2 $city</td></tr>
                    <tr><td align='right'>$landline</td></tr>

                </table>
            </td>
        </tr>
    </table>
    </htmlpageheader>
<div id='invoice_body'>
    
     <table id='tableHeader' style='margin-top:10px;'>
            <tr style='background:#eee;'>
                <td style='width:8%' ><b>No.</b></td>
                <td style='width:17%'><b>Code</b></td>
                 <td style='width:30%'><b>Description</b></td>
                <td style='width:15%'><b>Quantity</b></td>
                <td style='width:15%' ><b>Unit Price</b></td>
                <td style='width:15%'><b>Total</b></td>
            </tr>
            </table>


            <table style='overflow:hidden;'>

            ";

    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject = new stdClass();
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();

    $addItemByUnits = true;
    $stm = $db->prepare("SELECT order_qty_by_subunits FROM B2B_Configuration LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($orderQtyBySubunits);
    while ($stm->fetch()) {
        if(strcmp($orderQtyBySubunits,'yes')==0){
            $addItemByUnits = false;
        }
    }
    $stm-> close();

    $counter = 0;
    $stm = $db->prepare("SELECT Tender_Item.item_id,qty,unit_price,Items.vat_id,item_code,name FROM Tender_Item,Items WHERE Tender_Item.item_id=Items.item_id AND Tender_Item.tender_id='$tenderID'");
    $stm->execute();
    $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name);



    while ($stm->fetch()) {
        $counter++;

        if($addItemByUnits) {
            $qty = $qty / floatval(getSubUnits($itemID));
            $lineTotal = $unitPrice*$qty;
        } else {
            $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
        }

        $lineTotal = number_format(floatval($lineTotal),2);
        $lineTotalDisplay = number_format(floatval($lineTotal),2);
        $unitPrice = number_format(floatval($unitPrice),2);
        $unitPriceDisplay = number_format(floatval($unitPrice),2);

        if($customerID > 0) {
            $name = getCustomerSynonym($customerID,$itemID,'name',$name);
            $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
        }

        $result.= "<tr>
                <td style='width:8%'> $counter</td >
                <td style='width:17%;' > $itemCode  </td >
                <td style='width:30%'> $name </td >
                <td style='width:15%;text-align:center;padding-right:5px;'  > $qty</td >
                <td style='width:15%;text-align:right;padding-right:5px;' > $unitPriceDisplay</td >
                <td style='width:15%;text-align:right;padding-right:5px;'  > $lineTotalDisplay</td >
            </tr >";

        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatLineAmount = $vatObject->percentage * $lineTotal / 100;
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$lineTotal;
            }
        }

    }
    $stm->close();


    $result.=
        "

        </table>
        </div>


        


    </div>



   

</div>
<htmlpagefooter name='myFooter1'>


        <div id='invoice_total' style='margin-top:20px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>
            <table style='width: 100%'>
             <tr>
               <td style='width:50%;'>

               <table>
                  <tr>
                    <td style='text-align:center'>
                     <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                    </td>
                 </tr>
                 </table>
                 <table>
                 <tr>

                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p > Percent:</p>
                   </td>
                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p > Goods:</p>
                   </td>
                   <td style='width:33%;text-align:center;font-weight: bold;'>
                     <p> VAT</p>
                   </td>
                 </tr>";


    foreach($vatsArray as $vatObject) {

        if($vatObject->goods>0) {

            $vatObject->goods = number_format(floatval($vatObject->goods),2);
            $vatObject->vatAmount = number_format(floatval($vatObject->vatAmount),2);
            $result .= "<tr>
                <td style='width:33%;font-size:12px;text-align:center;' > $vatObject->percentage%  </td >
                <td style='width:33%;font-size:12px;text-align:center;'>  $vatObject->goods </td >
                 <td style='width:33%;text-align:center;font-size:12px;'> $vatObject->vatAmount</td >
            </tr >";
        }

    }


    $result.="
               </table>

              </td>
              <td style='width:20%'></td>
              <td  style='width:30%;'>
               <table>
                <tr>
                    <td style='text-align:right;font-weight:bold;'> Subtotal</td>
                    <td style='text-align:right;' >$subtotal</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Vat Total</td>
                    <td style='text-align:right;' >$vatAmount</td>
                </tr>
                <tr>
                    <td style='text-align:right;font-weight:bold'> Grand Total</td>
                    <td style='text-align:right;' >$grandTotal</td>
                </tr>
            </table>
              </td>
            </tr>
          </table>
        </div>
        <div style='margin-top: 2px;'>
          <p style='color:gray;margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce </p>
        </div>
            <table width='100%' style='margin-top: 10px;vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                <td width='33%' style='text-align: right; '>$orderCode</td>
                </tr></table>
            </htmlpagefooter>

<sethtmlpagefooter name='myHTMLHeader1' value='on'' />
<sethtmlpagefooter name='myFooter1' value='on'' />
";


    return $result;
}


$orderID =$_POST['tenderID'];
$orderCode =$_POST['tenderCode'];
$result = getTenderPDFForPrinting($orderID);




$mpdf=new mPDF('utf-8','A4');
//$mpdf->SetHTMLHeaderByName('myHTMLHeader1');
$mpdf->setAutoTopMargin='stretch';
$mpdf->setAutoBottomMargin='stretch';
$mpdf->keep_table_proportions=true;
$mpdf->WriteHTML($result);

$mpdf->Output("$orderCode.pdf","I");




?>