<?php
session_start();
if(!isset($_SESSION['customerID']) || $_SESSION['customerID'] == 0 ) {
    redirect("login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
include_once("../param.php");
require("./dbaccess/dbhelper.php");
include_once("headerImports.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT css_theme,delivery_on_weekend,link_delivery_to_schedules FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($cssTheme,$deliveryOnWeekend,$linkSchedulesToB2B);

while ($stm->fetch()) {
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}


?>

<body id="home" class="wide">
        <input type="hidden" id="state" value="0">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- Popup: Shopping cart items -->
            <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="container">
                        <div class="cart-items">

                        </div>
                    </div>
                </div>
            </div>
            <!-- /Popup: Shopping cart items -->

            <!-- HEADER -->
                <?php
                $topmenu = "topMenuCheckout$cssTheme.php";

                if(strcmp($topmenu,"topMenuCheckout2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }

                include_once("$topmenu");
                if(strcmp($topmenu,"topMenuCheckout.php")==0) {
                    include_once("navigationMenu.php");
                }
                ?>
            </header>

            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area" >


                <!-- PAGE -->
                <section class="page-section color">
                    <div class="container" id="checkoutContainer">
                        <h3 class="block-title alt"><i class="fa fa-angle-down"></i><?php echo $langu['checkout_title_label']?></h3>
                        <div id="checkoutCartContainer">

                        </div>


                        <form action="#" class="form-delivery">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group selectpicker-wrapper">

                                    </div>
                                 </div>
                                 <div class="col-md-6">

                                </div>

                        </form>


                        <div >
                            <a class="btn btn-theme btn-theme-dark" href="./index.php"><?php echo $langu['home_page_button']?></a>
                            <a class="btn btn-theme btn-theme-transparent" data-toggle="modal" data-target="#clearCartModal" style="margin-left:20px;"><?php echo $langu['clear_cart_button']?></a>
                        </div>
                    </div>
                </section>
                <!-- /PAGE -->

            </div>
            <!-- /CONTENT AREA -->

            <!-- Modal -->
            <div class="modal fade" id="clearCartModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document" style="margin-top:20%">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                            <h4 style="color:black;" class="modal-title" id="myModalLabel"><?php echo $langu['clear_cart_button'];?></h4>
                        </div>
                        <div class="modal-body">
                            <?php echo$langu['clear_cart_question']; ?>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal"><?php echo $langu['close_label'];?></button>
                            <button type="button" class="btn btn-primary" data-dismiss="modal" onclick="clearCart()"><?php echo $langu['clear_cart_button'];?></button>
                        </div>
                    </div>
                </div>
            </div>

            <!-- FOOTER -->
            <footer class="footer">
                <div class="footer-meta">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-6" style="font-size:16px;">

                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- /FOOTER -->

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->

        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>

        <script src="assets/js/jquery.tabletojson.js"></script>
        <script src="assets/js/jquery-scrolltofixed-min.js"></script>

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>

        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>
        <!--<![endif]-->

        <script src="assets/js/waitMe.min.js"></script>



        <script type="text/javascript">

            var copMap;
            var markers=[];
            var directionsDisplay = null;


            function initAutocomplete() {
                const map = new google.maps.Map(document.getElementById("map_coprime"), {
                    center: { lat: 25.2531745, lng: 55.36567280000001 },
                    zoom: 5,
                    mapTypeId: "roadmap",
                    mapTypeControl: false,
                });
                // Create the search box and link it to the UI element.
                const input = document.getElementById("pac-input");
                const searchBox = new google.maps.places.SearchBox(input);
                map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
                // Bias the SearchBox results towards current map's viewport.
                map.addListener("bounds_changed", () => {
                    searchBox.setBounds(map.getBounds());
                });
                let markers = [];

                var directionsService = new google.maps.DirectionsService();
                var lastDirections = null;

                var lat = $('#address').find(':selected').data('lat');
                var lng = $('#address').find(':selected').data('lng');
                var end = $('#pac-input').val();
                var start = new google.maps.LatLng(lat, lng);

                var request = {
                    origin      : start, // a city, full address, landmark etc
                    destination : end,
                    travelMode  : google.maps.DirectionsTravelMode.DRIVING
                };

                directionsService.route(request, function(response, status) {
                    if (status == google.maps.DirectionsStatus.OK) {
                        // alert( response.routes[0].legs[0].distance.value ); // the distance in metres
                        var distance = response.routes[0].legs[0].distance.value;
                        distanceKm = Math.round(distance / 1000);

                        if (lastDirections !== null) {
                            lastDirections.setMap(null);
                        }
                        directionsDisplay = new google.maps.DirectionsRenderer();
                        directionsDisplay.setMap(map);
                        directionsDisplay.setDirections(response);
                        lastDirections = directionsDisplay;
                        $('#distanceKm').html(distanceKm);
                    }
                });


                // Listen for the event fired when the user selects a prediction and retrieve
                // more details for that place.
                searchBox.addListener("places_changed", () => {
                    var lat = $('#address').find(':selected').data('lat');
                    var lng = $('#address').find(':selected').data('lng');
                    var lat_lng = new Array();
                    var path = [];
                    if (directionsDisplay != null) {
                        directionsDisplay.setMap(null);
                        directionsDisplay = null;
                    }


                    const places = searchBox.getPlaces();

                    if (places.length == 0) {
                        return;
                    }
                    // Clear out the old markers.
                    markers.forEach((marker) => {
                        marker.setMap(null);
                    });
                    markers = [];
                    // For each place, get the icon, name and location.
                    const bounds = new google.maps.LatLngBounds();
                    places.forEach((place) => {
                        if (!place.geometry || !place.geometry.location) {
                            console.log("Returned place contains no geometry");
                            return;
                        }

                        // Create a marker for each place.
                        var delLatlng = place.geometry.location;
                        var myLatlng = new google.maps.LatLng(lat, lng);
                        lat_lng = [];
                        lat_lng.push(myLatlng);
                        lat_lng.push(delLatlng);
                        //////
                        $('#addressTo').val(place.formatted_address);
                        $('#latFrom').val(myLatlng.lat);
                        $('#latTo').val(delLatlng.lat);
                        $('#lngFrom').val(myLatlng.lng);
                        $('#lngTo').val(delLatlng.lng);

                        var componentForm = {
                            street_number: 'short_name',
                            route: 'long_name',
                            locality: 'long_name',
                            administrative_area_level_1: 'short_name',
                            postal_code: 'short_name',
                            country: 'long_name'
                        };

                        for (var i = 0; i < place.address_components.length; i++) {
                            var addressType = place.address_components[i].types[0];
                            if (componentForm[addressType]) {
                                if (addressType == 'locality') {
                                    var locality = place.address_components[i][componentForm[addressType]];
                                }

                                if (addressType == 'administrative_area_level_1') {
                                    var state = place.address_components[i][componentForm[addressType]];
                                }
                            }
                        }
                        if(locality == null){locality=state;}
                        if(locality == null){locality='';}
                        $('#addressAreaTo').val(locality);

                        var addrInput = $('#pac-input').val();
                        var customer= addrInput.substr(0, addrInput.indexOf(','));
                        if(customer.localeCompare('')==0){
                            customer= addrInput.substr(0, addrInput.indexOf('-'));
                        }

                        $('#clientNameTo').val(customer);
                        //////


                        if (place.geometry.viewport) {
                            // Only geocodes have viewport.
                            bounds.union(place.geometry.viewport);
                            bounds.extend(myLatlng);

                        } else {
                            bounds.extend(place.geometry.location);
                            bounds.extend(myLatlng);
                        }
                    });
                    map.fitBounds(bounds);

                    var start = new google.maps.LatLng(lat_lng[0].lat(), lat_lng[0].lng());
                    var end = new google.maps.LatLng(lat_lng[1].lat(),lat_lng[1].lng());

                    var request = {
                        origin      : start, // a city, full address, landmark etc
                        destination : end,
                        travelMode  : google.maps.DirectionsTravelMode.DRIVING
                    };

                    directionsService.route(request, function(response, status) {
                        if ( status == google.maps.DirectionsStatus.OK ) {
                            // alert( response.routes[0].legs[0].distance.value ); // the distance in metres
                            var distance = response.routes[0].legs[0].distance.value;
                            distanceKm = Math.round(distance/1000);

                            if ( lastDirections !== null) {
                                lastDirections.setMap(null);
                            }
                            directionsDisplay = new google.maps.DirectionsRenderer();
                            directionsDisplay.setMap(map);
                            directionsDisplay.setDirections(response);
                            lastDirections = directionsDisplay;
                            $('#distanceKm').html(distanceKm);

                            var distanceKm = $('#distanceKm').html();
                            var volumetrics = $('#totalVolumetrics').html();
                            var totalKg = $('#totalWeight').html();
                            $.ajax({
                                type: 'POST',
                                url: './dbaccess/getDropShipDeliveryFee.php',
                                data: { 'volumetrics': volumetrics,'totalKg':totalKg,'distanceKm':distanceKm },
                                success: function (result) {
                                    if(result > 0){
                                        $('#deliveryMethod').val(result).change();
                                    }

                                }
                            });
                        }
                        else {
                            // oops, there's no route between these two locations
                            // every time this happens, a kitten dies
                            // so please, ensure your address is formatted properly
                        }
                    });


                });
                $('#address').on('change', function() {
                    var lat = $('#address').find(':selected').data('lat');
                    var lng = $('#address').find(':selected').data('lng');
                    var lat_lng = new Array();
                    var path = [];
                    if (directionsDisplay != null) {
                        directionsDisplay.setMap(null);
                        directionsDisplay = null;
                    }


                    const places = searchBox.getPlaces();

                    if (places.length == 0) {
                        return;
                    }
                    // Clear out the old markers.
                    markers.forEach((marker) => {
                        marker.setMap(null);
                    });
                    markers = [];
                    // For each place, get the icon, name and location.
                    const bounds = new google.maps.LatLngBounds();
                    places.forEach((place) => {
                        if (!place.geometry || !place.geometry.location) {
                            console.log("Returned place contains no geometry");
                            return;
                        }

                        // Create a marker for each place.
                        var delLatlng = place.geometry.location;
                        var myLatlng = new google.maps.LatLng(lat, lng);
                        lat_lng = [];
                        lat_lng.push(myLatlng);
                        lat_lng.push(delLatlng);



                        if (place.geometry.viewport) {
                            // Only geocodes have viewport.
                            bounds.union(place.geometry.viewport);
                            bounds.extend(myLatlng);

                        } else {
                            bounds.extend(place.geometry.location);
                            bounds.extend(myLatlng);
                        }
                    });
                    map.fitBounds(bounds);

                    var start = new google.maps.LatLng(lat_lng[0].lat(), lat_lng[0].lng());
                    var end = new google.maps.LatLng(lat_lng[1].lat(),lat_lng[1].lng());

                    var request = {
                        origin      : start, // a city, full address, landmark etc
                        destination : end,
                        travelMode  : google.maps.DirectionsTravelMode.DRIVING
                    };

                    directionsService.route(request, function(response, status) {
                        if ( status == google.maps.DirectionsStatus.OK ) {
                            // alert( response.routes[0].legs[0].distance.value ); // the distance in metres
                            var distance = response.routes[0].legs[0].distance.value;
                            distanceKm = Math.round(distance/1000);

                            if ( lastDirections !== null) {
                                lastDirections.setMap(null);
                            }
                            directionsDisplay = new google.maps.DirectionsRenderer();
                            directionsDisplay.setMap(map);
                            directionsDisplay.setDirections(response);
                            lastDirections = directionsDisplay;
                            $('#distanceKm').html(distanceKm);
                            var distanceKm = $('#distanceKm').html();
                            var volumetrics = $('#totalVolumetrics').html();
                            var totalKg = $('#totalWeight').html();
                            $.ajax({
                                type: 'POST',
                                url: './dbaccess/getDropShipDeliveryFee.php',
                                data: { 'volumetrics': volumetrics,'totalKg':totalKg,'distanceKm':distanceKm },
                                success: function (result) {
                                    if(result > 0){
                                        $('#deliveryMethod').val(result).change();
                                    }

                                }
                            });
                        }
                        else {
                            // oops, there's no route between these two locations
                            // every time this happens, a kitten dies
                            // so please, ensure your address is formatted properly
                        }
                    });


                });
            }
            jQuery(document).ready(function () {


                initThemeParameters();
                refreshCartInDropShip();






            });

            function quotationModal(val){

                if(val == 0 ) {
                    $('#checkoutModalTitle').html('<?php echo $langu['proceed_with_order_label'];?>');
                    $('#requestQuotationButton').hide();

                    $('#paymentMethod').show();
                    $('#paymentMethodLabel').show();
                    $('#paymentMethodLogo').show();
                    $('#deliveryAddressDiv').show();
                    $('#deliveryDateDiv').show();
                    $('#warningLabel').show();

                    $('#confirmTenderLabel').hide();

                    var iscredit = $('#paymentMethod :selected').data('iscredit');
                    if(iscredit.localeCompare('yes') === 0){
                        $('#placeOrderButton').show();
                        $('#payOrderButton').hide();
                    } else {
                        $('#placeOrderButton').hide();
                        $('#payOrderButton').show();
                    }
                } else {
                    $('#checkoutModalTitle').html('<?php echo $langu['request_quotation_button'];?>');
                    $('#requestQuotationButton').show();

                    $('#paymentMethod').hide();
                    $('#paymentMethodLabel').hide();
                    $('#paymentMethodLogo').hide();

                    $('#placeOrderButton').hide();
                    $('#payOrderButton').hide();
                    $('#deliveryAddressDiv').hide();
                    $('#deliveryDateDiv').hide();
                    $('#warningLabel').hide();

                    $('#confirmTenderLabel').show();

                }
            }

            function addCoupon(){
                var coupon = $('#couponBox').val();
                if(coupon.localeCompare('')!=0){

                    $.ajax({
                        type: "POST",
                        url: "./dbaccess/getPromotionFromCoupon.php",
                        data: {coupon: coupon},
                        success: function (result) {
                            if(result == 0) {
                                $('#couponBox').css('border-color','firebrick').css('color','firebrick').val('Invalid Coupon');
                                setTimeout(function(){$('#couponBox').css('border-color', '').css('color','').val(''); }, 1000);
                            } else {
                                $('#couponBox').css('border-color','green').css('color','green');
                                refreshCartInDropShip();
                            }

                        }
                    });

                }
            }

            function checkDate(first){
                var curDate = new Date($('.deliveryDate').val());
                var day = curDate.getDay();

                <?php


                if(strcmp($deliveryOnWeekend,'no')==0){
                    echo " if(day === 6){
                               curDate.setDate(curDate.getDate() + 2);
                               if(!first){
                                 $('#deliveryDateChanged').show();
                               }
                           } else if(day === 0){
                               curDate.setDate(curDate.getDate() + 1);
                               if(!first){
                                 $('#deliveryDateChanged').show();
                               }
                           } else {
                             $('#deliveryDateChanged').hide();
                           }";
                } else if(strcmp($deliveryOnWeekend,'saturday')==0){
                    echo "if(day === 0){
                            curDate.setDate(curDate.getDate() + 1);
                            if(!first){
                              $('#deliveryDateChanged').show();
                            }
                          } else {
                            $('#deliveryDateChanged').hide();
                          }";
                } else if(strcmp($deliveryOnWeekend,'sunday')==0){
                    echo "if(day === 6){
                            curDate.setDate(curDate.getDate() + 1);
                            if(!first){
                              $('#deliveryDateChanged').show();
                            }
                          } else {
                            $('#deliveryDateChanged').hide();
                          }";
                } else {
                    echo " $('#deliveryDateChanged').hide();";
                }

                if(strcmp($linkSchedulesToB2B,'yes')==0){

                    echo "  var pdd = curDate.getDate();
                            var pmm = curDate.getMonth() + 1; //January is 0!
                            var pyyyy = curDate.getFullYear();
                            if (pdd < 10) {pdd = '0' + pdd;}
                            if (pmm < 10) {pmm = '0' + pmm;}
                            var postDate = pyyyy + '-' + pmm + '-' + pdd;
                   
                            $.ajax({
                                type:'POST',
                                url: './dbaccess/getNextScheduledDateForDelivery.php',
                                data:{'postDate':postDate},
                                success:function(result){

                                
                                    if(result > 0){
                                        curDate.setDate(curDate.getDate() + +result);
                                        var dd = curDate.getDate();
                                        var mm = curDate.getMonth() + 1; //January is 0!
                                        var yyyy = curDate.getFullYear();
                                        if (dd < 10) {dd = '0' + dd;}
                                        if (mm < 10) {mm = '0' + mm;}
                                        var newDate = yyyy + '-' + mm + '-' + dd;
                                        $('.deliveryDate').val(newDate);
                                        if(!first){
                                            $('#deliveryDateChanged').show();
                                        }
                                    } else {
                                        $('#deliveryDateChanged').hide();
                                    }
                                }
                            });";
                } else {
                    echo "  var dd = curDate.getDate();
                            var mm = curDate.getMonth() + 1; //January is 0!
                            var yyyy = curDate.getFullYear();
                            if (dd < 10) {dd = '0' + dd;}
                            if (mm < 10) {mm = '0' + mm;}
                            var newDate = yyyy + '-' + mm + '-' + dd;
                            $('.deliveryDate').val(newDate);";
                }

                ?>





            }

            function placeOrder()
            {

                $.ajax({
                    type: 'POST',
                    url: './dbaccess/checkLoginState.php',
                    success: function (loginState) {

                        $('#checkoutModal').modal('hide');

                        var isCredit = $('#paymentMethod option:selected').data('iscredit');

                        var numItems = $('.itemRow').size();
                        if(loginState >= 1) {
                            if (numItems > 0) {

                                var subtotal = $('#subtotal').text();
                                var vatAmount = $('#vatAmount').text();
                                var grandTotal = $('#grandTotal').text();
                                var address = $('#address').val();
                                var details = $('#details').val();
                                var deliveryTotal = $('#deliveryTotal').text();
                                var deliveryDate = $('#deliveryDate').val();
                                var deliveryFeeItem = $('#deliveryMethod').val();
                                var deliveryMethod = $('#deliveryMethod option:selected').text();


                                var clientNameTo = $('#clientNameTo').val();
                                var addressTo = $('#addressTo').val();
                                var addressAreaTo = $('#addressAreaTo').val();
                                var totalVolumetrics = $('#totalVolumetrics').val();
                                var totalWeight = $('#totalWeight').val();
                                var distanceKm = $('#distanceKm').val();
                                var latFrom = $('#latFrom').val();
                                var latTo = $('#latTo').val();
                                var lngFrom = $('#lngFrom').val();
                                var lngTo = $('#lngTo').val();
                                var freightCollectAmount = $('#freightCollectAmount').val();


                                var paymentMethodText = $('#paymentMethod option:selected').text();
                                if(paymentMethodText.localeCompare('')!==0){
                                    details = $('#details').val() + ' \nPayment Method:' + $('#paymentMethod option:selected').text();;
                                }

                                var onlineOrderItems = $('#onlineOrderItemsTable').tableToJSON(
                                    {
                                        ignoreColumns: [0],
                                        textExtractor: {
                                            0: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            1: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            2: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            3: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            4: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            },
                                            5: function (cellIndex, $cell) {
                                                return $cell.find('input').val();
                                            }
                                        },
                                        ignoreHiddenRows: false,
                                        ignoreEmptyRows: false
                                    }
                                );

                                $.ajax({
                                    type: "POST",
                                    url: "./dbaccess/placeOrder.php",
                                    data: {
                                        subtotal: subtotal,
                                        vatAmount: vatAmount,
                                        grandTotal: grandTotal,
                                        address: address,
                                        details: details,
                                        deliveryTotal: deliveryTotal,
                                        deliveryDate: deliveryDate,
                                        deliveryFeeItem: deliveryFeeItem,
                                        deliveryMethod: deliveryMethod,
                                        isCredit: isCredit,
                                        clientNameTo: clientNameTo,
                                        addressTo: addressTo,
                                        addressAreaTo: addressAreaTo,
                                        totalVolumetrics: totalVolumetrics,
                                        totalWeight: totalWeight,
                                        distanceKm: distanceKm,
                                        latFrom: latFrom,
                                        latTo: latTo,
                                        lngFrom: lngFrom,
                                        lngTo: lngTo,
                                        freightCollectAmount: freightCollectAmount,
                                        onlineOrderItems: onlineOrderItems
                                    },
                                    success: function (result) {
                                        window.scrollTo(0, 0);
                                        // alert(isCredit.localeCompare('no'));
                                        if (typeof isCredit === 'undefined' || isCredit === null) {
                                            var creditOrder = true;
                                        } else {
                                            if (isCredit.localeCompare('no') == 0) {
                                                var creditOrder = false;
                                            } else {
                                                var creditOrder = true;
                                            }
                                        }
                                        if (result == 0) {
                                            alert('Something Went Wrong.. Please Try Again.');
                                        } else {
                                            if (creditOrder) {

                                                $('#checkoutContainer').empty();
                                                $('#checkoutContainer').append(result);
                                                // var ID = $('#orderIDEmail').val();
                                                // var action = "ORDER";

                                                // $.ajax({
                                                //     type: "POST",
                                                //     url: '../backend/b2bAdmin/sendTemplateEmail.php',
                                                //     data: {
                                                //         'ID': ID,
                                                //         'action': action
                                                //
                                                //     },
                                                //     success: function (result) {
                                                //         // alert(result);
                                                //     }
                                                // });
                                            } else {

                                                switch ($('#paymentMethod option:selected').data('method')) {
                                                    case 'JCC':
                                                        $('#JCCOrderID').val(result);

                                                        var PurchaseAmt = $('#JCCPurchaseAmt').val();
                                                        var JCCorderID = result;

                                                        $.ajax({
                                                            type: 'POST',
                                                            url: './dbaccess/getEncriptedSignatureJCC.php',
                                                            data: {
                                                                'PurchaseAmt': PurchaseAmt,
                                                                'JCCorderID': JCCorderID

                                                            },
                                                            success: function (result) {

                                                                $('#JCCSignature').val(result);
                                                                document.forms["paymentFormJCC"].submit();
                                                            }
                                                        });
                                                        break;
                                                    case 'VIVA':
                                                        window.location.href="./dbaccess/createPaymentOrderVIVA.php?oid="+result
                                                        break;

                                                }

                                            }
                                        }
                                    }
                                });
                            }
                        } else {
                            window.location.href='login.php';
                        }
                    }
                });
            }

			function placeQuotation()
            {
                $.ajax({
                    type: 'POST',
                    url: './dbaccess/checkLoginState.php',
                    success: function (loginState) {
                        $('#checkoutModal').modal('hide');

                        var numItems = $('.itemRow').size();

                        if(numItems > 0)
                        {
                            var subtotal = $('#subtotal').text();
                            var vatAmount = $('#vatAmount').text();
                            var grandTotal = $('#grandTotal').text();
                            var address = $('#address').val();
                            var details = $('#details').val();
                            $.ajax({
                                type: "POST",
                                url: "./dbaccess/placeQuotation.php",
                                data: {subtotal: subtotal,vatAmount: vatAmount,grandTotal: grandTotal,address: address,details: details},
                                success: function (result) {
                                    window.scrollTo(0, 0);
                                    $('#checkoutContainer').empty();
                                    $('#checkoutContainer').append(result);

                                }
                            });
                        }
                    }
                });
            }

            function clearCart()
            {
                    $.ajax({
                        type: "POST",
                        url: "./dbaccess/clearCart.php",
                        data: {},
                        success: function (result) {

                            refreshCartInDropShip();

                        }
                    });

            }



        </script>



        <link href="./assets/popover/bootstrap-popover-x.min.css" media="all" rel="stylesheet" type="text/css" />
        <script src="./assets/popover/bootstrap-popover-x.min.js" type="text/javascript"></script>

    </body>
</html>