<?php
require("../param.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$u = 'c0p13R1M3_2024Rrd_1';
$p = 'X7m_lf33D55_3';

if(isset($_GET['u']) && isset($_GET['p'])){
    if(strcmp($_GET['u'],"$u")!=0 || strcmp($_GET['p'],"$p")!=0){
        echo "Invalid credentials.";
        exit();
    }
} else {
    echo "Invalid credentials.";
    exit();
}
ob_start();
echo "Generating Feed ...";
global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT company_name FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($companyName);
while ($stm->fetch()) {}
$stm-> close();

$xml = new SimpleXMLElement('<rss version="2.0"  encoding="UTF-8"></rss>');
$channel = $xml->addChild('channel');
$channel->addChild('title', " $companyName ");
$channel->addChild('link', "https://" . HTML_PATH . "/cop/b2b/index.php");
$channel->addChild('description', " $companyName ");
$channel->addChild('language', "en-us");

$categories = '';
$stm = $db->prepare("SELECT DISTINCT(category_id) FROM B2B_Categories");
$stm-> execute();
$stm-> bind_result($categoryID);
while ($stm->fetch()) {$categories .= $categoryID.getSubCategoriesID($categoryID).',';}
$stm->close();

$categories = rtrim($categories,',');
$categoriesArray = explode(',',$categories);


$statement = "SELECT Items.item_id,item_code,item_sku,Items.name,short_description,long_description,thumbnail_url,sellable,GROUP_CONCAT(DISTINCT(CONCAT(Categories.name)) SEPARATOR'|')  
                  FROM Items
                  INNER JOIN Category_Item ON (Items.item_id = Category_Item.item_id)
                  INNER JOIN Categories ON (Category_Item.category_id = Categories.category_id)
                  WHERE NOT status='inactive' 
                  AND NOT sellable='no' 
                  AND (Category_Item.category_id IN ($categories))
                  GROUP BY Items.item_id";

$stm = $db->prepare("$statement");
$stm-> execute();
$stm-> bind_result($itemID,$itemCode,$itemSKU,$name,$shortDescription,$longDescription,$thumbnail_url,$b2bAvailable,$inCategories);
while ($stm->fetch()) {

    $check = false;
    if(strcmp($thumbnail_url,'')!=0) {
        $imageLink = "https://" . HTML_PATH . "/cop/media/productImages/$thumbnail_url.jpg";
        if (file_exists(ROOT . "media/productImages/$thumbnail_url.jpg")) {$check = true;}
    }
    if(!$check) {$imageLink = "https://" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";}

    if(strcmp(strtolower(trim($b2bAvailable)),'notavailable')==0){continue;}
    if(strcmp(strtolower(trim($b2bAvailable)),'nonstock')==0){$b2bAvailable = 'out of stock';}
    if(strcmp(strtolower(trim($b2bAvailable)),'')==0){$b2bAvailable = 'in stock';}
    if(strcmp(strtolower(trim($b2bAvailable)),'yes')==0){$b2bAvailable = 'in stock';}

    if(strcmp(strtolower(trim($b2bAvailable)),'in stock')==0){
        $stock = getStock($itemID);
        if(floatval($stock) < 1){$b2bAvailable = 'out of stock';}
    }

    $itemPrice = getDefaultPrice($itemID);
    if($itemPrice <= 0){continue;}

    if(strcmp("$shortDescription",'')==0){$shortDescription = "$name";}

    $xmlPrice = number_format(floatval($itemPrice),2,'.',''). ' EUR';
    $categoriesArray = explode('|', "$inCategories");
    $brand = $categoriesArray[0];

    $urlCategory = make_greeklish($brand);
    $urlCategory = transliterateString($urlCategory);
    $urlCategory = str_replace(' ','-',strtolower($urlCategory));
    $urlCategory = str_replace('&','and',$urlCategory);
    $urlCategory = preg_replace('/[^A-Za-z0-9\-]/', '', $urlCategory);

    $item = $channel->addChild('item');
    $item->addChild('id', htmlspecialchars("$itemCode"));
    $item->addChild('title', htmlspecialchars("$name"));
    $item->addChild('description', htmlspecialchars("$shortDescription"));
    $item->addChild('availability', htmlspecialchars("$b2bAvailable"));
    $item->addChild('condition', htmlspecialchars("new"));
    $item->addChild('price', htmlspecialchars("$xmlPrice"));
    $item->addChild('link', htmlspecialchars("https://" . HTML_PATH . "/cop/b2b/products/$urlCategory/".urlencode(str_replace('/','--CP2F--',$itemCode))));
    $item->addChild('image_link', htmlspecialchars("$imageLink"));
    $item->addChild('brand', htmlspecialchars("$brand"));

}
$stm->close();

$xml->asXML('./facebook_feed.xml');
ob_end_clean();
echo "Feed generated successfully.";

function getSubCategoriesID($categoryID){
    $subCategoriesSt = '';
    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ORDER BY name");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {

        global $username,$password,$database;
        $db3 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $stm3 = $db3->prepare("SELECT COUNT(Categories.category_id) FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$subCategoryID\" AND Categories.category_id=Subcategories.subcategory_id");
        $stm3-> execute();
        $stm3-> bind_result($subCounter);
        while ($stm3->fetch()) {}
        $stm3-> close();

        if(strcmp($subCategoryID,'')!=0){

            $subCategoriesSt.=",$subCategoryID";

            if($subCounter > 0){
                $subCategoriesSt.= getSubCategoriesID($subCategoryID);
            }
        }

    }
    $stm2-> close();

    return $subCategoriesSt;

}

function getDefaultPrice($itemID,$db1='')
{
    global $username, $password, $database;
    $z=0;
    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }

    $stm1 = $db1->prepare("SELECT b2b_price_list,b2c_price_list,b2b_offer_price_list,b2c_offer_price_list,use_as_b2c,show_prices_with_vat FROM B2B_Configuration LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($fromB2BPriceList,$fromB2CPriceList,$offerB2BPriceList,$offerB2CPriceList,$useAsB2C,$showPricesIncludingVAT);
    while ($stm1->fetch()) {}
    $stm1->close();

    if(strcmp($showPricesIncludingVAT,"yes")==0){
        $includeVatOnPrice = true;
    } else {
        $includeVatOnPrice = false;
    }

    $priceListID = 0;
    if($fromB2BPriceList > 0){$priceListID = $fromB2BPriceList;}
    if($fromB2CPriceList > 0){$priceListID = $fromB2CPriceList;}
    if($offerB2BPriceList > 0){$priceListID = $offerB2BPriceList;}
    if($offerB2CPriceList > 0){$priceListID = $offerB2CPriceList;}

    if($offerB2CPriceList > 0){
        $stm1 = $db1->prepare("SELECT price FROM Prices WHERE item_id= '$itemID' AND pricetype_id= '$offerB2CPriceList' LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($price);
        while ($stm1->fetch()) {if(floatval($price) > 0){$z = $price;}}
        $stm1->close();

        if($includeVatOnPrice){$z = $z + $z*getVatPercentage($itemID)/100;}

        if($z > 0){return $z*getPriceRate();}
    }

    if($fromB2CPriceList > 0){
        $stm1 = $db1->prepare("SELECT price FROM Prices WHERE item_id= '$itemID' AND pricetype_id= '$fromB2CPriceList' LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($price);
        while ($stm1->fetch()) {if(floatval($price) > 0){$z = $price;}}
        $stm1->close();

        if($includeVatOnPrice){$z = $z + $z*getVatPercentage($itemID)/100;}

        if($z > 0){return $z*getPriceRate();}
    }

    if($offerB2BPriceList > 0){
        $stm1 = $db1->prepare("SELECT price FROM Prices WHERE item_id= '$itemID' AND pricetype_id= '$offerB2BPriceList' LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($price);
        while ($stm1->fetch()) {if(floatval($price) > 0){$z = $price;}}
        $stm1->close();

        if($includeVatOnPrice){$z = $z + $z*getVatPercentage($itemID)/100;}

        if($z > 0){return $z*getPriceRate();}
    }

    if($fromB2BPriceList > 0){
        $stm1 = $db1->prepare("SELECT price FROM Prices WHERE item_id= '$itemID' AND pricetype_id= '$fromB2BPriceList' LIMIT 1");
        $stm1-> execute();
        $stm1-> bind_result($price);
        while ($stm1->fetch()) {if(floatval($price) > 0){$z = $price;}}
        $stm1->close();

        if($includeVatOnPrice){$z = $z + $z*getVatPercentage($itemID)/100;}

        if($z > 0){return $z*getPriceRate();}
    }


    $stm1 = $db1->prepare("SELECT price FROM Prices,PriceTypes WHERE item_id= '$itemID' AND default_type=\"yes\" AND Prices.pricetype_id=PriceTypes.pricetype_id  LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($price);
    while ($stm1->fetch()) {$z = $price;}
    $stm1->close();

    if($includeVatOnPrice){$z = $z + $z*getVatPercentage($itemID)/100;}

    return $z*getPriceRate();
}

function getPriceRate(){
    $currencyID = getOrderCurrency();
    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT rate_on_default FROM Display_Currency WHERE currency_id=$currencyID LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($rate);
    while ($stm->fetch()) {}
    $stm->close();


    if(strcmp("$rate",'')==0 || floatval($rate) == 0){
        return 1;
    } else {
        return $rate;
    }
}

function getOrderCurrency(){

    $currencyID = 0;

    return $currencyID;
}

function getVatPercentage($itemID){
    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT percentage FROM Items,Vats WHERE Items.vat_id=Vats.vat_id AND item_id=$itemID LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($percentage);
    while ($stm->fetch()) {}
    $stm->close();

    return $percentage;
}


function getStock($itemID)
{
    global $username, $password, $database;

    $stock = 0;
    $db1 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm = $db1->prepare("SELECT get_stock_from,stock_from_warehouse FROM B2B_Page_Catalogue LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($getStockFrom,$fromWarehouses);
    while ($stm->fetch()) {}
    $stm-> close();


    if(strcmp($getStockFrom,'both')==0){$getStockFrom = "available+reserved";}
    else if(strcmp($getStockFrom,'ignoreReserved')==0){$getStockFrom = "available";}
    else {$getStockFrom = 'available-reserved';}

    if(strcmp($fromWarehouses,'all')==0){$whFilter = "";}
    else if(strcmp($fromWarehouses,'')==0){$whFilter = "";}
    else {$whFilter = " AND warehouse_id IN($fromWarehouses) ";}


    $stm1 = $db1->prepare("SELECT SUM($getStockFrom) FROM Stock WHERE item_id= '$itemID' $whFilter LIMIT 1");
    $stm1->execute();
    $stm1->bind_result($stock);
    while ($stm1->fetch()) {}
    $stm1->close();

    return $stock;

}

function make_greeklish($text) {
    $expressions = array(
        '/[αΑ][ιίΙΊ]/u' => 'e',
        '/[οΟΕε][ιίΙΊ]/u' => 'i',
        '/[αΑ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'af$1',
        '/[αΑ][υύΥΎ]/u' => 'av',
        '/[εΕ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'ef$1',
        '/[εΕ][υύΥΎ]/u' => 'ev',
        '/[οΟ][υύΥΎ]/u' => 'ou',
        '/(^|\s)[μΜ][πΠ]/u' => '$1b',
        '/[μΜ][πΠ](\s|$)/u' => 'b$1',
        '/[μΜ][πΠ]/u' => 'mp',
        '/[νΝ][τΤ]/u' => 'nt',
        '/[τΤ][σΣ]/u' => 'ts',
        '/[τΤ][ζΖ]/u' => 'tz',
        '/[γΓ][γΓ]/u' => 'ng',
        '/[γΓ][κΚ]/u' => 'gk',
        '/[ηΗ][υΥ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'if$1',
        '/[ηΗ][υΥ]/u' => 'iu',
        '/[θΘ]/u' => 'th',
        '/[χΧ]/u' => 'ch',
        '/[ψΨ]/u' => 'ps',
        '/[αά]/u' => 'a',
        '/[βΒ]/u' => 'v',
        '/[γΓ]/u' => 'g',
        '/[δΔ]/u' => 'd',
        '/[εέΕΈ]/u' => 'e',
        '/[ζΖ]/u' => 'z',
        '/[ηήΗΉ]/u' => 'i',
        '/[ιίϊΙΊΪ]/u' => 'i',
        '/[κΚ]/u' => 'k',
        '/[λΛ]/u' => 'l',
        '/[μΜ]/u' => 'm',
        '/[νΝ]/u' => 'n',
        '/[ξΞ]/u' => 'x',
        '/[οόΟΌ]/u' => 'o',
        '/[πΠ]/u' => 'p',
        '/[ρΡ]/u' => 'r',
        '/[σςΣ]/u' => 's',
        '/[τΤ]/u' => 't',
        '/[υύϋΥΎΫ]/u' => 'i',
        '/[φΦ]/iu' => 'f',
        '/[ωώ]/iu' => 'o',
    );

    $text = preg_replace( array_keys($expressions), array_values($expressions), $text);
    return $text;
}

function transliterateString($txt) {
    $transliterationTable = array('á' => 'a', 'Á' => 'A', 'à' => 'a', 'À' => 'A', 'ă' => 'a', 'Ă' => 'A', 'â' => 'a', 'Â' => 'A', 'å' => 'a', 'Å' => 'A', 'ã' => 'a', 'Ã' => 'A', 'ą' => 'a', 'Ą' => 'A', 'ā' => 'a', 'Ā' => 'A', 'ä' => 'ae', 'Ä' => 'AE', 'æ' => 'ae', 'Æ' => 'AE', 'ḃ' => 'b', 'Ḃ' => 'B', 'ć' => 'c', 'Ć' => 'C', 'ĉ' => 'c', 'Ĉ' => 'C', 'č' => 'c', 'Č' => 'C', 'ċ' => 'c', 'Ċ' => 'C', 'ç' => 'c', 'Ç' => 'C', 'ď' => 'd', 'Ď' => 'D', 'ḋ' => 'd', 'Ḋ' => 'D', 'đ' => 'd', 'Đ' => 'D', 'ð' => 'dh', 'Ð' => 'Dh', 'é' => 'e', 'É' => 'E', 'è' => 'e', 'È' => 'E', 'ĕ' => 'e', 'Ĕ' => 'E', 'ê' => 'e', 'Ê' => 'E', 'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'ė' => 'e', 'Ė' => 'E', 'ę' => 'e', 'Ę' => 'E', 'ē' => 'e', 'Ē' => 'E', 'ḟ' => 'f', 'Ḟ' => 'F', 'ƒ' => 'f', 'Ƒ' => 'F', 'ğ' => 'g', 'Ğ' => 'G', 'ĝ' => 'g', 'Ĝ' => 'G', 'ġ' => 'g', 'Ġ' => 'G', 'ģ' => 'g', 'Ģ' => 'G', 'ĥ' => 'h', 'Ĥ' => 'H', 'ħ' => 'h', 'Ħ' => 'H', 'í' => 'i', 'Í' => 'I', 'ì' => 'i', 'Ì' => 'I', 'î' => 'i', 'Î' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ĩ' => 'i', 'Ĩ' => 'I', 'į' => 'i', 'Į' => 'I', 'ī' => 'i', 'Ī' => 'I', 'ĵ' => 'j', 'Ĵ' => 'J', 'ķ' => 'k', 'Ķ' => 'K', 'ĺ' => 'l', 'Ĺ' => 'L', 'ľ' => 'l', 'Ľ' => 'L', 'ļ' => 'l', 'Ļ' => 'L', 'ł' => 'l', 'Ł' => 'L', 'ṁ' => 'm', 'Ṁ' => 'M', 'ń' => 'n', 'Ń' => 'N', 'ň' => 'n', 'Ň' => 'N', 'ñ' => 'n', 'Ñ' => 'N', 'ņ' => 'n', 'Ņ' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ò' => 'o', 'Ò' => 'O', 'ô' => 'o', 'Ô' => 'O', 'ő' => 'o', 'Ő' => 'O', 'õ' => 'o', 'Õ' => 'O', 'ø' => 'oe', 'Ø' => 'OE', 'ō' => 'o', 'Ō' => 'O', 'ơ' => 'o', 'Ơ' => 'O', 'ö' => 'oe', 'Ö' => 'OE', 'ṗ' => 'p', 'Ṗ' => 'P', 'ŕ' => 'r', 'Ŕ' => 'R', 'ř' => 'r', 'Ř' => 'R', 'ŗ' => 'r', 'Ŗ' => 'R', 'ś' => 's', 'Ś' => 'S', 'ŝ' => 's', 'Ŝ' => 'S', 'š' => 's', 'Š' => 'S', 'ṡ' => 's', 'Ṡ' => 'S', 'ş' => 's', 'Ş' => 'S', 'ș' => 's', 'Ș' => 'S', 'ß' => 'SS', 'ť' => 't', 'Ť' => 'T', 'ṫ' => 't', 'Ṫ' => 'T', 'ţ' => 't', 'Ţ' => 'T', 'ț' => 't', 'Ț' => 'T', 'ŧ' => 't', 'Ŧ' => 'T', 'ú' => 'u', 'Ú' => 'U', 'ù' => 'u', 'Ù' => 'U', 'ŭ' => 'u', 'Ŭ' => 'U', 'û' => 'u', 'Û' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ű' => 'u', 'Ű' => 'U', 'ũ' => 'u', 'Ũ' => 'U', 'ų' => 'u', 'Ų' => 'U', 'ū' => 'u', 'Ū' => 'U', 'ư' => 'u', 'Ư' => 'U', 'ü' => 'ue', 'Ü' => 'UE', 'ẃ' => 'w', 'Ẃ' => 'W', 'ẁ' => 'w', 'Ẁ' => 'W', 'ŵ' => 'w', 'Ŵ' => 'W', 'ẅ' => 'w', 'Ẅ' => 'W', 'ý' => 'y', 'Ý' => 'Y', 'ỳ' => 'y', 'Ỳ' => 'Y', 'ŷ' => 'y', 'Ŷ' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y', 'ź' => 'z', 'Ź' => 'Z', 'ž' => 'z', 'Ž' => 'Z', 'ż' => 'z', 'Ż' => 'Z', 'þ' => 'th', 'Þ' => 'Th', 'µ' => 'u', 'а' => 'a', 'А' => 'a', 'б' => 'b', 'Б' => 'b', 'в' => 'v', 'В' => 'v', 'г' => 'g', 'Г' => 'g', 'д' => 'd', 'Д' => 'd', 'е' => 'e', 'Е' => 'E', 'ё' => 'e', 'Ё' => 'E', 'ж' => 'zh', 'Ж' => 'zh', 'з' => 'z', 'З' => 'z', 'и' => 'i', 'И' => 'i', 'й' => 'j', 'Й' => 'j', 'к' => 'k', 'К' => 'k', 'л' => 'l', 'Л' => 'l', 'м' => 'm', 'М' => 'm', 'н' => 'n', 'Н' => 'n', 'о' => 'o', 'О' => 'o', 'п' => 'p', 'П' => 'p', 'р' => 'r', 'Р' => 'r', 'с' => 's', 'С' => 's', 'т' => 't', 'Т' => 't', 'у' => 'u', 'У' => 'u', 'ф' => 'f', 'Ф' => 'f', 'х' => 'h', 'Х' => 'h', 'ц' => 'c', 'Ц' => 'c', 'ч' => 'ch', 'Ч' => 'ch', 'ш' => 'sh', 'Ш' => 'sh', 'щ' => 'sch', 'Щ' => 'sch', 'ъ' => '', 'Ъ' => '', 'ы' => 'y', 'Ы' => 'y', 'ь' => '', 'Ь' => '', 'э' => 'e', 'Э' => 'e', 'ю' => 'ju', 'Ю' => 'ju', 'я' => 'ja', 'Я' => 'ja');
    return str_replace(array_keys($transliterationTable), array_values($transliterationTable), $txt);
}
?>