<?php
include_once('../../param.php');
require_once("../dbaccess/dbhelper.php");
include_once('../dbaccess/emailOrder.php');

//ini_set('display_errors', 1);
//ini_set('display_startup_errors', 1);
//error_reporting(E_ERROR);

session_start();
$jccOrderID = $_SESSION['JCCIDV2'];
$orderCode = $_SESSION['orderCodeJCCV2'];
$customerID = $_SESSION['customerID'];

echo "<center><h2><br><br><br>Redirecting...</h2></center>";


if(isset($_GET['OC']) && strcmp($_GET['OC'],'')!=0){
    $orderCode = $_GET['OC'];
}

if(isset($_GET['CID']) && strcmp($_GET['CID'],'')!=0){
    $customerID = $_GET['CID'];
}

if(isset($_GET['retry']) && strcmp($_GET['retry'],'')!=0){
    $retry = $_GET['retry'];
} else {
    $retry = 0;
}

if(strcmp($jccOrderID,'')==0){
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT jcc_order_id FROM B2B_JCC_V2_Orders WHERE order_code='$orderCode' LIMIT 1");
    $stm->execute();
    $stm->bind_result($jccOrderID);
    while ($stm->fetch()) {}
    $stm->close();
}

if(isset($jccOrderID) && strcmp($jccOrderID,'')!=0){
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT merchant_id,password,currency_iso_code,post_url FROM B2C_Payment_Methods WHERE payment_method_code = 'JCC_V2'");
    $stm->execute();
    $stm->bind_result($userNameJCC, $passwordJCC, $currencyJCC,$postURL);
    while ($stm->fetch()) {}
    $stm->close();

    $apiURL = "$postURL/rest/getOrderStatusExtended.do";

    $ch = curl_init();
    curl_setopt_array($ch, array(
        CURLOPT_URL => "$apiURL",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => array('userName' => "$userNameJCC",'password' => "$passwordJCC",'orderId' => "$jccOrderID",'language' => 'en'),
    ));
    $response = curl_exec($ch);

    if (curl_errno($ch)) {
        echo 'Σφάλμα cURL: ' . curl_error($ch);
    } else {
        $body = json_decode($response, true);
        $statusOrderResponse = $body['orderStatus'];
        $statusOrderResponseDescription = $body['actionCodeDescription'];
        $_SESSION['JCCIDV2'] = '';
        $_SESSION['orderCodeJCCV2'] = '';
    }
    curl_close($ch);


//    0 - order was registered but not paid;
//    1 - pre-authorized amount is on hold on the buyer's account (for two-phase payments);
//    2 - order amount is fully authorized;
//    3 - authorization canceled;
//    4 - transaction was refunded;
//    5 - access control server of the issuing bank initiated authorization procedure;
//    6 - authorization declined.
//    7 - pending order payment;
//    8 - intermediate completion for multiple partial completion.

    $jccStatusArray = array(
        0 => "order was registered but not paid [0]",
        1 => "pre-authorized amount is on hold on the buyer's account (for two-phase payments) [1]",
        2 => "order amount is fully authorized [2]",
        3 => "authorization canceled [3]",
        4 => "transaction was refunded [4]",
        5 => "access control server of the issuing bank initiated authorization procedure [5]",
        6 => "authorization declined [6]",
        7 => "pending order payment [7]",
        8 => "intermediate completion for multiple partial completion [8]",
    );

    if ($statusOrderResponse==2){
        $companyID = 0;
        $salespersonID = 0;
        $invoiceID = 0;
        $receiptAddress = 0;
        $amount = 0;
        $cashDiscount = 0;
        $bank = 'JCC';
        $branch = " ";
        $chequeNumber = "";
        $chequeDate = date('Y-m-d');
        $payment = 0;

        $receiptDate = date('Y-m-d');
        $paymentMethod ="JCC";
        $notes = "For Online Order $orderCode <br> Order Number JCC: $jccOrderID";
        $receiptStatus = "Confirmed";

        $payedStatus = "Placed";
        $db->set_charset("utf8");
        $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_code=? AND customer_id=?");
        $stmt->bind_param('ssi',$payedStatus, $orderCode,$customerID);
        $stmt->execute();
        $stmt->close();

        $logStatus = 'Success';
        $stmt = $db->prepare("UPDATE B2B_JCC_V2_Orders SET jcc_status=? WHERE order_code=?");
        $stmt->bind_param('ss',$logStatus,$orderCode);
        $stmt->execute();
        $stmt->close();

        $stm = $db->prepare("SELECT order_id,delivery_address_id,grand_total FROM Orders WHERE order_code=? AND customer_id=?");
        $stm-> bind_param('si', $orderCode,$customerID);
        $stm-> execute();
        $stm-> bind_result($orderID,$receiptAddress,$amount);
        while ($stm->fetch()) {}
        $stm->close();

        $stm = $db->prepare("SELECT salesperson_for_order FROM B2B_Configuration LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($defaultSalesPerson);
        while ($stm->fetch()) {
            if(strcmp($defaultSalesPerson,'')!=0 && $defaultSalesPerson > 0){
                $salespersonID = $defaultSalesPerson;
            } else {
                $salespersonID = 0;
            }
        }
        $stm->close();

        if($amount > 0) {
            $receiptID   = getNextKey("Receipts","receipt_id");
            $receiptCode = getNextCodeSingleTransaction("Receipts", "receipt_code", "R", "CLOUD", $db);
            if (strcmp($receiptCode, '') == 0) {
                $receiptCode = getReceiptPrefix("CLOUD").getNextReceiptCode("CLOUD");
            }

            $db->set_charset("utf8");
            $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('isiiiiiidsdsssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes,$receiptStatus);
            $stmt->execute();
            $stmt->close();
            setNextReceiptCode("CLOUD");

            $detailsTra="Online Payment Receipt $receiptCode";
            $sign = -1;
            $payment -= $cashDiscount;
            $transactionID = getNextKey("Transactions", "transaction_id");
            $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('isisssids', $transactionID, $receiptCode, $customerID, $receiptDate, $receiptDate, $receiptCode, $sign, $amount, $detailsTra);
            $stmt->execute();
            $stmt->close();
            updateCustomerBalance($customerID, $amount);
        }
        sendEmail($orderID, $receiptID);
        $pFlag = 1;
    } else if(in_array($statusOrderResponse,array(0,1,5))){

        $retry++;

        if($retry < 21) {

            $payedStatus = "Processing Payment";
            $db->set_charset("utf8");
            $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_code=? AND customer_id=?");
            $stmt->bind_param('ssi',$payedStatus, $orderCode,$customerID);
            $stmt->execute();
            $stmt->close();

            $logStatus = $jccStatusArray[$statusOrderResponse];
            $stmt = $db->prepare("UPDATE B2B_JCC_V2_Orders SET jcc_status=? WHERE order_code=?");
            $stmt->bind_param('ss',$logStatus,$orderCode);
            $stmt->execute();
            $stmt->close();

            header("Location: //" . HTML_PATH . "/cop/b2b/jccV2/success.php?OC=$orderCode&CID=$customerID&retry=$retry");
        } else {
            $payedStatus = "JCC ". $jccStatusArray[$statusOrderResponse];
            $db->set_charset("utf8");
            $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_code=? AND customer_id=?");
            $stmt->bind_param('ssi',$payedStatus, $orderCode,$customerID);
            $stmt->execute();
            $stmt->close();

            $logStatus = $jccStatusArray[$statusOrderResponse];
            $stmt = $db->prepare("UPDATE B2B_JCC_V2_Orders SET jcc_status=? WHERE order_code=?");
            $stmt->bind_param('ss',$logStatus,$orderCode);
            $stmt->execute();
            $stmt->close();

            $pFlag = 0;

        }

    } else {

        if(strcmp($statusOrderResponseDescription,'')==0){
            $statusOrderResponseDescription = $jccStatusArray[$statusOrderResponse];
        }

        $payedStatus = "JCC ". $statusOrderResponseDescription;
        $db->set_charset("utf8");
        $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_code=? AND customer_id=?");
        $stmt->bind_param('ssi',$payedStatus, $orderCode,$customerID);
        $stmt->execute();
        $stmt->close();

        if(strcmp($statusOrderResponseDescription,'')==0){
            $statusOrderResponseDescription = $response;
        }

        $stmt = $db->prepare("UPDATE B2B_JCC_V2_Orders SET jcc_status=? WHERE order_code=?");
        $stmt->bind_param('ss',$statusOrderResponseDescription,$orderCode);
        $stmt->execute();
        $stmt->close();

        $pFlag = 0;

    }
}else{
    $pFlag = 0;
}

redirectFromJCC("//".HTML_PATH."/cop/b2b/viewsingleorder.php?p=$pFlag&Order=$orderCode");


function updateCustomerBalance($customerID,$amount)
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE  Customers SET balance = balance - ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();
}

function redirectFromJCC($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

?>
