<?php

include_once("../param.php");
require_once("./dbaccess/dbhelper.php");
$orderID=$_SESSION['orderID'];
$customerID=$_SESSION['customerID'];

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$allowAnonymousOrder = false;
$includeVatOnPrice = false;
$showCustomerLogo = false;
$showCurrencies = false;
$addItemByUnits = true;
$db->set_charset("utf8");
$stm = $db->prepare("SELECT  facebook_link,instagram_link,twitter_link,css_theme,theme,anonymous_order,show_prices_with_vat,show_customer_logo,multi_currency,order_qty_by_subunits FROM B2B_Configuration LIMIT 1 ");
$stm-> execute();
$stm-> bind_result($facebookLink,$instagramLink,$twitterLink,$cssTheme,$themeColor,$anonymousOrder,$showPricesIncludingVAT,$showCustomerLogoSetting,$multiCurrency,$orderQtyBySubunits);
while ($stm->fetch()) {
    if($cssTheme <= 1){
        $cssTheme = '';
    }
    $themeColor = strtolower($themeColor);

    if(strcmp($anonymousOrder,'yes')==0){
        $allowAnonymousOrder = true;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0){
        $includeVatOnPrice = true;
    }
    if(strcmp($showCustomerLogoSetting,"yes")==0){
        $showCustomerLogo = true;
    }
    if(strcmp($multiCurrency,"yes")==0){
        $showCurrencies = true;
    }

    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }

}
$stm->close();


$logoLinkHeader = $logoLink;
if($showCustomerLogo) {
    if (isset($_SESSION['customerID']) && $_SESSION['customerID'] > 0) {

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT logo FROM Customers WHERE customer_id='". $_SESSION['customerID']."' AND customer_id > 0 LIMIT 1");
        $stm->execute();
        $stm->bind_result($customerLogo);
        while ($stm->fetch()) {
            if(strcmp($customerLogo,'')!=0 && file_exists('../media/customersLogos/'.$customerLogo)){
                $logoLinkHeader = '../media/customersLogos/'.$customerLogo;
            }
        }
        $stm->close();

    }
}


$currencyRate = getPriceRate();
$count = 0;
$itemCounter = 0;
$subtotal = 0;
$netTotalLabel = $langu['column_total_label'];
$db->set_charset("utf8");
$stm = $db->prepare("SELECT qty,unit_price,Items.vat_id,Online_Order_Item.item_id FROM Online_Order_Item,Items WHERE  Online_Order_Item.item_id=Items.item_id AND order_id='$orderID'");
$stm->execute();
$stm->bind_result($ordQty,  $ordLineUnitPrice,$ordVatID,$ordItemID);
while ($stm->fetch()) {

    if($addItemByUnits) {
        $ordQty = $ordQty / floatval(getSubUnits($ordItemID));
        $subtotalLine = $ordLineUnitPrice*$ordQty;
    } else {
        $subtotalLine = $ordLineUnitPrice*$ordQty / floatval(getSubUnits($ordItemID));
    }

    $count += $ordQty;
    $itemCounter++;

    if($includeVatOnPrice) {
        $vatPercentage = getVatPercentage($ordVatID);
        $subtotal += $subtotalLine + $subtotalLine * ($vatPercentage / 100);
    } else {
        $subtotal += $subtotalLine;
    }
}
$stm->close();


if(strcmp($showPrices,'no')==0 || $_SESSION['showPrices']==false || $showPrices==false){
    $showPrices = false;
    $showCurrencies = false;
} else {
    $showPrices = true;
}


// user favorites
$favoritesShow = false;
$stm = $db->prepare("SELECT allow_user_favorites FROM B2B_Page_Catalogue LIMIT 1 ");
$stm-> execute();
$stm-> bind_result($allowUserFavorites);
while ($stm->fetch()) {
    if(strcmp($allowUserFavorites,'yes')==0){
        $favoritesShow = true;
    }
}
$stm->close();


?>

<div class="header-wrapper" style="padding-top:5px;padding-bottom:5px;margin-left: 0px;margin-right: 20px;width: 100%">
    <div class="container" style="width: 100%">

        <div class="col-xs-1 col-sm-1 col-sm-offset-1 col-xs-offset-1 hidden-md  hidden-lg  pull-left">
            <label style='display:block; min-height: 20px;' class='hidden-xs'></label>
            <a href='#' class='menu-toggle btn btn-theme-transparent pull-left'><i class='fa fa-bars'></i></a>
        </div>

        <div class="col-xs-8 col-sm-8 col-sm-offset-1 col-xs-offset-1 col-md-2 col-lg-2" style="padding-right:0;vertical-align: middle">
            <label style='display:block; min-height: 20px;' class='hidden-xs'></label>
            <table>
                <tr>
                    <td>

                            <?php
                            $showLanguages = $_SESSION['show_language_selection'];
                            $lang = $_SESSION['lang'];
                            $langName = $_SESSION['langname'];

                            if($showLanguages) {

                                echo "<select id='languageSelect' class='btn-theme-transparent' onchange='setLanguage()' style='width:80px;display:inline-block;height:38px;margin-right: 20px;'>";

                                if (strcmp($lang, 'en') == 0) {
                                    echo "<option value='en'><strong>English</strong></option>";
                                    echo "<option value='el'><strong>Greek</strong></option>";
                                } else {
                                    echo "<option value='el'>Greek</option>";
                                    echo "<option value='en'>English</option>";
                                }
                                echo "</select>";
                            }



                            ?>


                    </td>
                    <td>
                        <ul  style="display:inline-block;margin-bottom: 0px;">
                            <?php
                            if(strcmp($facebookLink,'')!=0){
                                echo "<li style='display:inline-block'><a target='_blank' href='$facebookLink' class='btn btn-theme-transparent' style='margin-right: 1px;'>&nbsp;<i class='fa fa-facebook'></i>&nbsp;</a></li>";
                            }
                            if(strcmp($instagramLink,'')!=0){
                                echo "<li style='display:inline-block'><a target='_blank' href='$instagramLink' class='btn btn-theme-transparent' style='margin-right: 1px;'>&nbsp;<i class='fa fa-instagram'></i>&nbsp;</a></li>";
                            }
                            if(strcmp($twitterLink,'')!=0) {
                                echo "<li style='display:inline-block'><a target='_blank' href='$twitterLink'  class='btn btn-theme-transparent'><i class='fa fa-twitter' ></i></a></li>";
                            }
                            ?>
                        </ul>
                    </td>
                </tr>
            </table>
        </div>



        <!-- Logo -->
        <div class="col-sm-12 col-xs-12 col-md-6 col-lg-6 ">
            <a href="index.php"><img style="display: block;margin-left: auto;margin-right: auto;max-height:60px;" src="<?php echo $logoLinkHeader ?>" alt="Coprime"/></a>
        </div>





        <?php

        $allowAnonymousOrder = false;
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT css_theme,theme,anonymous_order FROM B2B_Configuration LIMIT 1 ");
        $stm-> execute();
        $stm-> bind_result($cssTheme,$themeColor,$anonymousOrder);
        while ($stm->fetch()) {
            if($cssTheme <= 1){
                $cssTheme = '';
            }
            $themeColor = strtolower($themeColor);

            if(strcmp($anonymousOrder,'yes')==0){
                $allowAnonymousOrder = true;
            }

        }
        $stm->close();

      if (!(!isset($_SESSION['customerID'])||$_SESSION['customerID']==0) || $allowAnonymousOrder) {

          global $username, $password, $database;

          $userId =  $_SESSION['userID'];
          $db = new mysqli('localhost',$username,$password,$database);
          if (mysqli_connect_errno()) {
              printf("Connect failed: %s\n", mysqli_connect_error());
              exit();
          }
          $db->set_charset("utf8");

          $stm = $db->prepare("SELECT username,first_name FROM B2B_User WHERE b2b_user_id='$userId'");
          $stm-> execute();
          $stm-> bind_result($userName,$fname);

          while ($stm->fetch()) {
            if(strcmp(trim($fname),'')!=0){$userName=$fname;}
          }
          $stm-> close();

          $checkoutLabel = $langu['checkout_label'];
          $displaySubTotal = number_format(floatval($subtotal),2);

          $greeting = $langu['greeting'];


          $show = true;

          $stm = $db->prepare("SELECT category_id, count(category_id) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$userId'");
          $stm->execute();
          $stm->bind_result($categoryID, $counter);
          while ($stm->fetch()) {
          }
          $stm->close();

          if($counter == 1 && $categoryID == 2){$show = false;}
          else if($counter == 1 && $categoryID == 14){$show = false;$_GET['category_id']=$categoryID;}

          $_SESSION['show'] = $show;
          $itemsLabel = $langu['item'];
          $qtyLabel = $langu['qty'];
          if(strcmp($userName,'')==0){$greeting='&nbsp;';}

          $favoriteIcon = "";
          if($favoritesShow) {
              $userID = intval($_SESSION["userID"]);
              $customerID = intval($_SESSION["customerID"]);

              if ($userID == 0 || $customerID == 0) {
                  $onclick = "onclick=\"$('#loginModal').modal('show');\"";
              } else {
                  $onclick = "onclick=\"getItemsInCategory(28,1,96);\"";
              }

              $favoriteIcon = "<a href='#' $onclick class='btn btn-theme-transparent pull-right' style='padding-top:8px;margin-left: 5px;'>
                    <i class='fa fa-heart '></i>
                 </a>";
          }

          echo"

         <!-- Header shopping cart -->

            <div class='header-cart  pull-right'>      
                <div class='cart-wrapper pull-right' style=''>
                  <label style='display:block' class='hidden-xs'>$greeting $userName</label>
                    <a href='checkout.php'  class='btn btn-theme-transparent  pull-right' style='margin-left: 5px;'><span>$checkoutLabel</span></a>
                    <a href='#'  class='btn btn-theme-transparent  pull-right' style='margin-left: 5px;' onclick='openCart()' data-toggle='modal' data-target='#popup-cart'><i class='fa fa-shopping-cart'></i> <span class='hidden-xs' id='modalCartButtonText'> $itemCounter $itemsLabel - $qtyLabel $count"; if($showPrices){ echo " $netTotalLabel: $displaySubTotal";} echo "</span> <i class='fa fa-angle-down'></i></a>
                    <!-- Mobile menu toggle button -->
                    $favoriteIcon
                   
                </div>
            </div>

        ";
     }
?>


        <style>
            @media (max-width: 600px) {
                .header-cart {
                    width:70%;
                }
            }
        </style>

        <script>

            function setLanguage()
            {
                var language = $('#languageSelect').val();

                var currenthref = window.location.href;
                var newhref = '';

                if(currenthref.indexOf('?lang=') > -1)
                {
                    newhref = window.location.href.split('?lang=')[0];
                }
                else if(currenthref.indexOf('lang=') > -1)
                {
                    newhref = window.location.href.split('lang=')[0];
                }
                else {
                    newhref = window.location.href;
                }

                if (newhref.substring(newhref.length-1) == "&")
                {
                    newhref = newhref.substring(0, newhref.length-1);
                }

                if(newhref.indexOf('?') > -1)
                {
                    window.location.href=newhref + "&lang=" + language;
                }
                else
                {
                    window.location.href=newhref + "?lang=" + language;
                }

            }

        </script>

    </div>
</div>