<?php
session_start();
if(!isset($_SESSION['customerID']) ) {
    redirect("login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
include_once("../param.php");
require("./dbaccess/dbhelper.php");

$fromPayment=false;
if(isset($_GET['p']) && isset($_GET['Receipt'])){
    $paymentReceiptCode = $_GET['Receipt'];
    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT receipt_id FROM Receipts WHERE receipt_code = '$paymentReceiptCode' AND customer_id='".$_SESSION['customerID']."'");
    $stm-> execute();
    $stm-> bind_result($receiptID);

    while ($stm->fetch()) {}
    $stm-> close();

    $_POST['receiptID'] = $receiptID;
    $paymentStatus = $_GET['p'];
    $fromPayment=true;

}
//ALLAGH
$receiptID=$_POST['receiptID'];

if(isset($_POST['receiptID'])){
    $_SESSION['LRVID'] = $receiptID;
}else{
    $receiptID = $_SESSION['LRVID'];
}
include_once("headerImports.php");
$showPrices=true;
$showPricesWithVAT=false;
$includeVatOnPrice=false;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT primary_language,show_prices,show_prices_with_vat,css_theme,drop_ship FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$showPricesIncludingVAT,$cssTheme,$dropShip);

while ($stm->fetch()) {
    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }

    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}
$stm-> close();


$stm = $db->prepare("SELECT receipt_id,receipt_code,receipt_date,amount,notes,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,receipt_date,status,customer_id FROM Receipts WHERE Receipts.receipt_id='$receiptID' AND customer_id='".$_SESSION['customerID']."'");
$stm-> execute();
$stm-> bind_result($resolvedOrderID,$receiptCode,$receiptDate,$amount,$details,$paymentMethod,$cash_discount,$bank,$branch,$cheque_number,$cheque_date,$receipt_date,$status,$customerID);
while ($stm->fetch()) {}
$stm-> close();
//allagh
$customerInfo = getCustomerInfo($customerID);
$customerCode = $customerInfo->code;
$customerName = $customerInfo->name;
$orderCode = str_replace('For Online Order ','',$details);
$stm = $db->prepare("SELECT currency_sign,currency_rate FROM Multi_Currency_Orders,Orders WHERE Multi_Currency_Orders.order_id=Orders.order_id AND order_code='$orderCode' LIMIT 1");
$stm-> execute();
$stm-> bind_result($currencySign,$currencyRate);
while ($stm->fetch()) {}
$stm-> close();

if(strcmp("$currencySign",'')==0){$currencySign = B2B_CURRENCY_SYMBOL;}

if(strcmp("$currencyRate",'')==0 || (float)$currencyRate == 0){$currencyRate = 1;}
$currencyName = getCurrencyNameBySign($currencySign);
$amount *= $currencyRate;

$displayAmount = "$currencySign".number_format(floatval($amount),2);
$receiptDate = date_format( date_create_from_format('Y-m-d', $receiptDate), 'd-m-Y');
$cheque_date = date_format( date_create_from_format('Y-m-d', $cheque_date), 'd-m-Y');
$amountForConvertion = explode('.',number_format(floatval($amount),2,'.',''));
$textAmount = convertNumber($amountForConvertion[0])." $currencyName and ". convertNumber($amountForConvertion[1])." cents";
$textAmount = str_replace('one zero','ten',$textAmount);
$textAmount = str_replace('zero zero','zero',$textAmount);
if (strpos($textAmount, "$currencyName") !== false) {
    $textAmount.=" only";
} else {
    $textAmount.=" $currencyName only";
}

function convertNumber($number)
{
    list($integer, $fraction) = explode(".", (string) $number);

    $output = "";

    if ($integer[0] == "-")
    {
        $output = "negative ";
        $integer    = ltrim($integer, "-");
    }
    else if ($integer[0] == "+")
    {
        $output = "positive ";
        $integer    = ltrim($integer, "+");
    }

    if ($integer[0] == "0")
    {
        $output .= "zero";
    }
    else
    {
        $integer = str_pad($integer, 36, "0", STR_PAD_LEFT);
        $group   = rtrim(chunk_split($integer, 3, " "), " ");
        $groups  = explode(" ", $group);

        $groups2 = array();
        foreach ($groups as $g)
        {
            $groups2[] = convertThreeDigit($g[0], $g[1], $g[2]);
        }

        for ($z = 0; $z < count($groups2); $z++)
        {
            if ($groups2[$z] != "")
            {
                $output .= $groups2[$z] . convertGroup(11 - $z) . (
                    $z < 11
                    && !array_search('', array_slice($groups2, $z + 1, -1))
                    && $groups2[11] != ''
                    && $groups[11][0] == '0'
                        ? " and "
                        : ", "
                    );
            }
        }

        $output = rtrim($output, ", ");
    }

    if ($fraction > 0)
    {
        $output .= " euros and";
        for ($i = 0; $i < strlen($fraction); $i++)
        {
            $output .= " " . convertDigit($fraction[$i]);
        }
    }

    return $output;
}

function convertGroup($index)
{
    switch ($index)
    {
        case 11:
            return " decillion";
        case 10:
            return " nonillion";
        case 9:
            return " octillion";
        case 8:
            return " septillion";
        case 7:
            return " sextillion";
        case 6:
            return " quintrillion";
        case 5:
            return " quadrillion";
        case 4:
            return " trillion";
        case 3:
            return " billion";
        case 2:
            return " million";
        case 1:
            return " thousand";
        case 0:
            return "";
    }
}

function convertThreeDigit($digit1, $digit2, $digit3)
{
    $buffer = "";

    if ($digit1 == "0" && $digit2 == "0" && $digit3 == "0")
    {
        return "";
    }

    if ($digit1 != "0")
    {
        $buffer .= convertDigit($digit1) . " hundred";
        if ($digit2 != "0" || $digit3 != "0")
        {
            $buffer .= " ";
        }
    }

    if ($digit2 != "0")
    {
        $buffer .= convertTwoDigit($digit2, $digit3);
    }
    else if ($digit3 != "0")
    {
        $buffer .= convertDigit($digit3);
    }

    return $buffer;
}

function convertTwoDigit($digit1, $digit2)
{
    if ($digit2 == "0")
    {
        switch ($digit1)
        {
            case "1":
                return "ten";
            case "2":
                return "twenty";
            case "3":
                return "thirty";
            case "4":
                return "forty";
            case "5":
                return "fifty";
            case "6":
                return "sixty";
            case "7":
                return "seventy";
            case "8":
                return "eighty";
            case "9":
                return "ninety";
        }
    } else if ($digit1 == "1")
    {
        switch ($digit2)
        {
            case "1":
                return "eleven";
            case "2":
                return "twelve";
            case "3":
                return "thirteen";
            case "4":
                return "fourteen";
            case "5":
                return "fifteen";
            case "6":
                return "sixteen";
            case "7":
                return "seventeen";
            case "8":
                return "eighteen";
            case "9":
                return "nineteen";
        }
    } else
    {
        $temp = convertDigit($digit2);
        switch ($digit1)
        {
            case "2":
                return "twenty $temp";
            case "3":
                return "thirty $temp";
            case "4":
                return "forty $temp";
            case "5":
                return "fifty $temp";
            case "6":
                return "sixty $temp";
            case "7":
                return "seventy $temp";
            case "8":
                return "eighty $temp";
            case "9":
                return "ninety $temp";
        }
    }
}

function convertDigit($digit)
{
    switch ($digit)
    {
        case "0":
            return "zero";
        case "1":
            return "one";
        case "2":
            return "two";
        case "3":
            return "three";
        case "4":
            return "four";
        case "5":
            return "five";
        case "6":
            return "six";
        case "7":
            return "seven";
        case "8":
            return "eight";
        case "9":
            return "nine";
    }
}
//allagh
function getCustomerInfo($customerID){
    global $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $stm1 = $db1->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID' LIMIT 1");
    $stm1-> execute();
    $stm1-> bind_result($customerCode,$customerName);
    while ($stm1->fetch()) {
        $customerObj = new stdClass();
        $customerObj->code = $customerCode;
        $customerObj->name = $customerName;
    }
    $stm1->close();

    return $customerObj;
}

?>

<body id="home" class="wide">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- Popup: Shopping cart items -->
            <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="container">
                        <div class="cart-items">

                        </div>
                    </div>
                </div>
            </div>
            <!-- /Popup: Shopping cart items -->

            <!-- HEADER -->
                <?php
                $topmenu = "topMenu$cssTheme.php";

                if(strcmp($topmenu,"topMenu2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }

                include_once("$topmenu");
                if(strcmp($topmenu,"topMenu.php")==0) {
                    include_once("navigationMenu.php");
                }
                ?>
            </header>
            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area">

                <!-- PAGE -->
                <section class="page-section color">
                    <div class="container" id="checkoutContainer">
                        <h3 class="block-title alt"><i class="fa fa-angle-down"></i><?php echo $langu['account_view_receipt_title'] ?></h3>
                        <div id="checkoutCartContainer">
                            <div class='col-md-12' style="padding-top:5px;padding-left:0;">

                            </div>
                            <div class='row orders block'>
                                <?php

echo "              
                            <div class='col-md-12' id='totalsBox'>
                                <div class='shopping-cart'>";


                                         $account_view_amount = $langu['account_receipt_grand_total'];
                                         $dateLabel = $langu['account_view_receipt_date'];
                                         $grandTotalTitleString = $langu['grand_total_label'];
                                         $codeTitleString = $langu['account_view_receipt_code'];
                                         $chequeDateLabel = $langu['account_view_cheque_date'];
                                         $chequeNumberLabel = $langu['account_view_cheque_number'];
                                         $bankLabel = $langu['account_view_bank'];
                                         $paymentMethodLabel = $langu['payment_method_label'];
                                         $notesTitleString  = $langu['account_view_order_notes'];
                                         $customerInfoLabel = $langu['customer_label'];//allagh




                                echo "     
                                    <table>
                                        <tr>
                                            <td style='text-align: left;font-weight: bolder'>$codeTitleString</td>
                                            <td >$receiptCode</td>
                                        </tr>
                                        <tr>
                                            <td style='text-align: left;font-weight: bolder'>$dateLabel</td>
                                            <td >$receiptDate</td>
                                        </tr>
                                        <tr>
                                            <td style='text-align: left;font-weight: bolder'>$paymentMethodLabel</td>
                                            <td >$paymentMethod</td>
                                        </tr>
                                        <tr>
                                            <td style='text-align: left;font-weight: bolder'>$customerInfoLabel</td>
                                            <td >$customerCode-$customerName</td>
                                        </tr>";//allagh
                                if(strcmp($paymentMethod,'Cheque')==0) {
                                    echo "
                                         <tr>
                                            <td style='text-align: left;font-weight: bolder'>$chequeNumberLabel</td>
                                            <td >$cheque_number</td>
                                        </tr>
                                        <tr>
                                            <td style='text-align: left;font-weight: bolder'>$chequeDateLabel</td>
                                            <td >$cheque_date</td>
                                        </tr>
                                        <tr>
                                            <td style='text-align: left;font-weight: bolder'>$bankLabel</td>
                                            <td >$bank $branch</td>
                                        </tr>";
                                }
                                echo "
                                        <tfoot>
                                        <tr style='border-bottom: 1px solid gray;background-color: lightblue;'>
                                            <td style='text-align: left;font-weight: bolder'>$account_view_amount</td>
                                            <td >$displayAmount<br>($textAmount)</td>
                                        </tr>
                                        </tfoot>
                                    </table>";
                                echo "  
                                        <label style='font-weight: bolder;padding-top:10px;'>$notesTitleString: </label>  
                                        <p style='padding-top:10px;'>$details </p>
                                                                                
                                        
                                     </div>";

                                    ?>
                                    <div class='col-md-12'  style="margin-top:5px;width: 100%;padding: 0px;">


                                     <?php

                                     $db = new mysqli('localhost',$username,$password,$database);
                                     if (mysqli_connect_errno()) {
                                         printf("Connect failed: %s\n", mysqli_connect_error());
                                         exit();
                                     }
                                     $db->set_charset("utf8");
                                     $isFirst = true;
                                     $stm = $db->prepare("SELECT amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,notes FROM Receipt_Item WHERE Receipt_Item.receipt_id='$receiptID' AND Receipt_Item.receipt_id > 0");
                                     $stm-> execute();
                                     $stm-> bind_result($lineAmount,$linePaymentMethod,$lineCashDiscount,$lineBank,$lineBranch,$lineChequeNumber,$lineChequeDate,$lineNotes);
                                    while ($stm->fetch()) {

                                        if($isFirst){
                                            echo "<table class='table' style='border: 1px solid silver'>
                                                    <thead>
                                                    <tr>
                                                        <th >".$langu['account_view_date']."</th>
                                                        <th >".$langu['account_view_method']."</th>
                                                        <th>".$langu['account_view_receipt_cheque_number']."</th>
                                                        <th>".$langu['account_view_receipt_cheque_details']."</th>
                                                        <th>".$langu['account_view_notes']."</th>
                                                        <th style='text-align: right;'>".$langu['account_view_amount']."</th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>";
                                        }

                                        if(strcmp($linePaymentMethod,'Cash')==0){
                                            $lineBank = $lineChequeNumber = '-';
                                            $lineBranch = '';
                                        }

                                        $lineAmount = "&euro;".number_format(floatval($lineAmount),2);
                                        $lineChequeDate = date_format( date_create_from_format('Y-m-d', $lineChequeDate), 'd-m-Y');

                                         echo "
                                        <tr class='itemRow'>
                                            <td class='date'>$lineChequeDate</td>
                                            <td class='payment_method'>$linePaymentMethod</td>
                                            <td class='cheque_number'>$lineChequeNumber</td>
                                            <td class='bank'>$lineBank $lineBranch</td>
                                            <td class='total'>$lineNotes</td>
                                            <td class='amount' style='text-align: right;'>$lineAmount</td>

                                        </tr>";



                                        $isFirst = false;
                                     }
                                     $stm->close();

                                     if(!$isFirst){
                                         echo "</tbody>
                                               </table>
                                               ";
                                     }


                                     echo "</div>";




                                     echo "
                                        </footer>
                                     </form>
                                   </div>
                                </div>";



?>





                    </div>
                                <div class="overflowed" style="display: flex">
                                    <a class="btn btn-theme btn-theme-dark" href="./receipt-history.php"><?php echo $langu['account_view_order_back_to_receipt_button'] ?></a>
                                    <div class='col-xs-12 col-sm-4 col-md-3 col-lg-2'>
                                        <form  method='POST' action='./dbaccess/printReceiptPDF.php' target='_blank' style='display: inline-block;margin-left: 10px;'>
                                            <input type='hidden' name='receiptID' id='receiptID' value='<?php echo $receiptID ?>'/>
                                            <input type='hidden' name='receiptCode' value='<?php echo $receiptCode ?>'/>
                                            <input type='hidden' name='download' value='yes'/>
                                            <button type='submit' class='btn btn-theme btn-theme-danger' id='printOrderButton' ><i class='fa fa-file-pdf-o'></i>&nbsp; PDF</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                </section>
                <!-- /PAGE -->

            </div>
            <!-- /CONTENT AREA -->

            <!-- FOOTER -->
            <footer class="footer">
                <div class="footer-meta">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-6" style="margin-top:20px;font-size:16px;">

                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- /FOOTER -->

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->

        <!-- Modal -->
        <div class="modal fade" id="saveModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" style="margin-left:10px;"><i class='fa fa-money'></i><strong style="padding-left:5px;">&nbsp; <?php echo $langu['proceed_with_payment']; ?></strong></h4>
                    </div>

                    <div class="modal-body" style="margin-top:5px;padding-top:5px;">

                    </div>

                    <footer class="modal-footer" >
                        <button onclick="$('#saveModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;"><?php echo $langu['close_label'];?></button>
                        <button id="payNowButton" onclick="payOrder();" class="btn btn-success" style="display: none;"></button>
                    </footer>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->

        <!-- Modal -->
        <div class="modal fade" id="paymentStatusModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" style="margin-left:10px;"><strong style="padding-left:5px;">&nbsp;</strong></h4>
                    </div>

                    <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                        <center><br><br>

                        </center><br><br>
                    </div>

                    <footer class="modal-footer" >
                        <button onclick="$('#paymentStatusModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;"><?php echo $langu['close_label'];?></button>
                    </footer>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->




        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>

        <script src="assets/js/jquery-scrolltofixed-min.js"></script>

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>

        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>
        <!--<![endif]-->

        <script src="assets/js/waitMe.min.js"></script>

        <script type="text/javascript">
            jQuery(document).ready(function () {

                initThemeParameters();

                <?php
                if($fromPayment){
                    echo "$('#paymentStatusModal').modal('toggle');";
                }?>
            });



            function payOrder() {
                switch ($('#paymentMethod option:selected').data('method')) {
                    case 'JCC':
                        document.forms["paymentFormJCC"].submit();
                        break;
                    case "VIVA":
                        window.location.href="./dbaccess/createPaymentOrderVIVA.php?oid=<?php echo $orderCode?>";
                        break;
                    default:
                        var isCredit = $('#paymentMethod option:selected').data('iscredit');

                        if(isCredit.localeCompare('yes')==0){
                            $('#cancelPreviousOrder').val('yes');
                            $('#newPaymentMethod').val($('#paymentMethod option:selected').val());
                            document.forms["reorderForm"].submit();

                        }

                }
            }


        </script>

    </body>
</html>