<?php
session_start();
if(!isset($_SESSION['customerID']) ) {
    redirect("login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
include_once("../param.php");
require("./dbaccess/dbhelper.php");
$singleOrderID=$_POST['orderID'];
include_once("headerImports.php");
global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT primary_language,show_prices,css_theme FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$cssTheme);

while ($stm->fetch()) {
    if(strcmp($showPrices,"no")==0)
    {
        $showPrices=false;
    }
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}
$stm-> close();
$stm = $db->prepare("SELECT tender_id,tender_code,tender_date,subtotal,vat_amount,grand_total,details FROM Tenders WHERE Tenders.tender_id='$singleOrderID' AND customer_id='".$_SESSION['customerID']."'");
$stm-> execute();
$stm-> bind_result($resolvedOrderID,$orderCode,$orderDate,$subtotal,$vatAmount,$grandTotal,$details);
while ($stm->fetch()) {

    $displaySubTotal = number_format(floatval($subtotal),2);
    $displayVatTotal = number_format(floatval($vatAmount),2);
    $displayGrandTotal = number_format(floatval($grandTotal),2);



}

$stm-> close();


$orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');
?>

<body id="home" class="wide">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- Popup: Shopping cart items -->
            <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="container">
                        <div class="cart-items">

                        </div>
                    </div>
                </div>
            </div>
            <!-- /Popup: Shopping cart items -->

            <!-- HEADER -->
            <header class="header fixed">
                <?php
                $topmenu = "topMenu$cssTheme.php";

                if(strcmp($topmenu,"topMenu2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }

                include_once("$topmenu");
                if(strcmp($topmenu,"topMenu.php")==0) {
                    include_once("navigationMenu.php");
                }
                ?>
            </header>
            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area">

                <!-- PAGE -->
                <section class="page-section color">
                    <div class="container" id="checkoutContainer">
                        <h3 class="block-title alt"><i class="fa fa-angle-down"></i><?php echo $langu['account_view_tender_title'] ?></h3>
                        <div id="checkoutCartContainer">
                            <div class='col-md-12' style="padding-top:10px;padding-left:0">
                                <h4 style="color:black"><b><?php echo $langu['account_view_tender_code'] ?>:</b>  <?php echo" $orderCode"?></h4>
                                <h4 style="color:black"><b><?php echo $langu['account_view_tender_date'] ?>:</b><?php echo" $orderDate"?></h4>
                            </div>
                            <div class='row orders'>
                                <div class='col-md-8'  style="margin-top:5px">
                                    <table class='table'>
                                        <thead>
                                        <tr>
                                            <th ><?php echo $langu['account_view_order_image'] ?></th>
                                            <th style='text-align: center'><?php echo $langu['account_view_order_quantity'] ?></th>
                                            <th><?php echo $langu['account_view_order_product_name'] ?></th>
                                            <th><?php if($showPrices){ echo $langu['account_view_order_total']; }?></th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                     <?php

                                     $db = new mysqli('localhost',$username,$password,$database);
                                     if (mysqli_connect_errno()) {
                                         printf("Connect failed: %s\n", mysqli_connect_error());
                                         exit();
                                     }
                                     $db->set_charset("utf8");

                                     $stm = $db->prepare("SELECT Tender_Item.item_id,qty,unit_price,Items.vat_id,Items.item_code,Items.name,Items.short_description,Items.subunits FROM Tender_Item,Items WHERE Tender_Item.item_id=Items.item_id AND Tender_Item.tender_id='$resolvedOrderID'");
                                     $stm-> execute();
                                     $stm-> bind_result($itemID,$qty,$unitPrice,$vatID,$itemCode,$name,$shortDescription,$subUnits);

                                     $i = 0;
                                     $subTotal=0;
                                     $grandTotal=0;
                                     $vatTotal=0;
                                     while ($stm->fetch()) {
                                         $i++;
                                         $imageUrl = getDefaultImage($itemID);
                                         $price = number_format(floatval($unitPrice),2);

                                         if(strcmp($subUnits,'')!=0 && $subUnits > 1){
                                             $qty = $qty/$subUnits;
                                         }
                                         $lineTotal = $unitPrice * $qty;
                                         $subTotal += $lineTotal;
                                         $lineVat = $lineTotal * getVatPercentage($vatID) / 100;
                                         $vatTotal += $lineVat;
                                         if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
                                         {
                                             $name=$shortDescription;
                                         }



                                         if($showPrices)
                                         {
                                             $displayLineTotal = number_format(floatval($lineTotal),2);
                                         }
                                         else
                                         {
                                             $displayLineTotal = "";
                                         }

                                         $customerID = $_SESSION['customerID'];
                                         if($customerID > 0) {
                                             $name = getCustomerSynonym($customerID,$itemID,'name',$name);
                                             $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
                                         }

                                         echo "
                                        <tr class='itemRow'>
                                            <td class='image'><a class='media-link' href='#'><img style='width:50px;height:50px;' src='$imageUrl' alt='' width='50px' height='50px;'/></a></td>
                                            <td class='quantity' style='text-align: center'>$qty</td>
                                            <td class='description'>
                                                <h4><a href='#'>$name</a></h4>
                                                $itemCode
                                            </td>
                                            <td class='total'>$displayLineTotal </td>
                                        </tr>";

                                     }
                                     echo "
                                        </tbody>
                                    </table>
                                </div>";

                                     echo "              

                            <div class='col-md-4 ' id='totalsBox'>
                                <div class='shopping-cart'>";
                                     if($showPrices) {

                                         $subtotalTitleString = $langu['subtotal_label'];
                                         $vatTitleString = $langu['vat_label'];
                                         $grandTotalTitleString = $langu['grand_total_label'];
                                         $displaySubTotal = number_format(floatval($subTotal),2);
                                         echo "
                                    <table>
                                        <tr>
                                            <td>$subtotalTitleString</td>
                                            <td id='subtotal'>$displaySubTotal</td>
                                        </tr>
                                        <tr>
                                            <td>$vatTitleString</td>
                                            <td id='vatAmount'>$displayVatTotal</td>
                                        </tr>
                                        <tfoot>
                                        <tr>
                                            <td>$grandTotalTitleString</td>
                                            <td id='grandTotal'>$displayGrandTotal</td>
                                        </tr>
                                        </tfoot>
                                    </table>";
                                     }

                                     $notesTitleString = $langu['account_view_order_notes'];
                                     $addressTitleString = $langu['account_view_order_address'];

                                     echo "    <p style='padding-top:10px;'>$notesTitleString: $details </p>

                                      <!--<label>$addressTitleString: </label>-->
                                       <!--<p style='padding-top:10px;'> $addressLine1 - $addressLine2</p>-->
                                     </div>
                                </div>
                            </div>";

?>

                        <div class="overflowed">
                            <a class="btn btn-theme btn-theme-dark" href="./tender-history.php"><?php echo $langu['account_view_order_back_to_tenders_button'] ?></a>

                        </div>



                    </div>
                </section>
                <!-- /PAGE -->

            </div>
            <!-- /CONTENT AREA -->

            <!-- FOOTER -->
            <footer class="footer">
                <div class="footer-meta">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-6" style="margin-top:20px;font-size:16px;">

                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- /FOOTER -->

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->

        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>

        <script src="assets/js/jquery-scrolltofixed-min.js"></script>

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>

        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>
        <!--<![endif]-->

        <script src="assets/js/waitMe.min.js"></script>

        <script>
            jQuery(document).ready(function () {

                initThemeParameters();
            });

            }

//            function printOrderPDF(orderID)
//            {
//                alert("aaaaa");
//                $.ajax({
//                    type: "POST",
//                    url: "./dbaccess/printOrderPDF.php",
//                    data: {orderID: orderID},
//                    success: function (result) {
//
//
//
//                    }
//                });
//            }


        </script>

    </body>
</html>